/* DUPLICATOR-PRO (PHP MULTI-THREADED BUILD MODE) MYSQL SCRIPT CREATED ON : 2026-02-05 07:53:09 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;

CREATE TABLE IF NOT EXISTS `YTcMX_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) NOT NULL DEFAULT '',
  `user_pass` varchar(255) NOT NULL DEFAULT '',
  `user_nicename` varchar(50) NOT NULL DEFAULT '',
  `user_email` varchar(100) NOT NULL DEFAULT '',
  `user_url` varchar(100) NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT 0,
  `display_name` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `YTcMX_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=255 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `YTcMX_actionscheduler_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) NOT NULL,
  `status` varchar(20) NOT NULL,
  `scheduled_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  `priority` tinyint(3) unsigned NOT NULL DEFAULT 10,
  `args` varchar(191) DEFAULT NULL,
  `schedule` longtext DEFAULT NULL,
  `group_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `attempts` int(11) NOT NULL DEFAULT 0,
  `last_attempt_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `extended_args` varchar(8000) DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `hook_status_scheduled_date_gmt` (`hook`(163),`status`,`scheduled_date_gmt`),
  KEY `status_scheduled_date_gmt` (`status`,`scheduled_date_gmt`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id_status_priority_scheduled_date_gmt` (`claim_id`,`status`,`priority`,`scheduled_date_gmt`),
  KEY `status_last_attempt_gmt` (`status`,`last_attempt_gmt`),
  KEY `status_claim_id` (`status`,`claim_id`)
) ENGINE=InnoDB AUTO_INCREMENT=369 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `YTcMX_actionscheduler_claims` (
  `claim_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=40710 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `YTcMX_actionscheduler_groups` (
  `group_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `YTcMX_actionscheduler_logs` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint(20) unsigned NOT NULL,
  `message` text NOT NULL,
  `log_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=1069 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `YTcMX_aiowps_audit_log` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `network_id` bigint(20) NOT NULL DEFAULT 0,
  `site_id` bigint(20) NOT NULL DEFAULT 0,
  `username` varchar(60) NOT NULL DEFAULT '',
  `ip` varchar(45) NOT NULL DEFAULT '',
  `level` varchar(25) NOT NULL DEFAULT '',
  `event_type` varchar(25) NOT NULL DEFAULT '',
  `details` text NOT NULL,
  `stacktrace` text NOT NULL,
  `created` int(10) unsigned DEFAULT NULL,
  `country_code` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `username` (`username`),
  KEY `ip` (`ip`),
  KEY `level` (`level`),
  KEY `event_type` (`event_type`)
) ENGINE=InnoDB AUTO_INCREMENT=128 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `YTcMX_aiowps_debug_log` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created` datetime NOT NULL DEFAULT '1000-10-10 10:00:00',
  `logtime` int(10) unsigned DEFAULT NULL,
  `level` varchar(25) NOT NULL DEFAULT '',
  `network_id` bigint(20) NOT NULL DEFAULT 0,
  `site_id` bigint(20) NOT NULL DEFAULT 0,
  `message` text NOT NULL,
  `type` varchar(25) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `YTcMX_aiowps_events` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `event_type` varchar(150) NOT NULL DEFAULT '',
  `username` varchar(150) DEFAULT NULL,
  `user_id` bigint(20) DEFAULT NULL,
  `event_date` datetime NOT NULL DEFAULT '1000-10-10 10:00:00',
  `created` int(10) unsigned DEFAULT NULL,
  `ip_or_host` varchar(100) DEFAULT NULL,
  `referer_info` varchar(255) DEFAULT NULL,
  `url` varchar(255) DEFAULT NULL,
  `country_code` varchar(50) DEFAULT NULL,
  `event_data` longtext DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `YTcMX_aiowps_global_meta` (
  `meta_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `date_time` datetime NOT NULL DEFAULT '1000-10-10 10:00:00',
  `created` int(10) unsigned DEFAULT NULL,
  `meta_key1` varchar(255) NOT NULL,
  `meta_key2` varchar(255) NOT NULL,
  `meta_key3` varchar(255) NOT NULL,
  `meta_key4` varchar(255) NOT NULL,
  `meta_key5` varchar(255) NOT NULL,
  `meta_value1` varchar(255) NOT NULL,
  `meta_value2` text NOT NULL,
  `meta_value3` text NOT NULL,
  `meta_value4` longtext NOT NULL,
  `meta_value5` longtext NOT NULL,
  PRIMARY KEY (`meta_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `YTcMX_aiowps_logged_in_users` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `username` varchar(60) NOT NULL DEFAULT '',
  `ip_address` varchar(45) NOT NULL DEFAULT '',
  `site_id` bigint(20) NOT NULL,
  `created` int(10) unsigned DEFAULT NULL,
  `expires` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_user_id` (`user_id`),
  KEY `created` (`created`),
  KEY `expires` (`expires`),
  KEY `user_id` (`user_id`),
  KEY `site_id` (`site_id`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `YTcMX_aiowps_login_lockdown` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `user_login` varchar(150) NOT NULL,
  `lockdown_date` datetime NOT NULL DEFAULT '1000-10-10 10:00:00',
  `created` int(10) unsigned DEFAULT NULL,
  `release_date` datetime NOT NULL DEFAULT '1000-10-10 10:00:00',
  `released` int(10) unsigned DEFAULT NULL,
  `failed_login_ip` varchar(100) NOT NULL DEFAULT '',
  `lock_reason` varchar(128) NOT NULL DEFAULT '',
  `unlock_key` varchar(128) NOT NULL DEFAULT '',
  `is_lockout_email_sent` tinyint(1) NOT NULL DEFAULT 1,
  `backtrace_log` text NOT NULL,
  `ip_lookup_result` longtext DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `failed_login_ip` (`failed_login_ip`),
  KEY `is_lockout_email_sent` (`is_lockout_email_sent`),
  KEY `unlock_key` (`unlock_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `YTcMX_aiowps_message_store` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `message_key` text NOT NULL,
  `message_value` text NOT NULL,
  `created` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `YTcMX_aiowps_permanent_block` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `blocked_ip` varchar(100) NOT NULL DEFAULT '',
  `block_reason` varchar(128) NOT NULL DEFAULT '',
  `country_origin` varchar(50) NOT NULL DEFAULT '',
  `blocked_date` datetime NOT NULL DEFAULT '1000-10-10 10:00:00',
  `created` int(10) unsigned DEFAULT NULL,
  `unblock` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `blocked_ip` (`blocked_ip`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `YTcMX_chaty_contact_form_leads` (
  `id` bigint(11) NOT NULL AUTO_INCREMENT,
  `widget_id` int(11) DEFAULT NULL,
  `name` varchar(100) DEFAULT NULL,
  `email` varchar(100) DEFAULT NULL,
  `phone_number` varchar(100) DEFAULT NULL,
  `message` text DEFAULT NULL,
  `ref_page` text DEFAULT NULL,
  `ip_address` tinytext DEFAULT NULL,
  `created_on` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `YTcMX_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `YTcMX_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT 0,
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT 0,
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `YTcMX_duplicator_activity_logs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(100) NOT NULL,
  `sub_type` varchar(100) NOT NULL,
  `severity` int(8) NOT NULL,
  `title` text NOT NULL,
  `data` longtext NOT NULL,
  `parent_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `version` varchar(30) NOT NULL DEFAULT '',
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `type_idx` (`type`),
  KEY `sub_type_idx` (`sub_type`),
  KEY `severity_idx` (`severity`),
  KEY `created_at` (`created_at`),
  KEY `updated_at` (`updated_at`),
  KEY `version` (`version`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `YTcMX_duplicator_backups` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(100) NOT NULL,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `archive_name` varchar(350) NOT NULL DEFAULT '',
  `status` int(11) NOT NULL,
  `flags` set('MANUAL','SCHEDULE','SCHEDULE_RUN_NOW','DB_ONLY','MEDIA_ONLY','HAVE_LOCAL','HAVE_REMOTE','DISASTER_AVAIABLE','DISASTER_SET','CREATED_AFTER_RESTORE','ACTIVE','TEMPLATE','ZIP_ARCHIVE','DUP_ARCHIVE','TEMPORARY') NOT NULL DEFAULT '',
  `package` longtext NOT NULL,
  `version` varchar(30) NOT NULL DEFAULT '',
  `created` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `type_idx` (`type`),
  KEY `hash` (`hash`),
  KEY `flags` (`flags`),
  KEY `version` (`version`),
  KEY `created` (`created`),
  KEY `updated_at` (`updated_at`),
  KEY `status` (`status`),
  KEY `name` (`name`(191)),
  KEY `archive_name` (`archive_name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `YTcMX_duplicator_entities` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(100) NOT NULL,
  `value_1` varchar(255) NOT NULL DEFAULT '',
  `value_2` varchar(255) NOT NULL DEFAULT '',
  `value_3` varchar(255) NOT NULL DEFAULT '',
  `value_4` varchar(255) NOT NULL DEFAULT '',
  `value_5` varchar(255) NOT NULL DEFAULT '',
  `data` longtext NOT NULL,
  `version` varchar(30) NOT NULL DEFAULT '',
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `type_idx` (`type`),
  KEY `created_at` (`created_at`),
  KEY `updated_at` (`updated_at`),
  KEY `version` (`version`),
  KEY `value_1` (`value_1`(191)),
  KEY `value_2` (`value_2`(191)),
  KEY `value_3` (`value_3`(191)),
  KEY `value_4` (`value_4`(191)),
  KEY `value_5` (`value_5`(191))
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `YTcMX_e_events` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `event_data` text DEFAULT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `created_at_index` (`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `YTcMX_e_notes` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `route_url` text DEFAULT NULL COMMENT 'Clean url where the note was created.',
  `route_title` varchar(255) DEFAULT NULL,
  `route_post_id` bigint(20) unsigned DEFAULT NULL COMMENT 'The post id of the route that the note was created on.',
  `post_id` bigint(20) unsigned DEFAULT NULL,
  `element_id` varchar(60) DEFAULT NULL COMMENT 'The Elementor element ID the note is attached to.',
  `parent_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `author_id` bigint(20) unsigned DEFAULT NULL,
  `author_display_name` varchar(250) DEFAULT NULL COMMENT 'Save the author name when the author was deleted.',
  `status` varchar(20) NOT NULL DEFAULT 'publish',
  `position` text DEFAULT NULL COMMENT 'A JSON string that represents the position of the note inside the element in percentages. e.g. {x:10, y:15}',
  `content` longtext DEFAULT NULL,
  `is_resolved` tinyint(1) NOT NULL DEFAULT 0,
  `is_public` tinyint(1) NOT NULL DEFAULT 1,
  `last_activity_at` datetime DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `route_url_index` (`route_url`(191)),
  KEY `post_id_index` (`post_id`),
  KEY `element_id_index` (`element_id`),
  KEY `parent_id_index` (`parent_id`),
  KEY `author_id_index` (`author_id`),
  KEY `status_index` (`status`),
  KEY `is_resolved_index` (`is_resolved`),
  KEY `is_public_index` (`is_public`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`),
  KEY `last_activity_at_index` (`last_activity_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `YTcMX_e_notes_users_relations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(60) NOT NULL COMMENT 'The relation type between user and note (e.g mention, watch, read).',
  `note_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `type_index` (`type`),
  KEY `note_id_index` (`note_id`),
  KEY `user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `YTcMX_e_submissions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(60) DEFAULT NULL,
  `hash_id` varchar(60) NOT NULL,
  `main_meta_id` bigint(20) unsigned NOT NULL COMMENT 'Id of main field. to represent the main meta field',
  `post_id` bigint(20) unsigned NOT NULL,
  `referer` varchar(500) NOT NULL,
  `referer_title` varchar(300) DEFAULT NULL,
  `element_id` varchar(20) NOT NULL,
  `form_name` varchar(60) NOT NULL,
  `campaign_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `user_ip` varchar(46) NOT NULL,
  `user_agent` text NOT NULL,
  `actions_count` int(11) DEFAULT 0,
  `actions_succeeded_count` int(11) DEFAULT 0,
  `status` varchar(20) NOT NULL,
  `is_read` tinyint(1) NOT NULL DEFAULT 0,
  `meta` text DEFAULT NULL,
  `created_at_gmt` datetime NOT NULL,
  `updated_at_gmt` datetime NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `hash_id_unique_index` (`hash_id`),
  KEY `main_meta_id_index` (`main_meta_id`),
  KEY `hash_id_index` (`hash_id`),
  KEY `type_index` (`type`),
  KEY `post_id_index` (`post_id`),
  KEY `element_id_index` (`element_id`),
  KEY `campaign_id_index` (`campaign_id`),
  KEY `user_id_index` (`user_id`),
  KEY `user_ip_index` (`user_ip`),
  KEY `status_index` (`status`),
  KEY `is_read_index` (`is_read`),
  KEY `created_at_gmt_index` (`created_at_gmt`),
  KEY `updated_at_gmt_index` (`updated_at_gmt`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`),
  KEY `referer_index` (`referer`(191)),
  KEY `referer_title_index` (`referer_title`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `YTcMX_e_submissions_actions_log` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `submission_id` bigint(20) unsigned NOT NULL,
  `action_name` varchar(60) NOT NULL,
  `action_label` varchar(60) DEFAULT NULL,
  `status` varchar(20) NOT NULL,
  `log` text DEFAULT NULL,
  `created_at_gmt` datetime NOT NULL,
  `updated_at_gmt` datetime NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `submission_id_index` (`submission_id`),
  KEY `action_name_index` (`action_name`),
  KEY `status_index` (`status`),
  KEY `created_at_gmt_index` (`created_at_gmt`),
  KEY `updated_at_gmt_index` (`updated_at_gmt`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `YTcMX_e_submissions_values` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `submission_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `key` varchar(60) DEFAULT NULL,
  `value` longtext DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `submission_id_index` (`submission_id`),
  KEY `key_index` (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `YTcMX_ff_scheduled_actions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `action` varchar(255) DEFAULT NULL,
  `form_id` bigint(20) unsigned DEFAULT NULL,
  `origin_id` bigint(20) unsigned DEFAULT NULL,
  `feed_id` bigint(20) unsigned DEFAULT NULL,
  `type` varchar(255) DEFAULT 'submission_action',
  `status` varchar(255) DEFAULT NULL,
  `data` longtext DEFAULT NULL,
  `note` tinytext DEFAULT NULL,
  `retry_count` int(10) unsigned DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `YTcMX_fluentform_entry_details` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `form_id` bigint(20) unsigned DEFAULT NULL,
  `submission_id` bigint(20) unsigned DEFAULT NULL,
  `field_name` varchar(255) DEFAULT NULL,
  `sub_field_name` varchar(255) DEFAULT NULL,
  `field_value` longtext DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `YTcMX_fluentform_forms` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `status` varchar(45) DEFAULT 'Draft',
  `appearance_settings` text DEFAULT NULL,
  `form_fields` longtext DEFAULT NULL,
  `has_payment` tinyint(1) NOT NULL DEFAULT 0,
  `type` varchar(45) DEFAULT NULL,
  `conditions` text DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `YTcMX_fluentform_form_analytics` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `form_id` int(10) unsigned DEFAULT NULL,
  `user_id` int(10) unsigned DEFAULT NULL,
  `source_url` text NOT NULL,
  `platform` char(30) DEFAULT NULL,
  `browser` char(30) DEFAULT NULL,
  `city` varchar(100) DEFAULT NULL,
  `country` varchar(100) DEFAULT NULL,
  `ip` char(15) DEFAULT NULL,
  `count` int(11) DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `YTcMX_fluentform_form_meta` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `form_id` int(10) unsigned DEFAULT NULL,
  `meta_key` varchar(255) NOT NULL,
  `value` longtext DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `YTcMX_fluentform_logs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `parent_source_id` int(10) unsigned DEFAULT NULL,
  `source_type` varchar(255) DEFAULT NULL,
  `source_id` int(10) unsigned DEFAULT NULL,
  `component` varchar(255) DEFAULT NULL,
  `status` char(30) DEFAULT NULL,
  `title` varchar(255) NOT NULL,
  `description` longtext DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `YTcMX_fluentform_submissions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `form_id` int(10) unsigned DEFAULT NULL,
  `serial_number` int(10) unsigned DEFAULT NULL,
  `response` longtext DEFAULT NULL,
  `source_url` varchar(255) DEFAULT NULL,
  `user_id` int(10) unsigned DEFAULT NULL,
  `status` varchar(45) DEFAULT 'unread' COMMENT 'possible values: read, unread, trashed',
  `is_favourite` tinyint(1) NOT NULL DEFAULT 0,
  `browser` varchar(45) DEFAULT NULL,
  `device` varchar(45) DEFAULT NULL,
  `ip` varchar(45) DEFAULT NULL,
  `city` varchar(45) DEFAULT NULL,
  `country` varchar(45) DEFAULT NULL,
  `payment_status` varchar(45) DEFAULT NULL,
  `payment_method` varchar(45) DEFAULT NULL,
  `payment_type` varchar(45) DEFAULT NULL,
  `currency` varchar(45) DEFAULT NULL,
  `payment_total` float DEFAULT NULL,
  `total_paid` float DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `YTcMX_fluentform_submission_meta` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `response_id` bigint(20) unsigned DEFAULT NULL,
  `form_id` int(10) unsigned DEFAULT NULL,
  `meta_key` varchar(45) DEFAULT NULL,
  `value` longtext DEFAULT NULL,
  `status` varchar(45) DEFAULT NULL,
  `user_id` int(10) unsigned DEFAULT NULL,
  `name` varchar(45) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `YTcMX_fsmpt_email_logs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `site_id` int(10) unsigned DEFAULT NULL,
  `to` varchar(255) DEFAULT NULL,
  `from` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `body` longtext DEFAULT NULL,
  `headers` longtext DEFAULT NULL,
  `attachments` longtext DEFAULT NULL,
  `status` varchar(20) DEFAULT 'pending',
  `response` text DEFAULT NULL,
  `extra` text DEFAULT NULL,
  `retries` int(10) unsigned DEFAULT 0,
  `resent_count` int(10) unsigned DEFAULT 0,
  `source` varchar(255) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `YTcMX_gf_draft_submissions` (
  `uuid` char(32) NOT NULL,
  `email` varchar(255) DEFAULT NULL,
  `form_id` mediumint(10) unsigned NOT NULL,
  `date_created` datetime NOT NULL,
  `ip` varchar(45) NOT NULL,
  `source_url` longtext NOT NULL,
  `submission` longtext NOT NULL,
  PRIMARY KEY (`uuid`),
  KEY `form_id` (`form_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `YTcMX_gf_entry` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `form_id` mediumint(10) unsigned NOT NULL,
  `post_id` bigint(10) unsigned DEFAULT NULL,
  `date_created` datetime NOT NULL,
  `date_updated` datetime DEFAULT NULL,
  `is_starred` tinyint(10) NOT NULL DEFAULT 0,
  `is_read` tinyint(10) NOT NULL DEFAULT 0,
  `ip` varchar(45) NOT NULL,
  `source_url` varchar(200) NOT NULL DEFAULT '',
  `user_agent` varchar(250) NOT NULL DEFAULT '',
  `currency` varchar(5) DEFAULT NULL,
  `payment_status` varchar(15) DEFAULT NULL,
  `payment_date` datetime DEFAULT NULL,
  `payment_amount` decimal(19,2) DEFAULT NULL,
  `payment_method` varchar(30) DEFAULT NULL,
  `transaction_id` varchar(50) DEFAULT NULL,
  `is_fulfilled` tinyint(10) DEFAULT NULL,
  `created_by` bigint(10) unsigned DEFAULT NULL,
  `transaction_type` tinyint(10) DEFAULT NULL,
  `status` varchar(20) NOT NULL DEFAULT 'active',
  `source_id` bigint(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `form_id` (`form_id`),
  KEY `form_id_status` (`form_id`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `YTcMX_gf_entry_meta` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `form_id` mediumint(10) unsigned NOT NULL DEFAULT 0,
  `entry_id` bigint(10) unsigned NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  `item_index` varchar(60) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `meta_key` (`meta_key`(191)),
  KEY `entry_id` (`entry_id`),
  KEY `meta_value` (`meta_value`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `YTcMX_gf_entry_notes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `entry_id` int(10) unsigned NOT NULL,
  `user_name` varchar(250) DEFAULT NULL,
  `user_id` bigint(10) DEFAULT NULL,
  `date_created` datetime NOT NULL,
  `value` longtext DEFAULT NULL,
  `note_type` varchar(50) DEFAULT NULL,
  `sub_type` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `entry_id` (`entry_id`),
  KEY `entry_user_key` (`entry_id`,`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `YTcMX_gf_form` (
  `id` mediumint(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(150) NOT NULL,
  `date_created` datetime NOT NULL,
  `date_updated` datetime DEFAULT NULL,
  `is_active` tinyint(10) NOT NULL DEFAULT 1,
  `is_trash` tinyint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `YTcMX_gf_form_meta` (
  `form_id` mediumint(10) unsigned NOT NULL,
  `display_meta` longtext DEFAULT NULL,
  `entries_grid_meta` longtext DEFAULT NULL,
  `confirmations` longtext DEFAULT NULL,
  `notifications` longtext DEFAULT NULL,
  PRIMARY KEY (`form_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `YTcMX_gf_form_revisions` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `form_id` mediumint(10) unsigned NOT NULL,
  `display_meta` longtext DEFAULT NULL,
  `date_created` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `date_created` (`date_created`),
  KEY `form_id` (`form_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `YTcMX_gf_form_view` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `form_id` mediumint(10) unsigned NOT NULL,
  `date_created` datetime NOT NULL,
  `ip` char(15) DEFAULT NULL,
  `count` mediumint(10) unsigned NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`),
  KEY `date_created` (`date_created`),
  KEY `form_id` (`form_id`)
) ENGINE=InnoDB AUTO_INCREMENT=52 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `YTcMX_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT 1,
  `link_rating` int(11) NOT NULL DEFAULT 0,
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `YTcMX_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=83307 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `YTcMX_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=21526 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `YTcMX_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT 0,
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext NOT NULL,
  `post_title` text NOT NULL,
  `post_excerpt` text NOT NULL,
  `post_status` varchar(20) NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) NOT NULL DEFAULT 'open',
  `post_password` varchar(255) NOT NULL DEFAULT '',
  `post_name` varchar(200) NOT NULL DEFAULT '',
  `to_ping` text NOT NULL,
  `pinged` text NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `guid` varchar(255) NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT 0,
  `post_type` varchar(20) NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`),
  KEY `type_status_author` (`post_type`,`post_status`,`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=1625 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `YTcMX_rank_math_404_logs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `uri` varchar(255) NOT NULL,
  `accessed` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `times_accessed` bigint(20) unsigned NOT NULL DEFAULT 1,
  `referer` varchar(255) NOT NULL DEFAULT '',
  `user_agent` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `uri` (`uri`(191))
) ENGINE=InnoDB AUTO_INCREMENT=86 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `YTcMX_rank_math_analytics_gsc` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `created` timestamp NOT NULL,
  `query` varchar(1000) NOT NULL,
  `page` varchar(500) NOT NULL,
  `clicks` mediumint(6) NOT NULL,
  `impressions` mediumint(6) NOT NULL,
  `position` double NOT NULL,
  `ctr` double NOT NULL,
  PRIMARY KEY (`id`),
  KEY `analytics_query` (`query`(190)),
  KEY `analytics_page` (`page`(190)),
  KEY `clicks` (`clicks`),
  KEY `rank_position` (`position`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `YTcMX_rank_math_analytics_inspections` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `page` varchar(500) NOT NULL,
  `created` timestamp NOT NULL,
  `index_verdict` varchar(64) NOT NULL,
  `indexing_state` varchar(64) NOT NULL,
  `coverage_state` text NOT NULL,
  `page_fetch_state` varchar(64) NOT NULL,
  `robots_txt_state` varchar(64) NOT NULL,
  `rich_results_verdict` varchar(64) NOT NULL,
  `rich_results_items` longtext NOT NULL,
  `last_crawl_time` timestamp NOT NULL,
  `crawled_as` varchar(64) NOT NULL,
  `google_canonical` text NOT NULL,
  `user_canonical` text NOT NULL,
  `sitemap` text NOT NULL,
  `referring_urls` longtext NOT NULL,
  `raw_api_response` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `analytics_object_page` (`page`(190)),
  KEY `created` (`created`),
  KEY `index_verdict` (`index_verdict`),
  KEY `page_fetch_state` (`page_fetch_state`),
  KEY `robots_txt_state` (`robots_txt_state`),
  KEY `rich_results_verdict` (`rich_results_verdict`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `YTcMX_rank_math_analytics_objects` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `created` timestamp NOT NULL,
  `title` text NOT NULL,
  `page` varchar(500) NOT NULL,
  `object_type` varchar(100) NOT NULL,
  `object_subtype` varchar(100) NOT NULL,
  `object_id` bigint(20) unsigned NOT NULL,
  `primary_key` varchar(255) NOT NULL,
  `seo_score` tinyint(4) NOT NULL DEFAULT 0,
  `page_score` tinyint(4) NOT NULL DEFAULT 0,
  `is_indexable` tinyint(1) NOT NULL DEFAULT 1,
  `schemas_in_use` varchar(500) DEFAULT NULL,
  `desktop_interactive` double DEFAULT 0,
  `desktop_pagescore` double DEFAULT 0,
  `mobile_interactive` double DEFAULT 0,
  `mobile_pagescore` double DEFAULT 0,
  `pagespeed_refreshed` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `analytics_object_page` (`page`(190))
) ENGINE=InnoDB AUTO_INCREMENT=46 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `YTcMX_rank_math_internal_links` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(255) NOT NULL,
  `post_id` bigint(20) unsigned NOT NULL,
  `target_post_id` bigint(20) unsigned NOT NULL,
  `type` varchar(8) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `link_direction` (`post_id`,`type`),
  KEY `target_post_id` (`target_post_id`)
) ENGINE=InnoDB AUTO_INCREMENT=6038 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `YTcMX_rank_math_internal_meta` (
  `object_id` bigint(20) unsigned NOT NULL,
  `internal_link_count` int(10) unsigned DEFAULT 0,
  `external_link_count` int(10) unsigned DEFAULT 0,
  `incoming_link_count` int(10) unsigned DEFAULT 0,
  PRIMARY KEY (`object_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `YTcMX_rank_math_redirections` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `sources` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `url_to` text NOT NULL,
  `header_code` smallint(4) unsigned NOT NULL,
  `hits` bigint(20) unsigned NOT NULL DEFAULT 0,
  `status` varchar(25) NOT NULL DEFAULT 'active',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_accessed` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `YTcMX_rank_math_redirections_cache` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `from_url` text CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `redirection_id` bigint(20) unsigned NOT NULL,
  `object_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `object_type` varchar(10) NOT NULL DEFAULT 'post',
  `is_redirected` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `redirection_id` (`redirection_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `YTcMX_statistics_events` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `date` datetime NOT NULL,
  `page_id` bigint(20) DEFAULT NULL,
  `visitor_id` bigint(20) DEFAULT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `event_name` varchar(64) NOT NULL,
  `event_data` text NOT NULL,
  PRIMARY KEY (`ID`),
  KEY `visitor_id` (`visitor_id`),
  KEY `page_id` (`page_id`),
  KEY `event_name` (`event_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `YTcMX_statistics_exclusions` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `reason` varchar(180) DEFAULT NULL,
  `count` bigint(20) NOT NULL,
  PRIMARY KEY (`ID`),
  KEY `date` (`date`),
  KEY `reason` (`reason`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `YTcMX_statistics_historical` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `category` varchar(25) NOT NULL,
  `page_id` bigint(20) NOT NULL,
  `uri` varchar(190) NOT NULL,
  `value` bigint(20) NOT NULL,
  PRIMARY KEY (`ID`),
  UNIQUE KEY `uri` (`uri`),
  KEY `category` (`category`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `YTcMX_statistics_pages` (
  `page_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `uri` varchar(190) NOT NULL,
  `type` varchar(180) NOT NULL,
  `date` date NOT NULL,
  `count` int(11) NOT NULL,
  `id` int(11) NOT NULL,
  PRIMARY KEY (`page_id`),
  UNIQUE KEY `date_2` (`date`,`uri`),
  KEY `url` (`uri`),
  KEY `date` (`date`),
  KEY `id` (`id`),
  KEY `uri` (`uri`,`count`,`id`)
) ENGINE=InnoDB AUTO_INCREMENT=176 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `YTcMX_statistics_summary_totals` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `visitors` bigint(20) unsigned NOT NULL,
  `views` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`ID`),
  UNIQUE KEY `date` (`date`)
) ENGINE=InnoDB AUTO_INCREMENT=61 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `YTcMX_statistics_visitor` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `last_counter` date NOT NULL,
  `referred` text NOT NULL,
  `agent` varchar(180) NOT NULL,
  `platform` varchar(180) DEFAULT NULL,
  `version` varchar(180) DEFAULT NULL,
  `device` varchar(180) DEFAULT NULL,
  `model` varchar(180) DEFAULT NULL,
  `UAString` varchar(190) DEFAULT NULL,
  `ip` varchar(60) NOT NULL,
  `location` varchar(10) DEFAULT NULL,
  `user_id` bigint(40) NOT NULL,
  `hits` int(11) DEFAULT NULL,
  `honeypot` int(11) DEFAULT NULL,
  `city` varchar(100) DEFAULT NULL,
  `region` varchar(100) DEFAULT NULL,
  `continent` varchar(50) DEFAULT NULL,
  `source_channel` varchar(50) DEFAULT NULL,
  `source_name` varchar(100) DEFAULT NULL,
  `first_page` bigint(20) unsigned DEFAULT NULL,
  `first_view` datetime DEFAULT NULL,
  `last_page` bigint(20) unsigned DEFAULT NULL,
  `last_view` datetime DEFAULT NULL,
  PRIMARY KEY (`ID`),
  UNIQUE KEY `date_ip_agent` (`last_counter`,`ip`,`agent`(50),`platform`(50),`version`(50)),
  KEY `agent` (`agent`),
  KEY `platform` (`platform`),
  KEY `version` (`version`),
  KEY `device` (`device`),
  KEY `model` (`model`),
  KEY `location` (`location`),
  KEY `ip` (`ip`)
) ENGINE=InnoDB AUTO_INCREMENT=183 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `YTcMX_statistics_visitor_relationships` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `visitor_id` bigint(20) NOT NULL,
  `page_id` bigint(20) NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`ID`),
  KEY `visitor_id` (`visitor_id`),
  KEY `page_id` (`page_id`)
) ENGINE=InnoDB AUTO_INCREMENT=390 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `YTcMX_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `YTcMX_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=82 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `YTcMX_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_order` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `YTcMX_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `taxonomy` varchar(32) NOT NULL DEFAULT '',
  `description` longtext NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=82 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `YTcMX_wpuf_subscribers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `name` varchar(191) NOT NULL,
  `subscribtion_id` varchar(191) NOT NULL,
  `subscribtion_status` varchar(191) NOT NULL,
  `gateway` varchar(191) NOT NULL,
  `transaction_id` varchar(191) NOT NULL,
  `starts_from` varchar(191) NOT NULL,
  `expire` varchar(191) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `YTcMX_wpuf_transaction` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) DEFAULT NULL,
  `status` varchar(60) NOT NULL DEFAULT 'pending_payment',
  `subtotal` varchar(255) DEFAULT '',
  `tax` varchar(255) DEFAULT '',
  `cost` varchar(255) DEFAULT '',
  `post_id` varchar(20) DEFAULT NULL,
  `pack_id` bigint(20) DEFAULT NULL,
  `payer_first_name` varchar(60) DEFAULT NULL,
  `payer_last_name` varchar(60) DEFAULT NULL,
  `payer_email` varchar(100) DEFAULT NULL,
  `payment_type` varchar(20) DEFAULT NULL,
  `payer_address` longtext DEFAULT NULL,
  `transaction_id` varchar(60) DEFAULT NULL,
  `created` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `post_id` (`post_id`),
  KEY `pack_id` (`pack_id`),
  KEY `payer_email` (`payer_email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

/***** TABLE CREATION END *****/
INSERT IGNORE INTO `YTcMX_users` VALUES 
("1","admin_x9yeemci","$wp$2y$10$k7iO9wdS21Ra/brWafqn1u.z0J8RS9EMcHrrkFHp58f59wgj.Zhyi","admin_x9yeemci","admin@avnalaw.com","https://avnalaw.com","2025-08-30 19:34:28","","0","admin"),
("3","author_w5upz2oe","$wp$2y$10$W9MN0DPYibl0et4WpAC4QexrVL0NGiA9/x9rO4wEJr7DA19N8YVMi","author_w5upz2oe","user101@avnalaw.com","","2025-09-03 18:06:44","","0","author_w5upz2oe"),
("6","hashemi","$wp$2y$10$n9ApRpmOfLjyamz2eGU01evscqPnmrK2ktxnyterSCPSpX.CzB3Um","hashemi","sayidmahdi@gmail.com","","2025-12-07 07:10:37","","0","hashemi"),
("7","rasaneh-design","$wp$2y$10$lydI4ju6PlKTHc2Ua4agpeFDZWYXlnhcZdehJYpaoN67D.NKkT2Ci","rasaneh-design","rasane.design@gmail.com","","2025-12-07 13:56:46","","0","rasaneh-design"),
("8","a.hashemi","$wp$2y$10$U1wo4vVSUi4iODLR9q/HeufvyFZR59X06FBgwjeMOeEJppTCjY.CS","a-hashemi","seo3.rasanehsoft@gmail.com","","2025-12-07 13:58:43","","0","a.hashemi");

INSERT IGNORE INTO `YTcMX_usermeta` VALUES 
("1","1","nickname","admin_x9yeemci"),
("2","1","first_name",""),
("3","1","last_name",""),
("4","1","description",""),
("5","1","rich_editing","true"),
("6","1","syntax_highlighting","true"),
("7","1","comment_shortcuts","false"),
("8","1","admin_color","fresh"),
("9","1","use_ssl","0"),
("10","1","show_admin_bar_front","true"),
("11","1","locale","en_US"),
("12","1","YTcMX_capabilities","a:1:{s:13:\"administrator\";b:1;}"),
("13","1","YTcMX_user_level","10"),
("14","1","dismissed_wp_pointers",""),
("15","1","show_welcome_panel","0"),
("17","1","YTcMX_dashboard_quick_press_last_post_id","1163"),
("18","1","community-events-location","a:1:{s:2:\"ip\";s:12:\"104.28.214.0\";}"),
("19","1","wfls-last-login","1765091161"),
("20","1","astra-sites-on-active","notice-dismissed"),
("21","1","closedpostboxes_dashboard","a:0:{}"),
("22","1","metaboxhidden_dashboard","a:2:{i:0;s:16:\"wpuf_admin_db_mb\";i:1;s:21:\"dashboard_quick_press\";}"),
("23","1","YTcMX_user-settings","libraryContent=browse&editor=html&mfold=o"),
("24","1","YTcMX_user-settings-time","1757887628"),
("25","1","pse_country_code","IR"),
("26","1","hfcm_file_edit_plugin_notice_dismissed","true"),
("27","1","YTcMX_persisted_preferences","a:5:{s:4:\"core\";a:2:{s:26:\"isComplementaryAreaVisible\";b:1;s:10:\"openPanels\";a:3:{i:0;s:11:\"post-status\";i:1;s:23:\"taxonomy-panel-category\";i:2;s:23:\"taxonomy-panel-post_tag\";}}s:9:\"_modified\";s:24:\"2025-11-30T09:03:09.653Z\";s:14:\"core/edit-post\";a:1:{s:12:\"welcomeGuide\";b:0;}s:22:\"core/customize-widgets\";a:1:{s:12:\"welcomeGuide\";b:0;}s:17:\"core/block-editor\";a:1:{s:25:\"linkControlSettingsDrawer\";b:0;}}"),
("42","3","nickname","author_w5upz2oe"),
("43","3","first_name",""),
("44","3","last_name",""),
("45","3","description",""),
("46","3","rich_editing","true"),
("47","3","syntax_highlighting","true"),
("48","3","comment_shortcuts","false"),
("49","3","admin_color","fresh"),
("50","3","use_ssl","0"),
("51","3","show_admin_bar_front","true"),
("52","3","locale",""),
("53","3","YTcMX_capabilities","a:1:{s:6:\"author\";b:1;}"),
("54","3","YTcMX_user_level","2"),
("55","3","dismissed_wp_pointers",""),
("57","3","wfls-last-login","1765033434"),
("59","3","_wpuf_subscription_pack",""),
("60","1","meta-box-order_dashboard","a:4:{s:6:\"normal\";s:153:\"rank_math_dashboard_widget,dashboard_site_health,fluentsmtp_reports_widget,dashboard_activity,dashboard_right_now,wpuf_admin_db_mb,fluentform_stat_widget\";s:4:\"side\";s:72:\"dashboard_quick_press,wordfence_activity_report_widget,dashboard_primary\";s:7:\"column3\";s:0:\"\";s:7:\"column4\";s:0:\"\";}"),
("91","1","spectra-optin-notice","notice-dismissed"),
("92","1","YTcMX_media_library_mode","grid"),
("93","1","manageedit-postcolumnshidden","a:3:{i:0;s:0:\"\";i:1;s:15:\"rank_math_title\";i:2;s:21:\"rank_math_description\";}"),
("94","1","manageedit-postcolumnshidden_default","1"),
("95","1","manageedit-pagecolumnshidden","a:3:{i:0;s:0:\"\";i:1;s:15:\"rank_math_title\";i:2;s:21:\"rank_math_description\";}"),
("96","1","manageedit-pagecolumnshidden_default","1"),
("97","1","manageedit-wpuf_subscriptioncolumnshidden","a:3:{i:0;s:0:\"\";i:1;s:15:\"rank_math_title\";i:2;s:21:\"rank_math_description\";}"),
("98","1","manageedit-wpuf_subscriptioncolumnshidden_default","1"),
("99","1","last_update","1766063540"),
("100","3","manageedit-postcolumnshidden","a:3:{i:0;s:0:\"\";i:1;s:15:\"rank_math_title\";i:2;s:21:\"rank_math_description\";}"),
("101","3","manageedit-postcolumnshidden_default","1"),
("102","3","manageedit-pagecolumnshidden","a:3:{i:0;s:0:\"\";i:1;s:15:\"rank_math_title\";i:2;s:21:\"rank_math_description\";}"),
("103","3","manageedit-pagecolumnshidden_default","1"),
("104","3","last_update","1764611299"),
("105","3","session_tokens","a:1:{s:64:\"db883d2eabbab74eeaab6800f11131b45e83113faf26f70cfee61098d7f8ba9f\";a:4:{s:10:\"expiration\";i:1769895681;s:2:\"ip\";s:13:\"89.198.101.39\";s:2:\"ua\";s:111:\"Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Mobile Safari/537.36\";s:5:\"login\";i:1769722881;}}"),
("106","1","rank_math_hide_frontend_stats","1"),
("107","1","meta-box-order_page","a:2:{i:0;b:0;s:4:\"side\";s:38:\"submitdiv,rank_math_metabox_content_ai\";}"),
("109","1","twitter",""),
("110","1","facebook",""),
("111","1","additional_profile_urls",""),
("112","3","twitter",""),
("113","3","facebook",""),
("114","3","additional_profile_urls",""),
("115","1","meta-box-order_post","a:2:{i:0;b:0;s:4:\"side\";s:38:\"submitdiv,rank_math_metabox_content_ai\";}"),
("116","1","session_tokens","a:1:{s:64:\"5c5c94bd2461a1432cc3781d5657db0f3f1208380db85020cf33194d4a7b9ae0\";a:4:{s:10:\"expiration\";i:1765263961;s:2:\"ip\";s:14:\"104.28.214.165\";s:2:\"ua\";s:80:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:145.0) Gecko/20100101 Firefox/145.0\";s:5:\"login\";i:1765091161;}}"),
("117","6","nickname","hashemi"),
("118","6","first_name",""),
("119","6","last_name",""),
("120","6","description",""),
("121","6","rich_editing","true"),
("122","6","syntax_highlighting","true"),
("123","6","comment_shortcuts","false"),
("124","6","admin_color","fresh"),
("125","6","use_ssl","0"),
("126","6","show_admin_bar_front","true"),
("127","6","locale","fa_IR"),
("128","6","YTcMX_capabilities","a:1:{s:13:\"administrator\";b:1;}"),
("129","6","YTcMX_user_level","10"),
("130","6","last_update","1766516565"),
("131","6","dismissed_wp_pointers",""),
("132","6","twitter",""),
("133","6","facebook",""),
("134","6","additional_profile_urls",""),
("135","6","session_tokens","a:1:{s:64:\"0a0b4247e0b6e137c1b78e258a51725e3fdbd43738b9e5ede8662bcf3ac98a03\";a:4:{s:10:\"expiration\";i:1770449547;s:2:\"ip\";s:12:\"89.58.46.160\";s:2:\"ua\";s:80:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:147.0) Gecko/20100101 Firefox/147.0\";s:5:\"login\";i:1770276747;}}"),
("136","6","YTcMX_dashboard_quick_press_last_post_id","1622"),
("137","6","manageedit-postcolumnshidden","a:3:{i:0;s:0:\"\";i:1;s:15:\"rank_math_title\";i:2;s:21:\"rank_math_description\";}"),
("138","6","manageedit-postcolumnshidden_default","1"),
("139","6","manageedit-pagecolumnshidden","a:3:{i:0;s:0:\"\";i:1;s:15:\"rank_math_title\";i:2;s:21:\"rank_math_description\";}"),
("140","6","manageedit-pagecolumnshidden_default","1"),
("141","6","community-events-location","a:1:{s:2:\"ip\";s:12:\"152.53.117.0\";}"),
("142","6","metaboxhidden_dashboard","a:17:{i:0;s:13:\"rss_dashboard\";i:1;s:26:\"rank_math_dashboard_widget\";i:2;s:20:\"e-dashboard-overview\";i:3;s:25:\"wp-statistics-hits-widget\";i:4;s:27:\"wp-statistics-search-widget\";i:5;s:26:\"wp-statistics-pages-widget\";i:6;s:33:\"wp-statistics-top-visitors-widget\";i:7;s:27:\"wp-statistics-recent-widget\";i:8;s:31:\"wp-statistics-useronline-widget\";i:9;s:28:\"wp-statistics-hitsmap-widget\";i:10;s:29:\"wp-statistics-browsers-widget\";i:11;s:30:\"wp-statistics-platforms-widget\";i:12;s:28:\"wp-statistics-devices-widget\";i:13;s:27:\"wp-statistics-models-widget\";i:14;s:30:\"wp-statistics-countries-widget\";i:15;s:30:\"wp-statistics-referring-widget\";i:16;s:17:\"dashboard_primary\";}"),
("143","6","wp_statistics_metaboxhidden_dashboard_initialized","1"),
("144","6","meta-box-order_page","a:2:{i:0;b:0;s:4:\"side\";s:38:\"submitdiv,rank_math_metabox_content_ai\";}"),
("145","6","pse_country_code","IR"),
("146","6","YTcMX_persisted_preferences","a:3:{s:4:\"core\";a:2:{s:26:\"isComplementaryAreaVisible\";b:1;s:10:\"openPanels\";a:2:{i:0;s:11:\"post-status\";i:1;s:23:\"taxonomy-panel-category\";}}s:14:\"core/edit-post\";a:1:{s:12:\"welcomeGuide\";b:0;}s:9:\"_modified\";s:24:\"2025-12-23T15:33:19.134Z\";}"),
("147","6","meta-box-order_dashboard","a:4:{s:6:\"normal\";s:297:\"rss_dashboard,rank_math_dashboard_widget,e-dashboard-overview,wp-statistics-quickstats-widget,wp-statistics-hits-widget,wp-statistics-search-widget,wp-statistics-pages-widget,wp-statistics-top-visitors-widget,wp-statistics-recent-widget,wp-statistics-useronline-widget,wp-statistics-hitsmap-widget\";s:4:\"side\";s:198:\"dashboard_activity,wp-statistics-browsers-widget,wp-statistics-platforms-widget,wp-statistics-devices-widget,wp-statistics-models-widget,wp-statistics-countries-widget,wp-statistics-referring-widget\";s:7:\"column3\";s:60:\"rg_forms_dashboard,dashboard_quick_press,dashboard_right_now\";s:7:\"column4\";s:39:\"dashboard_site_health,dashboard_primary\";}"),
("148","6","manageedit-e-floating-buttonscolumnshidden","a:3:{i:0;s:0:\"\";i:1;s:15:\"rank_math_title\";i:2;s:21:\"rank_math_description\";}"),
("149","6","manageedit-e-floating-buttonscolumnshidden_default","1"),
("150","6","elementor_introduction","a:4:{s:27:\"ai-get-started-announcement\";b:1;s:20:\"globals_introduction\";b:1;s:59:\"ai_get_started_introduction_site_logo_with_ai_site-settings\";b:1;s:27:\"e-editor-one-notice-pointer\";b:1;}"),
("151","6","aiowps_last_login_time","2026-02-05 07:32:27"),
("152","7","nickname","rasaneh-design"),
("153","7","first_name",""),
("154","7","last_name",""),
("155","7","description",""),
("156","7","rich_editing","true"),
("157","7","syntax_highlighting","true"),
("158","7","comment_shortcuts","false"),
("159","7","admin_color","fresh"),
("160","7","use_ssl","0"),
("161","7","show_admin_bar_front","true"),
("162","7","locale",""),
("163","7","YTcMX_capabilities","a:1:{s:13:\"administrator\";b:1;}"),
("164","7","YTcMX_user_level","10"),
("165","7","last_update","1765914408"),
("166","7","dismissed_wp_pointers",""),
("167","7","twitter",""),
("168","7","facebook",""),
("169","7","additional_profile_urls",""),
("170","8","nickname","a.hashemi"),
("171","8","first_name",""),
("172","8","last_name",""),
("173","8","description",""),
("174","8","rich_editing","true"),
("175","8","syntax_highlighting","true"),
("176","8","comment_shortcuts","false"),
("177","8","admin_color","fresh"),
("178","8","use_ssl","0"),
("179","8","show_admin_bar_front","true"),
("180","8","locale",""),
("181","8","YTcMX_capabilities","a:1:{s:13:\"administrator\";b:1;}"),
("182","8","YTcMX_user_level","10"),
("183","8","last_update","1767895379"),
("184","8","dismissed_wp_pointers",""),
("185","8","session_tokens","a:1:{s:64:\"ba9fa2596824d97a9816b432d2673f3182d10d592e2016ddba9405dbd8f486fe\";a:4:{s:10:\"expiration\";i:1770190959;s:2:\"ip\";s:15:\"216.247.106.186\";s:2:\"ua\";s:111:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Safari/537.36\";s:5:\"login\";i:1770018159;}}"),
("186","8","aiowps_last_login_time","2026-02-02 07:42:39"),
("187","8","metaboxhidden_dashboard","a:16:{i:0;s:36:\"wp-statistics-traffic-summary-widget\";i:1;s:29:\"wp-statistics-browsers-widget\";i:2;s:30:\"wp-statistics-platforms-widget\";i:3;s:28:\"wp-statistics-devices-widget\";i:4;s:27:\"wp-statistics-models-widget\";i:5;s:25:\"wp-statistics-hits-widget\";i:6;s:27:\"wp-statistics-search-widget\";i:7;s:26:\"wp-statistics-pages-widget\";i:8;s:33:\"wp-statistics-top-visitors-widget\";i:9;s:27:\"wp-statistics-recent-widget\";i:10;s:31:\"wp-statistics-useronline-widget\";i:11;s:30:\"wp-statistics-countries-widget\";i:12;s:30:\"wp-statistics-referring-widget\";i:13;s:27:\"wp-statistics-about-metabox\";i:14;s:31:\"wp-statistics-go-premium-widget\";i:15;s:28:\"wp-statistics-hitsmap-widget\";}"),
("188","8","wp_statistics_metaboxhidden_dashboard_initialized","1"),
("189","8","YTcMX_dashboard_quick_press_last_post_id","1621"),
("190","8","manageedit-postcolumnshidden","a:3:{i:0;s:0:\"\";i:1;s:15:\"rank_math_title\";i:2;s:21:\"rank_math_description\";}"),
("191","8","manageedit-postcolumnshidden_default","1"),
("192","8","manageedit-pagecolumnshidden","a:3:{i:0;s:0:\"\";i:1;s:15:\"rank_math_title\";i:2;s:21:\"rank_math_description\";}"),
("193","8","manageedit-pagecolumnshidden_default","1"),
("194","8","manageedit-e-floating-buttonscolumnshidden","a:3:{i:0;s:0:\"\";i:1;s:15:\"rank_math_title\";i:2;s:21:\"rank_math_description\";}"),
("195","8","manageedit-e-floating-buttonscolumnshidden_default","1"),
("196","8","community-events-location","a:1:{s:2:\"ip\";s:13:\"216.247.106.0\";}"),
("197","8","meta-box-order_page","a:2:{i:0;b:0;s:4:\"side\";s:38:\"submitdiv,rank_math_metabox_content_ai\";}"),
("198","8","elementor_introduction","a:2:{s:27:\"ai-get-started-announcement\";b:1;s:20:\"globals_introduction\";b:1;}"),
("199","8","YTcMX_user-settings","editor=tinymce&libraryContent=browse"),
("200","8","YTcMX_user-settings-time","1765962952"),
("201","6","YTcMX_user-settings","editor=tinymce&libraryContent=upload"),
("202","6","YTcMX_user-settings-time","1766503953"),
("203","8","pse_country_code","PL"),
("204","8","YTcMX_persisted_preferences","a:3:{s:14:\"core/edit-post\";a:1:{s:12:\"welcomeGuide\";b:0;}s:4:\"core\";a:1:{s:26:\"isComplementaryAreaVisible\";b:1;}s:9:\"_modified\";s:24:\"2025-12-07T14:07:33.538Z\";}"),
("205","6","closedpostboxes_page","a:0:{}"),
("206","6","metaboxhidden_page","a:6:{i:0;s:18:\"wpuf-custom-fields\";i:1;s:10:\"postcustom\";i:2;s:16:\"commentstatusdiv\";i:3;s:11:\"commentsdiv\";i:4;s:7:\"slugdiv\";i:5;s:9:\"authordiv\";}"),
("207","7","session_tokens","a:1:{s:64:\"238ceeca864034eb06b1e067f80881777400b5c5a91332b1329308f7b8abded9\";a:4:{s:10:\"expiration\";i:1768385212;s:2:\"ip\";s:14:\"185.115.78.178\";s:2:\"ua\";s:111:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36\";s:5:\"login\";i:1767175612;}}"),
("208","7","aiowps_last_login_time","2025-12-31 10:06:52"),
("209","7","metaboxhidden_dashboard","a:16:{i:0;s:36:\"wp-statistics-traffic-summary-widget\";i:1;s:29:\"wp-statistics-browsers-widget\";i:2;s:30:\"wp-statistics-platforms-widget\";i:3;s:28:\"wp-statistics-devices-widget\";i:4;s:27:\"wp-statistics-models-widget\";i:5;s:25:\"wp-statistics-hits-widget\";i:6;s:27:\"wp-statistics-search-widget\";i:7;s:26:\"wp-statistics-pages-widget\";i:8;s:33:\"wp-statistics-top-visitors-widget\";i:9;s:27:\"wp-statistics-recent-widget\";i:10;s:31:\"wp-statistics-useronline-widget\";i:11;s:30:\"wp-statistics-countries-widget\";i:12;s:30:\"wp-statistics-referring-widget\";i:13;s:27:\"wp-statistics-about-metabox\";i:14;s:31:\"wp-statistics-go-premium-widget\";i:15;s:28:\"wp-statistics-hitsmap-widget\";}"),
("210","7","wp_statistics_metaboxhidden_dashboard_initialized","1"),
("211","7","YTcMX_dashboard_quick_press_last_post_id","1598"),
("212","7","manageedit-postcolumnshidden","a:3:{i:0;s:0:\"\";i:1;s:15:\"rank_math_title\";i:2;s:21:\"rank_math_description\";}"),
("213","7","manageedit-postcolumnshidden_default","1"),
("214","7","manageedit-pagecolumnshidden","a:3:{i:0;s:0:\"\";i:1;s:15:\"rank_math_title\";i:2;s:21:\"rank_math_description\";}"),
("215","7","manageedit-pagecolumnshidden_default","1"),
("216","7","manageedit-e-floating-buttonscolumnshidden","a:3:{i:0;s:0:\"\";i:1;s:15:\"rank_math_title\";i:2;s:21:\"rank_math_description\";}"),
("217","7","manageedit-e-floating-buttonscolumnshidden_default","1"),
("218","7","community-events-location","a:1:{s:2:\"ip\";s:12:\"185.115.78.0\";}"),
("219","7","meta-box-order_page","a:2:{i:0;b:0;s:4:\"side\";s:38:\"submitdiv,rank_math_metabox_content_ai\";}"),
("220","7","pse_country_code","IR"),
("221","7","YTcMX_persisted_preferences","a:3:{s:4:\"core\";a:1:{s:26:\"isComplementaryAreaVisible\";b:1;}s:14:\"core/edit-post\";a:1:{s:12:\"welcomeGuide\";b:0;}s:9:\"_modified\";s:24:\"2025-12-07T14:12:21.782Z\";}"),
("222","8","meta-box-order_post","a:2:{i:0;b:0;s:4:\"side\";s:38:\"submitdiv,rank_math_metabox_content_ai\";}"),
("223","8","YTcMX_classic-editor-settings","classic"),
("224","8","YTcMX_elementor_enable_ai","1"),
("225","8","twitter",""),
("226","8","facebook",""),
("227","8","additional_profile_urls",""),
("228","7","elementor_introduction","a:3:{s:27:\"ai-get-started-announcement\";b:1;s:20:\"globals_introduction\";b:1;s:59:\"ai_get_started_introduction_site_logo_with_ai_site-settings\";b:1;}"),
("229","8","nav_menu_recently_edited","10"),
("230","8","managenav-menuscolumnshidden","a:5:{i:0;s:11:\"link-target\";i:1;s:11:\"css-classes\";i:2;s:3:\"xfn\";i:3;s:11:\"description\";i:4;s:15:\"title-attribute\";}"),
("231","8","metaboxhidden_nav-menus","a:2:{i:0;s:31:\"add-post-type-wpuf_subscription\";i:1;s:12:\"add-post_tag\";}"),
("232","7","YTcMX_user-settings","editor=tinymce&libraryContent=browse"),
("233","7","YTcMX_user-settings-time","1765901811"),
("234","8","closedpostboxes_post","a:0:{}"),
("235","8","metaboxhidden_post","a:13:{i:0;s:16:\"wpuf-select-form\";i:1;s:14:\"wpuf-post-lock\";i:2;s:28:\"rank_math_metabox_content_ai\";i:3;s:28:\"classic-editor-switch-editor\";i:4;s:24:\"ht_ctc_settings_meta_box\";i:5;s:34:\"rank_math_metabox_link_suggestions\";i:6;s:18:\"wpuf-custom-fields\";i:7;s:11:\"postexcerpt\";i:8;s:13:\"trackbacksdiv\";i:9;s:10:\"postcustom\";i:10;s:16:\"commentstatusdiv\";i:11;s:7:\"slugdiv\";i:12;s:9:\"authordiv\";}"),
("236","7","gform_recent_forms","a:1:{i:0;s:1:\"1\";}"),
("237","7","wporg_favorites","smhashemi"),
("238","3","aiowps_last_login_time","2026-01-29 21:41:21"),
("239","8","gform_recent_forms","a:2:{i:0;s:1:\"2\";i:1;s:1:\"1\";}"),
("240","6","nav_menu_recently_edited","8"),
("241","6","managenav-menuscolumnshidden","a:5:{i:0;s:11:\"link-target\";i:1;s:11:\"css-classes\";i:2;s:3:\"xfn\";i:3;s:11:\"description\";i:4;s:15:\"title-attribute\";}"),
("242","6","metaboxhidden_nav-menus","a:1:{i:0;s:12:\"add-post_tag\";}"),
("243","6","meta-box-order_post","a:2:{i:0;b:0;s:4:\"side\";s:38:\"submitdiv,rank_math_metabox_content_ai\";}"),
("244","6","essential-addons-for-elementor-lite_review_notice_dismissed","1"),
("245","6","wpsh_stats_dismiss","1"),
("246","3","metaboxhidden_dashboard","a:16:{i:0;s:13:\"rss_dashboard\";i:1;s:20:\"e-dashboard-overview\";i:2;s:25:\"wp-statistics-hits-widget\";i:3;s:27:\"wp-statistics-search-widget\";i:4;s:26:\"wp-statistics-pages-widget\";i:5;s:33:\"wp-statistics-top-visitors-widget\";i:6;s:27:\"wp-statistics-recent-widget\";i:7;s:31:\"wp-statistics-useronline-widget\";i:8;s:28:\"wp-statistics-hitsmap-widget\";i:9;s:17:\"dashboard_primary\";i:10;s:29:\"wp-statistics-browsers-widget\";i:11;s:30:\"wp-statistics-platforms-widget\";i:12;s:28:\"wp-statistics-devices-widget\";i:13;s:27:\"wp-statistics-models-widget\";i:14;s:30:\"wp-statistics-countries-widget\";i:15;s:30:\"wp-statistics-referring-widget\";}"),
("247","3","wp_statistics_metaboxhidden_dashboard_initialized","1"),
("248","3","YTcMX_dashboard_quick_press_last_post_id","1620"),
("249","3","manageedit-e-floating-buttonscolumnshidden","a:3:{i:0;s:0:\"\";i:1;s:15:\"rank_math_title\";i:2;s:21:\"rank_math_description\";}"),
("250","3","manageedit-e-floating-buttonscolumnshidden_default","1"),
("251","3","community-events-location","a:1:{s:2:\"ip\";s:12:\"89.198.101.0\";}"),
("252","3","closedpostboxes_dashboard","a:1:{i:0;s:18:\"dashboard_activity\";}"),
("253","3","meta-box-order_dashboard","a:4:{s:6:\"normal\";s:309:\"rss_dashboard,dashboard_activity,dashboard_right_now,wp-statistics-quickstats-widget,e-dashboard-overview,wp-statistics-hits-widget,wp-statistics-search-widget,wp-statistics-pages-widget,wp-statistics-top-visitors-widget,wp-statistics-recent-widget,wp-statistics-useronline-widget,wp-statistics-hitsmap-widget\";s:4:\"side\";s:219:\"dashboard_quick_press,dashboard_primary,wp-statistics-browsers-widget,wp-statistics-platforms-widget,wp-statistics-devices-widget,wp-statistics-models-widget,wp-statistics-countries-widget,wp-statistics-referring-widget\";s:7:\"column3\";s:0:\"\";s:7:\"column4\";s:0:\"\";}"),
("254","6","closedpostboxes_dashboard","a:0:{}");

INSERT IGNORE INTO `YTcMX_actionscheduler_actions` VALUES 
("45","rank_math/analytics/email_report_event","failed","2025-09-18 00:00:00","2025-09-18 00:00:00","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758153600;s:18:\"\0*\0first_timestamp\";i:1758153600;s:13:\"\0*\0recurrence\";i:2592000;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758153600;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:2592000;}","3","1","2025-09-18 00:00:03","2025-09-18 03:30:03","1646",NULL),
("47","rank_math/analytics/email_report_event","failed","2025-10-18 00:00:03","2025-10-18 00:00:03","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760745603;s:18:\"\0*\0first_timestamp\";i:1758153600;s:13:\"\0*\0recurrence\";i:2592000;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760745603;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:2592000;}","3","1","2025-10-18 00:00:03","2025-10-18 03:30:03","9974",NULL),
("207","rank_math/analytics/email_report_event","failed","2025-11-17 00:00:03","2025-11-17 00:00:03","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763337603;s:18:\"\0*\0first_timestamp\";i:1758153600;s:13:\"\0*\0recurrence\";i:2592000;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763337603;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:2592000;}","3","1","2025-11-17 00:00:03","2025-11-17 03:30:03","18310",NULL),
("297","rank_math/analytics/email_report_event","complete","2026-01-16 00:00:04","2026-01-16 03:30:04","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768521604;s:18:\"\0*\0first_timestamp\";i:1765929600;s:13:\"\0*\0recurrence\";i:2592000;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768521604;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:2592000;}","3","1","2026-01-16 00:05:03","2026-01-16 03:35:03","35042",NULL),
("325","rank_math/analytics/data_fetch","complete","2026-01-07 18:30:04","2026-01-07 22:00:04","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767810604;s:18:\"\0*\0first_timestamp\";i:1758210180;s:13:\"\0*\0recurrence\";i:259200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767810604;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:259200;}","3","1","2026-01-07 18:30:05","2026-01-07 22:00:05","32752",NULL),
("326","action_scheduler_run_recurring_actions_schedule_hook","complete","2026-01-06 01:45:03","2026-01-06 05:15:03","20","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767663903;s:18:\"\0*\0first_timestamp\";i:1756673979;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767663903;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","1","1","2026-01-06 01:45:03","2026-01-06 05:15:03","32271",NULL),
("327","action_scheduler_run_recurring_actions_schedule_hook","complete","2026-01-07 01:45:03","2026-01-07 05:15:03","20","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767750303;s:18:\"\0*\0first_timestamp\";i:1756673979;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767750303;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","1","1","2026-01-07 01:45:03","2026-01-07 05:15:03","32550",NULL),
("328","action_scheduler_run_recurring_actions_schedule_hook","complete","2026-01-08 01:45:03","2026-01-08 05:15:03","20","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767836703;s:18:\"\0*\0first_timestamp\";i:1756673979;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767836703;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","1","1","2026-01-08 01:50:02","2026-01-08 05:20:02","32830",NULL),
("329","rank_math/analytics/data_fetch","complete","2026-01-10 18:30:05","2026-01-10 22:00:05","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768069805;s:18:\"\0*\0first_timestamp\";i:1758210180;s:13:\"\0*\0recurrence\";i:259200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768069805;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:259200;}","3","1","2026-01-10 18:35:04","2026-01-10 22:05:04","33590",NULL),
("330","action_scheduler_run_recurring_actions_schedule_hook","complete","2026-01-09 01:50:02","2026-01-09 05:20:02","20","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767923402;s:18:\"\0*\0first_timestamp\";i:1756673979;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767923402;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","1","1","2026-01-09 01:50:03","2026-01-09 05:20:03","33109",NULL),
("331","action_scheduler_run_recurring_actions_schedule_hook","complete","2026-01-10 01:50:03","2026-01-10 05:20:03","20","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768009803;s:18:\"\0*\0first_timestamp\";i:1756673979;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768009803;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","1","1","2026-01-10 01:55:02","2026-01-10 05:25:02","33389",NULL),
("332","action_scheduler_run_recurring_actions_schedule_hook","complete","2026-01-11 01:55:02","2026-01-11 05:25:02","20","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768096502;s:18:\"\0*\0first_timestamp\";i:1756673979;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768096502;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","1","1","2026-01-11 01:55:02","2026-01-11 05:25:02","33669",NULL),
("333","rank_math/analytics/data_fetch","complete","2026-01-13 18:35:04","2026-01-13 22:05:04","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768329304;s:18:\"\0*\0first_timestamp\";i:1758210180;s:13:\"\0*\0recurrence\";i:259200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768329304;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:259200;}","3","1","2026-01-13 18:40:04","2026-01-13 22:10:04","34429",NULL),
("334","action_scheduler_run_recurring_actions_schedule_hook","complete","2026-01-12 01:55:02","2026-01-12 05:25:02","20","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768182902;s:18:\"\0*\0first_timestamp\";i:1756673979;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768182902;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","1","1","2026-01-12 01:55:03","2026-01-12 05:25:03","33948",NULL),
("335","action_scheduler_run_recurring_actions_schedule_hook","complete","2026-01-13 01:55:03","2026-01-13 05:25:03","20","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768269303;s:18:\"\0*\0first_timestamp\";i:1756673979;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768269303;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","1","1","2026-01-13 02:00:03","2026-01-13 05:30:03","34228",NULL),
("336","action_scheduler_run_recurring_actions_schedule_hook","complete","2026-01-14 02:00:03","2026-01-14 05:30:03","20","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768356003;s:18:\"\0*\0first_timestamp\";i:1756673979;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768356003;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","1","1","2026-01-14 02:00:03","2026-01-14 05:30:03","34508",NULL),
("337","rank_math/analytics/data_fetch","complete","2026-01-16 18:40:04","2026-01-16 22:10:04","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768588804;s:18:\"\0*\0first_timestamp\";i:1758210180;s:13:\"\0*\0recurrence\";i:259200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768588804;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:259200;}","3","1","2026-01-16 18:45:04","2026-01-16 22:15:04","35268",NULL),
("338","action_scheduler_run_recurring_actions_schedule_hook","complete","2026-01-15 02:00:03","2026-01-15 05:30:03","20","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768442403;s:18:\"\0*\0first_timestamp\";i:1756673979;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768442403;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","1","1","2026-01-15 02:05:02","2026-01-15 05:35:02","34787",NULL),
("339","action_scheduler_run_recurring_actions_schedule_hook","complete","2026-01-16 02:05:02","2026-01-16 05:35:02","20","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768529102;s:18:\"\0*\0first_timestamp\";i:1756673979;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768529102;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","1","1","2026-01-16 02:05:03","2026-01-16 05:35:03","35067",NULL),
("340","rank_math/analytics/email_report_event","pending","2026-02-15 00:05:03","2026-02-15 03:35:03","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1771113903;s:18:\"\0*\0first_timestamp\";i:1765929600;s:13:\"\0*\0recurrence\";i:2592000;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1771113903;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:2592000;}","3","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0",NULL),
("341","action_scheduler_run_recurring_actions_schedule_hook","complete","2026-01-17 02:05:03","2026-01-17 05:35:03","20","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768615503;s:18:\"\0*\0first_timestamp\";i:1756673979;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768615503;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","1","1","2026-01-17 02:10:03","2026-01-17 05:40:03","35348",NULL),
("342","rank_math/analytics/data_fetch","complete","2026-01-19 18:45:04","2026-01-19 22:15:04","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768848304;s:18:\"\0*\0first_timestamp\";i:1758210180;s:13:\"\0*\0recurrence\";i:259200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768848304;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:259200;}","3","1","2026-01-19 18:50:04","2026-01-19 22:20:04","36105",NULL),
("343","action_scheduler_run_recurring_actions_schedule_hook","complete","2026-01-18 02:10:03","2026-01-18 05:40:03","20","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768702203;s:18:\"\0*\0first_timestamp\";i:1756673979;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768702203;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","1","1","2026-01-18 02:15:03","2026-01-18 05:45:03","35627",NULL),
("344","action_scheduler_run_recurring_actions_schedule_hook","complete","2026-01-19 02:15:03","2026-01-19 05:45:03","20","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768788903;s:18:\"\0*\0first_timestamp\";i:1756673979;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768788903;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","1","1","2026-01-19 02:20:03","2026-01-19 05:50:03","35906",NULL),
("345","action_scheduler_run_recurring_actions_schedule_hook","complete","2026-01-20 02:20:03","2026-01-20 05:50:03","20","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768875603;s:18:\"\0*\0first_timestamp\";i:1756673979;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768875603;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","1","1","2026-01-20 02:20:03","2026-01-20 05:50:03","36185",NULL),
("346","rank_math/analytics/data_fetch","complete","2026-01-22 18:50:04","2026-01-22 22:20:04","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769107804;s:18:\"\0*\0first_timestamp\";i:1758210180;s:13:\"\0*\0recurrence\";i:259200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769107804;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:259200;}","3","1","2026-01-22 18:55:04","2026-01-22 22:25:04","36940",NULL),
("347","action_scheduler_run_recurring_actions_schedule_hook","complete","2026-01-21 02:20:03","2026-01-21 05:50:03","20","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768962003;s:18:\"\0*\0first_timestamp\";i:1756673979;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768962003;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","1","1","2026-01-21 02:25:02","2026-01-21 05:55:02","36464",NULL),
("348","action_scheduler_run_recurring_actions_schedule_hook","complete","2026-01-22 02:25:02","2026-01-22 05:55:02","20","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769048702;s:18:\"\0*\0first_timestamp\";i:1756673979;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769048702;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","1","1","2026-01-22 02:25:02","2026-01-22 05:55:02","36741",NULL),
("349","action_scheduler_run_recurring_actions_schedule_hook","complete","2026-01-23 02:25:02","2026-01-23 05:55:02","20","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769135102;s:18:\"\0*\0first_timestamp\";i:1756673979;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769135102;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","1","1","2026-01-23 02:25:03","2026-01-23 05:55:03","37021",NULL),
("350","rank_math/analytics/data_fetch","complete","2026-01-25 18:55:04","2026-01-25 22:25:04","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769367304;s:18:\"\0*\0first_timestamp\";i:1758210180;s:13:\"\0*\0recurrence\";i:259200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769367304;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:259200;}","3","1","2026-01-25 19:00:05","2026-01-25 22:30:05","37777",NULL),
("351","action_scheduler_run_recurring_actions_schedule_hook","complete","2026-01-24 02:25:03","2026-01-24 05:55:03","20","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769221503;s:18:\"\0*\0first_timestamp\";i:1756673979;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769221503;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","1","1","2026-01-24 02:25:03","2026-01-24 05:55:03","37299",NULL),
("352","action_scheduler_run_recurring_actions_schedule_hook","complete","2026-01-25 02:25:03","2026-01-25 05:55:03","20","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769307903;s:18:\"\0*\0first_timestamp\";i:1756673979;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769307903;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","1","1","2026-01-25 02:30:03","2026-01-25 06:00:03","37578",NULL),
("353","action_scheduler_run_recurring_actions_schedule_hook","complete","2026-01-26 02:30:03","2026-01-26 06:00:03","20","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769394603;s:18:\"\0*\0first_timestamp\";i:1756673979;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769394603;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","1","1","2026-01-26 02:35:02","2026-01-26 06:05:02","37857",NULL),
("354","rank_math/analytics/data_fetch","complete","2026-01-28 19:00:05","2026-01-28 22:30:05","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769626805;s:18:\"\0*\0first_timestamp\";i:1758210180;s:13:\"\0*\0recurrence\";i:259200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769626805;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:259200;}","3","1","2026-01-28 19:05:04","2026-01-28 22:35:04","38613",NULL),
("355","action_scheduler_run_recurring_actions_schedule_hook","complete","2026-01-27 02:35:02","2026-01-27 06:05:02","20","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769481302;s:18:\"\0*\0first_timestamp\";i:1756673979;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769481302;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","1","1","2026-01-27 02:35:02","2026-01-27 06:05:02","38135",NULL),
("356","action_scheduler_run_recurring_actions_schedule_hook","complete","2026-01-28 02:35:02","2026-01-28 06:05:02","20","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769567702;s:18:\"\0*\0first_timestamp\";i:1756673979;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769567702;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","1","1","2026-01-28 02:35:04","2026-01-28 06:05:04","38414",NULL),
("357","action_scheduler_run_recurring_actions_schedule_hook","complete","2026-01-29 02:35:04","2026-01-29 06:05:04","20","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769654104;s:18:\"\0*\0first_timestamp\";i:1756673979;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769654104;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","1","1","2026-01-29 02:40:03","2026-01-29 06:10:03","38695",NULL),
("358","rank_math/analytics/data_fetch","complete","2026-01-31 19:05:04","2026-01-31 22:35:04","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769886304;s:18:\"\0*\0first_timestamp\";i:1758210180;s:13:\"\0*\0recurrence\";i:259200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769886304;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:259200;}","3","1","2026-01-31 19:10:04","2026-01-31 22:40:04","39452",NULL),
("359","action_scheduler_run_recurring_actions_schedule_hook","complete","2026-01-30 02:40:03","2026-01-30 06:10:03","20","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769740803;s:18:\"\0*\0first_timestamp\";i:1756673979;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769740803;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","1","1","2026-01-30 02:40:03","2026-01-30 06:10:03","38974",NULL),
("360","action_scheduler_run_recurring_actions_schedule_hook","complete","2026-01-31 02:40:03","2026-01-31 06:10:03","20","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769827203;s:18:\"\0*\0first_timestamp\";i:1756673979;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769827203;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","1","1","2026-01-31 02:45:03","2026-01-31 06:15:03","39254",NULL),
("361","action_scheduler_run_recurring_actions_schedule_hook","complete","2026-02-01 02:45:03","2026-02-01 06:15:03","20","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769913903;s:18:\"\0*\0first_timestamp\";i:1756673979;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769913903;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","1","1","2026-02-01 02:45:03","2026-02-01 06:15:03","39534",NULL),
("362","rank_math/analytics/data_fetch","complete","2026-02-03 19:10:04","2026-02-03 22:40:04","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1770145804;s:18:\"\0*\0first_timestamp\";i:1758210180;s:13:\"\0*\0recurrence\";i:259200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1770145804;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:259200;}","3","1","2026-02-03 19:15:03","2026-02-03 22:45:03","40290",NULL),
("363","action_scheduler_run_recurring_actions_schedule_hook","complete","2026-02-02 02:45:03","2026-02-02 06:15:03","20","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1770000303;s:18:\"\0*\0first_timestamp\";i:1756673979;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1770000303;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","1","1","2026-02-02 02:45:03","2026-02-02 06:15:03","39812",NULL),
("364","action_scheduler_run_recurring_actions_schedule_hook","complete","2026-02-03 02:45:03","2026-02-03 06:15:03","20","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1770086703;s:18:\"\0*\0first_timestamp\";i:1756673979;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1770086703;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","1","1","2026-02-03 02:45:03","2026-02-03 06:15:03","40091",NULL),
("365","action_scheduler_run_recurring_actions_schedule_hook","complete","2026-02-04 02:45:03","2026-02-04 06:15:03","20","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1770173103;s:18:\"\0*\0first_timestamp\";i:1756673979;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1770173103;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","1","1","2026-02-04 02:50:03","2026-02-04 06:20:03","40371",NULL),
("366","rank_math/analytics/data_fetch","pending","2026-02-06 19:15:03","2026-02-06 22:45:03","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1770405303;s:18:\"\0*\0first_timestamp\";i:1758210180;s:13:\"\0*\0recurrence\";i:259200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1770405303;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:259200;}","3","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0",NULL),
("367","action_scheduler_run_recurring_actions_schedule_hook","complete","2026-02-05 02:50:03","2026-02-05 06:20:03","20","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1770259803;s:18:\"\0*\0first_timestamp\";i:1756673979;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1770259803;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","1","1","2026-02-05 02:50:03","2026-02-05 06:20:03","40648",NULL),
("368","action_scheduler_run_recurring_actions_schedule_hook","pending","2026-02-06 02:50:03","2026-02-06 06:20:03","20","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1770346203;s:18:\"\0*\0first_timestamp\";i:1756673979;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1770346203;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","1","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0",NULL);

INSERT IGNORE INTO `YTcMX_actionscheduler_groups` VALUES 
("1","ActionScheduler"),
("2","action-scheduler-migration"),
("3","rank-math");

INSERT IGNORE INTO `YTcMX_actionscheduler_logs` VALUES 
("97","45","action created","2025-09-17 16:13:30","2025-09-17 16:13:30"),
("105","45","action started via WP Cron","2025-09-18 00:00:03","2025-09-18 00:00:03"),
("106","45","action failed via WP Cron: abs(): Argument #1 ($num) must be of type int|float, string given","2025-09-18 00:00:03","2025-09-18 00:00:03"),
("107","47","action created","2025-09-18 00:00:03","2025-09-18 00:00:03"),
("585","47","action started via WP Cron","2025-10-18 00:00:03","2025-10-18 00:00:03"),
("586","47","action failed via WP Cron: abs(): Argument #1 ($num) must be of type int|float, string given","2025-10-18 00:00:03","2025-10-18 00:00:03"),
("587","207","action created","2025-10-18 00:00:03","2025-10-18 00:00:03"),
("717","207","action started via WP Cron","2025-11-17 00:00:03","2025-11-17 00:00:03"),
("718","207","action failed via WP Cron: abs(): Argument #1 ($num) must be of type int|float, string given","2025-11-17 00:00:03","2025-11-17 00:00:03"),
("855","297","action created","2025-12-17 00:00:04","2025-12-17 03:30:04"),
("939","325","action created","2026-01-04 18:30:04","2026-01-04 22:00:04"),
("942","326","action created","2026-01-05 01:45:03","2026-01-05 05:15:03"),
("943","326","action started via WP Cron","2026-01-06 01:45:03","2026-01-06 05:15:03"),
("944","326","action complete via WP Cron","2026-01-06 01:45:03","2026-01-06 05:15:03"),
("945","327","action created","2026-01-06 01:45:03","2026-01-06 05:15:03"),
("946","327","action started via WP Cron","2026-01-07 01:45:03","2026-01-07 05:15:03"),
("947","327","action complete via WP Cron","2026-01-07 01:45:03","2026-01-07 05:15:03"),
("948","328","action created","2026-01-07 01:45:03","2026-01-07 05:15:03"),
("949","325","action started via WP Cron","2026-01-07 18:30:04","2026-01-07 22:00:04"),
("950","325","action complete via WP Cron","2026-01-07 18:30:05","2026-01-07 22:00:05"),
("951","329","action created","2026-01-07 18:30:05","2026-01-07 22:00:05"),
("952","328","action started via WP Cron","2026-01-08 01:50:02","2026-01-08 05:20:02"),
("953","328","action complete via WP Cron","2026-01-08 01:50:02","2026-01-08 05:20:02"),
("954","330","action created","2026-01-08 01:50:02","2026-01-08 05:20:02"),
("955","330","action started via WP Cron","2026-01-09 01:50:03","2026-01-09 05:20:03"),
("956","330","action complete via WP Cron","2026-01-09 01:50:03","2026-01-09 05:20:03"),
("957","331","action created","2026-01-09 01:50:03","2026-01-09 05:20:03"),
("958","331","action started via WP Cron","2026-01-10 01:55:02","2026-01-10 05:25:02"),
("959","331","action complete via WP Cron","2026-01-10 01:55:02","2026-01-10 05:25:02"),
("960","332","action created","2026-01-10 01:55:02","2026-01-10 05:25:02"),
("961","329","action started via WP Cron","2026-01-10 18:35:02","2026-01-10 22:05:02"),
("962","329","action complete via WP Cron","2026-01-10 18:35:04","2026-01-10 22:05:04"),
("963","333","action created","2026-01-10 18:35:04","2026-01-10 22:05:04"),
("964","332","action started via WP Cron","2026-01-11 01:55:02","2026-01-11 05:25:02"),
("965","332","action complete via WP Cron","2026-01-11 01:55:02","2026-01-11 05:25:02"),
("966","334","action created","2026-01-11 01:55:02","2026-01-11 05:25:02"),
("967","334","action started via WP Cron","2026-01-12 01:55:03","2026-01-12 05:25:03"),
("968","334","action complete via WP Cron","2026-01-12 01:55:03","2026-01-12 05:25:03"),
("969","335","action created","2026-01-12 01:55:03","2026-01-12 05:25:03"),
("970","335","action started via WP Cron","2026-01-13 02:00:03","2026-01-13 05:30:03"),
("971","335","action complete via WP Cron","2026-01-13 02:00:03","2026-01-13 05:30:03"),
("972","336","action created","2026-01-13 02:00:03","2026-01-13 05:30:03"),
("973","333","action started via WP Cron","2026-01-13 18:40:02","2026-01-13 22:10:02"),
("974","333","action complete via WP Cron","2026-01-13 18:40:04","2026-01-13 22:10:04"),
("975","337","action created","2026-01-13 18:40:04","2026-01-13 22:10:04"),
("976","336","action started via WP Cron","2026-01-14 02:00:03","2026-01-14 05:30:03"),
("977","336","action complete via WP Cron","2026-01-14 02:00:03","2026-01-14 05:30:03"),
("978","338","action created","2026-01-14 02:00:03","2026-01-14 05:30:03"),
("979","338","action started via WP Cron","2026-01-15 02:05:02","2026-01-15 05:35:02"),
("980","338","action complete via WP Cron","2026-01-15 02:05:02","2026-01-15 05:35:02"),
("981","339","action created","2026-01-15 02:05:02","2026-01-15 05:35:02"),
("982","297","action started via WP Cron","2026-01-16 00:05:03","2026-01-16 03:35:03"),
("983","297","action complete via WP Cron","2026-01-16 00:05:03","2026-01-16 03:35:03"),
("984","340","action created","2026-01-16 00:05:03","2026-01-16 03:35:03"),
("985","339","action started via WP Cron","2026-01-16 02:05:03","2026-01-16 05:35:03"),
("986","339","action complete via WP Cron","2026-01-16 02:05:03","2026-01-16 05:35:03"),
("987","341","action created","2026-01-16 02:05:03","2026-01-16 05:35:03"),
("988","337","action started via WP Cron","2026-01-16 18:45:03","2026-01-16 22:15:03"),
("989","337","action complete via WP Cron","2026-01-16 18:45:04","2026-01-16 22:15:04"),
("990","342","action created","2026-01-16 18:45:04","2026-01-16 22:15:04"),
("991","341","action started via WP Cron","2026-01-17 02:10:03","2026-01-17 05:40:03"),
("992","341","action complete via WP Cron","2026-01-17 02:10:03","2026-01-17 05:40:03"),
("993","343","action created","2026-01-17 02:10:03","2026-01-17 05:40:03"),
("994","343","action started via WP Cron","2026-01-18 02:15:03","2026-01-18 05:45:03"),
("995","343","action complete via WP Cron","2026-01-18 02:15:03","2026-01-18 05:45:03"),
("996","344","action created","2026-01-18 02:15:03","2026-01-18 05:45:03"),
("997","344","action started via WP Cron","2026-01-19 02:20:03","2026-01-19 05:50:03"),
("998","344","action complete via WP Cron","2026-01-19 02:20:03","2026-01-19 05:50:03"),
("999","345","action created","2026-01-19 02:20:03","2026-01-19 05:50:03"),
("1000","342","action started via WP Cron","2026-01-19 18:50:03","2026-01-19 22:20:03"),
("1001","342","action complete via WP Cron","2026-01-19 18:50:04","2026-01-19 22:20:04"),
("1002","346","action created","2026-01-19 18:50:04","2026-01-19 22:20:04"),
("1003","345","action started via WP Cron","2026-01-20 02:20:03","2026-01-20 05:50:03"),
("1004","345","action complete via WP Cron","2026-01-20 02:20:03","2026-01-20 05:50:03"),
("1005","347","action created","2026-01-20 02:20:03","2026-01-20 05:50:03"),
("1006","347","action started via WP Cron","2026-01-21 02:25:02","2026-01-21 05:55:02"),
("1007","347","action complete via WP Cron","2026-01-21 02:25:02","2026-01-21 05:55:02"),
("1008","348","action created","2026-01-21 02:25:02","2026-01-21 05:55:02"),
("1009","348","action started via WP Cron","2026-01-22 02:25:02","2026-01-22 05:55:02"),
("1010","348","action complete via WP Cron","2026-01-22 02:25:02","2026-01-22 05:55:02"),
("1011","349","action created","2026-01-22 02:25:02","2026-01-22 05:55:02"),
("1012","346","action started via WP Cron","2026-01-22 18:55:02","2026-01-22 22:25:02"),
("1013","346","action complete via WP Cron","2026-01-22 18:55:04","2026-01-22 22:25:04"),
("1014","350","action created","2026-01-22 18:55:04","2026-01-22 22:25:04"),
("1015","349","action started via WP Cron","2026-01-23 02:25:03","2026-01-23 05:55:03"),
("1016","349","action complete via WP Cron","2026-01-23 02:25:03","2026-01-23 05:55:03"),
("1017","351","action created","2026-01-23 02:25:03","2026-01-23 05:55:03"),
("1018","351","action started via WP Cron","2026-01-24 02:25:03","2026-01-24 05:55:03"),
("1019","351","action complete via WP Cron","2026-01-24 02:25:03","2026-01-24 05:55:03"),
("1020","352","action created","2026-01-24 02:25:03","2026-01-24 05:55:03"),
("1021","352","action started via WP Cron","2026-01-25 02:30:03","2026-01-25 06:00:03"),
("1022","352","action complete via WP Cron","2026-01-25 02:30:03","2026-01-25 06:00:03"),
("1023","353","action created","2026-01-25 02:30:03","2026-01-25 06:00:03"),
("1024","350","action started via WP Cron","2026-01-25 19:00:03","2026-01-25 22:30:03"),
("1025","350","action complete via WP Cron","2026-01-25 19:00:05","2026-01-25 22:30:05"),
("1026","354","action created","2026-01-25 19:00:05","2026-01-25 22:30:05"),
("1027","353","action started via WP Cron","2026-01-26 02:35:02","2026-01-26 06:05:02"),
("1028","353","action complete via WP Cron","2026-01-26 02:35:02","2026-01-26 06:05:02"),
("1029","355","action created","2026-01-26 02:35:02","2026-01-26 06:05:02"),
("1030","355","action started via WP Cron","2026-01-27 02:35:02","2026-01-27 06:05:02"),
("1031","355","action complete via WP Cron","2026-01-27 02:35:02","2026-01-27 06:05:02"),
("1032","356","action created","2026-01-27 02:35:02","2026-01-27 06:05:02"),
("1033","356","action started via WP Cron","2026-01-28 02:35:04","2026-01-28 06:05:04"),
("1034","356","action complete via WP Cron","2026-01-28 02:35:04","2026-01-28 06:05:04"),
("1035","357","action created","2026-01-28 02:35:04","2026-01-28 06:05:04"),
("1036","354","action started via WP Cron","2026-01-28 19:05:02","2026-01-28 22:35:02"),
("1037","354","action complete via WP Cron","2026-01-28 19:05:04","2026-01-28 22:35:04"),
("1038","358","action created","2026-01-28 19:05:04","2026-01-28 22:35:04"),
("1039","357","action started via WP Cron","2026-01-29 02:40:03","2026-01-29 06:10:03"),
("1040","357","action complete via WP Cron","2026-01-29 02:40:03","2026-01-29 06:10:03"),
("1041","359","action created","2026-01-29 02:40:03","2026-01-29 06:10:03"),
("1042","359","action started via WP Cron","2026-01-30 02:40:03","2026-01-30 06:10:03"),
("1043","359","action complete via WP Cron","2026-01-30 02:40:03","2026-01-30 06:10:03"),
("1044","360","action created","2026-01-30 02:40:03","2026-01-30 06:10:03"),
("1045","360","action started via WP Cron","2026-01-31 02:45:03","2026-01-31 06:15:03"),
("1046","360","action complete via WP Cron","2026-01-31 02:45:03","2026-01-31 06:15:03"),
("1047","361","action created","2026-01-31 02:45:03","2026-01-31 06:15:03"),
("1048","358","action started via WP Cron","2026-01-31 19:10:02","2026-01-31 22:40:02"),
("1049","358","action complete via WP Cron","2026-01-31 19:10:04","2026-01-31 22:40:04"),
("1050","362","action created","2026-01-31 19:10:04","2026-01-31 22:40:04"),
("1051","361","action started via WP Cron","2026-02-01 02:45:03","2026-02-01 06:15:03"),
("1052","361","action complete via WP Cron","2026-02-01 02:45:03","2026-02-01 06:15:03"),
("1053","363","action created","2026-02-01 02:45:03","2026-02-01 06:15:03"),
("1054","363","action started via WP Cron","2026-02-02 02:45:03","2026-02-02 06:15:03"),
("1055","363","action complete via WP Cron","2026-02-02 02:45:03","2026-02-02 06:15:03"),
("1056","364","action created","2026-02-02 02:45:03","2026-02-02 06:15:03"),
("1057","364","action started via WP Cron","2026-02-03 02:45:03","2026-02-03 06:15:03"),
("1058","364","action complete via WP Cron","2026-02-03 02:45:03","2026-02-03 06:15:03"),
("1059","365","action created","2026-02-03 02:45:03","2026-02-03 06:15:03"),
("1060","362","action started via WP Cron","2026-02-03 19:15:02","2026-02-03 22:45:02"),
("1061","362","action complete via WP Cron","2026-02-03 19:15:03","2026-02-03 22:45:03"),
("1062","366","action created","2026-02-03 19:15:03","2026-02-03 22:45:03"),
("1063","365","action started via WP Cron","2026-02-04 02:50:03","2026-02-04 06:20:03"),
("1064","365","action complete via WP Cron","2026-02-04 02:50:03","2026-02-04 06:20:03"),
("1065","367","action created","2026-02-04 02:50:03","2026-02-04 06:20:03"),
("1066","367","action started via WP Cron","2026-02-05 02:50:03","2026-02-05 06:20:03"),
("1067","367","action complete via WP Cron","2026-02-05 02:50:03","2026-02-05 06:20:03"),
("1068","368","action created","2026-02-05 02:50:03","2026-02-05 06:20:03");

INSERT IGNORE INTO `YTcMX_aiowps_audit_log` VALUES 
("1","1","1","hashemi","5.215.118.124","info","plugin_updated","{\"plugin\":{\"name\":\"Rank Math SEO\",\"version\":\"1.0.259.1\",\"action\":\"updated\",\"network\":\"\"}}","a:14:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:197;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:70:\"/home/dadmanla/public_html/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:419;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:61:\"/home/dadmanla/public_html/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4653;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:21:\"wp_ajax_update_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:50:\"/home/dadmanla/public_html/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1765102869",""),
("2","1","1","hashemi","5.215.118.124","info","plugin_updated","{\"plugin\":{\"name\":\"Spectra\",\"version\":\"2.19.17\",\"action\":\"updated\",\"network\":\"\"}}","a:14:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:197;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:70:\"/home/dadmanla/public_html/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:419;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:61:\"/home/dadmanla/public_html/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4653;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:21:\"wp_ajax_update_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:50:\"/home/dadmanla/public_html/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1765102877",""),
("3","1","1","hashemi","5.215.118.124","warning","plugin_deleted","{\"plugin\":{\"name\":\"\\u0627\\u0641\\u0632\\u0648\\u0646\\u0647 \\u0627\\u0645\\u0646\\u06cc\\u062a\\u06cc \\u0648\\u0631\\u062f\\u0641\\u0646\\u0633\",\"version\":\"8.1.2\",\"action\":\"deleted\",\"network\":\"\"}}","a:14:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:238;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:14:\"plugin_deleted\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:55:\"/home/dadmanla/public_html/wp-admin/includes/plugin.php\";s:4:\"line\";i:1002;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:61:\"/home/dadmanla/public_html/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4774;s:8:\"function\";s:14:\"delete_plugins\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:21:\"wp_ajax_delete_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:50:\"/home/dadmanla/public_html/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1765102881",""),
("4","1","1","hashemi","5.215.118.124","info","plugin_updated","{\"plugin\":{\"name\":\"\\u0641\\u0631\\u0645\\u200c\\u0647\\u0627\\u06cc \\u0641\\u0644\\u0648\\u0626\\u0646\\u062a\",\"version\":\"6.1.11\",\"action\":\"updated\",\"network\":\"\"}}","a:14:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:197;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:70:\"/home/dadmanla/public_html/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:419;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:61:\"/home/dadmanla/public_html/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4653;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:21:\"wp_ajax_update_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:50:\"/home/dadmanla/public_html/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1765102890",""),
("5","1","1","hashemi","5.215.118.124","info","plugin_installed","{\"plugin\":{\"name\":\"WP Statistics\",\"version\":\"14.16\",\"action\":\"installed\",\"network\":\"\"}}","a:15:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:164;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:16:\"plugin_installed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:66:\"/home/dadmanla/public_html/wp-admin/includes/class-wp-upgrader.php\";s:4:\"line\";i:987;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:70:\"/home/dadmanla/public_html/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:137;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:11:\"WP_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:61:\"/home/dadmanla/public_html/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4497;s:8:\"function\";s:7:\"install\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:4:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:22:\"wp_ajax_install_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:4:{s:4:\"file\";s:50:\"/home/dadmanla/public_html/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1765104112",""),
("6","1","1","hashemi","5.215.118.124","info","translation_updated","{\"translation_updated\":{\"language\":\"fa_IR\",\"type\":\"plugin\",\"slug\":\"wp-statistics\",\"version\":\"14.16\"}}","a:19:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:417;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:19:\"translation_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:77:\"/home/dadmanla/public_html/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:287;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:77:\"/home/dadmanla/public_html/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:104;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:343;s:8:\"function\";s:13:\"async_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:4:{s:4:\"file\";s:66:\"/home/dadmanla/public_html/wp-admin/includes/class-wp-upgrader.php\";s:4:\"line\";i:987;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:70:\"/home/dadmanla/public_html/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:137;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:11:\"WP_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:61:\"/home/dadmanla/public_html/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4497;s:8:\"function\";s:7:\"install\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:4:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:22:\"wp_ajax_install_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:4:{s:4:\"file\";s:50:\"/home/dadmanla/public_html/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1765104113",""),
("7","1","1","hashemi","5.215.118.124","info","plugin_activated","{\"plugin\":{\"name\":\"\\u0622\\u0645\\u0627\\u0631 \\u0648\\u0631\\u062f\\u067e\\u0631\\u0633\",\"version\":\"14.16\",\"action\":\"activated\",\"network\":\"\"}}","a:10:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:177;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:16:\"plugin_activated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:55:\"/home/dadmanla/public_html/wp-admin/includes/plugin.php\";s:4:\"line\";i:730;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"/home/dadmanla/public_html/wp-admin/plugins.php\";s:4:\"line\";i:60;s:8:\"function\";s:15:\"activate_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1765104185",""),
("8","1","1","hashemi","5.215.118.124","info","plugin_installed","{\"plugin\":{\"name\":\"Elementor\",\"version\":\"3.33.3\",\"action\":\"installed\",\"network\":\"\"}}","a:15:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:164;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:16:\"plugin_installed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:66:\"/home/dadmanla/public_html/wp-admin/includes/class-wp-upgrader.php\";s:4:\"line\";i:987;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:70:\"/home/dadmanla/public_html/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:137;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:11:\"WP_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:61:\"/home/dadmanla/public_html/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4497;s:8:\"function\";s:7:\"install\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:4:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:22:\"wp_ajax_install_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:4:{s:4:\"file\";s:50:\"/home/dadmanla/public_html/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1765105213",""),
("9","1","1","hashemi","5.215.118.124","info","translation_updated","{\"translation_updated\":{\"language\":\"fa_IR\",\"type\":\"plugin\",\"slug\":\"elementor\",\"version\":\"3.33.3\"}}","a:19:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:417;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:19:\"translation_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:77:\"/home/dadmanla/public_html/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:287;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:77:\"/home/dadmanla/public_html/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:104;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:343;s:8:\"function\";s:13:\"async_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:4:{s:4:\"file\";s:66:\"/home/dadmanla/public_html/wp-admin/includes/class-wp-upgrader.php\";s:4:\"line\";i:987;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:70:\"/home/dadmanla/public_html/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:137;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:11:\"WP_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:61:\"/home/dadmanla/public_html/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4497;s:8:\"function\";s:7:\"install\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:4:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:22:\"wp_ajax_install_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:4:{s:4:\"file\";s:50:\"/home/dadmanla/public_html/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1765105215",""),
("10","1","1","hashemi","5.215.118.124","info","plugin_activated","{\"plugin\":{\"name\":\"\\u0627\\u0644\\u0645\\u0646\\u062a\\u0648\\u0631\",\"version\":\"3.33.3\",\"action\":\"activated\",\"network\":\"\"}}","a:10:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:177;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:16:\"plugin_activated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:55:\"/home/dadmanla/public_html/wp-admin/includes/plugin.php\";s:4:\"line\";i:730;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"/home/dadmanla/public_html/wp-admin/plugins.php\";s:4:\"line\";i:60;s:8:\"function\";s:15:\"activate_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1765105221",""),
("11","1","1","hashemi","5.215.118.124","info","plugin_installed","{\"plugin\":{\"name\":\"Elementor Pro\",\"version\":\"3.33.2\",\"action\":\"installed\",\"network\":\"\"}}","a:11:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:164;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:16:\"plugin_installed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:66:\"/home/dadmanla/public_html/wp-admin/includes/class-wp-upgrader.php\";s:4:\"line\";i:987;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:70:\"/home/dadmanla/public_html/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:137;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:11:\"WP_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:46:\"/home/dadmanla/public_html/wp-admin/update.php\";s:4:\"line\";i:180;s:8:\"function\";s:7:\"install\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1765105275",""),
("12","1","1","hashemi","5.215.118.124","info","plugin_activated","{\"plugin\":{\"name\":\"Elementor Pro\",\"version\":\"3.33.2\",\"action\":\"activated\",\"network\":\"\"}}","a:10:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:177;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:16:\"plugin_activated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:55:\"/home/dadmanla/public_html/wp-admin/includes/plugin.php\";s:4:\"line\";i:730;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"/home/dadmanla/public_html/wp-admin/plugins.php\";s:4:\"line\";i:60;s:8:\"function\";s:15:\"activate_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1765105283",""),
("13","1","1","hashemi","5.215.118.124","info","plugin_installed","{\"plugin\":{\"name\":\"Advanced Editor Tools\",\"version\":\"5.9.2\",\"action\":\"installed\",\"network\":\"\"}}","a:15:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:164;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:16:\"plugin_installed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:66:\"/home/dadmanla/public_html/wp-admin/includes/class-wp-upgrader.php\";s:4:\"line\";i:987;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:70:\"/home/dadmanla/public_html/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:137;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:11:\"WP_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:61:\"/home/dadmanla/public_html/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4497;s:8:\"function\";s:7:\"install\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:4:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:22:\"wp_ajax_install_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:4:{s:4:\"file\";s:50:\"/home/dadmanla/public_html/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1765105665",""),
("14","1","1","hashemi","5.215.118.124","info","translation_updated","{\"translation_updated\":{\"language\":\"fa_IR\",\"type\":\"plugin\",\"slug\":\"tinymce-advanced\",\"version\":\"5.9.2\"}}","a:19:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:417;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:19:\"translation_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:77:\"/home/dadmanla/public_html/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:287;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:77:\"/home/dadmanla/public_html/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:104;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:343;s:8:\"function\";s:13:\"async_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:4:{s:4:\"file\";s:66:\"/home/dadmanla/public_html/wp-admin/includes/class-wp-upgrader.php\";s:4:\"line\";i:987;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:70:\"/home/dadmanla/public_html/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:137;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:11:\"WP_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:61:\"/home/dadmanla/public_html/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4497;s:8:\"function\";s:7:\"install\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:4:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:22:\"wp_ajax_install_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:4:{s:4:\"file\";s:50:\"/home/dadmanla/public_html/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1765105667",""),
("15","1","1","hashemi","5.215.118.124","info","plugin_installed","{\"plugin\":{\"name\":\"Classic Editor\",\"version\":\"1.6.7\",\"action\":\"installed\",\"network\":\"\"}}","a:15:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:164;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:16:\"plugin_installed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:66:\"/home/dadmanla/public_html/wp-admin/includes/class-wp-upgrader.php\";s:4:\"line\";i:987;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:70:\"/home/dadmanla/public_html/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:137;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:11:\"WP_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:61:\"/home/dadmanla/public_html/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4497;s:8:\"function\";s:7:\"install\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:4:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:22:\"wp_ajax_install_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:4:{s:4:\"file\";s:50:\"/home/dadmanla/public_html/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1765105669",""),
("16","1","1","hashemi","5.215.118.124","info","translation_updated","{\"translation_updated\":{\"language\":\"fa_IR\",\"type\":\"plugin\",\"slug\":\"classic-editor\",\"version\":\"1.6.7\"}}","a:19:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:417;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:19:\"translation_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:77:\"/home/dadmanla/public_html/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:287;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:77:\"/home/dadmanla/public_html/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:104;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:343;s:8:\"function\";s:13:\"async_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:4:{s:4:\"file\";s:66:\"/home/dadmanla/public_html/wp-admin/includes/class-wp-upgrader.php\";s:4:\"line\";i:987;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:70:\"/home/dadmanla/public_html/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:137;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:11:\"WP_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:61:\"/home/dadmanla/public_html/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4497;s:8:\"function\";s:7:\"install\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:4:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:22:\"wp_ajax_install_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:4:{s:4:\"file\";s:50:\"/home/dadmanla/public_html/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1765105670",""),
("17","1","1","hashemi","5.215.118.124","info","plugin_activated","{\"plugin\":{\"name\":\"\\u0648\\u06cc\\u0631\\u0627\\u06cc\\u0634\\u06af\\u0631 \\u06a9\\u0644\\u0627\\u0633\\u06cc\\u06a9\",\"version\":\"1.6.7\",\"action\":\"activated\",\"network\":\"\"}}","a:10:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:177;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:16:\"plugin_activated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:55:\"/home/dadmanla/public_html/wp-admin/includes/plugin.php\";s:4:\"line\";i:730;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"/home/dadmanla/public_html/wp-admin/plugins.php\";s:4:\"line\";i:60;s:8:\"function\";s:15:\"activate_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1765105677",""),
("18","1","1","hashemi","5.215.118.124","info","plugin_activated","{\"plugin\":{\"name\":\"\\u0648\\u06cc\\u0631\\u0627\\u06cc\\u0634\\u06af\\u0631 \\u067e\\u06cc\\u0634\\u0631\\u0641\\u062a\\u0647\",\"version\":\"5.9.2\",\"action\":\"activated\",\"network\":\"\"}}","a:10:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:177;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:16:\"plugin_activated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:55:\"/home/dadmanla/public_html/wp-admin/includes/plugin.php\";s:4:\"line\";i:730;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"/home/dadmanla/public_html/wp-admin/plugins.php\";s:4:\"line\";i:60;s:8:\"function\";s:15:\"activate_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1765105687",""),
("19","1","1","hashemi","207.244.89.161","info","successful_login","{\"successful_login\":{\"username\":\"hashemi\"}}","a:22:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:622;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:667;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"/home/dadmanla/public_html/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:133:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";s:4:\"line\";i:1340;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:4:{s:4:\"file\";s:132:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-process-renamed-login-page.php\";s:4:\"line\";i:223;s:4:\"args\";a:1:{i:0;s:133:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";}s:8:\"function\";s:12:\"require_once\";}i:12;a:6:{s:4:\"file\";s:121:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-wp-loaded-tasks.php\";s:4:\"line\";i:21;s:8:\"function\";s:24:\"renamed_login_init_tasks\";s:5:\"class\";s:40:\"AIOWPSecurity_Process_Renamed_Login_Page\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:102:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/wp-security-core.php\";s:4:\"line\";i:497;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:29:\"AIOWPSecurity_WP_Loaded_Tasks\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:24:\"aiowps_wp_loaded_handler\";s:5:\"class\";s:15:\"AIO_WP_Security\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:4:{s:4:\"file\";s:42:\"/home/dadmanla/public_html/wp-settings.php\";s:4:\"line\";i:764;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:4:{s:4:\"file\";s:40:\"/home/dadmanla/public_html/wp-config.php\";s:4:\"line\";i:111;s:4:\"args\";a:1:{i:0;s:42:\"/home/dadmanla/public_html/wp-settings.php\";}s:8:\"function\";s:12:\"require_once\";}i:19;a:4:{s:4:\"file\";s:38:\"/home/dadmanla/public_html/wp-load.php\";s:4:\"line\";i:50;s:4:\"args\";a:1:{i:0;s:40:\"/home/dadmanla/public_html/wp-config.php\";}s:8:\"function\";s:12:\"require_once\";}i:20;a:4:{s:4:\"file\";s:45:\"/home/dadmanla/public_html/wp-blog-header.php\";s:4:\"line\";i:13;s:4:\"args\";a:1:{i:0;s:38:\"/home/dadmanla/public_html/wp-load.php\";}s:8:\"function\";s:12:\"require_once\";}i:21;a:4:{s:4:\"file\";s:36:\"/home/dadmanla/public_html/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:45:\"/home/dadmanla/public_html/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}","1765115558",""),
("20","1","1","hashemi","207.244.89.161","info","user_registration","{\"user_registration\":{\"registered_username\":\"rasaneh-design\",\"type\":\"admin\",\"admin_username\":\"hashemi\"}}","a:11:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:599;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:123:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-registration.php\";s:4:\"line\";i:49;s:8:\"function\";s:23:\"event_user_registration\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:343;s:8:\"function\";s:39:\"aiowps_user_registration_action_handler\";s:5:\"class\";s:31:\"AIOWPSecurity_User_Registration\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:47:\"/home/dadmanla/public_html/wp-includes/user.php\";s:4:\"line\";i:2654;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:53:\"/home/dadmanla/public_html/wp-admin/includes/user.php\";s:4:\"line\";i:235;s:8:\"function\";s:14:\"wp_insert_user\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:48:\"/home/dadmanla/public_html/wp-admin/user-new.php\";s:4:\"line\";i:201;s:8:\"function\";s:9:\"edit_user\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1765115807",""),
("21","1","1","hashemi","207.244.89.161","info","user_registration","{\"user_registration\":{\"registered_username\":\"a.hashemi\",\"type\":\"admin\",\"admin_username\":\"hashemi\"}}","a:11:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:599;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:123:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-registration.php\";s:4:\"line\";i:49;s:8:\"function\";s:23:\"event_user_registration\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:343;s:8:\"function\";s:39:\"aiowps_user_registration_action_handler\";s:5:\"class\";s:31:\"AIOWPSecurity_User_Registration\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:47:\"/home/dadmanla/public_html/wp-includes/user.php\";s:4:\"line\";i:2654;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:53:\"/home/dadmanla/public_html/wp-admin/includes/user.php\";s:4:\"line\";i:235;s:8:\"function\";s:14:\"wp_insert_user\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:48:\"/home/dadmanla/public_html/wp-admin/user-new.php\";s:4:\"line\";i:201;s:8:\"function\";s:9:\"edit_user\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1765115923",""),
("22","1","1","a.hashemi","151.115.98.18","info","successful_login","{\"successful_login\":{\"username\":\"a.hashemi\"}}","a:22:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:622;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:667;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"/home/dadmanla/public_html/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:133:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";s:4:\"line\";i:1340;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:4:{s:4:\"file\";s:132:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-process-renamed-login-page.php\";s:4:\"line\";i:223;s:4:\"args\";a:1:{i:0;s:133:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";}s:8:\"function\";s:12:\"require_once\";}i:12;a:6:{s:4:\"file\";s:121:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-wp-loaded-tasks.php\";s:4:\"line\";i:21;s:8:\"function\";s:24:\"renamed_login_init_tasks\";s:5:\"class\";s:40:\"AIOWPSecurity_Process_Renamed_Login_Page\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:102:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/wp-security-core.php\";s:4:\"line\";i:497;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:29:\"AIOWPSecurity_WP_Loaded_Tasks\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:24:\"aiowps_wp_loaded_handler\";s:5:\"class\";s:15:\"AIO_WP_Security\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:4:{s:4:\"file\";s:42:\"/home/dadmanla/public_html/wp-settings.php\";s:4:\"line\";i:764;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:4:{s:4:\"file\";s:40:\"/home/dadmanla/public_html/wp-config.php\";s:4:\"line\";i:111;s:4:\"args\";a:1:{i:0;s:42:\"/home/dadmanla/public_html/wp-settings.php\";}s:8:\"function\";s:12:\"require_once\";}i:19;a:4:{s:4:\"file\";s:38:\"/home/dadmanla/public_html/wp-load.php\";s:4:\"line\";i:50;s:4:\"args\";a:1:{i:0;s:40:\"/home/dadmanla/public_html/wp-config.php\";}s:8:\"function\";s:12:\"require_once\";}i:20;a:4:{s:4:\"file\";s:45:\"/home/dadmanla/public_html/wp-blog-header.php\";s:4:\"line\";i:13;s:4:\"args\";a:1:{i:0;s:38:\"/home/dadmanla/public_html/wp-load.php\";}s:8:\"function\";s:12:\"require_once\";}i:21;a:4:{s:4:\"file\";s:36:\"/home/dadmanla/public_html/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:45:\"/home/dadmanla/public_html/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}","1765116056",""),
("23","1","1","hashemi","151.238.118.253","info","successful_logout","{\"successful_logout\":{\"username\":\"hashemi\",\"force_logout\":\"\"}}","a:18:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:638;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:714;s:8:\"function\";s:23:\"event_successful_logout\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:24:\"wp_logout_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:52:\"/home/dadmanla/public_html/wp-includes/pluggable.php\";s:4:\"line\";i:755;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:93:\"/home/dadmanla/public_html/wp-content/plugins/wp-user-frontend/includes/Free/Simple_Login.php\";s:4:\"line\";i:705;s:8:\"function\";s:9:\"wp_logout\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:14:\"process_logout\";s:5:\"class\";s:29:\"WeDevs\\Wpuf\\Free\\Simple_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:42:\"/home/dadmanla/public_html/wp-settings.php\";s:4:\"line\";i:742;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:4:{s:4:\"file\";s:40:\"/home/dadmanla/public_html/wp-config.php\";s:4:\"line\";i:111;s:4:\"args\";a:1:{i:0;s:42:\"/home/dadmanla/public_html/wp-settings.php\";}s:8:\"function\";s:12:\"require_once\";}i:15;a:4:{s:4:\"file\";s:38:\"/home/dadmanla/public_html/wp-load.php\";s:4:\"line\";i:50;s:4:\"args\";a:1:{i:0;s:40:\"/home/dadmanla/public_html/wp-config.php\";}s:8:\"function\";s:12:\"require_once\";}i:16;a:4:{s:4:\"file\";s:45:\"/home/dadmanla/public_html/wp-blog-header.php\";s:4:\"line\";i:13;s:4:\"args\";a:1:{i:0;s:38:\"/home/dadmanla/public_html/wp-load.php\";}s:8:\"function\";s:12:\"require_once\";}i:17;a:4:{s:4:\"file\";s:36:\"/home/dadmanla/public_html/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:45:\"/home/dadmanla/public_html/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}","1765116658",""),
("24","1","1","rasaneh-design","151.238.118.253","info","successful_login","{\"successful_login\":{\"username\":\"rasaneh-design\"}}","a:22:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:622;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:667;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"/home/dadmanla/public_html/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:133:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";s:4:\"line\";i:1340;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:4:{s:4:\"file\";s:132:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-process-renamed-login-page.php\";s:4:\"line\";i:223;s:4:\"args\";a:1:{i:0;s:133:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";}s:8:\"function\";s:12:\"require_once\";}i:12;a:6:{s:4:\"file\";s:121:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-wp-loaded-tasks.php\";s:4:\"line\";i:21;s:8:\"function\";s:24:\"renamed_login_init_tasks\";s:5:\"class\";s:40:\"AIOWPSecurity_Process_Renamed_Login_Page\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:102:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/wp-security-core.php\";s:4:\"line\";i:497;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:29:\"AIOWPSecurity_WP_Loaded_Tasks\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:24:\"aiowps_wp_loaded_handler\";s:5:\"class\";s:15:\"AIO_WP_Security\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:4:{s:4:\"file\";s:42:\"/home/dadmanla/public_html/wp-settings.php\";s:4:\"line\";i:764;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:4:{s:4:\"file\";s:40:\"/home/dadmanla/public_html/wp-config.php\";s:4:\"line\";i:111;s:4:\"args\";a:1:{i:0;s:42:\"/home/dadmanla/public_html/wp-settings.php\";}s:8:\"function\";s:12:\"require_once\";}i:19;a:4:{s:4:\"file\";s:38:\"/home/dadmanla/public_html/wp-load.php\";s:4:\"line\";i:50;s:4:\"args\";a:1:{i:0;s:40:\"/home/dadmanla/public_html/wp-config.php\";}s:8:\"function\";s:12:\"require_once\";}i:20;a:4:{s:4:\"file\";s:45:\"/home/dadmanla/public_html/wp-blog-header.php\";s:4:\"line\";i:13;s:4:\"args\";a:1:{i:0;s:38:\"/home/dadmanla/public_html/wp-load.php\";}s:8:\"function\";s:12:\"require_once\";}i:21;a:4:{s:4:\"file\";s:36:\"/home/dadmanla/public_html/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:45:\"/home/dadmanla/public_html/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}","1765116707",""),
("25","1","1","rasaneh-design","151.238.118.253","warning","theme_deleted","{\"theme\":{\"name\":\"Twenty Twenty-Five\",\"version\":\"1.3\",\"action\":\"deleted\",\"network\":\"\"}}","a:14:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:393;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:356;s:8:\"function\";s:19:\"event_theme_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:13:\"theme_deleted\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:54:\"/home/dadmanla/public_html/wp-admin/includes/theme.php\";s:4:\"line\";i:98;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:61:\"/home/dadmanla/public_html/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4430;s:8:\"function\";s:12:\"delete_theme\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:20:\"wp_ajax_delete_theme\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:50:\"/home/dadmanla/public_html/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1765116817",""),
("26","1","1","a.hashemi","151.238.119.31","info","successful_login","{\"successful_login\":{\"username\":\"a.hashemi\"}}","a:22:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:622;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:667;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"/home/dadmanla/public_html/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:133:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";s:4:\"line\";i:1340;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:4:{s:4:\"file\";s:132:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-process-renamed-login-page.php\";s:4:\"line\";i:223;s:4:\"args\";a:1:{i:0;s:133:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";}s:8:\"function\";s:12:\"require_once\";}i:12;a:6:{s:4:\"file\";s:121:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-wp-loaded-tasks.php\";s:4:\"line\";i:21;s:8:\"function\";s:24:\"renamed_login_init_tasks\";s:5:\"class\";s:40:\"AIOWPSecurity_Process_Renamed_Login_Page\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:102:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/wp-security-core.php\";s:4:\"line\";i:497;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:29:\"AIOWPSecurity_WP_Loaded_Tasks\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:24:\"aiowps_wp_loaded_handler\";s:5:\"class\";s:15:\"AIO_WP_Security\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:4:{s:4:\"file\";s:42:\"/home/dadmanla/public_html/wp-settings.php\";s:4:\"line\";i:764;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:4:{s:4:\"file\";s:40:\"/home/dadmanla/public_html/wp-config.php\";s:4:\"line\";i:111;s:4:\"args\";a:1:{i:0;s:42:\"/home/dadmanla/public_html/wp-settings.php\";}s:8:\"function\";s:12:\"require_once\";}i:19;a:4:{s:4:\"file\";s:38:\"/home/dadmanla/public_html/wp-load.php\";s:4:\"line\";i:50;s:4:\"args\";a:1:{i:0;s:40:\"/home/dadmanla/public_html/wp-config.php\";}s:8:\"function\";s:12:\"require_once\";}i:20;a:4:{s:4:\"file\";s:45:\"/home/dadmanla/public_html/wp-blog-header.php\";s:4:\"line\";i:13;s:4:\"args\";a:1:{i:0;s:38:\"/home/dadmanla/public_html/wp-load.php\";}s:8:\"function\";s:12:\"require_once\";}i:21;a:4:{s:4:\"file\";s:36:\"/home/dadmanla/public_html/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:45:\"/home/dadmanla/public_html/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}","1765207246",""),
("27","1","1","a.hashemi","194.34.105.108","info","successful_login","{\"successful_login\":{\"username\":\"a.hashemi\"}}","a:22:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:622;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:667;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"/home/dadmanla/public_html/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:133:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";s:4:\"line\";i:1340;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:4:{s:4:\"file\";s:132:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-process-renamed-login-page.php\";s:4:\"line\";i:223;s:4:\"args\";a:1:{i:0;s:133:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";}s:8:\"function\";s:12:\"require_once\";}i:12;a:6:{s:4:\"file\";s:121:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-wp-loaded-tasks.php\";s:4:\"line\";i:21;s:8:\"function\";s:24:\"renamed_login_init_tasks\";s:5:\"class\";s:40:\"AIOWPSecurity_Process_Renamed_Login_Page\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:102:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/wp-security-core.php\";s:4:\"line\";i:497;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:29:\"AIOWPSecurity_WP_Loaded_Tasks\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:24:\"aiowps_wp_loaded_handler\";s:5:\"class\";s:15:\"AIO_WP_Security\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:4:{s:4:\"file\";s:42:\"/home/dadmanla/public_html/wp-settings.php\";s:4:\"line\";i:764;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:4:{s:4:\"file\";s:40:\"/home/dadmanla/public_html/wp-config.php\";s:4:\"line\";i:111;s:4:\"args\";a:1:{i:0;s:42:\"/home/dadmanla/public_html/wp-settings.php\";}s:8:\"function\";s:12:\"require_once\";}i:19;a:4:{s:4:\"file\";s:38:\"/home/dadmanla/public_html/wp-load.php\";s:4:\"line\";i:50;s:4:\"args\";a:1:{i:0;s:40:\"/home/dadmanla/public_html/wp-config.php\";}s:8:\"function\";s:12:\"require_once\";}i:20;a:4:{s:4:\"file\";s:45:\"/home/dadmanla/public_html/wp-blog-header.php\";s:4:\"line\";i:13;s:4:\"args\";a:1:{i:0;s:38:\"/home/dadmanla/public_html/wp-load.php\";}s:8:\"function\";s:12:\"require_once\";}i:21;a:4:{s:4:\"file\";s:36:\"/home/dadmanla/public_html/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:45:\"/home/dadmanla/public_html/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}","1765280912",""),
("28","1","1","hashemi","185.115.78.123","info","successful_login","{\"successful_login\":{\"username\":\"hashemi\"}}","a:22:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:622;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:667;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"/home/dadmanla/public_html/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:133:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";s:4:\"line\";i:1340;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:4:{s:4:\"file\";s:132:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-process-renamed-login-page.php\";s:4:\"line\";i:223;s:4:\"args\";a:1:{i:0;s:133:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";}s:8:\"function\";s:12:\"require_once\";}i:12;a:6:{s:4:\"file\";s:121:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-wp-loaded-tasks.php\";s:4:\"line\";i:21;s:8:\"function\";s:24:\"renamed_login_init_tasks\";s:5:\"class\";s:40:\"AIOWPSecurity_Process_Renamed_Login_Page\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:102:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/wp-security-core.php\";s:4:\"line\";i:497;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:29:\"AIOWPSecurity_WP_Loaded_Tasks\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:24:\"aiowps_wp_loaded_handler\";s:5:\"class\";s:15:\"AIO_WP_Security\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:4:{s:4:\"file\";s:42:\"/home/dadmanla/public_html/wp-settings.php\";s:4:\"line\";i:764;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:4:{s:4:\"file\";s:40:\"/home/dadmanla/public_html/wp-config.php\";s:4:\"line\";i:111;s:4:\"args\";a:1:{i:0;s:42:\"/home/dadmanla/public_html/wp-settings.php\";}s:8:\"function\";s:12:\"require_once\";}i:19;a:4:{s:4:\"file\";s:38:\"/home/dadmanla/public_html/wp-load.php\";s:4:\"line\";i:50;s:4:\"args\";a:1:{i:0;s:40:\"/home/dadmanla/public_html/wp-config.php\";}s:8:\"function\";s:12:\"require_once\";}i:20;a:4:{s:4:\"file\";s:45:\"/home/dadmanla/public_html/wp-blog-header.php\";s:4:\"line\";i:13;s:4:\"args\";a:1:{i:0;s:38:\"/home/dadmanla/public_html/wp-load.php\";}s:8:\"function\";s:12:\"require_once\";}i:21;a:4:{s:4:\"file\";s:36:\"/home/dadmanla/public_html/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:45:\"/home/dadmanla/public_html/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}","1765448849",""),
("29","1","1","rasaneh-design","151.238.116.38","info","successful_login","{\"successful_login\":{\"username\":\"rasaneh-design\"}}","a:22:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:622;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:667;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"/home/dadmanla/public_html/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:133:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";s:4:\"line\";i:1340;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:4:{s:4:\"file\";s:132:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-process-renamed-login-page.php\";s:4:\"line\";i:223;s:4:\"args\";a:1:{i:0;s:133:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";}s:8:\"function\";s:12:\"require_once\";}i:12;a:6:{s:4:\"file\";s:121:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-wp-loaded-tasks.php\";s:4:\"line\";i:21;s:8:\"function\";s:24:\"renamed_login_init_tasks\";s:5:\"class\";s:40:\"AIOWPSecurity_Process_Renamed_Login_Page\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:102:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/wp-security-core.php\";s:4:\"line\";i:497;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:29:\"AIOWPSecurity_WP_Loaded_Tasks\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:24:\"aiowps_wp_loaded_handler\";s:5:\"class\";s:15:\"AIO_WP_Security\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:4:{s:4:\"file\";s:42:\"/home/dadmanla/public_html/wp-settings.php\";s:4:\"line\";i:764;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:4:{s:4:\"file\";s:40:\"/home/dadmanla/public_html/wp-config.php\";s:4:\"line\";i:111;s:4:\"args\";a:1:{i:0;s:42:\"/home/dadmanla/public_html/wp-settings.php\";}s:8:\"function\";s:12:\"require_once\";}i:19;a:4:{s:4:\"file\";s:38:\"/home/dadmanla/public_html/wp-load.php\";s:4:\"line\";i:50;s:4:\"args\";a:1:{i:0;s:40:\"/home/dadmanla/public_html/wp-config.php\";}s:8:\"function\";s:12:\"require_once\";}i:20;a:4:{s:4:\"file\";s:45:\"/home/dadmanla/public_html/wp-blog-header.php\";s:4:\"line\";i:13;s:4:\"args\";a:1:{i:0;s:38:\"/home/dadmanla/public_html/wp-load.php\";}s:8:\"function\";s:12:\"require_once\";}i:21;a:4:{s:4:\"file\";s:36:\"/home/dadmanla/public_html/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:45:\"/home/dadmanla/public_html/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}","1765463645",""),
("30","1","1","hashemi","151.238.116.38","info","successful_login","{\"successful_login\":{\"username\":\"hashemi\"}}","a:22:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:622;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:667;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"/home/dadmanla/public_html/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:133:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";s:4:\"line\";i:1340;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:4:{s:4:\"file\";s:132:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-process-renamed-login-page.php\";s:4:\"line\";i:223;s:4:\"args\";a:1:{i:0;s:133:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";}s:8:\"function\";s:12:\"require_once\";}i:12;a:6:{s:4:\"file\";s:121:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-wp-loaded-tasks.php\";s:4:\"line\";i:21;s:8:\"function\";s:24:\"renamed_login_init_tasks\";s:5:\"class\";s:40:\"AIOWPSecurity_Process_Renamed_Login_Page\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:102:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/wp-security-core.php\";s:4:\"line\";i:497;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:29:\"AIOWPSecurity_WP_Loaded_Tasks\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:24:\"aiowps_wp_loaded_handler\";s:5:\"class\";s:15:\"AIO_WP_Security\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:4:{s:4:\"file\";s:42:\"/home/dadmanla/public_html/wp-settings.php\";s:4:\"line\";i:764;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:4:{s:4:\"file\";s:40:\"/home/dadmanla/public_html/wp-config.php\";s:4:\"line\";i:111;s:4:\"args\";a:1:{i:0;s:42:\"/home/dadmanla/public_html/wp-settings.php\";}s:8:\"function\";s:12:\"require_once\";}i:19;a:4:{s:4:\"file\";s:38:\"/home/dadmanla/public_html/wp-load.php\";s:4:\"line\";i:50;s:4:\"args\";a:1:{i:0;s:40:\"/home/dadmanla/public_html/wp-config.php\";}s:8:\"function\";s:12:\"require_once\";}i:20;a:4:{s:4:\"file\";s:45:\"/home/dadmanla/public_html/wp-blog-header.php\";s:4:\"line\";i:13;s:4:\"args\";a:1:{i:0;s:38:\"/home/dadmanla/public_html/wp-load.php\";}s:8:\"function\";s:12:\"require_once\";}i:21;a:4:{s:4:\"file\";s:36:\"/home/dadmanla/public_html/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:45:\"/home/dadmanla/public_html/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}","1765464757",""),
("31","1","1","hashemi","151.238.116.38","warning","plugin_deactivated","{\"plugin\":{\"name\":\"Cache Enabler\",\"version\":\"1.8.15\",\"action\":\"deactivated\",\"network\":\"\"}}","a:10:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:212;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:18:\"plugin_deactivated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:55:\"/home/dadmanla/public_html/wp-admin/includes/plugin.php\";s:4:\"line\";i:840;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"/home/dadmanla/public_html/wp-admin/plugins.php\";s:4:\"line\";i:253;s:8:\"function\";s:18:\"deactivate_plugins\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1765465348",""),
("32","1","1","hashemi","151.238.116.38","warning","plugin_deactivated","{\"plugin\":{\"name\":\"Spectra\",\"version\":\"2.19.17\",\"action\":\"deactivated\",\"network\":\"\"}}","a:10:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:212;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:18:\"plugin_deactivated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:55:\"/home/dadmanla/public_html/wp-admin/includes/plugin.php\";s:4:\"line\";i:840;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"/home/dadmanla/public_html/wp-admin/plugins.php\";s:4:\"line\";i:253;s:8:\"function\";s:18:\"deactivate_plugins\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1765465348",""),
("33","1","1","hashemi","151.238.116.38","warning","plugin_deactivated","{\"plugin\":{\"name\":\"WP Call Button\",\"version\":\"1.4.3\",\"action\":\"deactivated\",\"network\":\"\"}}","a:10:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:212;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:18:\"plugin_deactivated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:55:\"/home/dadmanla/public_html/wp-admin/includes/plugin.php\";s:4:\"line\";i:840;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"/home/dadmanla/public_html/wp-admin/plugins.php\";s:4:\"line\";i:253;s:8:\"function\";s:18:\"deactivate_plugins\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1765465348",""),
("34","1","1","hashemi","151.238.116.38","warning","plugin_deactivated","{\"plugin\":{\"name\":\"WP Crontrol\\u200c\",\"version\":\"1.19.3\",\"action\":\"deactivated\",\"network\":\"\"}}","a:10:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:212;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:18:\"plugin_deactivated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:55:\"/home/dadmanla/public_html/wp-admin/includes/plugin.php\";s:4:\"line\";i:840;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"/home/dadmanla/public_html/wp-admin/plugins.php\";s:4:\"line\";i:253;s:8:\"function\";s:18:\"deactivate_plugins\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1765465348",""),
("35","1","1","hashemi","151.238.116.38","warning","plugin_deactivated","{\"plugin\":{\"name\":\"\\u0628\\u0647\\u06cc\\u0646\\u0647\\u200c\\u0633\\u0627\\u0632\\u06cc \\u062e\\u0648\\u062f\\u06a9\\u0627\\u0631\",\"version\":\"3.1.14\",\"action\":\"deactivated\",\"network\":\"\"}}","a:10:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:212;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:18:\"plugin_deactivated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:55:\"/home/dadmanla/public_html/wp-admin/includes/plugin.php\";s:4:\"line\";i:840;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"/home/dadmanla/public_html/wp-admin/plugins.php\";s:4:\"line\";i:253;s:8:\"function\";s:18:\"deactivate_plugins\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1765465348","");

INSERT IGNORE INTO `YTcMX_aiowps_audit_log` VALUES 
("36","1","1","hashemi","151.238.116.38","warning","plugin_deactivated","{\"plugin\":{\"name\":\"\\u0641\\u0631\\u0645\\u200c\\u0647\\u0627\\u06cc \\u0641\\u0644\\u0648\\u0626\\u0646\\u062a\",\"version\":\"6.1.11\",\"action\":\"deactivated\",\"network\":\"\"}}","a:10:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:212;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:18:\"plugin_deactivated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:55:\"/home/dadmanla/public_html/wp-admin/includes/plugin.php\";s:4:\"line\";i:840;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"/home/dadmanla/public_html/wp-admin/plugins.php\";s:4:\"line\";i:253;s:8:\"function\";s:18:\"deactivate_plugins\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1765465348",""),
("37","1","1","hashemi","151.238.116.38","warning","plugin_deactivated","{\"plugin\":{\"name\":\"\\u0641\\u0644\\u0648\\u0626\\u0646\\u062a SMTP\",\"version\":\"2.2.92\",\"action\":\"deactivated\",\"network\":\"\"}}","a:10:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:212;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:18:\"plugin_deactivated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:55:\"/home/dadmanla/public_html/wp-admin/includes/plugin.php\";s:4:\"line\";i:840;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"/home/dadmanla/public_html/wp-admin/plugins.php\";s:4:\"line\";i:253;s:8:\"function\";s:18:\"deactivate_plugins\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1765465348",""),
("38","1","1","a.hashemi","151.115.98.139","info","successful_login","{\"successful_login\":{\"username\":\"a.hashemi\"}}","a:22:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:622;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:667;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"/home/dadmanla/public_html/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:133:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";s:4:\"line\";i:1340;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:4:{s:4:\"file\";s:132:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-process-renamed-login-page.php\";s:4:\"line\";i:223;s:4:\"args\";a:1:{i:0;s:133:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";}s:8:\"function\";s:12:\"require_once\";}i:12;a:6:{s:4:\"file\";s:121:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-wp-loaded-tasks.php\";s:4:\"line\";i:21;s:8:\"function\";s:24:\"renamed_login_init_tasks\";s:5:\"class\";s:40:\"AIOWPSecurity_Process_Renamed_Login_Page\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:102:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/wp-security-core.php\";s:4:\"line\";i:497;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:29:\"AIOWPSecurity_WP_Loaded_Tasks\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:24:\"aiowps_wp_loaded_handler\";s:5:\"class\";s:15:\"AIO_WP_Security\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:4:{s:4:\"file\";s:42:\"/home/dadmanla/public_html/wp-settings.php\";s:4:\"line\";i:764;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:4:{s:4:\"file\";s:40:\"/home/dadmanla/public_html/wp-config.php\";s:4:\"line\";i:111;s:4:\"args\";a:1:{i:0;s:42:\"/home/dadmanla/public_html/wp-settings.php\";}s:8:\"function\";s:12:\"require_once\";}i:19;a:4:{s:4:\"file\";s:38:\"/home/dadmanla/public_html/wp-load.php\";s:4:\"line\";i:50;s:4:\"args\";a:1:{i:0;s:40:\"/home/dadmanla/public_html/wp-config.php\";}s:8:\"function\";s:12:\"require_once\";}i:20;a:4:{s:4:\"file\";s:45:\"/home/dadmanla/public_html/wp-blog-header.php\";s:4:\"line\";i:13;s:4:\"args\";a:1:{i:0;s:38:\"/home/dadmanla/public_html/wp-load.php\";}s:8:\"function\";s:12:\"require_once\";}i:21;a:4:{s:4:\"file\";s:36:\"/home/dadmanla/public_html/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:45:\"/home/dadmanla/public_html/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}","1765466013",""),
("39","1","1","hashemi","104.28.246.168","info","theme_installed","{\"theme\":{\"name\":\"Hello Elementor\",\"version\":\"3.4.5\",\"action\":\"installed\",\"network\":\"\"}}","a:15:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:393;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:289;s:8:\"function\";s:19:\"event_theme_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:15:\"theme_installed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:66:\"/home/dadmanla/public_html/wp-admin/includes/class-wp-upgrader.php\";s:4:\"line\";i:987;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:69:\"/home/dadmanla/public_html/wp-admin/includes/class-theme-upgrader.php\";s:4:\"line\";i:250;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:11:\"WP_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:61:\"/home/dadmanla/public_html/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4200;s:8:\"function\";s:7:\"install\";s:5:\"class\";s:14:\"Theme_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:4:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:21:\"wp_ajax_install_theme\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:4:{s:4:\"file\";s:50:\"/home/dadmanla/public_html/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1765467685",""),
("40","1","1","hashemi","104.28.246.168","info","translation_updated","{\"translation_updated\":{\"language\":\"fa_IR\",\"type\":\"theme\",\"slug\":\"hello-elementor\",\"version\":\"3.4.5\"}}","a:19:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:417;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:19:\"translation_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:77:\"/home/dadmanla/public_html/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:287;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:77:\"/home/dadmanla/public_html/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:104;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:343;s:8:\"function\";s:13:\"async_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:4:{s:4:\"file\";s:66:\"/home/dadmanla/public_html/wp-admin/includes/class-wp-upgrader.php\";s:4:\"line\";i:987;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:69:\"/home/dadmanla/public_html/wp-admin/includes/class-theme-upgrader.php\";s:4:\"line\";i:250;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:11:\"WP_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:61:\"/home/dadmanla/public_html/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4200;s:8:\"function\";s:7:\"install\";s:5:\"class\";s:14:\"Theme_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:4:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:21:\"wp_ajax_install_theme\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:4:{s:4:\"file\";s:50:\"/home/dadmanla/public_html/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1765467686",""),
("41","1","1","hashemi","104.28.246.168","info","theme_activated","{\"theme\":{\"name\":\"Hello Elementor\",\"action\":\"activated\"}}","a:9:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:306;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:343;s:8:\"function\";s:15:\"theme_activated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:48:\"/home/dadmanla/public_html/wp-includes/theme.php\";s:4:\"line\";i:878;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:46:\"/home/dadmanla/public_html/wp-admin/themes.php\";s:4:\"line\";i:33;s:8:\"function\";s:12:\"switch_theme\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1765467693",""),
("42","1","1","a.hashemi","151.115.98.139","info","successful_login","{\"successful_login\":{\"username\":\"a.hashemi\"}}","a:22:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:622;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:667;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"/home/dadmanla/public_html/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:133:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";s:4:\"line\";i:1340;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:4:{s:4:\"file\";s:132:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-process-renamed-login-page.php\";s:4:\"line\";i:223;s:4:\"args\";a:1:{i:0;s:133:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";}s:8:\"function\";s:12:\"require_once\";}i:12;a:6:{s:4:\"file\";s:121:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-wp-loaded-tasks.php\";s:4:\"line\";i:21;s:8:\"function\";s:24:\"renamed_login_init_tasks\";s:5:\"class\";s:40:\"AIOWPSecurity_Process_Renamed_Login_Page\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:102:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/wp-security-core.php\";s:4:\"line\";i:497;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:29:\"AIOWPSecurity_WP_Loaded_Tasks\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:24:\"aiowps_wp_loaded_handler\";s:5:\"class\";s:15:\"AIO_WP_Security\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:4:{s:4:\"file\";s:42:\"/home/dadmanla/public_html/wp-settings.php\";s:4:\"line\";i:764;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:4:{s:4:\"file\";s:40:\"/home/dadmanla/public_html/wp-config.php\";s:4:\"line\";i:111;s:4:\"args\";a:1:{i:0;s:42:\"/home/dadmanla/public_html/wp-settings.php\";}s:8:\"function\";s:12:\"require_once\";}i:19;a:4:{s:4:\"file\";s:38:\"/home/dadmanla/public_html/wp-load.php\";s:4:\"line\";i:50;s:4:\"args\";a:1:{i:0;s:40:\"/home/dadmanla/public_html/wp-config.php\";}s:8:\"function\";s:12:\"require_once\";}i:20;a:4:{s:4:\"file\";s:45:\"/home/dadmanla/public_html/wp-blog-header.php\";s:4:\"line\";i:13;s:4:\"args\";a:1:{i:0;s:38:\"/home/dadmanla/public_html/wp-load.php\";}s:8:\"function\";s:12:\"require_once\";}i:21;a:4:{s:4:\"file\";s:36:\"/home/dadmanla/public_html/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:45:\"/home/dadmanla/public_html/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}","1765622911",""),
("43","1","1","a.hashemi","151.115.98.8","info","successful_login","{\"successful_login\":{\"username\":\"a.hashemi\"}}","a:22:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:622;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:667;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"/home/dadmanla/public_html/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:133:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";s:4:\"line\";i:1340;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:4:{s:4:\"file\";s:132:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-process-renamed-login-page.php\";s:4:\"line\";i:223;s:4:\"args\";a:1:{i:0;s:133:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";}s:8:\"function\";s:12:\"require_once\";}i:12;a:6:{s:4:\"file\";s:121:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-wp-loaded-tasks.php\";s:4:\"line\";i:21;s:8:\"function\";s:24:\"renamed_login_init_tasks\";s:5:\"class\";s:40:\"AIOWPSecurity_Process_Renamed_Login_Page\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:102:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/wp-security-core.php\";s:4:\"line\";i:497;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:29:\"AIOWPSecurity_WP_Loaded_Tasks\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:24:\"aiowps_wp_loaded_handler\";s:5:\"class\";s:15:\"AIO_WP_Security\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:4:{s:4:\"file\";s:42:\"/home/dadmanla/public_html/wp-settings.php\";s:4:\"line\";i:764;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:4:{s:4:\"file\";s:40:\"/home/dadmanla/public_html/wp-config.php\";s:4:\"line\";i:111;s:4:\"args\";a:1:{i:0;s:42:\"/home/dadmanla/public_html/wp-settings.php\";}s:8:\"function\";s:12:\"require_once\";}i:19;a:4:{s:4:\"file\";s:38:\"/home/dadmanla/public_html/wp-load.php\";s:4:\"line\";i:50;s:4:\"args\";a:1:{i:0;s:40:\"/home/dadmanla/public_html/wp-config.php\";}s:8:\"function\";s:12:\"require_once\";}i:20;a:4:{s:4:\"file\";s:45:\"/home/dadmanla/public_html/wp-blog-header.php\";s:4:\"line\";i:13;s:4:\"args\";a:1:{i:0;s:38:\"/home/dadmanla/public_html/wp-load.php\";}s:8:\"function\";s:12:\"require_once\";}i:21;a:4:{s:4:\"file\";s:36:\"/home/dadmanla/public_html/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:45:\"/home/dadmanla/public_html/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}","1765626207",""),
("44","1","1","a.hashemi","151.115.98.8","warning","failed_login","{\"failed_login\":{\"imported\":false,\"username\":\"a.hashemi\",\"known\":true}}","a:21:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:569;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"event_failed_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:17:\"post_authenticate\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:0:{}}i:6;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:205;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:52:\"/home/dadmanla/public_html/wp-includes/pluggable.php\";s:4:\"line\";i:702;s:8:\"function\";s:13:\"apply_filters\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:47:\"/home/dadmanla/public_html/wp-includes/user.php\";s:4:\"line\";i:109;s:8:\"function\";s:15:\"wp_authenticate\";s:4:\"args\";a:0:{}}i:9;a:4:{s:4:\"file\";s:133:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";s:4:\"line\";i:1340;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:132:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-process-renamed-login-page.php\";s:4:\"line\";i:223;s:4:\"args\";a:1:{i:0;s:133:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";}s:8:\"function\";s:12:\"require_once\";}i:11;a:6:{s:4:\"file\";s:121:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-wp-loaded-tasks.php\";s:4:\"line\";i:21;s:8:\"function\";s:24:\"renamed_login_init_tasks\";s:5:\"class\";s:40:\"AIOWPSecurity_Process_Renamed_Login_Page\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:102:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/wp-security-core.php\";s:4:\"line\";i:497;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:29:\"AIOWPSecurity_WP_Loaded_Tasks\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:24:\"aiowps_wp_loaded_handler\";s:5:\"class\";s:15:\"AIO_WP_Security\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:4:{s:4:\"file\";s:42:\"/home/dadmanla/public_html/wp-settings.php\";s:4:\"line\";i:764;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:4:{s:4:\"file\";s:40:\"/home/dadmanla/public_html/wp-config.php\";s:4:\"line\";i:111;s:4:\"args\";a:1:{i:0;s:42:\"/home/dadmanla/public_html/wp-settings.php\";}s:8:\"function\";s:12:\"require_once\";}i:18;a:4:{s:4:\"file\";s:38:\"/home/dadmanla/public_html/wp-load.php\";s:4:\"line\";i:50;s:4:\"args\";a:1:{i:0;s:40:\"/home/dadmanla/public_html/wp-config.php\";}s:8:\"function\";s:12:\"require_once\";}i:19;a:4:{s:4:\"file\";s:45:\"/home/dadmanla/public_html/wp-blog-header.php\";s:4:\"line\";i:13;s:4:\"args\";a:1:{i:0;s:38:\"/home/dadmanla/public_html/wp-load.php\";}s:8:\"function\";s:12:\"require_once\";}i:20;a:4:{s:4:\"file\";s:36:\"/home/dadmanla/public_html/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:45:\"/home/dadmanla/public_html/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}","1765635746",""),
("45","1","1","a.hashemi","151.115.98.8","info","successful_login","{\"successful_login\":{\"username\":\"a.hashemi\"}}","a:22:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:622;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:667;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"/home/dadmanla/public_html/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:133:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";s:4:\"line\";i:1340;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:4:{s:4:\"file\";s:132:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-process-renamed-login-page.php\";s:4:\"line\";i:223;s:4:\"args\";a:1:{i:0;s:133:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";}s:8:\"function\";s:12:\"require_once\";}i:12;a:6:{s:4:\"file\";s:121:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-wp-loaded-tasks.php\";s:4:\"line\";i:21;s:8:\"function\";s:24:\"renamed_login_init_tasks\";s:5:\"class\";s:40:\"AIOWPSecurity_Process_Renamed_Login_Page\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:102:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/wp-security-core.php\";s:4:\"line\";i:497;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:29:\"AIOWPSecurity_WP_Loaded_Tasks\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:24:\"aiowps_wp_loaded_handler\";s:5:\"class\";s:15:\"AIO_WP_Security\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:4:{s:4:\"file\";s:42:\"/home/dadmanla/public_html/wp-settings.php\";s:4:\"line\";i:764;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:4:{s:4:\"file\";s:40:\"/home/dadmanla/public_html/wp-config.php\";s:4:\"line\";i:111;s:4:\"args\";a:1:{i:0;s:42:\"/home/dadmanla/public_html/wp-settings.php\";}s:8:\"function\";s:12:\"require_once\";}i:19;a:4:{s:4:\"file\";s:38:\"/home/dadmanla/public_html/wp-load.php\";s:4:\"line\";i:50;s:4:\"args\";a:1:{i:0;s:40:\"/home/dadmanla/public_html/wp-config.php\";}s:8:\"function\";s:12:\"require_once\";}i:20;a:4:{s:4:\"file\";s:45:\"/home/dadmanla/public_html/wp-blog-header.php\";s:4:\"line\";i:13;s:4:\"args\";a:1:{i:0;s:38:\"/home/dadmanla/public_html/wp-load.php\";}s:8:\"function\";s:12:\"require_once\";}i:21;a:4:{s:4:\"file\";s:36:\"/home/dadmanla/public_html/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:45:\"/home/dadmanla/public_html/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}","1765635751",""),
("46","1","1","hashemi","89.111.28.80","info","successful_login","{\"successful_login\":{\"username\":\"hashemi\"}}","a:22:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:622;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:667;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"/home/dadmanla/public_html/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:133:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";s:4:\"line\";i:1340;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:4:{s:4:\"file\";s:132:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-process-renamed-login-page.php\";s:4:\"line\";i:223;s:4:\"args\";a:1:{i:0;s:133:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";}s:8:\"function\";s:12:\"require_once\";}i:12;a:6:{s:4:\"file\";s:121:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-wp-loaded-tasks.php\";s:4:\"line\";i:21;s:8:\"function\";s:24:\"renamed_login_init_tasks\";s:5:\"class\";s:40:\"AIOWPSecurity_Process_Renamed_Login_Page\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:102:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/wp-security-core.php\";s:4:\"line\";i:497;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:29:\"AIOWPSecurity_WP_Loaded_Tasks\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:24:\"aiowps_wp_loaded_handler\";s:5:\"class\";s:15:\"AIO_WP_Security\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:4:{s:4:\"file\";s:42:\"/home/dadmanla/public_html/wp-settings.php\";s:4:\"line\";i:764;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:4:{s:4:\"file\";s:40:\"/home/dadmanla/public_html/wp-config.php\";s:4:\"line\";i:111;s:4:\"args\";a:1:{i:0;s:42:\"/home/dadmanla/public_html/wp-settings.php\";}s:8:\"function\";s:12:\"require_once\";}i:19;a:4:{s:4:\"file\";s:38:\"/home/dadmanla/public_html/wp-load.php\";s:4:\"line\";i:50;s:4:\"args\";a:1:{i:0;s:40:\"/home/dadmanla/public_html/wp-config.php\";}s:8:\"function\";s:12:\"require_once\";}i:20;a:4:{s:4:\"file\";s:45:\"/home/dadmanla/public_html/wp-blog-header.php\";s:4:\"line\";i:13;s:4:\"args\";a:1:{i:0;s:38:\"/home/dadmanla/public_html/wp-load.php\";}s:8:\"function\";s:12:\"require_once\";}i:21;a:4:{s:4:\"file\";s:36:\"/home/dadmanla/public_html/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:45:\"/home/dadmanla/public_html/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}","1765639118",""),
("47","1","1","a.hashemi","109.125.181.35","info","successful_login","{\"successful_login\":{\"username\":\"a.hashemi\"}}","a:22:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:622;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:667;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"/home/dadmanla/public_html/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:133:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";s:4:\"line\";i:1340;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:4:{s:4:\"file\";s:132:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-process-renamed-login-page.php\";s:4:\"line\";i:223;s:4:\"args\";a:1:{i:0;s:133:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";}s:8:\"function\";s:12:\"require_once\";}i:12;a:6:{s:4:\"file\";s:121:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-wp-loaded-tasks.php\";s:4:\"line\";i:21;s:8:\"function\";s:24:\"renamed_login_init_tasks\";s:5:\"class\";s:40:\"AIOWPSecurity_Process_Renamed_Login_Page\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:102:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/wp-security-core.php\";s:4:\"line\";i:497;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:29:\"AIOWPSecurity_WP_Loaded_Tasks\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:24:\"aiowps_wp_loaded_handler\";s:5:\"class\";s:15:\"AIO_WP_Security\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:4:{s:4:\"file\";s:42:\"/home/dadmanla/public_html/wp-settings.php\";s:4:\"line\";i:764;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:4:{s:4:\"file\";s:40:\"/home/dadmanla/public_html/wp-config.php\";s:4:\"line\";i:111;s:4:\"args\";a:1:{i:0;s:42:\"/home/dadmanla/public_html/wp-settings.php\";}s:8:\"function\";s:12:\"require_once\";}i:19;a:4:{s:4:\"file\";s:38:\"/home/dadmanla/public_html/wp-load.php\";s:4:\"line\";i:50;s:4:\"args\";a:1:{i:0;s:40:\"/home/dadmanla/public_html/wp-config.php\";}s:8:\"function\";s:12:\"require_once\";}i:20;a:4:{s:4:\"file\";s:45:\"/home/dadmanla/public_html/wp-blog-header.php\";s:4:\"line\";i:13;s:4:\"args\";a:1:{i:0;s:38:\"/home/dadmanla/public_html/wp-load.php\";}s:8:\"function\";s:12:\"require_once\";}i:21;a:4:{s:4:\"file\";s:36:\"/home/dadmanla/public_html/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:45:\"/home/dadmanla/public_html/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}","1765803816",""),
("48","1","1","a.hashemi","151.115.98.18","info","successful_login","{\"successful_login\":{\"username\":\"a.hashemi\"}}","a:22:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:622;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:667;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"/home/dadmanla/public_html/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:133:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";s:4:\"line\";i:1340;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:4:{s:4:\"file\";s:132:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-process-renamed-login-page.php\";s:4:\"line\";i:223;s:4:\"args\";a:1:{i:0;s:133:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";}s:8:\"function\";s:12:\"require_once\";}i:12;a:6:{s:4:\"file\";s:121:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-wp-loaded-tasks.php\";s:4:\"line\";i:21;s:8:\"function\";s:24:\"renamed_login_init_tasks\";s:5:\"class\";s:40:\"AIOWPSecurity_Process_Renamed_Login_Page\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:102:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/wp-security-core.php\";s:4:\"line\";i:497;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:29:\"AIOWPSecurity_WP_Loaded_Tasks\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:24:\"aiowps_wp_loaded_handler\";s:5:\"class\";s:15:\"AIO_WP_Security\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:4:{s:4:\"file\";s:42:\"/home/dadmanla/public_html/wp-settings.php\";s:4:\"line\";i:764;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:4:{s:4:\"file\";s:40:\"/home/dadmanla/public_html/wp-config.php\";s:4:\"line\";i:111;s:4:\"args\";a:1:{i:0;s:42:\"/home/dadmanla/public_html/wp-settings.php\";}s:8:\"function\";s:12:\"require_once\";}i:19;a:4:{s:4:\"file\";s:38:\"/home/dadmanla/public_html/wp-load.php\";s:4:\"line\";i:50;s:4:\"args\";a:1:{i:0;s:40:\"/home/dadmanla/public_html/wp-config.php\";}s:8:\"function\";s:12:\"require_once\";}i:20;a:4:{s:4:\"file\";s:45:\"/home/dadmanla/public_html/wp-blog-header.php\";s:4:\"line\";i:13;s:4:\"args\";a:1:{i:0;s:38:\"/home/dadmanla/public_html/wp-load.php\";}s:8:\"function\";s:12:\"require_once\";}i:21;a:4:{s:4:\"file\";s:36:\"/home/dadmanla/public_html/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:45:\"/home/dadmanla/public_html/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}","1765888604",""),
("49","1","1","hashemi","151.238.119.16","info","successful_login","{\"successful_login\":{\"username\":\"hashemi\"}}","a:22:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:622;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:667;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"/home/dadmanla/public_html/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:133:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";s:4:\"line\";i:1340;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:4:{s:4:\"file\";s:132:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-process-renamed-login-page.php\";s:4:\"line\";i:223;s:4:\"args\";a:1:{i:0;s:133:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";}s:8:\"function\";s:12:\"require_once\";}i:12;a:6:{s:4:\"file\";s:121:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-wp-loaded-tasks.php\";s:4:\"line\";i:21;s:8:\"function\";s:24:\"renamed_login_init_tasks\";s:5:\"class\";s:40:\"AIOWPSecurity_Process_Renamed_Login_Page\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:102:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/wp-security-core.php\";s:4:\"line\";i:497;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:29:\"AIOWPSecurity_WP_Loaded_Tasks\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:24:\"aiowps_wp_loaded_handler\";s:5:\"class\";s:15:\"AIO_WP_Security\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:4:{s:4:\"file\";s:42:\"/home/dadmanla/public_html/wp-settings.php\";s:4:\"line\";i:764;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:4:{s:4:\"file\";s:40:\"/home/dadmanla/public_html/wp-config.php\";s:4:\"line\";i:111;s:4:\"args\";a:1:{i:0;s:42:\"/home/dadmanla/public_html/wp-settings.php\";}s:8:\"function\";s:12:\"require_once\";}i:19;a:4:{s:4:\"file\";s:38:\"/home/dadmanla/public_html/wp-load.php\";s:4:\"line\";i:50;s:4:\"args\";a:1:{i:0;s:40:\"/home/dadmanla/public_html/wp-config.php\";}s:8:\"function\";s:12:\"require_once\";}i:20;a:4:{s:4:\"file\";s:45:\"/home/dadmanla/public_html/wp-blog-header.php\";s:4:\"line\";i:13;s:4:\"args\";a:1:{i:0;s:38:\"/home/dadmanla/public_html/wp-load.php\";}s:8:\"function\";s:12:\"require_once\";}i:21;a:4:{s:4:\"file\";s:36:\"/home/dadmanla/public_html/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:45:\"/home/dadmanla/public_html/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}","1765891070",""),
("50","1","1","a.hashemi","151.115.98.18","info","successful_login","{\"successful_login\":{\"username\":\"a.hashemi\"}}","a:22:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:622;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:667;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"/home/dadmanla/public_html/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:133:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";s:4:\"line\";i:1340;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:4:{s:4:\"file\";s:132:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-process-renamed-login-page.php\";s:4:\"line\";i:223;s:4:\"args\";a:1:{i:0;s:133:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";}s:8:\"function\";s:12:\"require_once\";}i:12;a:6:{s:4:\"file\";s:121:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-wp-loaded-tasks.php\";s:4:\"line\";i:21;s:8:\"function\";s:24:\"renamed_login_init_tasks\";s:5:\"class\";s:40:\"AIOWPSecurity_Process_Renamed_Login_Page\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:102:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/wp-security-core.php\";s:4:\"line\";i:497;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:29:\"AIOWPSecurity_WP_Loaded_Tasks\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:24:\"aiowps_wp_loaded_handler\";s:5:\"class\";s:15:\"AIO_WP_Security\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:4:{s:4:\"file\";s:42:\"/home/dadmanla/public_html/wp-settings.php\";s:4:\"line\";i:764;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:4:{s:4:\"file\";s:40:\"/home/dadmanla/public_html/wp-config.php\";s:4:\"line\";i:111;s:4:\"args\";a:1:{i:0;s:42:\"/home/dadmanla/public_html/wp-settings.php\";}s:8:\"function\";s:12:\"require_once\";}i:19;a:4:{s:4:\"file\";s:38:\"/home/dadmanla/public_html/wp-load.php\";s:4:\"line\";i:50;s:4:\"args\";a:1:{i:0;s:40:\"/home/dadmanla/public_html/wp-config.php\";}s:8:\"function\";s:12:\"require_once\";}i:20;a:4:{s:4:\"file\";s:45:\"/home/dadmanla/public_html/wp-blog-header.php\";s:4:\"line\";i:13;s:4:\"args\";a:1:{i:0;s:38:\"/home/dadmanla/public_html/wp-load.php\";}s:8:\"function\";s:12:\"require_once\";}i:21;a:4:{s:4:\"file\";s:36:\"/home/dadmanla/public_html/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:45:\"/home/dadmanla/public_html/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}","1765892965",""),
("51","1","1","hashemi","151.238.119.16","info","successful_login","{\"successful_login\":{\"username\":\"hashemi\"}}","a:22:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:622;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:667;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"/home/dadmanla/public_html/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:133:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";s:4:\"line\";i:1340;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:4:{s:4:\"file\";s:132:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-process-renamed-login-page.php\";s:4:\"line\";i:223;s:4:\"args\";a:1:{i:0;s:133:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";}s:8:\"function\";s:12:\"require_once\";}i:12;a:6:{s:4:\"file\";s:121:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-wp-loaded-tasks.php\";s:4:\"line\";i:21;s:8:\"function\";s:24:\"renamed_login_init_tasks\";s:5:\"class\";s:40:\"AIOWPSecurity_Process_Renamed_Login_Page\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:102:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/wp-security-core.php\";s:4:\"line\";i:497;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:29:\"AIOWPSecurity_WP_Loaded_Tasks\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:24:\"aiowps_wp_loaded_handler\";s:5:\"class\";s:15:\"AIO_WP_Security\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:4:{s:4:\"file\";s:42:\"/home/dadmanla/public_html/wp-settings.php\";s:4:\"line\";i:764;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:4:{s:4:\"file\";s:40:\"/home/dadmanla/public_html/wp-config.php\";s:4:\"line\";i:111;s:4:\"args\";a:1:{i:0;s:42:\"/home/dadmanla/public_html/wp-settings.php\";}s:8:\"function\";s:12:\"require_once\";}i:19;a:4:{s:4:\"file\";s:38:\"/home/dadmanla/public_html/wp-load.php\";s:4:\"line\";i:50;s:4:\"args\";a:1:{i:0;s:40:\"/home/dadmanla/public_html/wp-config.php\";}s:8:\"function\";s:12:\"require_once\";}i:20;a:4:{s:4:\"file\";s:45:\"/home/dadmanla/public_html/wp-blog-header.php\";s:4:\"line\";i:13;s:4:\"args\";a:1:{i:0;s:38:\"/home/dadmanla/public_html/wp-load.php\";}s:8:\"function\";s:12:\"require_once\";}i:21;a:4:{s:4:\"file\";s:36:\"/home/dadmanla/public_html/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:45:\"/home/dadmanla/public_html/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}","1765893889",""),
("52","1","1","rasaneh-design","151.238.119.16","info","plugin_installed","{\"plugin\":{\"name\":\"\\u062a\\u0627\\u0631\\u06cc\\u062e \\u0634\\u0645\\u0633\\u06cc \\u0648 \\u0641\\u0627\\u0631\\u0633\\u06cc \\u0633\\u0627\\u0632 \\u0648\\u0631\\u062f\\u067e\\u0631\\u0633-\\u0627\\u0635\\u0644\\u0627\\u062d\\u06cc\\u0647 \\u0627\\u0645\\u0646\\u06cc\\u062a\\u06cc \\u0698\\u0627\\u06a9\\u062a\",\"version\":\"4.3.3.1\",\"action\":\"installed\",\"network\":\"\"}}","a:11:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:164;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:16:\"plugin_installed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:66:\"/home/dadmanla/public_html/wp-admin/includes/class-wp-upgrader.php\";s:4:\"line\";i:987;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:70:\"/home/dadmanla/public_html/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:137;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:11:\"WP_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:46:\"/home/dadmanla/public_html/wp-admin/update.php\";s:4:\"line\";i:180;s:8:\"function\";s:7:\"install\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1765898432",""),
("53","1","1","rasaneh-design","151.238.119.16","info","translation_updated","{\"translation_updated\":{\"language\":\"fa_IR\",\"type\":\"plugin\",\"slug\":\"seo-by-rank-math\",\"version\":\"1.0.259.1\"}}","a:15:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:417;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:19:\"translation_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:77:\"/home/dadmanla/public_html/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:287;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:77:\"/home/dadmanla/public_html/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:104;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:343;s:8:\"function\";s:13:\"async_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:4:{s:4:\"file\";s:66:\"/home/dadmanla/public_html/wp-admin/includes/class-wp-upgrader.php\";s:4:\"line\";i:987;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:70:\"/home/dadmanla/public_html/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:137;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:11:\"WP_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:46:\"/home/dadmanla/public_html/wp-admin/update.php\";s:4:\"line\";i:180;s:8:\"function\";s:7:\"install\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1765898434",""),
("54","1","1","rasaneh-design","151.238.119.16","info","plugin_activated","{\"plugin\":{\"name\":\"\\u062a\\u0627\\u0631\\u06cc\\u062e \\u0634\\u0645\\u0633\\u06cc \\u0648 \\u0641\\u0627\\u0631\\u0633\\u06cc \\u0633\\u0627\\u0632 \\u0648\\u0631\\u062f\\u067e\\u0631\\u0633-\\u0627\\u0635\\u0644\\u0627\\u062d\\u06cc\\u0647 \\u0627\\u0645\\u0646\\u06cc\\u062a\\u06cc \\u0698\\u0627\\u06a9\\u062a\",\"version\":\"4.3.3.1\",\"action\":\"activated\",\"network\":\"\"}}","a:10:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:177;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:16:\"plugin_activated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:55:\"/home/dadmanla/public_html/wp-admin/includes/plugin.php\";s:4:\"line\";i:730;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"/home/dadmanla/public_html/wp-admin/plugins.php\";s:4:\"line\";i:60;s:8:\"function\";s:15:\"activate_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1765898442",""),
("55","1","1","rasaneh-design","151.238.119.16","info","plugin_installed","{\"plugin\":{\"name\":\"Gravity Forms\",\"version\":\"2.9.24\",\"action\":\"installed\",\"network\":\"\"}}","a:11:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:164;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:16:\"plugin_installed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:66:\"/home/dadmanla/public_html/wp-admin/includes/class-wp-upgrader.php\";s:4:\"line\";i:987;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:70:\"/home/dadmanla/public_html/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:137;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:11:\"WP_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:46:\"/home/dadmanla/public_html/wp-admin/update.php\";s:4:\"line\";i:180;s:8:\"function\";s:7:\"install\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1765898507",""),
("56","1","1","rasaneh-design","151.238.119.16","info","plugin_activated","{\"plugin\":{\"name\":\"\\u06af\\u0631\\u0648\\u06cc\\u062a\\u06cc \\u0641\\u0631\\u0645\",\"version\":\"2.9.24\",\"action\":\"activated\",\"network\":\"\"}}","a:10:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:177;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:16:\"plugin_activated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:55:\"/home/dadmanla/public_html/wp-admin/includes/plugin.php\";s:4:\"line\";i:730;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"/home/dadmanla/public_html/wp-admin/plugins.php\";s:4:\"line\";i:60;s:8:\"function\";s:15:\"activate_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1765898512",""),
("57","1","1","rasaneh-design","151.238.119.16","info","plugin_installed","{\"plugin\":{\"name\":\"Essential Addons for Elementor\",\"version\":\"6.5.4\",\"action\":\"installed\",\"network\":\"\"}}","a:15:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:164;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:16:\"plugin_installed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:66:\"/home/dadmanla/public_html/wp-admin/includes/class-wp-upgrader.php\";s:4:\"line\";i:987;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:70:\"/home/dadmanla/public_html/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:137;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:11:\"WP_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:61:\"/home/dadmanla/public_html/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4497;s:8:\"function\";s:7:\"install\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:4:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:22:\"wp_ajax_install_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:4:{s:4:\"file\";s:50:\"/home/dadmanla/public_html/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1765898906",""),
("58","1","1","rasaneh-design","151.238.119.16","info","translation_updated","{\"translation_updated\":{\"language\":\"fa_IR\",\"type\":\"plugin\",\"slug\":\"essential-addons-for-elementor-lite\",\"version\":\"6.5.4\"}}","a:19:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:417;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:19:\"translation_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:77:\"/home/dadmanla/public_html/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:287;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:77:\"/home/dadmanla/public_html/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:104;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:343;s:8:\"function\";s:13:\"async_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:4:{s:4:\"file\";s:66:\"/home/dadmanla/public_html/wp-admin/includes/class-wp-upgrader.php\";s:4:\"line\";i:987;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:70:\"/home/dadmanla/public_html/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:137;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:11:\"WP_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:61:\"/home/dadmanla/public_html/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4497;s:8:\"function\";s:7:\"install\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:4:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:22:\"wp_ajax_install_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:4:{s:4:\"file\";s:50:\"/home/dadmanla/public_html/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1765898908",""),
("59","1","1","rasaneh-design","151.238.119.16","info","plugin_activated","{\"plugin\":{\"name\":\"\\u0627\\u0641\\u0632\\u0648\\u0646\\u0647\\u200c\\u0647\\u0627\\u06cc \\u0636\\u0631\\u0648\\u0631\\u06cc \\u0628\\u0631\\u0627\\u06cc \\u0627\\u0644\\u0645\\u0646\\u062a\\u0648\\u0631\",\"version\":\"6.5.4\",\"action\":\"activated\",\"network\":\"\"}}","a:10:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:177;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:16:\"plugin_activated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:55:\"/home/dadmanla/public_html/wp-admin/includes/plugin.php\";s:4:\"line\";i:730;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"/home/dadmanla/public_html/wp-admin/plugins.php\";s:4:\"line\";i:60;s:8:\"function\";s:15:\"activate_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1765898913",""),
("60","1","1","author_w5upz2oe","5.211.219.63","info","successful_login","{\"successful_login\":{\"username\":\"author_w5upz2oe\"}}","a:19:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:622;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:667;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"/home/dadmanla/public_html/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:93:\"/home/dadmanla/public_html/wp-content/plugins/wp-user-frontend/includes/Free/Simple_Login.php\";s:4:\"line\";i:592;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:13:\"process_login\";s:5:\"class\";s:29:\"WeDevs\\Wpuf\\Free\\Simple_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:4:{s:4:\"file\";s:42:\"/home/dadmanla/public_html/wp-settings.php\";s:4:\"line\";i:742;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:4:{s:4:\"file\";s:40:\"/home/dadmanla/public_html/wp-config.php\";s:4:\"line\";i:111;s:4:\"args\";a:1:{i:0;s:42:\"/home/dadmanla/public_html/wp-settings.php\";}s:8:\"function\";s:12:\"require_once\";}i:16;a:4:{s:4:\"file\";s:38:\"/home/dadmanla/public_html/wp-load.php\";s:4:\"line\";i:50;s:4:\"args\";a:1:{i:0;s:40:\"/home/dadmanla/public_html/wp-config.php\";}s:8:\"function\";s:12:\"require_once\";}i:17;a:4:{s:4:\"file\";s:45:\"/home/dadmanla/public_html/wp-blog-header.php\";s:4:\"line\";i:13;s:4:\"args\";a:1:{i:0;s:38:\"/home/dadmanla/public_html/wp-load.php\";}s:8:\"function\";s:12:\"require_once\";}i:18;a:4:{s:4:\"file\";s:36:\"/home/dadmanla/public_html/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:45:\"/home/dadmanla/public_html/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}","1765921753",""),
("61","1","1","a.hashemi","5.202.229.15","info","successful_login","{\"successful_login\":{\"username\":\"a.hashemi\"}}","a:22:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:622;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:667;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"/home/dadmanla/public_html/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:133:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";s:4:\"line\";i:1340;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:4:{s:4:\"file\";s:132:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-process-renamed-login-page.php\";s:4:\"line\";i:223;s:4:\"args\";a:1:{i:0;s:133:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";}s:8:\"function\";s:12:\"require_once\";}i:12;a:6:{s:4:\"file\";s:121:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-wp-loaded-tasks.php\";s:4:\"line\";i:21;s:8:\"function\";s:24:\"renamed_login_init_tasks\";s:5:\"class\";s:40:\"AIOWPSecurity_Process_Renamed_Login_Page\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:102:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/wp-security-core.php\";s:4:\"line\";i:497;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:29:\"AIOWPSecurity_WP_Loaded_Tasks\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:24:\"aiowps_wp_loaded_handler\";s:5:\"class\";s:15:\"AIO_WP_Security\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:4:{s:4:\"file\";s:42:\"/home/dadmanla/public_html/wp-settings.php\";s:4:\"line\";i:764;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:4:{s:4:\"file\";s:40:\"/home/dadmanla/public_html/wp-config.php\";s:4:\"line\";i:111;s:4:\"args\";a:1:{i:0;s:42:\"/home/dadmanla/public_html/wp-settings.php\";}s:8:\"function\";s:12:\"require_once\";}i:19;a:4:{s:4:\"file\";s:38:\"/home/dadmanla/public_html/wp-load.php\";s:4:\"line\";i:50;s:4:\"args\";a:1:{i:0;s:40:\"/home/dadmanla/public_html/wp-config.php\";}s:8:\"function\";s:12:\"require_once\";}i:20;a:4:{s:4:\"file\";s:45:\"/home/dadmanla/public_html/wp-blog-header.php\";s:4:\"line\";i:13;s:4:\"args\";a:1:{i:0;s:38:\"/home/dadmanla/public_html/wp-load.php\";}s:8:\"function\";s:12:\"require_once\";}i:21;a:4:{s:4:\"file\";s:36:\"/home/dadmanla/public_html/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:45:\"/home/dadmanla/public_html/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}","1765960091",""),
("62","1","1","a.hashemi","151.238.118.138","info","successful_login","{\"successful_login\":{\"username\":\"a.hashemi\"}}","a:22:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:622;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:667;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"/home/dadmanla/public_html/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:133:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";s:4:\"line\";i:1340;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:4:{s:4:\"file\";s:132:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-process-renamed-login-page.php\";s:4:\"line\";i:223;s:4:\"args\";a:1:{i:0;s:133:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";}s:8:\"function\";s:12:\"require_once\";}i:12;a:6:{s:4:\"file\";s:121:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-wp-loaded-tasks.php\";s:4:\"line\";i:21;s:8:\"function\";s:24:\"renamed_login_init_tasks\";s:5:\"class\";s:40:\"AIOWPSecurity_Process_Renamed_Login_Page\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:102:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/wp-security-core.php\";s:4:\"line\";i:497;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:29:\"AIOWPSecurity_WP_Loaded_Tasks\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:24:\"aiowps_wp_loaded_handler\";s:5:\"class\";s:15:\"AIO_WP_Security\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:4:{s:4:\"file\";s:42:\"/home/dadmanla/public_html/wp-settings.php\";s:4:\"line\";i:764;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:4:{s:4:\"file\";s:40:\"/home/dadmanla/public_html/wp-config.php\";s:4:\"line\";i:111;s:4:\"args\";a:1:{i:0;s:42:\"/home/dadmanla/public_html/wp-settings.php\";}s:8:\"function\";s:12:\"require_once\";}i:19;a:4:{s:4:\"file\";s:38:\"/home/dadmanla/public_html/wp-load.php\";s:4:\"line\";i:50;s:4:\"args\";a:1:{i:0;s:40:\"/home/dadmanla/public_html/wp-config.php\";}s:8:\"function\";s:12:\"require_once\";}i:20;a:4:{s:4:\"file\";s:45:\"/home/dadmanla/public_html/wp-blog-header.php\";s:4:\"line\";i:13;s:4:\"args\";a:1:{i:0;s:38:\"/home/dadmanla/public_html/wp-load.php\";}s:8:\"function\";s:12:\"require_once\";}i:21;a:4:{s:4:\"file\";s:36:\"/home/dadmanla/public_html/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:45:\"/home/dadmanla/public_html/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}","1765976023",""),
("63","1","1","author_w5upz2oe","5.215.207.155","info","successful_login","{\"successful_login\":{\"username\":\"author_w5upz2oe\"}}","a:19:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:622;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:667;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"/home/dadmanla/public_html/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:93:\"/home/dadmanla/public_html/wp-content/plugins/wp-user-frontend/includes/Free/Simple_Login.php\";s:4:\"line\";i:592;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:13:\"process_login\";s:5:\"class\";s:29:\"WeDevs\\Wpuf\\Free\\Simple_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:4:{s:4:\"file\";s:42:\"/home/dadmanla/public_html/wp-settings.php\";s:4:\"line\";i:742;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:4:{s:4:\"file\";s:40:\"/home/dadmanla/public_html/wp-config.php\";s:4:\"line\";i:111;s:4:\"args\";a:1:{i:0;s:42:\"/home/dadmanla/public_html/wp-settings.php\";}s:8:\"function\";s:12:\"require_once\";}i:16;a:4:{s:4:\"file\";s:38:\"/home/dadmanla/public_html/wp-load.php\";s:4:\"line\";i:50;s:4:\"args\";a:1:{i:0;s:40:\"/home/dadmanla/public_html/wp-config.php\";}s:8:\"function\";s:12:\"require_once\";}i:17;a:4:{s:4:\"file\";s:45:\"/home/dadmanla/public_html/wp-blog-header.php\";s:4:\"line\";i:13;s:4:\"args\";a:1:{i:0;s:38:\"/home/dadmanla/public_html/wp-load.php\";}s:8:\"function\";s:12:\"require_once\";}i:18;a:4:{s:4:\"file\";s:36:\"/home/dadmanla/public_html/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:45:\"/home/dadmanla/public_html/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}","1765977749",""),
("64","1","1","hashemi","104.28.214.164","info","successful_login","{\"successful_login\":{\"username\":\"hashemi\"}}","a:22:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:622;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:667;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"/home/dadmanla/public_html/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:133:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";s:4:\"line\";i:1340;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:4:{s:4:\"file\";s:132:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-process-renamed-login-page.php\";s:4:\"line\";i:223;s:4:\"args\";a:1:{i:0;s:133:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";}s:8:\"function\";s:12:\"require_once\";}i:12;a:6:{s:4:\"file\";s:121:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-wp-loaded-tasks.php\";s:4:\"line\";i:21;s:8:\"function\";s:24:\"renamed_login_init_tasks\";s:5:\"class\";s:40:\"AIOWPSecurity_Process_Renamed_Login_Page\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:102:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/wp-security-core.php\";s:4:\"line\";i:497;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:29:\"AIOWPSecurity_WP_Loaded_Tasks\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:24:\"aiowps_wp_loaded_handler\";s:5:\"class\";s:15:\"AIO_WP_Security\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:4:{s:4:\"file\";s:42:\"/home/dadmanla/public_html/wp-settings.php\";s:4:\"line\";i:764;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:4:{s:4:\"file\";s:40:\"/home/dadmanla/public_html/wp-config.php\";s:4:\"line\";i:111;s:4:\"args\";a:1:{i:0;s:42:\"/home/dadmanla/public_html/wp-settings.php\";}s:8:\"function\";s:12:\"require_once\";}i:19;a:4:{s:4:\"file\";s:38:\"/home/dadmanla/public_html/wp-load.php\";s:4:\"line\";i:50;s:4:\"args\";a:1:{i:0;s:40:\"/home/dadmanla/public_html/wp-config.php\";}s:8:\"function\";s:12:\"require_once\";}i:20;a:4:{s:4:\"file\";s:45:\"/home/dadmanla/public_html/wp-blog-header.php\";s:4:\"line\";i:13;s:4:\"args\";a:1:{i:0;s:38:\"/home/dadmanla/public_html/wp-load.php\";}s:8:\"function\";s:12:\"require_once\";}i:21;a:4:{s:4:\"file\";s:36:\"/home/dadmanla/public_html/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:45:\"/home/dadmanla/public_html/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}","1765984224",""),
("65","1","1","hashemi","5.201.194.245","info","successful_login","{\"successful_login\":{\"username\":\"hashemi\"}}","a:22:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:622;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:667;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"/home/dadmanla/public_html/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:133:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";s:4:\"line\";i:1340;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:4:{s:4:\"file\";s:132:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-process-renamed-login-page.php\";s:4:\"line\";i:223;s:4:\"args\";a:1:{i:0;s:133:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";}s:8:\"function\";s:12:\"require_once\";}i:12;a:6:{s:4:\"file\";s:121:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-wp-loaded-tasks.php\";s:4:\"line\";i:21;s:8:\"function\";s:24:\"renamed_login_init_tasks\";s:5:\"class\";s:40:\"AIOWPSecurity_Process_Renamed_Login_Page\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:102:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/wp-security-core.php\";s:4:\"line\";i:497;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:29:\"AIOWPSecurity_WP_Loaded_Tasks\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:24:\"aiowps_wp_loaded_handler\";s:5:\"class\";s:15:\"AIO_WP_Security\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:4:{s:4:\"file\";s:42:\"/home/dadmanla/public_html/wp-settings.php\";s:4:\"line\";i:764;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:4:{s:4:\"file\";s:40:\"/home/dadmanla/public_html/wp-config.php\";s:4:\"line\";i:111;s:4:\"args\";a:1:{i:0;s:42:\"/home/dadmanla/public_html/wp-settings.php\";}s:8:\"function\";s:12:\"require_once\";}i:19;a:4:{s:4:\"file\";s:38:\"/home/dadmanla/public_html/wp-load.php\";s:4:\"line\";i:50;s:4:\"args\";a:1:{i:0;s:40:\"/home/dadmanla/public_html/wp-config.php\";}s:8:\"function\";s:12:\"require_once\";}i:20;a:4:{s:4:\"file\";s:45:\"/home/dadmanla/public_html/wp-blog-header.php\";s:4:\"line\";i:13;s:4:\"args\";a:1:{i:0;s:38:\"/home/dadmanla/public_html/wp-load.php\";}s:8:\"function\";s:12:\"require_once\";}i:21;a:4:{s:4:\"file\";s:36:\"/home/dadmanla/public_html/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:45:\"/home/dadmanla/public_html/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}","1766046895","");

INSERT IGNORE INTO `YTcMX_aiowps_audit_log` VALUES 
("66","1","1","a.hashemi","5.202.229.15","info","successful_login","{\"successful_login\":{\"username\":\"a.hashemi\"}}","a:22:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:622;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:667;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"/home/dadmanla/public_html/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:133:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";s:4:\"line\";i:1340;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:4:{s:4:\"file\";s:132:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-process-renamed-login-page.php\";s:4:\"line\";i:223;s:4:\"args\";a:1:{i:0;s:133:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";}s:8:\"function\";s:12:\"require_once\";}i:12;a:6:{s:4:\"file\";s:121:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-wp-loaded-tasks.php\";s:4:\"line\";i:21;s:8:\"function\";s:24:\"renamed_login_init_tasks\";s:5:\"class\";s:40:\"AIOWPSecurity_Process_Renamed_Login_Page\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:102:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/wp-security-core.php\";s:4:\"line\";i:497;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:29:\"AIOWPSecurity_WP_Loaded_Tasks\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:24:\"aiowps_wp_loaded_handler\";s:5:\"class\";s:15:\"AIO_WP_Security\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:4:{s:4:\"file\";s:42:\"/home/dadmanla/public_html/wp-settings.php\";s:4:\"line\";i:764;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:4:{s:4:\"file\";s:40:\"/home/dadmanla/public_html/wp-config.php\";s:4:\"line\";i:111;s:4:\"args\";a:1:{i:0;s:42:\"/home/dadmanla/public_html/wp-settings.php\";}s:8:\"function\";s:12:\"require_once\";}i:19;a:4:{s:4:\"file\";s:38:\"/home/dadmanla/public_html/wp-load.php\";s:4:\"line\";i:50;s:4:\"args\";a:1:{i:0;s:40:\"/home/dadmanla/public_html/wp-config.php\";}s:8:\"function\";s:12:\"require_once\";}i:20;a:4:{s:4:\"file\";s:45:\"/home/dadmanla/public_html/wp-blog-header.php\";s:4:\"line\";i:13;s:4:\"args\";a:1:{i:0;s:38:\"/home/dadmanla/public_html/wp-load.php\";}s:8:\"function\";s:12:\"require_once\";}i:21;a:4:{s:4:\"file\";s:36:\"/home/dadmanla/public_html/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:45:\"/home/dadmanla/public_html/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}","1766047445",""),
("67","1","1","hashemi","5.201.194.245","warning","plugin_deleted","{\"plugin\":{\"name\":\"Cache Enabler\",\"version\":\"1.8.15\",\"action\":\"deleted\",\"network\":\"\"}}","a:14:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:238;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:14:\"plugin_deleted\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:55:\"/home/dadmanla/public_html/wp-admin/includes/plugin.php\";s:4:\"line\";i:1002;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:61:\"/home/dadmanla/public_html/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4774;s:8:\"function\";s:14:\"delete_plugins\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:21:\"wp_ajax_delete_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:50:\"/home/dadmanla/public_html/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1766050056",""),
("68","1","1","hashemi","5.201.194.245","warning","plugin_deleted","{\"plugin\":{\"name\":\"WP Crontrol\\u200c\",\"version\":\"1.19.3\",\"action\":\"deleted\",\"network\":\"\"}}","a:14:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:238;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:14:\"plugin_deleted\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:55:\"/home/dadmanla/public_html/wp-admin/includes/plugin.php\";s:4:\"line\";i:1002;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:61:\"/home/dadmanla/public_html/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4774;s:8:\"function\";s:14:\"delete_plugins\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:21:\"wp_ajax_delete_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:50:\"/home/dadmanla/public_html/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1766050066",""),
("69","1","1","hashemi","5.201.194.245","warning","plugin_deleted","{\"plugin\":{\"name\":\"WP Call Button\",\"version\":\"1.4.3\",\"action\":\"deleted\",\"network\":\"\"}}","a:14:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:238;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:14:\"plugin_deleted\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:55:\"/home/dadmanla/public_html/wp-admin/includes/plugin.php\";s:4:\"line\";i:1002;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:61:\"/home/dadmanla/public_html/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4774;s:8:\"function\";s:14:\"delete_plugins\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:21:\"wp_ajax_delete_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:50:\"/home/dadmanla/public_html/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1766050069",""),
("70","1","1","hashemi","5.201.194.245","warning","plugin_deleted","{\"plugin\":{\"name\":\"Spectra\",\"version\":\"2.19.17\",\"action\":\"deleted\",\"network\":\"\"}}","a:14:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:238;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:14:\"plugin_deleted\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:55:\"/home/dadmanla/public_html/wp-admin/includes/plugin.php\";s:4:\"line\";i:1002;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:61:\"/home/dadmanla/public_html/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4774;s:8:\"function\";s:14:\"delete_plugins\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:21:\"wp_ajax_delete_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:50:\"/home/dadmanla/public_html/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1766050074",""),
("71","1","1","hashemi","5.201.194.245","warning","plugin_deactivated","{\"plugin\":{\"name\":\"\\u0627\\u0641\\u0632\\u0648\\u0646\\u0647 \\u0646\\u0627\\u062d\\u06cc\\u0647 \\u06a9\\u0627\\u0628\\u0631\\u06cc \\u067e\\u06cc\\u0634\\u0631\\u0641\\u062a\\u0647\",\"version\":\"4.2.3\",\"action\":\"deactivated\",\"network\":\"\"}}","a:10:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:212;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:18:\"plugin_deactivated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:55:\"/home/dadmanla/public_html/wp-admin/includes/plugin.php\";s:4:\"line\";i:840;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"/home/dadmanla/public_html/wp-admin/plugins.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"deactivate_plugins\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1766050087",""),
("72","1","1","hashemi","5.201.194.245","warning","plugin_deleted","{\"plugin\":{\"name\":\"\\u0628\\u0647\\u06cc\\u0646\\u0647\\u200c\\u0633\\u0627\\u0632\\u06cc \\u062e\\u0648\\u062f\\u06a9\\u0627\\u0631\",\"version\":\"3.1.14\",\"action\":\"deleted\",\"network\":\"\"}}","a:14:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:238;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:14:\"plugin_deleted\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:55:\"/home/dadmanla/public_html/wp-admin/includes/plugin.php\";s:4:\"line\";i:1002;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:61:\"/home/dadmanla/public_html/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4774;s:8:\"function\";s:14:\"delete_plugins\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:21:\"wp_ajax_delete_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:50:\"/home/dadmanla/public_html/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1766050106",""),
("73","1","1","hashemi","5.201.194.245","warning","plugin_deleted","{\"plugin\":{\"name\":\"\\u0641\\u0631\\u0645\\u200c\\u0647\\u0627\\u06cc \\u0641\\u0644\\u0648\\u0626\\u0646\\u062a\",\"version\":\"6.1.11\",\"action\":\"deleted\",\"network\":\"\"}}","a:14:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:238;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:14:\"plugin_deleted\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:55:\"/home/dadmanla/public_html/wp-admin/includes/plugin.php\";s:4:\"line\";i:1002;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:61:\"/home/dadmanla/public_html/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4774;s:8:\"function\";s:14:\"delete_plugins\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:21:\"wp_ajax_delete_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:50:\"/home/dadmanla/public_html/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1766050110",""),
("74","1","1","hashemi","5.201.194.245","warning","plugin_deleted","{\"plugin\":{\"name\":\"\\u0641\\u0644\\u0648\\u0626\\u0646\\u062a SMTP\",\"version\":\"2.2.92\",\"action\":\"deleted\",\"network\":\"\"}}","a:14:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:238;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:14:\"plugin_deleted\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:55:\"/home/dadmanla/public_html/wp-admin/includes/plugin.php\";s:4:\"line\";i:1002;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:61:\"/home/dadmanla/public_html/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4774;s:8:\"function\";s:14:\"delete_plugins\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:21:\"wp_ajax_delete_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:50:\"/home/dadmanla/public_html/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1766050114",""),
("75","1","1","hashemi","5.201.194.245","warning","plugin_deactivated","{\"plugin\":{\"name\":\"\\u0641\\u0648\\u0646\\u062a\\u200c\\u0647\\u0627\\u06cc \\u062f\\u0644\\u062e\\u0648\\u0627\\u0647\",\"version\":\"2.1.16\",\"action\":\"deactivated\",\"network\":\"\"}}","a:10:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:212;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:18:\"plugin_deactivated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:55:\"/home/dadmanla/public_html/wp-admin/includes/plugin.php\";s:4:\"line\";i:840;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"/home/dadmanla/public_html/wp-admin/plugins.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"deactivate_plugins\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1766050120",""),
("76","1","1","hashemi","5.201.194.245","warning","plugin_deactivated","{\"plugin\":{\"name\":\"Click to Chat\",\"version\":\"4.33\",\"action\":\"deactivated\",\"network\":\"\"}}","a:10:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:212;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:18:\"plugin_deactivated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:55:\"/home/dadmanla/public_html/wp-admin/includes/plugin.php\";s:4:\"line\";i:840;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"/home/dadmanla/public_html/wp-admin/plugins.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"deactivate_plugins\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1766050126",""),
("77","1","1","hashemi","5.201.194.245","info","plugin_installed","{\"plugin\":{\"name\":\"Chaty\",\"version\":\"3.5.0\",\"action\":\"installed\",\"network\":\"\"}}","a:15:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:164;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:16:\"plugin_installed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:66:\"/home/dadmanla/public_html/wp-admin/includes/class-wp-upgrader.php\";s:4:\"line\";i:987;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:70:\"/home/dadmanla/public_html/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:137;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:11:\"WP_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:61:\"/home/dadmanla/public_html/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4497;s:8:\"function\";s:7:\"install\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:4:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:22:\"wp_ajax_install_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:4:{s:4:\"file\";s:50:\"/home/dadmanla/public_html/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1766050157",""),
("78","1","1","hashemi","5.201.194.245","info","translation_updated","{\"translation_updated\":{\"language\":\"fa_IR\",\"type\":\"plugin\",\"slug\":\"chaty\",\"version\":\"3.5.0\"}}","a:19:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:417;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:19:\"translation_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:77:\"/home/dadmanla/public_html/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:287;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:77:\"/home/dadmanla/public_html/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:104;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:343;s:8:\"function\";s:13:\"async_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:4:{s:4:\"file\";s:66:\"/home/dadmanla/public_html/wp-admin/includes/class-wp-upgrader.php\";s:4:\"line\";i:987;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:70:\"/home/dadmanla/public_html/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:137;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:11:\"WP_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:61:\"/home/dadmanla/public_html/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4497;s:8:\"function\";s:7:\"install\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:4:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:22:\"wp_ajax_install_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:4:{s:4:\"file\";s:50:\"/home/dadmanla/public_html/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1766050159",""),
("79","1","1","hashemi","5.201.194.245","info","plugin_activated","{\"plugin\":{\"name\":\"\\u0686\\u062a\\u06cc\",\"version\":\"3.5.0\",\"action\":\"activated\",\"network\":\"\"}}","a:10:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:177;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:16:\"plugin_activated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:55:\"/home/dadmanla/public_html/wp-admin/includes/plugin.php\";s:4:\"line\";i:730;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"/home/dadmanla/public_html/wp-admin/plugins.php\";s:4:\"line\";i:60;s:8:\"function\";s:15:\"activate_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1766050164",""),
("80","1","1","hashemi","5.201.194.245","warning","theme_deleted","{\"theme\":{\"name\":\"Astra\",\"version\":\"4.11.16\",\"action\":\"deleted\",\"network\":\"\"}}","a:14:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:393;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:356;s:8:\"function\";s:19:\"event_theme_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:13:\"theme_deleted\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:54:\"/home/dadmanla/public_html/wp-admin/includes/theme.php\";s:4:\"line\";i:98;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:61:\"/home/dadmanla/public_html/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4430;s:8:\"function\";s:12:\"delete_theme\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:20:\"wp_ajax_delete_theme\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:50:\"/home/dadmanla/public_html/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1766050841",""),
("81","1","1","hashemi","5.201.194.245","info","successful_login","{\"successful_login\":{\"username\":\"hashemi\"}}","a:22:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:622;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:667;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"/home/dadmanla/public_html/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:133:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";s:4:\"line\";i:1340;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:4:{s:4:\"file\";s:132:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-process-renamed-login-page.php\";s:4:\"line\";i:223;s:4:\"args\";a:1:{i:0;s:133:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";}s:8:\"function\";s:12:\"require_once\";}i:12;a:6:{s:4:\"file\";s:121:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-wp-loaded-tasks.php\";s:4:\"line\";i:21;s:8:\"function\";s:24:\"renamed_login_init_tasks\";s:5:\"class\";s:40:\"AIOWPSecurity_Process_Renamed_Login_Page\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:102:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/wp-security-core.php\";s:4:\"line\";i:497;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:29:\"AIOWPSecurity_WP_Loaded_Tasks\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:24:\"aiowps_wp_loaded_handler\";s:5:\"class\";s:15:\"AIO_WP_Security\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:4:{s:4:\"file\";s:42:\"/home/dadmanla/public_html/wp-settings.php\";s:4:\"line\";i:764;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:4:{s:4:\"file\";s:40:\"/home/dadmanla/public_html/wp-config.php\";s:4:\"line\";i:111;s:4:\"args\";a:1:{i:0;s:42:\"/home/dadmanla/public_html/wp-settings.php\";}s:8:\"function\";s:12:\"require_once\";}i:19;a:4:{s:4:\"file\";s:38:\"/home/dadmanla/public_html/wp-load.php\";s:4:\"line\";i:50;s:4:\"args\";a:1:{i:0;s:40:\"/home/dadmanla/public_html/wp-config.php\";}s:8:\"function\";s:12:\"require_once\";}i:20;a:4:{s:4:\"file\";s:45:\"/home/dadmanla/public_html/wp-blog-header.php\";s:4:\"line\";i:13;s:4:\"args\";a:1:{i:0;s:38:\"/home/dadmanla/public_html/wp-load.php\";}s:8:\"function\";s:12:\"require_once\";}i:21;a:4:{s:4:\"file\";s:36:\"/home/dadmanla/public_html/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:45:\"/home/dadmanla/public_html/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}","1766057269",""),
("82","1","1","a.hashemi","151.115.98.139","info","successful_login","{\"successful_login\":{\"username\":\"a.hashemi\"}}","a:22:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:622;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:667;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"/home/dadmanla/public_html/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:133:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";s:4:\"line\";i:1340;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:4:{s:4:\"file\";s:132:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-process-renamed-login-page.php\";s:4:\"line\";i:223;s:4:\"args\";a:1:{i:0;s:133:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";}s:8:\"function\";s:12:\"require_once\";}i:12;a:6:{s:4:\"file\";s:121:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-wp-loaded-tasks.php\";s:4:\"line\";i:21;s:8:\"function\";s:24:\"renamed_login_init_tasks\";s:5:\"class\";s:40:\"AIOWPSecurity_Process_Renamed_Login_Page\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:102:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/wp-security-core.php\";s:4:\"line\";i:497;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:29:\"AIOWPSecurity_WP_Loaded_Tasks\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:24:\"aiowps_wp_loaded_handler\";s:5:\"class\";s:15:\"AIO_WP_Security\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:4:{s:4:\"file\";s:42:\"/home/dadmanla/public_html/wp-settings.php\";s:4:\"line\";i:764;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:4:{s:4:\"file\";s:40:\"/home/dadmanla/public_html/wp-config.php\";s:4:\"line\";i:111;s:4:\"args\";a:1:{i:0;s:42:\"/home/dadmanla/public_html/wp-settings.php\";}s:8:\"function\";s:12:\"require_once\";}i:19;a:4:{s:4:\"file\";s:38:\"/home/dadmanla/public_html/wp-load.php\";s:4:\"line\";i:50;s:4:\"args\";a:1:{i:0;s:40:\"/home/dadmanla/public_html/wp-config.php\";}s:8:\"function\";s:12:\"require_once\";}i:20;a:4:{s:4:\"file\";s:45:\"/home/dadmanla/public_html/wp-blog-header.php\";s:4:\"line\";i:13;s:4:\"args\";a:1:{i:0;s:38:\"/home/dadmanla/public_html/wp-load.php\";}s:8:\"function\";s:12:\"require_once\";}i:21;a:4:{s:4:\"file\";s:36:\"/home/dadmanla/public_html/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:45:\"/home/dadmanla/public_html/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}","1766221295",""),
("83","1","1","a.hashemi","151.115.98.201","info","successful_login","{\"successful_login\":{\"username\":\"a.hashemi\"}}","a:22:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:622;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:667;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"/home/dadmanla/public_html/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:133:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";s:4:\"line\";i:1340;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:4:{s:4:\"file\";s:132:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-process-renamed-login-page.php\";s:4:\"line\";i:223;s:4:\"args\";a:1:{i:0;s:133:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";}s:8:\"function\";s:12:\"require_once\";}i:12;a:6:{s:4:\"file\";s:121:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-wp-loaded-tasks.php\";s:4:\"line\";i:21;s:8:\"function\";s:24:\"renamed_login_init_tasks\";s:5:\"class\";s:40:\"AIOWPSecurity_Process_Renamed_Login_Page\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:102:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/wp-security-core.php\";s:4:\"line\";i:497;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:29:\"AIOWPSecurity_WP_Loaded_Tasks\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:24:\"aiowps_wp_loaded_handler\";s:5:\"class\";s:15:\"AIO_WP_Security\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:4:{s:4:\"file\";s:42:\"/home/dadmanla/public_html/wp-settings.php\";s:4:\"line\";i:764;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:4:{s:4:\"file\";s:40:\"/home/dadmanla/public_html/wp-config.php\";s:4:\"line\";i:111;s:4:\"args\";a:1:{i:0;s:42:\"/home/dadmanla/public_html/wp-settings.php\";}s:8:\"function\";s:12:\"require_once\";}i:19;a:4:{s:4:\"file\";s:38:\"/home/dadmanla/public_html/wp-load.php\";s:4:\"line\";i:50;s:4:\"args\";a:1:{i:0;s:40:\"/home/dadmanla/public_html/wp-config.php\";}s:8:\"function\";s:12:\"require_once\";}i:20;a:4:{s:4:\"file\";s:45:\"/home/dadmanla/public_html/wp-blog-header.php\";s:4:\"line\";i:13;s:4:\"args\";a:1:{i:0;s:38:\"/home/dadmanla/public_html/wp-load.php\";}s:8:\"function\";s:12:\"require_once\";}i:21;a:4:{s:4:\"file\";s:36:\"/home/dadmanla/public_html/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:45:\"/home/dadmanla/public_html/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}","1766242964",""),
("84","1","1","a.hashemi","151.115.98.8","info","successful_login","{\"successful_login\":{\"username\":\"a.hashemi\"}}","a:22:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:622;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:667;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"/home/dadmanla/public_html/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:133:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";s:4:\"line\";i:1340;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:4:{s:4:\"file\";s:132:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-process-renamed-login-page.php\";s:4:\"line\";i:223;s:4:\"args\";a:1:{i:0;s:133:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";}s:8:\"function\";s:12:\"require_once\";}i:12;a:6:{s:4:\"file\";s:121:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-wp-loaded-tasks.php\";s:4:\"line\";i:21;s:8:\"function\";s:24:\"renamed_login_init_tasks\";s:5:\"class\";s:40:\"AIOWPSecurity_Process_Renamed_Login_Page\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:102:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/wp-security-core.php\";s:4:\"line\";i:497;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:29:\"AIOWPSecurity_WP_Loaded_Tasks\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:24:\"aiowps_wp_loaded_handler\";s:5:\"class\";s:15:\"AIO_WP_Security\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:4:{s:4:\"file\";s:42:\"/home/dadmanla/public_html/wp-settings.php\";s:4:\"line\";i:764;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:4:{s:4:\"file\";s:40:\"/home/dadmanla/public_html/wp-config.php\";s:4:\"line\";i:111;s:4:\"args\";a:1:{i:0;s:42:\"/home/dadmanla/public_html/wp-settings.php\";}s:8:\"function\";s:12:\"require_once\";}i:19;a:4:{s:4:\"file\";s:38:\"/home/dadmanla/public_html/wp-load.php\";s:4:\"line\";i:50;s:4:\"args\";a:1:{i:0;s:40:\"/home/dadmanla/public_html/wp-config.php\";}s:8:\"function\";s:12:\"require_once\";}i:20;a:4:{s:4:\"file\";s:45:\"/home/dadmanla/public_html/wp-blog-header.php\";s:4:\"line\";i:13;s:4:\"args\";a:1:{i:0;s:38:\"/home/dadmanla/public_html/wp-load.php\";}s:8:\"function\";s:12:\"require_once\";}i:21;a:4:{s:4:\"file\";s:36:\"/home/dadmanla/public_html/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:45:\"/home/dadmanla/public_html/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}","1766330132",""),
("85","1","1","a.hashemi","151.115.98.8","info","successful_login","{\"successful_login\":{\"username\":\"a.hashemi\"}}","a:22:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:622;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:667;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"/home/dadmanla/public_html/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:133:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";s:4:\"line\";i:1340;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:4:{s:4:\"file\";s:132:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-process-renamed-login-page.php\";s:4:\"line\";i:223;s:4:\"args\";a:1:{i:0;s:133:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";}s:8:\"function\";s:12:\"require_once\";}i:12;a:6:{s:4:\"file\";s:121:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-wp-loaded-tasks.php\";s:4:\"line\";i:21;s:8:\"function\";s:24:\"renamed_login_init_tasks\";s:5:\"class\";s:40:\"AIOWPSecurity_Process_Renamed_Login_Page\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:102:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/wp-security-core.php\";s:4:\"line\";i:497;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:29:\"AIOWPSecurity_WP_Loaded_Tasks\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:24:\"aiowps_wp_loaded_handler\";s:5:\"class\";s:15:\"AIO_WP_Security\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:4:{s:4:\"file\";s:42:\"/home/dadmanla/public_html/wp-settings.php\";s:4:\"line\";i:764;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:4:{s:4:\"file\";s:40:\"/home/dadmanla/public_html/wp-config.php\";s:4:\"line\";i:111;s:4:\"args\";a:1:{i:0;s:42:\"/home/dadmanla/public_html/wp-settings.php\";}s:8:\"function\";s:12:\"require_once\";}i:19;a:4:{s:4:\"file\";s:38:\"/home/dadmanla/public_html/wp-load.php\";s:4:\"line\";i:50;s:4:\"args\";a:1:{i:0;s:40:\"/home/dadmanla/public_html/wp-config.php\";}s:8:\"function\";s:12:\"require_once\";}i:20;a:4:{s:4:\"file\";s:45:\"/home/dadmanla/public_html/wp-blog-header.php\";s:4:\"line\";i:13;s:4:\"args\";a:1:{i:0;s:38:\"/home/dadmanla/public_html/wp-load.php\";}s:8:\"function\";s:12:\"require_once\";}i:21;a:4:{s:4:\"file\";s:36:\"/home/dadmanla/public_html/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:45:\"/home/dadmanla/public_html/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}","1766404387",""),
("86","1","1","a.hashemi","151.115.98.139","info","successful_login","{\"successful_login\":{\"username\":\"a.hashemi\"}}","a:22:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:622;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:667;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"/home/dadmanla/public_html/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:133:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";s:4:\"line\";i:1340;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:4:{s:4:\"file\";s:132:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-process-renamed-login-page.php\";s:4:\"line\";i:223;s:4:\"args\";a:1:{i:0;s:133:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";}s:8:\"function\";s:12:\"require_once\";}i:12;a:6:{s:4:\"file\";s:121:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-wp-loaded-tasks.php\";s:4:\"line\";i:21;s:8:\"function\";s:24:\"renamed_login_init_tasks\";s:5:\"class\";s:40:\"AIOWPSecurity_Process_Renamed_Login_Page\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:102:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/wp-security-core.php\";s:4:\"line\";i:497;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:29:\"AIOWPSecurity_WP_Loaded_Tasks\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:24:\"aiowps_wp_loaded_handler\";s:5:\"class\";s:15:\"AIO_WP_Security\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:4:{s:4:\"file\";s:42:\"/home/dadmanla/public_html/wp-settings.php\";s:4:\"line\";i:764;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:4:{s:4:\"file\";s:40:\"/home/dadmanla/public_html/wp-config.php\";s:4:\"line\";i:111;s:4:\"args\";a:1:{i:0;s:42:\"/home/dadmanla/public_html/wp-settings.php\";}s:8:\"function\";s:12:\"require_once\";}i:19;a:4:{s:4:\"file\";s:38:\"/home/dadmanla/public_html/wp-load.php\";s:4:\"line\";i:50;s:4:\"args\";a:1:{i:0;s:40:\"/home/dadmanla/public_html/wp-config.php\";}s:8:\"function\";s:12:\"require_once\";}i:20;a:4:{s:4:\"file\";s:45:\"/home/dadmanla/public_html/wp-blog-header.php\";s:4:\"line\";i:13;s:4:\"args\";a:1:{i:0;s:38:\"/home/dadmanla/public_html/wp-load.php\";}s:8:\"function\";s:12:\"require_once\";}i:21;a:4:{s:4:\"file\";s:36:\"/home/dadmanla/public_html/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:45:\"/home/dadmanla/public_html/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}","1766492967",""),
("87","1","1","a.hashemi","151.115.98.8","info","successful_login","{\"successful_login\":{\"username\":\"a.hashemi\"}}","a:22:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:622;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:667;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"/home/dadmanla/public_html/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:133:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";s:4:\"line\";i:1340;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:4:{s:4:\"file\";s:132:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-process-renamed-login-page.php\";s:4:\"line\";i:223;s:4:\"args\";a:1:{i:0;s:133:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";}s:8:\"function\";s:12:\"require_once\";}i:12;a:6:{s:4:\"file\";s:121:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-wp-loaded-tasks.php\";s:4:\"line\";i:21;s:8:\"function\";s:24:\"renamed_login_init_tasks\";s:5:\"class\";s:40:\"AIOWPSecurity_Process_Renamed_Login_Page\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:102:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/wp-security-core.php\";s:4:\"line\";i:497;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:29:\"AIOWPSecurity_WP_Loaded_Tasks\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:24:\"aiowps_wp_loaded_handler\";s:5:\"class\";s:15:\"AIO_WP_Security\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:4:{s:4:\"file\";s:42:\"/home/dadmanla/public_html/wp-settings.php\";s:4:\"line\";i:764;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:4:{s:4:\"file\";s:40:\"/home/dadmanla/public_html/wp-config.php\";s:4:\"line\";i:111;s:4:\"args\";a:1:{i:0;s:42:\"/home/dadmanla/public_html/wp-settings.php\";}s:8:\"function\";s:12:\"require_once\";}i:19;a:4:{s:4:\"file\";s:38:\"/home/dadmanla/public_html/wp-load.php\";s:4:\"line\";i:50;s:4:\"args\";a:1:{i:0;s:40:\"/home/dadmanla/public_html/wp-config.php\";}s:8:\"function\";s:12:\"require_once\";}i:20;a:4:{s:4:\"file\";s:45:\"/home/dadmanla/public_html/wp-blog-header.php\";s:4:\"line\";i:13;s:4:\"args\";a:1:{i:0;s:38:\"/home/dadmanla/public_html/wp-load.php\";}s:8:\"function\";s:12:\"require_once\";}i:21;a:4:{s:4:\"file\";s:36:\"/home/dadmanla/public_html/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:45:\"/home/dadmanla/public_html/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}","1766501820",""),
("88","1","1","hashemi","151.238.116.86","info","successful_login","{\"successful_login\":{\"username\":\"hashemi\"}}","a:22:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:622;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:667;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"/home/dadmanla/public_html/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:133:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";s:4:\"line\";i:1340;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:4:{s:4:\"file\";s:132:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-process-renamed-login-page.php\";s:4:\"line\";i:223;s:4:\"args\";a:1:{i:0;s:133:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";}s:8:\"function\";s:12:\"require_once\";}i:12;a:6:{s:4:\"file\";s:121:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-wp-loaded-tasks.php\";s:4:\"line\";i:21;s:8:\"function\";s:24:\"renamed_login_init_tasks\";s:5:\"class\";s:40:\"AIOWPSecurity_Process_Renamed_Login_Page\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:102:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/wp-security-core.php\";s:4:\"line\";i:497;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:29:\"AIOWPSecurity_WP_Loaded_Tasks\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:24:\"aiowps_wp_loaded_handler\";s:5:\"class\";s:15:\"AIO_WP_Security\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:4:{s:4:\"file\";s:42:\"/home/dadmanla/public_html/wp-settings.php\";s:4:\"line\";i:764;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:4:{s:4:\"file\";s:40:\"/home/dadmanla/public_html/wp-config.php\";s:4:\"line\";i:111;s:4:\"args\";a:1:{i:0;s:42:\"/home/dadmanla/public_html/wp-settings.php\";}s:8:\"function\";s:12:\"require_once\";}i:19;a:4:{s:4:\"file\";s:38:\"/home/dadmanla/public_html/wp-load.php\";s:4:\"line\";i:50;s:4:\"args\";a:1:{i:0;s:40:\"/home/dadmanla/public_html/wp-config.php\";}s:8:\"function\";s:12:\"require_once\";}i:20;a:4:{s:4:\"file\";s:45:\"/home/dadmanla/public_html/wp-blog-header.php\";s:4:\"line\";i:13;s:4:\"args\";a:1:{i:0;s:38:\"/home/dadmanla/public_html/wp-load.php\";}s:8:\"function\";s:12:\"require_once\";}i:21;a:4:{s:4:\"file\";s:36:\"/home/dadmanla/public_html/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:45:\"/home/dadmanla/public_html/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}","1766503821",""),
("89","1","1","author_w5upz2oe","5.217.153.72","info","successful_login","{\"successful_login\":{\"username\":\"author_w5upz2oe\"}}","a:22:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:622;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:667;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"/home/dadmanla/public_html/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:133:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";s:4:\"line\";i:1340;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:4:{s:4:\"file\";s:132:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-process-renamed-login-page.php\";s:4:\"line\";i:223;s:4:\"args\";a:1:{i:0;s:133:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";}s:8:\"function\";s:12:\"require_once\";}i:12;a:6:{s:4:\"file\";s:121:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-wp-loaded-tasks.php\";s:4:\"line\";i:21;s:8:\"function\";s:24:\"renamed_login_init_tasks\";s:5:\"class\";s:40:\"AIOWPSecurity_Process_Renamed_Login_Page\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:102:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/wp-security-core.php\";s:4:\"line\";i:497;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:29:\"AIOWPSecurity_WP_Loaded_Tasks\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:24:\"aiowps_wp_loaded_handler\";s:5:\"class\";s:15:\"AIO_WP_Security\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:4:{s:4:\"file\";s:42:\"/home/dadmanla/public_html/wp-settings.php\";s:4:\"line\";i:764;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:4:{s:4:\"file\";s:40:\"/home/dadmanla/public_html/wp-config.php\";s:4:\"line\";i:111;s:4:\"args\";a:1:{i:0;s:42:\"/home/dadmanla/public_html/wp-settings.php\";}s:8:\"function\";s:12:\"require_once\";}i:19;a:4:{s:4:\"file\";s:38:\"/home/dadmanla/public_html/wp-load.php\";s:4:\"line\";i:50;s:4:\"args\";a:1:{i:0;s:40:\"/home/dadmanla/public_html/wp-config.php\";}s:8:\"function\";s:12:\"require_once\";}i:20;a:4:{s:4:\"file\";s:45:\"/home/dadmanla/public_html/wp-blog-header.php\";s:4:\"line\";i:13;s:4:\"args\";a:1:{i:0;s:38:\"/home/dadmanla/public_html/wp-load.php\";}s:8:\"function\";s:12:\"require_once\";}i:21;a:4:{s:4:\"file\";s:36:\"/home/dadmanla/public_html/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:45:\"/home/dadmanla/public_html/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}","1766504362",""),
("90","1","1","a.hashemi","151.115.98.201","info","successful_login","{\"successful_login\":{\"username\":\"a.hashemi\"}}","a:22:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:622;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:667;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"/home/dadmanla/public_html/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:133:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";s:4:\"line\";i:1340;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:4:{s:4:\"file\";s:132:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-process-renamed-login-page.php\";s:4:\"line\";i:223;s:4:\"args\";a:1:{i:0;s:133:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";}s:8:\"function\";s:12:\"require_once\";}i:12;a:6:{s:4:\"file\";s:121:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-wp-loaded-tasks.php\";s:4:\"line\";i:21;s:8:\"function\";s:24:\"renamed_login_init_tasks\";s:5:\"class\";s:40:\"AIOWPSecurity_Process_Renamed_Login_Page\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:102:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/wp-security-core.php\";s:4:\"line\";i:497;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:29:\"AIOWPSecurity_WP_Loaded_Tasks\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:24:\"aiowps_wp_loaded_handler\";s:5:\"class\";s:15:\"AIO_WP_Security\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:4:{s:4:\"file\";s:42:\"/home/dadmanla/public_html/wp-settings.php\";s:4:\"line\";i:764;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:4:{s:4:\"file\";s:40:\"/home/dadmanla/public_html/wp-config.php\";s:4:\"line\";i:111;s:4:\"args\";a:1:{i:0;s:42:\"/home/dadmanla/public_html/wp-settings.php\";}s:8:\"function\";s:12:\"require_once\";}i:19;a:4:{s:4:\"file\";s:38:\"/home/dadmanla/public_html/wp-load.php\";s:4:\"line\";i:50;s:4:\"args\";a:1:{i:0;s:40:\"/home/dadmanla/public_html/wp-config.php\";}s:8:\"function\";s:12:\"require_once\";}i:20;a:4:{s:4:\"file\";s:45:\"/home/dadmanla/public_html/wp-blog-header.php\";s:4:\"line\";i:13;s:4:\"args\";a:1:{i:0;s:38:\"/home/dadmanla/public_html/wp-load.php\";}s:8:\"function\";s:12:\"require_once\";}i:21;a:4:{s:4:\"file\";s:36:\"/home/dadmanla/public_html/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:45:\"/home/dadmanla/public_html/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}","1766664270",""),
("91","1","1","a.hashemi","151.238.119.133","info","successful_login","{\"successful_login\":{\"username\":\"a.hashemi\"}}","a:22:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:622;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:667;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"/home/dadmanla/public_html/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:133:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";s:4:\"line\";i:1340;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:4:{s:4:\"file\";s:132:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-process-renamed-login-page.php\";s:4:\"line\";i:223;s:4:\"args\";a:1:{i:0;s:133:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";}s:8:\"function\";s:12:\"require_once\";}i:12;a:6:{s:4:\"file\";s:121:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-wp-loaded-tasks.php\";s:4:\"line\";i:21;s:8:\"function\";s:24:\"renamed_login_init_tasks\";s:5:\"class\";s:40:\"AIOWPSecurity_Process_Renamed_Login_Page\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:102:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/wp-security-core.php\";s:4:\"line\";i:497;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:29:\"AIOWPSecurity_WP_Loaded_Tasks\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:24:\"aiowps_wp_loaded_handler\";s:5:\"class\";s:15:\"AIO_WP_Security\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:4:{s:4:\"file\";s:42:\"/home/dadmanla/public_html/wp-settings.php\";s:4:\"line\";i:764;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:4:{s:4:\"file\";s:40:\"/home/dadmanla/public_html/wp-config.php\";s:4:\"line\";i:111;s:4:\"args\";a:1:{i:0;s:42:\"/home/dadmanla/public_html/wp-settings.php\";}s:8:\"function\";s:12:\"require_once\";}i:19;a:4:{s:4:\"file\";s:38:\"/home/dadmanla/public_html/wp-load.php\";s:4:\"line\";i:50;s:4:\"args\";a:1:{i:0;s:40:\"/home/dadmanla/public_html/wp-config.php\";}s:8:\"function\";s:12:\"require_once\";}i:20;a:4:{s:4:\"file\";s:45:\"/home/dadmanla/public_html/wp-blog-header.php\";s:4:\"line\";i:13;s:4:\"args\";a:1:{i:0;s:38:\"/home/dadmanla/public_html/wp-load.php\";}s:8:\"function\";s:12:\"require_once\";}i:21;a:4:{s:4:\"file\";s:36:\"/home/dadmanla/public_html/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:45:\"/home/dadmanla/public_html/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}","1766673368",""),
("92","1","1","rasaneh-design","151.238.119.133","info","successful_login","{\"successful_login\":{\"username\":\"rasaneh-design\"}}","a:22:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:622;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:667;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"/home/dadmanla/public_html/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:133:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";s:4:\"line\";i:1340;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:4:{s:4:\"file\";s:132:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-process-renamed-login-page.php\";s:4:\"line\";i:223;s:4:\"args\";a:1:{i:0;s:133:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";}s:8:\"function\";s:12:\"require_once\";}i:12;a:6:{s:4:\"file\";s:121:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-wp-loaded-tasks.php\";s:4:\"line\";i:21;s:8:\"function\";s:24:\"renamed_login_init_tasks\";s:5:\"class\";s:40:\"AIOWPSecurity_Process_Renamed_Login_Page\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:102:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/wp-security-core.php\";s:4:\"line\";i:497;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:29:\"AIOWPSecurity_WP_Loaded_Tasks\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:24:\"aiowps_wp_loaded_handler\";s:5:\"class\";s:15:\"AIO_WP_Security\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:4:{s:4:\"file\";s:42:\"/home/dadmanla/public_html/wp-settings.php\";s:4:\"line\";i:764;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:4:{s:4:\"file\";s:40:\"/home/dadmanla/public_html/wp-config.php\";s:4:\"line\";i:111;s:4:\"args\";a:1:{i:0;s:42:\"/home/dadmanla/public_html/wp-settings.php\";}s:8:\"function\";s:12:\"require_once\";}i:19;a:4:{s:4:\"file\";s:38:\"/home/dadmanla/public_html/wp-load.php\";s:4:\"line\";i:50;s:4:\"args\";a:1:{i:0;s:40:\"/home/dadmanla/public_html/wp-config.php\";}s:8:\"function\";s:12:\"require_once\";}i:20;a:4:{s:4:\"file\";s:45:\"/home/dadmanla/public_html/wp-blog-header.php\";s:4:\"line\";i:13;s:4:\"args\";a:1:{i:0;s:38:\"/home/dadmanla/public_html/wp-load.php\";}s:8:\"function\";s:12:\"require_once\";}i:21;a:4:{s:4:\"file\";s:36:\"/home/dadmanla/public_html/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:45:\"/home/dadmanla/public_html/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}","1766675670",""),
("93","1","1","a.hashemi","151.115.98.201","info","successful_login","{\"successful_login\":{\"username\":\"a.hashemi\"}}","a:22:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:622;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:667;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"/home/dadmanla/public_html/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:133:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";s:4:\"line\";i:1340;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:4:{s:4:\"file\";s:132:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-process-renamed-login-page.php\";s:4:\"line\";i:223;s:4:\"args\";a:1:{i:0;s:133:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";}s:8:\"function\";s:12:\"require_once\";}i:12;a:6:{s:4:\"file\";s:121:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-wp-loaded-tasks.php\";s:4:\"line\";i:21;s:8:\"function\";s:24:\"renamed_login_init_tasks\";s:5:\"class\";s:40:\"AIOWPSecurity_Process_Renamed_Login_Page\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:102:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/wp-security-core.php\";s:4:\"line\";i:497;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:29:\"AIOWPSecurity_WP_Loaded_Tasks\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:24:\"aiowps_wp_loaded_handler\";s:5:\"class\";s:15:\"AIO_WP_Security\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:4:{s:4:\"file\";s:42:\"/home/dadmanla/public_html/wp-settings.php\";s:4:\"line\";i:764;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:4:{s:4:\"file\";s:40:\"/home/dadmanla/public_html/wp-config.php\";s:4:\"line\";i:111;s:4:\"args\";a:1:{i:0;s:42:\"/home/dadmanla/public_html/wp-settings.php\";}s:8:\"function\";s:12:\"require_once\";}i:19;a:4:{s:4:\"file\";s:38:\"/home/dadmanla/public_html/wp-load.php\";s:4:\"line\";i:50;s:4:\"args\";a:1:{i:0;s:40:\"/home/dadmanla/public_html/wp-config.php\";}s:8:\"function\";s:12:\"require_once\";}i:20;a:4:{s:4:\"file\";s:45:\"/home/dadmanla/public_html/wp-blog-header.php\";s:4:\"line\";i:13;s:4:\"args\";a:1:{i:0;s:38:\"/home/dadmanla/public_html/wp-load.php\";}s:8:\"function\";s:12:\"require_once\";}i:21;a:4:{s:4:\"file\";s:36:\"/home/dadmanla/public_html/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:45:\"/home/dadmanla/public_html/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}","1766838568",""),
("94","1","1","a.hashemi","151.115.98.139","info","successful_login","{\"successful_login\":{\"username\":\"a.hashemi\"}}","a:22:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:622;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:667;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"/home/dadmanla/public_html/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:133:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";s:4:\"line\";i:1340;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:4:{s:4:\"file\";s:132:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-process-renamed-login-page.php\";s:4:\"line\";i:223;s:4:\"args\";a:1:{i:0;s:133:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";}s:8:\"function\";s:12:\"require_once\";}i:12;a:6:{s:4:\"file\";s:121:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-wp-loaded-tasks.php\";s:4:\"line\";i:21;s:8:\"function\";s:24:\"renamed_login_init_tasks\";s:5:\"class\";s:40:\"AIOWPSecurity_Process_Renamed_Login_Page\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:102:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/wp-security-core.php\";s:4:\"line\";i:497;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:29:\"AIOWPSecurity_WP_Loaded_Tasks\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:24:\"aiowps_wp_loaded_handler\";s:5:\"class\";s:15:\"AIO_WP_Security\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:4:{s:4:\"file\";s:42:\"/home/dadmanla/public_html/wp-settings.php\";s:4:\"line\";i:764;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:4:{s:4:\"file\";s:40:\"/home/dadmanla/public_html/wp-config.php\";s:4:\"line\";i:111;s:4:\"args\";a:1:{i:0;s:42:\"/home/dadmanla/public_html/wp-settings.php\";}s:8:\"function\";s:12:\"require_once\";}i:19;a:4:{s:4:\"file\";s:38:\"/home/dadmanla/public_html/wp-load.php\";s:4:\"line\";i:50;s:4:\"args\";a:1:{i:0;s:40:\"/home/dadmanla/public_html/wp-config.php\";}s:8:\"function\";s:12:\"require_once\";}i:20;a:4:{s:4:\"file\";s:45:\"/home/dadmanla/public_html/wp-blog-header.php\";s:4:\"line\";i:13;s:4:\"args\";a:1:{i:0;s:38:\"/home/dadmanla/public_html/wp-load.php\";}s:8:\"function\";s:12:\"require_once\";}i:21;a:4:{s:4:\"file\";s:36:\"/home/dadmanla/public_html/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:45:\"/home/dadmanla/public_html/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}","1766840708",""),
("95","1","1","a.hashemi","151.238.116.92","info","successful_login","{\"successful_login\":{\"username\":\"a.hashemi\"}}","a:22:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:622;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:667;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"/home/dadmanla/public_html/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:133:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";s:4:\"line\";i:1340;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:4:{s:4:\"file\";s:132:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-process-renamed-login-page.php\";s:4:\"line\";i:223;s:4:\"args\";a:1:{i:0;s:133:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";}s:8:\"function\";s:12:\"require_once\";}i:12;a:6:{s:4:\"file\";s:121:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-wp-loaded-tasks.php\";s:4:\"line\";i:21;s:8:\"function\";s:24:\"renamed_login_init_tasks\";s:5:\"class\";s:40:\"AIOWPSecurity_Process_Renamed_Login_Page\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:102:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/wp-security-core.php\";s:4:\"line\";i:497;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:29:\"AIOWPSecurity_WP_Loaded_Tasks\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:24:\"aiowps_wp_loaded_handler\";s:5:\"class\";s:15:\"AIO_WP_Security\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:4:{s:4:\"file\";s:42:\"/home/dadmanla/public_html/wp-settings.php\";s:4:\"line\";i:764;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:4:{s:4:\"file\";s:40:\"/home/dadmanla/public_html/wp-config.php\";s:4:\"line\";i:111;s:4:\"args\";a:1:{i:0;s:42:\"/home/dadmanla/public_html/wp-settings.php\";}s:8:\"function\";s:12:\"require_once\";}i:19;a:4:{s:4:\"file\";s:38:\"/home/dadmanla/public_html/wp-load.php\";s:4:\"line\";i:50;s:4:\"args\";a:1:{i:0;s:40:\"/home/dadmanla/public_html/wp-config.php\";}s:8:\"function\";s:12:\"require_once\";}i:20;a:4:{s:4:\"file\";s:45:\"/home/dadmanla/public_html/wp-blog-header.php\";s:4:\"line\";i:13;s:4:\"args\";a:1:{i:0;s:38:\"/home/dadmanla/public_html/wp-load.php\";}s:8:\"function\";s:12:\"require_once\";}i:21;a:4:{s:4:\"file\";s:36:\"/home/dadmanla/public_html/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:45:\"/home/dadmanla/public_html/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}","1767017859","");

INSERT IGNORE INTO `YTcMX_aiowps_audit_log` VALUES 
("96","1","1","a.hashemi","5.217.10.150","info","successful_login","{\"successful_login\":{\"username\":\"a.hashemi\"}}","a:22:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:622;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:667;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"/home/dadmanla/public_html/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:133:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";s:4:\"line\";i:1340;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:4:{s:4:\"file\";s:132:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-process-renamed-login-page.php\";s:4:\"line\";i:223;s:4:\"args\";a:1:{i:0;s:133:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";}s:8:\"function\";s:12:\"require_once\";}i:12;a:6:{s:4:\"file\";s:121:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-wp-loaded-tasks.php\";s:4:\"line\";i:21;s:8:\"function\";s:24:\"renamed_login_init_tasks\";s:5:\"class\";s:40:\"AIOWPSecurity_Process_Renamed_Login_Page\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:102:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/wp-security-core.php\";s:4:\"line\";i:497;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:29:\"AIOWPSecurity_WP_Loaded_Tasks\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:24:\"aiowps_wp_loaded_handler\";s:5:\"class\";s:15:\"AIO_WP_Security\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:4:{s:4:\"file\";s:42:\"/home/dadmanla/public_html/wp-settings.php\";s:4:\"line\";i:764;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:4:{s:4:\"file\";s:40:\"/home/dadmanla/public_html/wp-config.php\";s:4:\"line\";i:111;s:4:\"args\";a:1:{i:0;s:42:\"/home/dadmanla/public_html/wp-settings.php\";}s:8:\"function\";s:12:\"require_once\";}i:19;a:4:{s:4:\"file\";s:38:\"/home/dadmanla/public_html/wp-load.php\";s:4:\"line\";i:50;s:4:\"args\";a:1:{i:0;s:40:\"/home/dadmanla/public_html/wp-config.php\";}s:8:\"function\";s:12:\"require_once\";}i:20;a:4:{s:4:\"file\";s:45:\"/home/dadmanla/public_html/wp-blog-header.php\";s:4:\"line\";i:13;s:4:\"args\";a:1:{i:0;s:38:\"/home/dadmanla/public_html/wp-load.php\";}s:8:\"function\";s:12:\"require_once\";}i:21;a:4:{s:4:\"file\";s:36:\"/home/dadmanla/public_html/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:45:\"/home/dadmanla/public_html/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}","1767081319",""),
("97","1","1","a.hashemi","151.115.98.201","info","successful_login","{\"successful_login\":{\"username\":\"a.hashemi\"}}","a:22:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:622;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:667;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"/home/dadmanla/public_html/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:133:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";s:4:\"line\";i:1340;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:4:{s:4:\"file\";s:132:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-process-renamed-login-page.php\";s:4:\"line\";i:223;s:4:\"args\";a:1:{i:0;s:133:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";}s:8:\"function\";s:12:\"require_once\";}i:12;a:6:{s:4:\"file\";s:121:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-wp-loaded-tasks.php\";s:4:\"line\";i:21;s:8:\"function\";s:24:\"renamed_login_init_tasks\";s:5:\"class\";s:40:\"AIOWPSecurity_Process_Renamed_Login_Page\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:102:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/wp-security-core.php\";s:4:\"line\";i:497;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:29:\"AIOWPSecurity_WP_Loaded_Tasks\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:24:\"aiowps_wp_loaded_handler\";s:5:\"class\";s:15:\"AIO_WP_Security\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:4:{s:4:\"file\";s:42:\"/home/dadmanla/public_html/wp-settings.php\";s:4:\"line\";i:764;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:4:{s:4:\"file\";s:40:\"/home/dadmanla/public_html/wp-config.php\";s:4:\"line\";i:111;s:4:\"args\";a:1:{i:0;s:42:\"/home/dadmanla/public_html/wp-settings.php\";}s:8:\"function\";s:12:\"require_once\";}i:19;a:4:{s:4:\"file\";s:38:\"/home/dadmanla/public_html/wp-load.php\";s:4:\"line\";i:50;s:4:\"args\";a:1:{i:0;s:40:\"/home/dadmanla/public_html/wp-config.php\";}s:8:\"function\";s:12:\"require_once\";}i:20;a:4:{s:4:\"file\";s:45:\"/home/dadmanla/public_html/wp-blog-header.php\";s:4:\"line\";i:13;s:4:\"args\";a:1:{i:0;s:38:\"/home/dadmanla/public_html/wp-load.php\";}s:8:\"function\";s:12:\"require_once\";}i:21;a:4:{s:4:\"file\";s:36:\"/home/dadmanla/public_html/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:45:\"/home/dadmanla/public_html/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}","1767105703",""),
("98","1","1","rasaneh-design","185.115.78.178","warning","failed_login","{\"failed_login\":{\"imported\":false,\"username\":\"rasaneh-design\",\"known\":true}}","a:21:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:569;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"event_failed_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:17:\"post_authenticate\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:0:{}}i:6;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:205;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:52:\"/home/dadmanla/public_html/wp-includes/pluggable.php\";s:4:\"line\";i:702;s:8:\"function\";s:13:\"apply_filters\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:47:\"/home/dadmanla/public_html/wp-includes/user.php\";s:4:\"line\";i:109;s:8:\"function\";s:15:\"wp_authenticate\";s:4:\"args\";a:0:{}}i:9;a:4:{s:4:\"file\";s:133:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";s:4:\"line\";i:1340;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:132:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-process-renamed-login-page.php\";s:4:\"line\";i:223;s:4:\"args\";a:1:{i:0;s:133:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";}s:8:\"function\";s:12:\"require_once\";}i:11;a:6:{s:4:\"file\";s:121:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-wp-loaded-tasks.php\";s:4:\"line\";i:21;s:8:\"function\";s:24:\"renamed_login_init_tasks\";s:5:\"class\";s:40:\"AIOWPSecurity_Process_Renamed_Login_Page\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:102:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/wp-security-core.php\";s:4:\"line\";i:497;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:29:\"AIOWPSecurity_WP_Loaded_Tasks\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:24:\"aiowps_wp_loaded_handler\";s:5:\"class\";s:15:\"AIO_WP_Security\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:4:{s:4:\"file\";s:42:\"/home/dadmanla/public_html/wp-settings.php\";s:4:\"line\";i:764;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:4:{s:4:\"file\";s:40:\"/home/dadmanla/public_html/wp-config.php\";s:4:\"line\";i:111;s:4:\"args\";a:1:{i:0;s:42:\"/home/dadmanla/public_html/wp-settings.php\";}s:8:\"function\";s:12:\"require_once\";}i:18;a:4:{s:4:\"file\";s:38:\"/home/dadmanla/public_html/wp-load.php\";s:4:\"line\";i:50;s:4:\"args\";a:1:{i:0;s:40:\"/home/dadmanla/public_html/wp-config.php\";}s:8:\"function\";s:12:\"require_once\";}i:19;a:4:{s:4:\"file\";s:45:\"/home/dadmanla/public_html/wp-blog-header.php\";s:4:\"line\";i:13;s:4:\"args\";a:1:{i:0;s:38:\"/home/dadmanla/public_html/wp-load.php\";}s:8:\"function\";s:12:\"require_once\";}i:20;a:4:{s:4:\"file\";s:36:\"/home/dadmanla/public_html/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:45:\"/home/dadmanla/public_html/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}","1767175558",""),
("99","1","1","rasaneh-design","185.115.78.178","info","successful_login","{\"successful_login\":{\"username\":\"rasaneh-design\"}}","a:22:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:622;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:667;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"/home/dadmanla/public_html/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:133:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";s:4:\"line\";i:1340;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:4:{s:4:\"file\";s:132:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-process-renamed-login-page.php\";s:4:\"line\";i:223;s:4:\"args\";a:1:{i:0;s:133:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";}s:8:\"function\";s:12:\"require_once\";}i:12;a:6:{s:4:\"file\";s:121:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-wp-loaded-tasks.php\";s:4:\"line\";i:21;s:8:\"function\";s:24:\"renamed_login_init_tasks\";s:5:\"class\";s:40:\"AIOWPSecurity_Process_Renamed_Login_Page\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:102:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/wp-security-core.php\";s:4:\"line\";i:497;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:29:\"AIOWPSecurity_WP_Loaded_Tasks\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:24:\"aiowps_wp_loaded_handler\";s:5:\"class\";s:15:\"AIO_WP_Security\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:4:{s:4:\"file\";s:42:\"/home/dadmanla/public_html/wp-settings.php\";s:4:\"line\";i:764;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:4:{s:4:\"file\";s:40:\"/home/dadmanla/public_html/wp-config.php\";s:4:\"line\";i:111;s:4:\"args\";a:1:{i:0;s:42:\"/home/dadmanla/public_html/wp-settings.php\";}s:8:\"function\";s:12:\"require_once\";}i:19;a:4:{s:4:\"file\";s:38:\"/home/dadmanla/public_html/wp-load.php\";s:4:\"line\";i:50;s:4:\"args\";a:1:{i:0;s:40:\"/home/dadmanla/public_html/wp-config.php\";}s:8:\"function\";s:12:\"require_once\";}i:20;a:4:{s:4:\"file\";s:45:\"/home/dadmanla/public_html/wp-blog-header.php\";s:4:\"line\";i:13;s:4:\"args\";a:1:{i:0;s:38:\"/home/dadmanla/public_html/wp-load.php\";}s:8:\"function\";s:12:\"require_once\";}i:21;a:4:{s:4:\"file\";s:36:\"/home/dadmanla/public_html/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:45:\"/home/dadmanla/public_html/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}","1767175612",""),
("100","1","1","rasaneh-design","185.115.78.178","warning","plugin_deactivated","{\"plugin\":{\"name\":\"Rank Math SEO\",\"version\":\"1.0.259.1\",\"action\":\"deactivated\",\"network\":\"\"}}","a:10:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:212;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:18:\"plugin_deactivated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:55:\"/home/dadmanla/public_html/wp-admin/includes/plugin.php\";s:4:\"line\";i:840;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"/home/dadmanla/public_html/wp-admin/plugins.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"deactivate_plugins\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1767175675",""),
("101","1","1","rasaneh-design","185.115.78.178","info","plugin_activated","{\"plugin\":{\"name\":\"Rank Math SEO\",\"version\":\"1.0.259.1\",\"action\":\"activated\",\"network\":\"\"}}","a:10:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:177;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:16:\"plugin_activated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:55:\"/home/dadmanla/public_html/wp-admin/includes/plugin.php\";s:4:\"line\";i:730;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"/home/dadmanla/public_html/wp-admin/plugins.php\";s:4:\"line\";i:60;s:8:\"function\";s:15:\"activate_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1767175780",""),
("102","1","1","a.hashemi","89.111.27.36","info","successful_login","{\"successful_login\":{\"username\":\"a.hashemi\"}}","a:22:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:622;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:667;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"/home/dadmanla/public_html/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:133:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";s:4:\"line\";i:1340;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:4:{s:4:\"file\";s:132:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-process-renamed-login-page.php\";s:4:\"line\";i:223;s:4:\"args\";a:1:{i:0;s:133:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";}s:8:\"function\";s:12:\"require_once\";}i:12;a:6:{s:4:\"file\";s:121:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-wp-loaded-tasks.php\";s:4:\"line\";i:21;s:8:\"function\";s:24:\"renamed_login_init_tasks\";s:5:\"class\";s:40:\"AIOWPSecurity_Process_Renamed_Login_Page\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:102:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/wp-security-core.php\";s:4:\"line\";i:497;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:29:\"AIOWPSecurity_WP_Loaded_Tasks\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:24:\"aiowps_wp_loaded_handler\";s:5:\"class\";s:15:\"AIO_WP_Security\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:4:{s:4:\"file\";s:42:\"/home/dadmanla/public_html/wp-settings.php\";s:4:\"line\";i:764;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:4:{s:4:\"file\";s:40:\"/home/dadmanla/public_html/wp-config.php\";s:4:\"line\";i:111;s:4:\"args\";a:1:{i:0;s:42:\"/home/dadmanla/public_html/wp-settings.php\";}s:8:\"function\";s:12:\"require_once\";}i:19;a:4:{s:4:\"file\";s:38:\"/home/dadmanla/public_html/wp-load.php\";s:4:\"line\";i:50;s:4:\"args\";a:1:{i:0;s:40:\"/home/dadmanla/public_html/wp-config.php\";}s:8:\"function\";s:12:\"require_once\";}i:20;a:4:{s:4:\"file\";s:45:\"/home/dadmanla/public_html/wp-blog-header.php\";s:4:\"line\";i:13;s:4:\"args\";a:1:{i:0;s:38:\"/home/dadmanla/public_html/wp-load.php\";}s:8:\"function\";s:12:\"require_once\";}i:21;a:4:{s:4:\"file\";s:36:\"/home/dadmanla/public_html/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:45:\"/home/dadmanla/public_html/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}","1767278034",""),
("103","1","1","a.hashemi","151.238.118.152","info","successful_login","{\"successful_login\":{\"username\":\"a.hashemi\"}}","a:22:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:622;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:667;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"/home/dadmanla/public_html/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:133:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";s:4:\"line\";i:1340;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:4:{s:4:\"file\";s:132:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-process-renamed-login-page.php\";s:4:\"line\";i:223;s:4:\"args\";a:1:{i:0;s:133:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";}s:8:\"function\";s:12:\"require_once\";}i:12;a:6:{s:4:\"file\";s:121:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-wp-loaded-tasks.php\";s:4:\"line\";i:21;s:8:\"function\";s:24:\"renamed_login_init_tasks\";s:5:\"class\";s:40:\"AIOWPSecurity_Process_Renamed_Login_Page\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:102:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/wp-security-core.php\";s:4:\"line\";i:497;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:29:\"AIOWPSecurity_WP_Loaded_Tasks\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:24:\"aiowps_wp_loaded_handler\";s:5:\"class\";s:15:\"AIO_WP_Security\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:4:{s:4:\"file\";s:42:\"/home/dadmanla/public_html/wp-settings.php\";s:4:\"line\";i:764;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:4:{s:4:\"file\";s:40:\"/home/dadmanla/public_html/wp-config.php\";s:4:\"line\";i:111;s:4:\"args\";a:1:{i:0;s:42:\"/home/dadmanla/public_html/wp-settings.php\";}s:8:\"function\";s:12:\"require_once\";}i:19;a:4:{s:4:\"file\";s:38:\"/home/dadmanla/public_html/wp-load.php\";s:4:\"line\";i:50;s:4:\"args\";a:1:{i:0;s:40:\"/home/dadmanla/public_html/wp-config.php\";}s:8:\"function\";s:12:\"require_once\";}i:20;a:4:{s:4:\"file\";s:45:\"/home/dadmanla/public_html/wp-blog-header.php\";s:4:\"line\";i:13;s:4:\"args\";a:1:{i:0;s:38:\"/home/dadmanla/public_html/wp-load.php\";}s:8:\"function\";s:12:\"require_once\";}i:21;a:4:{s:4:\"file\";s:36:\"/home/dadmanla/public_html/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:45:\"/home/dadmanla/public_html/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}","1767456813",""),
("104","1","1","hashemi","151.238.118.152","info","successful_login","{\"successful_login\":{\"username\":\"hashemi\"}}","a:22:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:622;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:667;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"/home/dadmanla/public_html/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:133:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";s:4:\"line\";i:1340;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:4:{s:4:\"file\";s:132:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-process-renamed-login-page.php\";s:4:\"line\";i:223;s:4:\"args\";a:1:{i:0;s:133:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";}s:8:\"function\";s:12:\"require_once\";}i:12;a:6:{s:4:\"file\";s:121:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-wp-loaded-tasks.php\";s:4:\"line\";i:21;s:8:\"function\";s:24:\"renamed_login_init_tasks\";s:5:\"class\";s:40:\"AIOWPSecurity_Process_Renamed_Login_Page\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:102:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/wp-security-core.php\";s:4:\"line\";i:497;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:29:\"AIOWPSecurity_WP_Loaded_Tasks\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:24:\"aiowps_wp_loaded_handler\";s:5:\"class\";s:15:\"AIO_WP_Security\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:4:{s:4:\"file\";s:42:\"/home/dadmanla/public_html/wp-settings.php\";s:4:\"line\";i:764;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:4:{s:4:\"file\";s:40:\"/home/dadmanla/public_html/wp-config.php\";s:4:\"line\";i:111;s:4:\"args\";a:1:{i:0;s:42:\"/home/dadmanla/public_html/wp-settings.php\";}s:8:\"function\";s:12:\"require_once\";}i:19;a:4:{s:4:\"file\";s:38:\"/home/dadmanla/public_html/wp-load.php\";s:4:\"line\";i:50;s:4:\"args\";a:1:{i:0;s:40:\"/home/dadmanla/public_html/wp-config.php\";}s:8:\"function\";s:12:\"require_once\";}i:20;a:4:{s:4:\"file\";s:45:\"/home/dadmanla/public_html/wp-blog-header.php\";s:4:\"line\";i:13;s:4:\"args\";a:1:{i:0;s:38:\"/home/dadmanla/public_html/wp-load.php\";}s:8:\"function\";s:12:\"require_once\";}i:21;a:4:{s:4:\"file\";s:36:\"/home/dadmanla/public_html/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:45:\"/home/dadmanla/public_html/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}","1767456891",""),
("105","1","1","a.hashemi","194.34.105.170","info","successful_login","{\"successful_login\":{\"username\":\"a.hashemi\"}}","a:22:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:622;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:667;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"/home/dadmanla/public_html/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:133:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";s:4:\"line\";i:1340;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:4:{s:4:\"file\";s:132:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-process-renamed-login-page.php\";s:4:\"line\";i:223;s:4:\"args\";a:1:{i:0;s:133:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";}s:8:\"function\";s:12:\"require_once\";}i:12;a:6:{s:4:\"file\";s:121:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-wp-loaded-tasks.php\";s:4:\"line\";i:21;s:8:\"function\";s:24:\"renamed_login_init_tasks\";s:5:\"class\";s:40:\"AIOWPSecurity_Process_Renamed_Login_Page\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:102:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/wp-security-core.php\";s:4:\"line\";i:497;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:29:\"AIOWPSecurity_WP_Loaded_Tasks\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:24:\"aiowps_wp_loaded_handler\";s:5:\"class\";s:15:\"AIO_WP_Security\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:4:{s:4:\"file\";s:42:\"/home/dadmanla/public_html/wp-settings.php\";s:4:\"line\";i:764;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:4:{s:4:\"file\";s:40:\"/home/dadmanla/public_html/wp-config.php\";s:4:\"line\";i:111;s:4:\"args\";a:1:{i:0;s:42:\"/home/dadmanla/public_html/wp-settings.php\";}s:8:\"function\";s:12:\"require_once\";}i:19;a:4:{s:4:\"file\";s:38:\"/home/dadmanla/public_html/wp-load.php\";s:4:\"line\";i:50;s:4:\"args\";a:1:{i:0;s:40:\"/home/dadmanla/public_html/wp-config.php\";}s:8:\"function\";s:12:\"require_once\";}i:20;a:4:{s:4:\"file\";s:45:\"/home/dadmanla/public_html/wp-blog-header.php\";s:4:\"line\";i:13;s:4:\"args\";a:1:{i:0;s:38:\"/home/dadmanla/public_html/wp-load.php\";}s:8:\"function\";s:12:\"require_once\";}i:21;a:4:{s:4:\"file\";s:36:\"/home/dadmanla/public_html/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:45:\"/home/dadmanla/public_html/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}","1767534095",""),
("106","1","1","hashemi","207.244.71.79","info","successful_login","{\"successful_login\":{\"username\":\"hashemi\"}}","a:22:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:622;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:667;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"/home/dadmanla/public_html/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:133:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";s:4:\"line\";i:1340;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:4:{s:4:\"file\";s:132:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-process-renamed-login-page.php\";s:4:\"line\";i:223;s:4:\"args\";a:1:{i:0;s:133:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";}s:8:\"function\";s:12:\"require_once\";}i:12;a:6:{s:4:\"file\";s:121:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-wp-loaded-tasks.php\";s:4:\"line\";i:21;s:8:\"function\";s:24:\"renamed_login_init_tasks\";s:5:\"class\";s:40:\"AIOWPSecurity_Process_Renamed_Login_Page\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:102:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/wp-security-core.php\";s:4:\"line\";i:497;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:29:\"AIOWPSecurity_WP_Loaded_Tasks\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:24:\"aiowps_wp_loaded_handler\";s:5:\"class\";s:15:\"AIO_WP_Security\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:4:{s:4:\"file\";s:42:\"/home/dadmanla/public_html/wp-settings.php\";s:4:\"line\";i:764;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:4:{s:4:\"file\";s:40:\"/home/dadmanla/public_html/wp-config.php\";s:4:\"line\";i:111;s:4:\"args\";a:1:{i:0;s:42:\"/home/dadmanla/public_html/wp-settings.php\";}s:8:\"function\";s:12:\"require_once\";}i:19;a:4:{s:4:\"file\";s:38:\"/home/dadmanla/public_html/wp-load.php\";s:4:\"line\";i:50;s:4:\"args\";a:1:{i:0;s:40:\"/home/dadmanla/public_html/wp-config.php\";}s:8:\"function\";s:12:\"require_once\";}i:20;a:4:{s:4:\"file\";s:45:\"/home/dadmanla/public_html/wp-blog-header.php\";s:4:\"line\";i:13;s:4:\"args\";a:1:{i:0;s:38:\"/home/dadmanla/public_html/wp-load.php\";}s:8:\"function\";s:12:\"require_once\";}i:21;a:4:{s:4:\"file\";s:36:\"/home/dadmanla/public_html/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:45:\"/home/dadmanla/public_html/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}","1767709849",""),
("107","1","1","a.hashemi","216.247.106.74","info","successful_login","{\"successful_login\":{\"username\":\"a.hashemi\"}}","a:22:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:622;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:667;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"/home/dadmanla/public_html/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:133:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";s:4:\"line\";i:1340;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:4:{s:4:\"file\";s:132:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-process-renamed-login-page.php\";s:4:\"line\";i:223;s:4:\"args\";a:1:{i:0;s:133:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";}s:8:\"function\";s:12:\"require_once\";}i:12;a:6:{s:4:\"file\";s:121:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-wp-loaded-tasks.php\";s:4:\"line\";i:21;s:8:\"function\";s:24:\"renamed_login_init_tasks\";s:5:\"class\";s:40:\"AIOWPSecurity_Process_Renamed_Login_Page\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:102:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/wp-security-core.php\";s:4:\"line\";i:497;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:29:\"AIOWPSecurity_WP_Loaded_Tasks\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:24:\"aiowps_wp_loaded_handler\";s:5:\"class\";s:15:\"AIO_WP_Security\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:4:{s:4:\"file\";s:42:\"/home/dadmanla/public_html/wp-settings.php\";s:4:\"line\";i:764;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:4:{s:4:\"file\";s:40:\"/home/dadmanla/public_html/wp-config.php\";s:4:\"line\";i:111;s:4:\"args\";a:1:{i:0;s:42:\"/home/dadmanla/public_html/wp-settings.php\";}s:8:\"function\";s:12:\"require_once\";}i:19;a:4:{s:4:\"file\";s:38:\"/home/dadmanla/public_html/wp-load.php\";s:4:\"line\";i:50;s:4:\"args\";a:1:{i:0;s:40:\"/home/dadmanla/public_html/wp-config.php\";}s:8:\"function\";s:12:\"require_once\";}i:20;a:4:{s:4:\"file\";s:45:\"/home/dadmanla/public_html/wp-blog-header.php\";s:4:\"line\";i:13;s:4:\"args\";a:1:{i:0;s:38:\"/home/dadmanla/public_html/wp-load.php\";}s:8:\"function\";s:12:\"require_once\";}i:21;a:4:{s:4:\"file\";s:36:\"/home/dadmanla/public_html/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:45:\"/home/dadmanla/public_html/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}","1767862097",""),
("108","1","1","author_w5upz2oe","5.217.205.37","info","successful_login","{\"successful_login\":{\"username\":\"author_w5upz2oe\"}}","a:22:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:622;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:667;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"/home/dadmanla/public_html/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:133:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";s:4:\"line\";i:1340;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:4:{s:4:\"file\";s:132:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-process-renamed-login-page.php\";s:4:\"line\";i:223;s:4:\"args\";a:1:{i:0;s:133:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";}s:8:\"function\";s:12:\"require_once\";}i:12;a:6:{s:4:\"file\";s:121:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-wp-loaded-tasks.php\";s:4:\"line\";i:21;s:8:\"function\";s:24:\"renamed_login_init_tasks\";s:5:\"class\";s:40:\"AIOWPSecurity_Process_Renamed_Login_Page\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:102:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/wp-security-core.php\";s:4:\"line\";i:497;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:29:\"AIOWPSecurity_WP_Loaded_Tasks\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:24:\"aiowps_wp_loaded_handler\";s:5:\"class\";s:15:\"AIO_WP_Security\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:4:{s:4:\"file\";s:42:\"/home/dadmanla/public_html/wp-settings.php\";s:4:\"line\";i:764;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:4:{s:4:\"file\";s:40:\"/home/dadmanla/public_html/wp-config.php\";s:4:\"line\";i:111;s:4:\"args\";a:1:{i:0;s:42:\"/home/dadmanla/public_html/wp-settings.php\";}s:8:\"function\";s:12:\"require_once\";}i:19;a:4:{s:4:\"file\";s:38:\"/home/dadmanla/public_html/wp-load.php\";s:4:\"line\";i:50;s:4:\"args\";a:1:{i:0;s:40:\"/home/dadmanla/public_html/wp-config.php\";}s:8:\"function\";s:12:\"require_once\";}i:20;a:4:{s:4:\"file\";s:45:\"/home/dadmanla/public_html/wp-blog-header.php\";s:4:\"line\";i:13;s:4:\"args\";a:1:{i:0;s:38:\"/home/dadmanla/public_html/wp-load.php\";}s:8:\"function\";s:12:\"require_once\";}i:21;a:4:{s:4:\"file\";s:36:\"/home/dadmanla/public_html/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:45:\"/home/dadmanla/public_html/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}","1767863793",""),
("109","1","1","a.hashemi","149.22.93.248","info","successful_login","{\"successful_login\":{\"username\":\"a.hashemi\"}}","a:22:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:622;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:667;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"/home/dadmanla/public_html/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:133:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";s:4:\"line\";i:1340;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:4:{s:4:\"file\";s:132:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-process-renamed-login-page.php\";s:4:\"line\";i:223;s:4:\"args\";a:1:{i:0;s:133:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";}s:8:\"function\";s:12:\"require_once\";}i:12;a:6:{s:4:\"file\";s:121:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-wp-loaded-tasks.php\";s:4:\"line\";i:21;s:8:\"function\";s:24:\"renamed_login_init_tasks\";s:5:\"class\";s:40:\"AIOWPSecurity_Process_Renamed_Login_Page\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:102:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/wp-security-core.php\";s:4:\"line\";i:497;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:29:\"AIOWPSecurity_WP_Loaded_Tasks\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:24:\"aiowps_wp_loaded_handler\";s:5:\"class\";s:15:\"AIO_WP_Security\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:4:{s:4:\"file\";s:42:\"/home/dadmanla/public_html/wp-settings.php\";s:4:\"line\";i:764;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:4:{s:4:\"file\";s:40:\"/home/dadmanla/public_html/wp-config.php\";s:4:\"line\";i:111;s:4:\"args\";a:1:{i:0;s:42:\"/home/dadmanla/public_html/wp-settings.php\";}s:8:\"function\";s:12:\"require_once\";}i:19;a:4:{s:4:\"file\";s:38:\"/home/dadmanla/public_html/wp-load.php\";s:4:\"line\";i:50;s:4:\"args\";a:1:{i:0;s:40:\"/home/dadmanla/public_html/wp-config.php\";}s:8:\"function\";s:12:\"require_once\";}i:20;a:4:{s:4:\"file\";s:45:\"/home/dadmanla/public_html/wp-blog-header.php\";s:4:\"line\";i:13;s:4:\"args\";a:1:{i:0;s:38:\"/home/dadmanla/public_html/wp-load.php\";}s:8:\"function\";s:12:\"require_once\";}i:21;a:4:{s:4:\"file\";s:36:\"/home/dadmanla/public_html/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:45:\"/home/dadmanla/public_html/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}","1767882658",""),
("110","1","1","author_w5upz2oe","89.198.101.39","info","successful_login","{\"successful_login\":{\"username\":\"author_w5upz2oe\"}}","a:22:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:622;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:667;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"/home/dadmanla/public_html/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:133:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";s:4:\"line\";i:1340;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:4:{s:4:\"file\";s:132:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-process-renamed-login-page.php\";s:4:\"line\";i:223;s:4:\"args\";a:1:{i:0;s:133:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";}s:8:\"function\";s:12:\"require_once\";}i:12;a:6:{s:4:\"file\";s:121:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-wp-loaded-tasks.php\";s:4:\"line\";i:21;s:8:\"function\";s:24:\"renamed_login_init_tasks\";s:5:\"class\";s:40:\"AIOWPSecurity_Process_Renamed_Login_Page\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:102:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/wp-security-core.php\";s:4:\"line\";i:497;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:29:\"AIOWPSecurity_WP_Loaded_Tasks\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:24:\"aiowps_wp_loaded_handler\";s:5:\"class\";s:15:\"AIO_WP_Security\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:4:{s:4:\"file\";s:42:\"/home/dadmanla/public_html/wp-settings.php\";s:4:\"line\";i:764;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:4:{s:4:\"file\";s:40:\"/home/dadmanla/public_html/wp-config.php\";s:4:\"line\";i:111;s:4:\"args\";a:1:{i:0;s:42:\"/home/dadmanla/public_html/wp-settings.php\";}s:8:\"function\";s:12:\"require_once\";}i:19;a:4:{s:4:\"file\";s:38:\"/home/dadmanla/public_html/wp-load.php\";s:4:\"line\";i:50;s:4:\"args\";a:1:{i:0;s:40:\"/home/dadmanla/public_html/wp-config.php\";}s:8:\"function\";s:12:\"require_once\";}i:20;a:4:{s:4:\"file\";s:45:\"/home/dadmanla/public_html/wp-blog-header.php\";s:4:\"line\";i:13;s:4:\"args\";a:1:{i:0;s:38:\"/home/dadmanla/public_html/wp-load.php\";}s:8:\"function\";s:12:\"require_once\";}i:21;a:4:{s:4:\"file\";s:36:\"/home/dadmanla/public_html/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:45:\"/home/dadmanla/public_html/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}","1769722881",""),
("111","1","1","a.hashemi","216.247.106.186","info","successful_login","{\"successful_login\":{\"username\":\"a.hashemi\"}}","a:22:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:622;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:667;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"/home/dadmanla/public_html/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:133:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";s:4:\"line\";i:1340;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:4:{s:4:\"file\";s:132:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-process-renamed-login-page.php\";s:4:\"line\";i:223;s:4:\"args\";a:1:{i:0;s:133:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";}s:8:\"function\";s:12:\"require_once\";}i:12;a:6:{s:4:\"file\";s:121:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-wp-loaded-tasks.php\";s:4:\"line\";i:21;s:8:\"function\";s:24:\"renamed_login_init_tasks\";s:5:\"class\";s:40:\"AIOWPSecurity_Process_Renamed_Login_Page\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:102:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/wp-security-core.php\";s:4:\"line\";i:497;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:29:\"AIOWPSecurity_WP_Loaded_Tasks\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:24:\"aiowps_wp_loaded_handler\";s:5:\"class\";s:15:\"AIO_WP_Security\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:4:{s:4:\"file\";s:42:\"/home/dadmanla/public_html/wp-settings.php\";s:4:\"line\";i:764;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:4:{s:4:\"file\";s:40:\"/home/dadmanla/public_html/wp-config.php\";s:4:\"line\";i:111;s:4:\"args\";a:1:{i:0;s:42:\"/home/dadmanla/public_html/wp-settings.php\";}s:8:\"function\";s:12:\"require_once\";}i:19;a:4:{s:4:\"file\";s:38:\"/home/dadmanla/public_html/wp-load.php\";s:4:\"line\";i:50;s:4:\"args\";a:1:{i:0;s:40:\"/home/dadmanla/public_html/wp-config.php\";}s:8:\"function\";s:12:\"require_once\";}i:20;a:4:{s:4:\"file\";s:45:\"/home/dadmanla/public_html/wp-blog-header.php\";s:4:\"line\";i:13;s:4:\"args\";a:1:{i:0;s:38:\"/home/dadmanla/public_html/wp-load.php\";}s:8:\"function\";s:12:\"require_once\";}i:21;a:4:{s:4:\"file\";s:36:\"/home/dadmanla/public_html/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:45:\"/home/dadmanla/public_html/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}","1770018159",""),
("112","1","1","hashemi","89.58.46.160","info","successful_login","{\"successful_login\":{\"username\":\"hashemi\"}}","a:22:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:622;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:667;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"/home/dadmanla/public_html/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:133:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";s:4:\"line\";i:1340;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:4:{s:4:\"file\";s:132:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-process-renamed-login-page.php\";s:4:\"line\";i:223;s:4:\"args\";a:1:{i:0;s:133:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes/wp-security-rename-login-feature.php\";}s:8:\"function\";s:12:\"require_once\";}i:12;a:6:{s:4:\"file\";s:121:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-wp-loaded-tasks.php\";s:4:\"line\";i:21;s:8:\"function\";s:24:\"renamed_login_init_tasks\";s:5:\"class\";s:40:\"AIOWPSecurity_Process_Renamed_Login_Page\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:102:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/wp-security-core.php\";s:4:\"line\";i:497;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:29:\"AIOWPSecurity_WP_Loaded_Tasks\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:24:\"aiowps_wp_loaded_handler\";s:5:\"class\";s:15:\"AIO_WP_Security\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:4:{s:4:\"file\";s:42:\"/home/dadmanla/public_html/wp-settings.php\";s:4:\"line\";i:764;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:4:{s:4:\"file\";s:40:\"/home/dadmanla/public_html/wp-config.php\";s:4:\"line\";i:111;s:4:\"args\";a:1:{i:0;s:42:\"/home/dadmanla/public_html/wp-settings.php\";}s:8:\"function\";s:12:\"require_once\";}i:19;a:4:{s:4:\"file\";s:38:\"/home/dadmanla/public_html/wp-load.php\";s:4:\"line\";i:50;s:4:\"args\";a:1:{i:0;s:40:\"/home/dadmanla/public_html/wp-config.php\";}s:8:\"function\";s:12:\"require_once\";}i:20;a:4:{s:4:\"file\";s:45:\"/home/dadmanla/public_html/wp-blog-header.php\";s:4:\"line\";i:13;s:4:\"args\";a:1:{i:0;s:38:\"/home/dadmanla/public_html/wp-load.php\";}s:8:\"function\";s:12:\"require_once\";}i:21;a:4:{s:4:\"file\";s:36:\"/home/dadmanla/public_html/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:45:\"/home/dadmanla/public_html/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}","1770276747",""),
("113","1","1","hashemi","89.58.46.160","info","plugin_updated","{\"plugin\":{\"name\":\"All-In-One Security (AIOS)\",\"version\":\"5.4.6\",\"action\":\"updated\",\"network\":\"\"}}","a:14:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:197;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:70:\"/home/dadmanla/public_html/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:419;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:61:\"/home/dadmanla/public_html/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4653;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:21:\"wp_ajax_update_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:50:\"/home/dadmanla/public_html/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1770276778",""),
("114","1","1","hashemi","89.58.46.160","info","translation_updated","{\"translation_updated\":{\"language\":\"fa_IR\",\"type\":\"plugin\",\"slug\":\"all-in-one-wp-security-and-firewall\",\"version\":\"5.4.6\"}}","a:18:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:417;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:19:\"translation_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:77:\"/home/dadmanla/public_html/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:287;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:77:\"/home/dadmanla/public_html/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:104;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:343;s:8:\"function\";s:13:\"async_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:4:{s:4:\"file\";s:70:\"/home/dadmanla/public_html/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:419;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:61:\"/home/dadmanla/public_html/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4653;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:4:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:21:\"wp_ajax_update_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:4:{s:4:\"file\";s:50:\"/home/dadmanla/public_html/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1770276780",""),
("115","1","1","hashemi","89.58.46.160","info","plugin_updated","{\"plugin\":{\"name\":\"Click to Chat\",\"version\":\"4.37\",\"action\":\"updated\",\"network\":\"\"}}","a:14:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:197;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:70:\"/home/dadmanla/public_html/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:419;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:61:\"/home/dadmanla/public_html/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4653;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:21:\"wp_ajax_update_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:50:\"/home/dadmanla/public_html/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1770276783",""),
("116","1","1","hashemi","89.58.46.160","info","plugin_updated","{\"plugin\":{\"name\":\"Rank Math SEO\",\"version\":\"1.0.263\",\"action\":\"updated\",\"network\":\"\"}}","a:14:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:197;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:70:\"/home/dadmanla/public_html/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:419;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:61:\"/home/dadmanla/public_html/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4653;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:21:\"wp_ajax_update_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:50:\"/home/dadmanla/public_html/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1770276787",""),
("117","1","1","hashemi","89.58.46.160","info","translation_updated","{\"translation_updated\":{\"language\":\"fa_IR\",\"type\":\"plugin\",\"slug\":\"seo-by-rank-math\",\"version\":\"1.0.263\"}}","a:18:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:417;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:19:\"translation_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:77:\"/home/dadmanla/public_html/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:287;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:77:\"/home/dadmanla/public_html/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:104;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:343;s:8:\"function\";s:13:\"async_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:4:{s:4:\"file\";s:70:\"/home/dadmanla/public_html/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:419;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:61:\"/home/dadmanla/public_html/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4653;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:4:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:21:\"wp_ajax_update_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:4:{s:4:\"file\";s:50:\"/home/dadmanla/public_html/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1770276789",""),
("118","1","1","hashemi","89.58.46.160","info","plugin_updated","{\"plugin\":{\"name\":\"\\u0627\\u0641\\u0632\\u0648\\u0646\\u0647 \\u0646\\u0627\\u062d\\u06cc\\u0647 \\u06a9\\u0627\\u0628\\u0631\\u06cc \\u067e\\u06cc\\u0634\\u0631\\u0641\\u062a\\u0647\",\"version\":\"4.2.8\",\"action\":\"updated\",\"network\":\"\"}}","a:14:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:197;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:70:\"/home/dadmanla/public_html/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:419;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:61:\"/home/dadmanla/public_html/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4653;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:21:\"wp_ajax_update_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:50:\"/home/dadmanla/public_html/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1770276792",""),
("119","1","1","hashemi","89.58.46.160","info","plugin_updated","{\"plugin\":{\"name\":\"\\u0627\\u0641\\u0632\\u0648\\u0646\\u0647\\u200c\\u0647\\u0627\\u06cc \\u0636\\u0631\\u0648\\u0631\\u06cc \\u0628\\u0631\\u0627\\u06cc \\u0627\\u0644\\u0645\\u0646\\u062a\\u0648\\u0631\",\"version\":\"6.5.9\",\"action\":\"updated\",\"network\":\"\"}}","a:14:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:197;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:70:\"/home/dadmanla/public_html/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:419;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:61:\"/home/dadmanla/public_html/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4653;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:21:\"wp_ajax_update_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:50:\"/home/dadmanla/public_html/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1770276796",""),
("120","1","1","hashemi","89.58.46.160","info","plugin_updated","{\"plugin\":{\"name\":\"\\u0627\\u0644\\u0645\\u0646\\u062a\\u0648\\u0631\",\"version\":\"3.35.1\",\"action\":\"updated\",\"network\":\"\"}}","a:14:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:197;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:70:\"/home/dadmanla/public_html/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:419;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:61:\"/home/dadmanla/public_html/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4653;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:21:\"wp_ajax_update_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:50:\"/home/dadmanla/public_html/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1770276801",""),
("121","1","1","hashemi","89.58.46.160","info","translation_updated","{\"translation_updated\":{\"language\":\"fa_IR\",\"type\":\"plugin\",\"slug\":\"elementor\",\"version\":\"3.35.1\"}}","a:18:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:417;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:19:\"translation_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:77:\"/home/dadmanla/public_html/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:287;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:77:\"/home/dadmanla/public_html/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:104;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:343;s:8:\"function\";s:13:\"async_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:4:{s:4:\"file\";s:70:\"/home/dadmanla/public_html/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:419;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:61:\"/home/dadmanla/public_html/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4653;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:4:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:21:\"wp_ajax_update_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:4:{s:4:\"file\";s:50:\"/home/dadmanla/public_html/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1770276803",""),
("122","1","1","hashemi","89.58.46.160","info","plugin_updated","{\"plugin\":{\"name\":\"\\u0641\\u0648\\u0646\\u062a\\u200c\\u0647\\u0627\\u06cc \\u062f\\u0644\\u062e\\u0648\\u0627\\u0647\",\"version\":\"2.1.17\",\"action\":\"updated\",\"network\":\"\"}}","a:14:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:197;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:70:\"/home/dadmanla/public_html/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:419;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:61:\"/home/dadmanla/public_html/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4653;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:21:\"wp_ajax_update_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:50:\"/home/dadmanla/public_html/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1770276807",""),
("123","1","1","hashemi","89.58.46.160","info","plugin_updated","{\"plugin\":{\"name\":\"\\u0686\\u062a\\u06cc\",\"version\":\"3.5.1\",\"action\":\"updated\",\"network\":\"\"}}","a:14:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:197;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:70:\"/home/dadmanla/public_html/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:419;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:61:\"/home/dadmanla/public_html/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4653;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:21:\"wp_ajax_update_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:50:\"/home/dadmanla/public_html/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1770276811",""),
("124","1","1","hashemi","89.58.46.160","info","plugin_installed","{\"plugin\":{\"name\":\"Elementor Pro\",\"version\":\"3.34.0\",\"action\":\"installed\",\"network\":\"\"}}","a:11:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:164;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:16:\"plugin_installed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:66:\"/home/dadmanla/public_html/wp-admin/includes/class-wp-upgrader.php\";s:4:\"line\";i:987;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:70:\"/home/dadmanla/public_html/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:137;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:11:\"WP_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:46:\"/home/dadmanla/public_html/wp-admin/update.php\";s:4:\"line\";i:180;s:8:\"function\";s:7:\"install\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1770276887","");

INSERT IGNORE INTO `YTcMX_aiowps_audit_log` VALUES 
("125","1","1","hashemi","89.58.46.160","info","plugin_installed","{\"plugin\":{\"name\":\"Elementor Pro\",\"version\":\"3.34.0\",\"action\":\"installed\",\"network\":\"\"}}","a:11:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:164;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:16:\"plugin_installed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:66:\"/home/dadmanla/public_html/wp-admin/includes/class-wp-upgrader.php\";s:4:\"line\";i:987;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:70:\"/home/dadmanla/public_html/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:137;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:11:\"WP_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:46:\"/home/dadmanla/public_html/wp-admin/update.php\";s:4:\"line\";i:180;s:8:\"function\";s:7:\"install\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1770276896",""),
("126","1","1","hashemi","152.53.117.98","info","plugin_installed","{\"plugin\":{\"name\":\"Duplicator Pro\",\"version\":\"4.5.24.3\",\"action\":\"installed\",\"network\":\"\"}}","a:11:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:164;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:16:\"plugin_installed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:66:\"/home/dadmanla/public_html/wp-admin/includes/class-wp-upgrader.php\";s:4:\"line\";i:987;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:70:\"/home/dadmanla/public_html/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:137;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:11:\"WP_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:46:\"/home/dadmanla/public_html/wp-admin/update.php\";s:4:\"line\";i:180;s:8:\"function\";s:7:\"install\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1770277436",""),
("127","1","1","hashemi","89.58.46.160","info","plugin_activated","{\"plugin\":{\"name\":\"Duplicator Pro\",\"version\":\"4.5.24.3\",\"action\":\"activated\",\"network\":\"\"}}","a:10:{i:0;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:118:\"/home/dadmanla/public_html/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:177;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:16:\"plugin_activated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"/home/dadmanla/public_html/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"/home/dadmanla/public_html/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:55:\"/home/dadmanla/public_html/wp-admin/includes/plugin.php\";s:4:\"line\";i:730;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"/home/dadmanla/public_html/wp-admin/plugins.php\";s:4:\"line\";i:60;s:8:\"function\";s:15:\"activate_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}","1770277750","");

INSERT IGNORE INTO `YTcMX_aiowps_logged_in_users` VALUES 
("19","6","hashemi","89.58.46.160","1","1770276747","1770449547");

INSERT IGNORE INTO `YTcMX_duplicator_activity_logs` VALUES 
("1","websites_scan","scan_start","10","اسکن کردن","{\n    \"packageId\": 1,\n    \"packageName\": \"20260205_daafd8b1d988d987d988daa9d984d8a7db8cd8\",\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 0,\n    \"dirCount\": 0,\n    \"size\": 0,\n    \"dbExcluded\": false,\n    \"dbTableCount\": 0,\n    \"dbSize\": 0,\n    \"dbRowCount\": 0\n}","0","4.5.24.3","2026-02-05 07:50:20","2026-02-05 07:50:20"),
("2","websites_scan","scan_end","10","Scan Completed","{\n    \"packageId\": 1,\n    \"packageName\": \"20260205_daafd8b1d988d987d988daa9d984d8a7db8cd8\",\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 15877,\n    \"dirCount\": 2920,\n    \"size\": 394677428,\n    \"dbExcluded\": false,\n    \"dbTableCount\": 68,\n    \"dbSize\": 25477120,\n    \"dbRowCount\": 6992\n}","1","4.5.24.3","2026-02-05 07:50:23","2026-02-05 07:50:23"),
("3","backup_create","start","10","Backup creation: 20260205_daafd8b1d988d987d988daa9d984d8a7db8cd8","{\n    \"packageId\": 2,\n    \"packageName\": \"20260205_daafd8b1d988d987d988daa9d984d8a7db8cd8\",\n    \"packageStatus\": 10,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"nameHash\": \"20260205_daafd8b1d988d987d988daa9d984d8a7db8cd8_38332bb4db6c80c29102_20260205075018\",\n    \"logFileName\": \"20260205_daafd8b1d988d987d988daa9d984d8a7db8cd8_38332bb4db6c80c29102_20260205075018_log.txt\",\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 15877,\n    \"dirCount\": 2920,\n    \"size\": 394677428,\n    \"dbFilterOn\": false,\n    \"dbFilterTables\": [],\n    \"dbPrefixFilter\": false,\n    \"archiveEngine\": \"Zip Archive\",\n    \"databaseEngine\": \"PHPCHUNKING\",\n    \"execType\": \"\\u062f\\u0633\\u062a\\u06cc\",\n    \"scheduleName\": \"\",\n    \"storageNames\": [\n        \"Default\"\n    ],\n    \"archiveSizeDisplay\": \"\",\n    \"uploadSummaries\": [],\n    \"dbExcluded\": false,\n    \"dbTableCount\": 68,\n    \"dbSizeDisplay\": \"24.3MB\",\n    \"execution_start_time\": 1770277987.5926330089569091796875\n}","0","4.5.24.3","2026-02-05 07:53:07","2026-02-05 07:53:07"),
("4","backup_create","db_dump","10","Backup creation: 20260205_daafd8b1d988d987d988daa9d984d8a7db8cd8 - Database Dump","{\n    \"packageId\": 2,\n    \"packageName\": \"20260205_daafd8b1d988d987d988daa9d984d8a7db8cd8\",\n    \"packageStatus\": 20,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"nameHash\": \"20260205_daafd8b1d988d987d988daa9d984d8a7db8cd8_38332bb4db6c80c29102_20260205075018\",\n    \"logFileName\": \"20260205_daafd8b1d988d987d988daa9d984d8a7db8cd8_38332bb4db6c80c29102_20260205075018_log.txt\",\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 15877,\n    \"dirCount\": 2920,\n    \"size\": 394677428,\n    \"dbFilterOn\": false,\n    \"dbFilterTables\": [],\n    \"dbPrefixFilter\": false,\n    \"archiveEngine\": \"Zip Archive\",\n    \"databaseEngine\": \"PHPCHUNKING\",\n    \"execType\": \"\\u062f\\u0633\\u062a\\u06cc\",\n    \"scheduleName\": \"\",\n    \"storageNames\": [\n        \"Default\"\n    ],\n    \"archiveSizeDisplay\": \"\",\n    \"uploadSummaries\": [],\n    \"dbExcluded\": false,\n    \"dbTableCount\": 68,\n    \"dbSizeDisplay\": \"24.3MB\",\n    \"execution_start_time\": 1770277987.5926330089569091796875\n}","3","4.5.24.3","2026-02-05 07:53:07","2026-02-05 07:53:07");

INSERT IGNORE INTO `YTcMX_duplicator_backups` VALUES 
("1","Standard","20260205_daafd8b1d988d987d988daa9d984d8a7db8cd8","38332bb4db6c80c29102_20260205075018","20260205_daafd8b1d988d987d988daa9d984d8a7db8cd8_38332bb4db6c80c29102_20260205075018_archive.zip","5","MANUAL,ZIP_ARCHIVE,TEMPORARY","{\n    \"ID\": 1,\n    \"VersionWP\": \"6.9.1\",\n    \"VersionDB\": \"11.4.9\",\n    \"VersionPHP\": \"8.1.33\",\n    \"VersionOS\": \"Linux\",\n    \"name\": \"20260205_daafd8b1d988d987d988daa9d984d8a7db8cd8\",\n    \"hash\": \"38332bb4db6c80c29102_20260205075018\",\n    \"execType\": 0,\n    \"notes\": \"The default template.\",\n    \"StorePath\": \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/avnalaw.com\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20260205_daafd8b1d988d987d988daa9d984d8a7db8cd8_38332bb4db6c80c29102_20260205075018_scan.json\",\n    \"timer_start\": -1,\n    \"Runtime\": \"\",\n    \"ExeSize\": \"0\",\n    \"ZipSize\": \"0\",\n    \"Brand\": \"\\u067e\\u06cc\\u0634 \\u0641\\u0631\\u0636\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/dadmanla\\/public_html\\/.opcache\",\n            \"\\/home\\/dadmanla\\/public_html\\/.tmb\",\n            \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/bps-backup\",\n            \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/cache\",\n            \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/old-cache\",\n            \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/updraft\",\n            \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/wfcache\",\n            \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/dadmanla\\/public_html\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/dadmanla\\/public_html\\/.htaccess\",\n            \"\\/home\\/dadmanla\\/public_html\\/.user.ini\",\n            \"\\/home\\/dadmanla\\/public_html\\/php.ini\",\n            \"\\/home\\/dadmanla\\/public_html\\/web.config\",\n            \"\\/home\\/dadmanla\\/public_html\\/wp-config.php\",\n            \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20260205_daafd8b1d988d987d988daa9d984d8a7db8cd8_38332bb4db6c80c29102_20260205075018_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/dadmanla\\/public_html\\/\",\n        \"Size\": 394677428,\n        \"Dirs\": [],\n        \"DirCount\": 2920,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 15877,\n        \"file_count\": -1,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [\n                    {\n                        \"ubytes\": 224319330,\n                        \"bytes\": \"213.93MB\",\n                        \"nodes\": 14780,\n                        \"name\": \"plugins\",\n                        \"dir\": \"wp-content\",\n                        \"path\": \"wp-content\\/plugins\"\n                    },\n                    {\n                        \"ubytes\": 333150324,\n                        \"bytes\": \"317.72MB\",\n                        \"nodes\": 15570,\n                        \"name\": \"wp-content\",\n                        \"dir\": \".\",\n                        \"path\": \"wp-content\"\n                    }\n                ],\n                \"Core\": [],\n                \"Global\": [\n                    \"\\/home\\/dadmanla\\/public_html\\/wp-snapshots\",\n                    \"\\/home\\/dadmanla\\/public_html\\/.opcache\",\n                    \"\\/home\\/dadmanla\\/public_html\\/.tmb\",\n                    \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/backups-dup-lite\",\n                    \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/backups-dup-pro\",\n                    \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/ai1wm-backups\",\n                    \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/backupwordpress\",\n                    \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/content\\/cache\",\n                    \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/contents\\/cache\",\n                    \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/infinitewp\\/backups\",\n                    \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/managewp\\/backups\",\n                    \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/old-cache\",\n                    \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/updraft\",\n                    \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/wpvividbackups\",\n                    \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/wishlist-backup\",\n                    \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/wfcache\",\n                    \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/bps-backup\",\n                    \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/cache\",\n                    \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/uploads\\/aiowps_backups\",\n                    \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/uploads\\/backupbuddy_temp\",\n                    \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/uploads\\/backupbuddy_backups\",\n                    \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n                    \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/uploads\\/mainwp\\/backup\",\n                    \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/uploads\\/pb_backupbuddy\",\n                    \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/uploads\\/snapshots\",\n                    \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/uploads\\/sucuri\",\n                    \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/uploads\\/wp-clone\",\n                    \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/uploads\\/wp_all_backup\",\n                    \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/uploads\\/wpbackitup_backups\",\n                    \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/uploads\\/backup-guard\",\n                    \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n                    \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n                    \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/plugins\\/wordfence\\/tmp\"\n                ],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"Files\": {\n                \"Size\": [\n                    {\n                        \"ubytes\": 4846801,\n                        \"bytes\": \"4.62MB\",\n                        \"nodes\": 1,\n                        \"name\": \"ast-block-templates-blocks-2.json\",\n                        \"dir\": \"wp-content\\/uploads\\/ast-block-templates-json\",\n                        \"path\": \"wp-content\\/uploads\\/ast-block-templates-json\\/ast-block-templates-blocks-2.json\"\n                    },\n                    {\n                        \"ubytes\": 62050779,\n                        \"bytes\": \"59.18MB\",\n                        \"nodes\": 1,\n                        \"name\": \"GeoLite2-City.mmdb\",\n                        \"dir\": \"wp-content\\/uploads\\/wp-statistics\",\n                        \"path\": \"wp-content\\/uploads\\/wp-statistics\\/GeoLite2-City.mmdb\"\n                    }\n                ],\n                \"Core\": [],\n                \"Global\": [\n                    \"error_log\",\n                    \"debug_log\",\n                    \"ws_ftp.log\",\n                    \"dbcache\",\n                    \"pgcache\",\n                    \"objectcache\",\n                    \".DS_Store\",\n                    \"\\/home\\/dadmanla\\/public_html\\/.htaccess\",\n                    \"\\/home\\/dadmanla\\/public_html\\/.user.ini\",\n                    \"\\/home\\/dadmanla\\/public_html\\/php.ini\",\n                    \"\\/home\\/dadmanla\\/public_html\\/web.config\",\n                    \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/debug.log\",\n                    \"\\/home\\/dadmanla\\/public_html\\/wp-config.php\"\n                ],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"TreeSize\": {\n                \"text\": \"\\/home\\/dadmanla\\/public_html <span class=\\\"size\\\" >376.39MB<\\/span> <span class=\\\"nodes\\\" >18797<\\/span>\",\n                \"fullPath\": \"\\/home\\/dadmanla\\/public_html\",\n                \"type\": \"folder\",\n                \"state\": {\n                    \"opened\": true,\n                    \"disabled\": false,\n                    \"selected\": false,\n                    \"checked\": false,\n                    \"checkbox_disabled\": true\n                },\n                \"children\": [\n                    {\n                        \"text\": \"wp-content <span class=\\\"size\\\" >317.72MB<\\/span> <span class=\\\"nodes\\\" >15570<\\/span>\",\n                        \"fullPath\": \"\\/home\\/dadmanla\\/public_html\\/wp-content\",\n                        \"type\": \"folder\",\n                        \"state\": {\n                            \"opened\": true,\n                            \"disabled\": false,\n                            \"selected\": false,\n                            \"checked\": false,\n                            \"checkbox_disabled\": false\n                        },\n                        \"children\": [\n                            {\n                                \"text\": \"plugins <span class=\\\"size\\\" >213.93MB<\\/span> <span class=\\\"nodes\\\" >14780<\\/span>\",\n                                \"fullPath\": \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/plugins\",\n                                \"type\": \"folder\",\n                                \"state\": {\n                                    \"opened\": false,\n                                    \"disabled\": false,\n                                    \"selected\": false,\n                                    \"checked\": false,\n                                    \"checkbox_disabled\": false\n                                },\n                                \"children\": true,\n                                \"li_attr\": {\n                                    \"data-full-loaded\": false,\n                                    \"class\": \" warning-node\"\n                                },\n                                \"a_attr\": []\n                            },\n                            {\n                                \"text\": \"uploads <span class=\\\"size\\\" >86.62MB<\\/span> <span class=\\\"nodes\\\" >347<\\/span>\",\n                                \"fullPath\": \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/uploads\",\n                                \"type\": \"folder\",\n                                \"state\": {\n                                    \"opened\": true,\n                                    \"disabled\": false,\n                                    \"selected\": false,\n                                    \"checked\": false,\n                                    \"checkbox_disabled\": false\n                                },\n                                \"children\": [\n                                    {\n                                        \"text\": \"ast-block-templates-json <span class=\\\"size\\\" >14.89MB<\\/span> <span class=\\\"nodes\\\" >35<\\/span>\",\n                                        \"fullPath\": \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/uploads\\/ast-block-templates-json\",\n                                        \"type\": \"folder\",\n                                        \"state\": {\n                                            \"opened\": true,\n                                            \"disabled\": false,\n                                            \"selected\": false,\n                                            \"checked\": false,\n                                            \"checkbox_disabled\": false\n                                        },\n                                        \"children\": [\n                                            {\n                                                \"text\": \"ast-block-templates-blocks-2.json <span class=\\\"size\\\" >4.62MB<\\/span> <span class=\\\"nodes\\\" >&nbsp;<\\/span>\",\n                                                \"fullPath\": \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/uploads\\/ast-block-templates-json\\/ast-block-templates-blocks-2.json\",\n                                                \"type\": \"file\",\n                                                \"state\": {\n                                                    \"opened\": false,\n                                                    \"disabled\": false,\n                                                    \"selected\": false,\n                                                    \"checked\": false,\n                                                    \"checkbox_disabled\": false\n                                                },\n                                                \"children\": null,\n                                                \"li_attr\": {\n                                                    \"class\": \" warning-node\"\n                                                },\n                                                \"a_attr\": []\n                                            }\n                                        ],\n                                        \"li_attr\": {\n                                            \"data-full-loaded\": false,\n                                            \"class\": \" warning-childs\"\n                                        },\n                                        \"a_attr\": []\n                                    },\n                                    {\n                                        \"text\": \"wp-statistics <span class=\\\"size\\\" >59.18MB<\\/span> <span class=\\\"nodes\\\" >3<\\/span>\",\n                                        \"fullPath\": \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/uploads\\/wp-statistics\",\n                                        \"type\": \"folder\",\n                                        \"state\": {\n                                            \"opened\": true,\n                                            \"disabled\": false,\n                                            \"selected\": false,\n                                            \"checked\": false,\n                                            \"checkbox_disabled\": false\n                                        },\n                                        \"children\": [\n                                            {\n                                                \"text\": \"GeoLite2-City.mmdb <span class=\\\"size\\\" >59.18MB<\\/span> <span class=\\\"nodes\\\" >&nbsp;<\\/span>\",\n                                                \"fullPath\": \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/uploads\\/wp-statistics\\/GeoLite2-City.mmdb\",\n                                                \"type\": \"file\",\n                                                \"state\": {\n                                                    \"opened\": false,\n                                                    \"disabled\": false,\n                                                    \"selected\": false,\n                                                    \"checked\": false,\n                                                    \"checkbox_disabled\": false\n                                                },\n                                                \"children\": null,\n                                                \"li_attr\": {\n                                                    \"class\": \" warning-node\"\n                                                },\n                                                \"a_attr\": []\n                                            }\n                                        ],\n                                        \"li_attr\": {\n                                            \"data-full-loaded\": false,\n                                            \"class\": \" warning-childs\"\n                                        },\n                                        \"a_attr\": []\n                                    }\n                                ],\n                                \"li_attr\": {\n                                    \"data-full-loaded\": false,\n                                    \"class\": \" warning-childs\"\n                                },\n                                \"a_attr\": []\n                            }\n                        ],\n                        \"li_attr\": {\n                            \"data-full-loaded\": false,\n                            \"class\": \" warning-node\"\n                        },\n                        \"a_attr\": []\n                    }\n                ],\n                \"li_attr\": {\n                    \"data-full-loaded\": false,\n                    \"class\": \" root-node core-node warning-childs\"\n                },\n                \"a_attr\": {\n                    \"title\": \"\\u062f\\u0627\\u06cc\\u0631\\u06a9\\u062a\\u0648\\u0631\\u06cc \\u0647\\u0627\\u06cc \\u06a9\\u0644\\u06cc\\u062f\\u06cc \\u0648\\u0631\\u062f\\u067e\\u0631\\u0633 \\u0646\\u0628\\u0627\\u06cc\\u062f \\u0641\\u06cc\\u0644\\u062a\\u0631 \\u0634\\u0648\\u0646\\u062f. \\u0647\\u0646\\u06af\\u0627\\u0645 \\u062d\\u0630\\u0641 \\u0641\\u0627\\u06cc\\u0644\\u0647\\u0627 \\u0627\\u062d\\u062a\\u06cc\\u0627\\u0637 \\u06a9\\u0646\\u06cc\\u062f.\"\n                }\n            }\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20260205_daafd8b1d988d987d988daa9d984d8a7db8cd8_38332bb4db6c80c29102_20260205075018_installer.php\",\n        \"Size\": 0,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"Plmz+U1+Z7I1W2Ww729Am5XK5ELC+zyOkbs4zt6n9\\/bhn1q9LBu7I3ZkN9mgbU\\/utPE93iVF8ORHMWASAXw8EQVJUnSU3FsEK2ytaqj9uWyTfweDsee8nwVTbRqpIMFu\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": false,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\"\n            ],\n            \"collationList\": [\n                \"utf8mb4_bin\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": true,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"dadmanla_wp_mq7rh\",\n            \"tablesBaseCount\": 68,\n            \"tablesFinalCount\": 68,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 6992,\n            \"tablesSizeOnDisk\": 25477120,\n            \"tablesList\": {\n                \"YTcMX_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"48\",\n                    \"insertedRows\": 0,\n                    \"size\": 196608\n                },\n                \"YTcMX_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"YTcMX_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"YTcMX_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"138\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"YTcMX_aiowps_audit_log\": {\n                    \"inaccurateRows\": \"85\",\n                    \"insertedRows\": 0,\n                    \"size\": 1654784\n                },\n                \"YTcMX_aiowps_debug_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"YTcMX_aiowps_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"YTcMX_aiowps_global_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"YTcMX_aiowps_logged_in_users\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"YTcMX_aiowps_login_lockdown\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"YTcMX_aiowps_message_store\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"YTcMX_aiowps_permanent_block\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"YTcMX_chaty_contact_form_leads\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"YTcMX_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"YTcMX_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"YTcMX_duplicator_activity_logs\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"YTcMX_duplicator_backups\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 163840\n                },\n                \"YTcMX_duplicator_entities\": {\n                    \"inaccurateRows\": \"8\",\n                    \"insertedRows\": 0,\n                    \"size\": 163840\n                },\n                \"YTcMX_e_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"YTcMX_e_notes\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 196608\n                },\n                \"YTcMX_e_notes_users_relations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"YTcMX_e_submissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 294912\n                },\n                \"YTcMX_e_submissions_actions_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"YTcMX_e_submissions_values\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"YTcMX_ff_scheduled_actions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"YTcMX_fluentform_entry_details\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"YTcMX_fluentform_forms\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"YTcMX_fluentform_form_analytics\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"YTcMX_fluentform_form_meta\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"YTcMX_fluentform_logs\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"YTcMX_fluentform_submissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"YTcMX_fluentform_submission_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"YTcMX_fsmpt_email_logs\": {\n                    \"inaccurateRows\": \"15\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"YTcMX_gf_draft_submissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"YTcMX_gf_entry\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"YTcMX_gf_entry_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"YTcMX_gf_entry_notes\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"YTcMX_gf_form\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"YTcMX_gf_form_meta\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"YTcMX_gf_form_revisions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"YTcMX_gf_form_view\": {\n                    \"inaccurateRows\": \"51\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"YTcMX_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"YTcMX_options\": {\n                    \"inaccurateRows\": \"614\",\n                    \"insertedRows\": 0,\n                    \"size\": 3620864\n                },\n                \"YTcMX_postmeta\": {\n                    \"inaccurateRows\": \"3714\",\n                    \"insertedRows\": 0,\n                    \"size\": 9175040\n                },\n                \"YTcMX_posts\": {\n                    \"inaccurateRows\": \"705\",\n                    \"insertedRows\": 0,\n                    \"size\": 7012352\n                },\n                \"YTcMX_rank_math_404_logs\": {\n                    \"inaccurateRows\": \"85\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"YTcMX_rank_math_analytics_gsc\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"YTcMX_rank_math_analytics_inspections\": {\n                    \"inaccurateRows\": \"17\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"YTcMX_rank_math_analytics_objects\": {\n                    \"inaccurateRows\": \"44\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"YTcMX_rank_math_internal_links\": {\n                    \"inaccurateRows\": \"72\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"YTcMX_rank_math_internal_meta\": {\n                    \"inaccurateRows\": \"57\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"YTcMX_rank_math_redirections\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"YTcMX_rank_math_redirections_cache\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"YTcMX_statistics_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"YTcMX_statistics_exclusions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"YTcMX_statistics_historical\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"YTcMX_statistics_pages\": {\n                    \"inaccurateRows\": \"174\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"YTcMX_statistics_summary_totals\": {\n                    \"inaccurateRows\": \"60\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"YTcMX_statistics_visitor\": {\n                    \"inaccurateRows\": \"181\",\n                    \"insertedRows\": 0,\n                    \"size\": 196608\n                },\n                \"YTcMX_statistics_visitor_relationships\": {\n                    \"inaccurateRows\": \"389\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"YTcMX_termmeta\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"YTcMX_terms\": {\n                    \"inaccurateRows\": \"75\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"YTcMX_term_relationships\": {\n                    \"inaccurateRows\": \"149\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"YTcMX_term_taxonomy\": {\n                    \"inaccurateRows\": \"75\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"YTcMX_usermeta\": {\n                    \"inaccurateRows\": \"206\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"YTcMX_users\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"YTcMX_wpuf_subscribers\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"YTcMX_wpuf_transaction\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                }\n            },\n            \"dbEngine\": \"MariaDB\",\n            \"version\": \"11.4.9\",\n            \"versionComment\": \"MariaDB Server\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 0,\n        \"File\": \"20260205_daafd8b1d988d987d988daa9d984d8a7db8cd8_38332bb4db6c80c29102_20260205075018_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"MariaDB Server\",\n        \"dbStorePathPublic\": \"\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"status\": 5,\n    \"schedule_id\": -1,\n    \"descriptorsMng\": null,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"expected_archive_size\": 394677428,\n        \"processed_archive_size\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 2,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 3,\n            \"storageClass\": \"Duplicator\\\\Models\\\\Storages\\\\AbstractStorageEntity\",\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 0,\n            \"stopped_timestamp\": 0,\n            \"chunkPosition\": [],\n            \"isProcessing\": false,\n            \"storage\": null,\n            \"packageExists\": true,\n            \"isDownloadFromRemote\": false,\n            \"copyExtraData\": [],\n            \"generalExtraData\": []\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": -1,\n    \"buildEmailSent\": false,\n    \"version\": \"4.5.24.3\",\n    \"created\": \"2026-02-05 07:50:18\",\n    \"updated\": \"2026-02-05 07:50:23\",\n    \"flags\": [\n        \"MANUAL\",\n        \"ZIP_ARCHIVE\",\n        \"TEMPORARY\"\n    ],\n    \"flagUpdatedAfterLoad\": false,\n    \"mainScanLogId\": 1,\n    \"mainActivityLogId\": 0\n}","4.5.24.3","2026-02-05 07:50:18","2026-02-05 07:50:23"),
("2","Standard","20260205_daafd8b1d988d987d988daa9d984d8a7db8cd8","38332bb4db6c80c29102_20260205075018","20260205_daafd8b1d988d987d988daa9d984d8a7db8cd8_38332bb4db6c80c29102_20260205075018_archive.zip","20","MANUAL,ZIP_ARCHIVE","{\n    \"ID\": 2,\n    \"VersionWP\": \"6.9.1\",\n    \"VersionDB\": \"11.4.9\",\n    \"VersionPHP\": \"8.1.33\",\n    \"VersionOS\": \"Linux\",\n    \"name\": \"20260205_daafd8b1d988d987d988daa9d984d8a7db8cd8\",\n    \"hash\": \"38332bb4db6c80c29102_20260205075018\",\n    \"execType\": 0,\n    \"notes\": \"The default template.\",\n    \"StorePath\": \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/avnalaw.com\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20260205_daafd8b1d988d987d988daa9d984d8a7db8cd8_38332bb4db6c80c29102_20260205075018_scan.json\",\n    \"timer_start\": 1770277987.5926330089569091796875,\n    \"Runtime\": \"\",\n    \"ExeSize\": \"0\",\n    \"ZipSize\": \"0\",\n    \"Brand\": \"\\u067e\\u06cc\\u0634 \\u0641\\u0631\\u0636\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/dadmanla\\/public_html\\/.opcache\",\n            \"\\/home\\/dadmanla\\/public_html\\/.tmb\",\n            \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/bps-backup\",\n            \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/cache\",\n            \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/old-cache\",\n            \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/updraft\",\n            \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/wfcache\",\n            \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/dadmanla\\/public_html\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/dadmanla\\/public_html\\/.htaccess\",\n            \"\\/home\\/dadmanla\\/public_html\\/.user.ini\",\n            \"\\/home\\/dadmanla\\/public_html\\/php.ini\",\n            \"\\/home\\/dadmanla\\/public_html\\/web.config\",\n            \"\\/home\\/dadmanla\\/public_html\\/wp-config.php\",\n            \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20260205_daafd8b1d988d987d988daa9d984d8a7db8cd8_38332bb4db6c80c29102_20260205075018_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/dadmanla\\/public_html\\/\",\n        \"Size\": 394677428,\n        \"Dirs\": [],\n        \"DirCount\": 2920,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 15877,\n        \"file_count\": -1,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [\n                    {\n                        \"ubytes\": 224319330,\n                        \"bytes\": \"213.93MB\",\n                        \"nodes\": 14780,\n                        \"name\": \"plugins\",\n                        \"dir\": \"wp-content\",\n                        \"path\": \"wp-content\\/plugins\"\n                    },\n                    {\n                        \"ubytes\": 333150324,\n                        \"bytes\": \"317.72MB\",\n                        \"nodes\": 15570,\n                        \"name\": \"wp-content\",\n                        \"dir\": \".\",\n                        \"path\": \"wp-content\"\n                    }\n                ],\n                \"Core\": [],\n                \"Global\": [\n                    \"\\/home\\/dadmanla\\/public_html\\/wp-snapshots\",\n                    \"\\/home\\/dadmanla\\/public_html\\/.opcache\",\n                    \"\\/home\\/dadmanla\\/public_html\\/.tmb\",\n                    \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/backups-dup-lite\",\n                    \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/backups-dup-pro\",\n                    \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/ai1wm-backups\",\n                    \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/backupwordpress\",\n                    \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/content\\/cache\",\n                    \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/contents\\/cache\",\n                    \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/infinitewp\\/backups\",\n                    \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/managewp\\/backups\",\n                    \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/old-cache\",\n                    \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/updraft\",\n                    \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/wpvividbackups\",\n                    \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/wishlist-backup\",\n                    \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/wfcache\",\n                    \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/bps-backup\",\n                    \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/cache\",\n                    \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/uploads\\/aiowps_backups\",\n                    \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/uploads\\/backupbuddy_temp\",\n                    \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/uploads\\/backupbuddy_backups\",\n                    \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n                    \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/uploads\\/mainwp\\/backup\",\n                    \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/uploads\\/pb_backupbuddy\",\n                    \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/uploads\\/snapshots\",\n                    \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/uploads\\/sucuri\",\n                    \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/uploads\\/wp-clone\",\n                    \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/uploads\\/wp_all_backup\",\n                    \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/uploads\\/wpbackitup_backups\",\n                    \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/uploads\\/backup-guard\",\n                    \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n                    \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n                    \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/plugins\\/wordfence\\/tmp\"\n                ],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"Files\": {\n                \"Size\": [\n                    {\n                        \"ubytes\": 4846801,\n                        \"bytes\": \"4.62MB\",\n                        \"nodes\": 1,\n                        \"name\": \"ast-block-templates-blocks-2.json\",\n                        \"dir\": \"wp-content\\/uploads\\/ast-block-templates-json\",\n                        \"path\": \"wp-content\\/uploads\\/ast-block-templates-json\\/ast-block-templates-blocks-2.json\"\n                    },\n                    {\n                        \"ubytes\": 62050779,\n                        \"bytes\": \"59.18MB\",\n                        \"nodes\": 1,\n                        \"name\": \"GeoLite2-City.mmdb\",\n                        \"dir\": \"wp-content\\/uploads\\/wp-statistics\",\n                        \"path\": \"wp-content\\/uploads\\/wp-statistics\\/GeoLite2-City.mmdb\"\n                    }\n                ],\n                \"Core\": [],\n                \"Global\": [\n                    \"error_log\",\n                    \"debug_log\",\n                    \"ws_ftp.log\",\n                    \"dbcache\",\n                    \"pgcache\",\n                    \"objectcache\",\n                    \".DS_Store\",\n                    \"\\/home\\/dadmanla\\/public_html\\/.htaccess\",\n                    \"\\/home\\/dadmanla\\/public_html\\/.user.ini\",\n                    \"\\/home\\/dadmanla\\/public_html\\/php.ini\",\n                    \"\\/home\\/dadmanla\\/public_html\\/web.config\",\n                    \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/debug.log\",\n                    \"\\/home\\/dadmanla\\/public_html\\/wp-config.php\"\n                ],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"TreeSize\": {\n                \"treeList\": []\n            }\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20260205_daafd8b1d988d987d988daa9d984d8a7db8cd8_38332bb4db6c80c29102_20260205075018_installer.php\",\n        \"Size\": 0,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"711KYOaDkKlQbh30NLtNddAvb56PMW3UpEcEriG1tTLhn1q9LBu7I3ZkN9mgbU\\/utPE93iVF8OSQrRvh\\/m5wEo+9xd4JSIMLx\\/9Bk5gKrcuIoEtozVVhkmJbzYfaxr\\/w\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": false,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\"\n            ],\n            \"collationList\": [\n                \"utf8mb4_bin\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": true,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"dadmanla_wp_mq7rh\",\n            \"tablesBaseCount\": 68,\n            \"tablesFinalCount\": 68,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 6992,\n            \"tablesSizeOnDisk\": 25477120,\n            \"tablesList\": {\n                \"YTcMX_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"48\",\n                    \"insertedRows\": 0,\n                    \"size\": 196608\n                },\n                \"YTcMX_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"YTcMX_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"YTcMX_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"138\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"YTcMX_aiowps_audit_log\": {\n                    \"inaccurateRows\": \"85\",\n                    \"insertedRows\": 0,\n                    \"size\": 1654784\n                },\n                \"YTcMX_aiowps_debug_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"YTcMX_aiowps_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"YTcMX_aiowps_global_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"YTcMX_aiowps_logged_in_users\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"YTcMX_aiowps_login_lockdown\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"YTcMX_aiowps_message_store\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"YTcMX_aiowps_permanent_block\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"YTcMX_chaty_contact_form_leads\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"YTcMX_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"YTcMX_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"YTcMX_duplicator_activity_logs\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"YTcMX_duplicator_backups\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 163840\n                },\n                \"YTcMX_duplicator_entities\": {\n                    \"inaccurateRows\": \"8\",\n                    \"insertedRows\": 0,\n                    \"size\": 163840\n                },\n                \"YTcMX_e_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"YTcMX_e_notes\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 196608\n                },\n                \"YTcMX_e_notes_users_relations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"YTcMX_e_submissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 294912\n                },\n                \"YTcMX_e_submissions_actions_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"YTcMX_e_submissions_values\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"YTcMX_ff_scheduled_actions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"YTcMX_fluentform_entry_details\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"YTcMX_fluentform_forms\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"YTcMX_fluentform_form_analytics\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"YTcMX_fluentform_form_meta\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"YTcMX_fluentform_logs\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"YTcMX_fluentform_submissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"YTcMX_fluentform_submission_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"YTcMX_fsmpt_email_logs\": {\n                    \"inaccurateRows\": \"15\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"YTcMX_gf_draft_submissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"YTcMX_gf_entry\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"YTcMX_gf_entry_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"YTcMX_gf_entry_notes\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"YTcMX_gf_form\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"YTcMX_gf_form_meta\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"YTcMX_gf_form_revisions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"YTcMX_gf_form_view\": {\n                    \"inaccurateRows\": \"51\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"YTcMX_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"YTcMX_options\": {\n                    \"inaccurateRows\": \"614\",\n                    \"insertedRows\": 0,\n                    \"size\": 3620864\n                },\n                \"YTcMX_postmeta\": {\n                    \"inaccurateRows\": \"3714\",\n                    \"insertedRows\": 0,\n                    \"size\": 9175040\n                },\n                \"YTcMX_posts\": {\n                    \"inaccurateRows\": \"705\",\n                    \"insertedRows\": 0,\n                    \"size\": 7012352\n                },\n                \"YTcMX_rank_math_404_logs\": {\n                    \"inaccurateRows\": \"85\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"YTcMX_rank_math_analytics_gsc\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"YTcMX_rank_math_analytics_inspections\": {\n                    \"inaccurateRows\": \"17\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"YTcMX_rank_math_analytics_objects\": {\n                    \"inaccurateRows\": \"44\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"YTcMX_rank_math_internal_links\": {\n                    \"inaccurateRows\": \"72\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"YTcMX_rank_math_internal_meta\": {\n                    \"inaccurateRows\": \"57\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"YTcMX_rank_math_redirections\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"YTcMX_rank_math_redirections_cache\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"YTcMX_statistics_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"YTcMX_statistics_exclusions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"YTcMX_statistics_historical\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"YTcMX_statistics_pages\": {\n                    \"inaccurateRows\": \"174\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"YTcMX_statistics_summary_totals\": {\n                    \"inaccurateRows\": \"60\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"YTcMX_statistics_visitor\": {\n                    \"inaccurateRows\": \"181\",\n                    \"insertedRows\": 0,\n                    \"size\": 196608\n                },\n                \"YTcMX_statistics_visitor_relationships\": {\n                    \"inaccurateRows\": \"389\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"YTcMX_termmeta\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"YTcMX_terms\": {\n                    \"inaccurateRows\": \"75\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"YTcMX_term_relationships\": {\n                    \"inaccurateRows\": \"149\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"YTcMX_term_taxonomy\": {\n                    \"inaccurateRows\": \"75\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"YTcMX_usermeta\": {\n                    \"inaccurateRows\": \"206\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"YTcMX_users\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"YTcMX_wpuf_subscribers\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"YTcMX_wpuf_transaction\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                }\n            },\n            \"dbEngine\": \"MariaDB\",\n            \"version\": \"11.4.9\",\n            \"versionComment\": \"MariaDB Server\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 0,\n        \"File\": \"20260205_daafd8b1d988d987d988daa9d984d8a7db8cd8_38332bb4db6c80c29102_20260205075018_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"MariaDB Server\",\n        \"dbStorePathPublic\": \"\\/home\\/dadmanla\\/public_html\\/wp-content\\/backups-dup-pro\\/tmp\\/20260205_daafd8b1d988d987d988daa9d984d8a7db8cd8_38332bb4db6c80c29102_20260205075018_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"status\": 20,\n    \"schedule_id\": -1,\n    \"descriptorsMng\": null,\n    \"build_progress\": {\n        \"thread_start_time\": 1770277990,\n        \"initialized\": true,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"expected_archive_size\": 394677428,\n        \"processed_archive_size\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 2,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [\n            \"YTcMX_users\",\n            \"YTcMX_usermeta\",\n            \"YTcMX_actionscheduler_actions\",\n            \"YTcMX_actionscheduler_claims\",\n            \"YTcMX_actionscheduler_groups\",\n            \"YTcMX_actionscheduler_logs\",\n            \"YTcMX_aiowps_audit_log\",\n            \"YTcMX_aiowps_debug_log\",\n            \"YTcMX_aiowps_events\",\n            \"YTcMX_aiowps_global_meta\",\n            \"YTcMX_aiowps_logged_in_users\",\n            \"YTcMX_aiowps_login_lockdown\",\n            \"YTcMX_aiowps_message_store\",\n            \"YTcMX_aiowps_permanent_block\",\n            \"YTcMX_chaty_contact_form_leads\",\n            \"YTcMX_commentmeta\",\n            \"YTcMX_comments\",\n            \"YTcMX_duplicator_activity_logs\",\n            \"YTcMX_duplicator_backups\",\n            \"YTcMX_duplicator_entities\",\n            \"YTcMX_e_events\",\n            \"YTcMX_e_notes\",\n            \"YTcMX_e_notes_users_relations\",\n            \"YTcMX_e_submissions\",\n            \"YTcMX_e_submissions_actions_log\",\n            \"YTcMX_e_submissions_values\",\n            \"YTcMX_ff_scheduled_actions\",\n            \"YTcMX_fluentform_entry_details\",\n            \"YTcMX_fluentform_forms\",\n            \"YTcMX_fluentform_form_analytics\",\n            \"YTcMX_fluentform_form_meta\",\n            \"YTcMX_fluentform_logs\",\n            \"YTcMX_fluentform_submissions\",\n            \"YTcMX_fluentform_submission_meta\",\n            \"YTcMX_fsmpt_email_logs\",\n            \"YTcMX_gf_draft_submissions\",\n            \"YTcMX_gf_entry\",\n            \"YTcMX_gf_entry_meta\",\n            \"YTcMX_gf_entry_notes\",\n            \"YTcMX_gf_form\",\n            \"YTcMX_gf_form_meta\",\n            \"YTcMX_gf_form_revisions\",\n            \"YTcMX_gf_form_view\",\n            \"YTcMX_links\",\n            \"YTcMX_options\",\n            \"YTcMX_postmeta\",\n            \"YTcMX_posts\",\n            \"YTcMX_rank_math_404_logs\",\n            \"YTcMX_rank_math_analytics_gsc\",\n            \"YTcMX_rank_math_analytics_inspections\",\n            \"YTcMX_rank_math_analytics_objects\",\n            \"YTcMX_rank_math_internal_links\",\n            \"YTcMX_rank_math_internal_meta\",\n            \"YTcMX_rank_math_redirections\",\n            \"YTcMX_rank_math_redirections_cache\",\n            \"YTcMX_statistics_events\",\n            \"YTcMX_statistics_exclusions\",\n            \"YTcMX_statistics_historical\",\n            \"YTcMX_statistics_pages\",\n            \"YTcMX_statistics_summary_totals\",\n            \"YTcMX_statistics_visitor\",\n            \"YTcMX_statistics_visitor_relationships\",\n            \"YTcMX_termmeta\",\n            \"YTcMX_terms\",\n            \"YTcMX_term_relationships\",\n            \"YTcMX_term_taxonomy\",\n            \"YTcMX_wpuf_subscribers\",\n            \"YTcMX_wpuf_transaction\"\n        ],\n        \"validationStage1\": false,\n        \"doneInit\": true,\n        \"doneFiltering\": true,\n        \"doneCreates\": true,\n        \"completed\": false,\n        \"startTime\": 1770277987.6240870952606201171875,\n        \"wasInterrupted\": true,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"countTotal\": 0,\n            \"impreciseTotalRows\": 6997,\n            \"tables\": {\n                \"YTcMX_users\": {\n                    \"start\": \"5\",\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"YTcMX_usermeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"YTcMX_actionscheduler_actions\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"YTcMX_actionscheduler_claims\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"YTcMX_actionscheduler_groups\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"YTcMX_actionscheduler_logs\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"YTcMX_aiowps_audit_log\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"YTcMX_aiowps_debug_log\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"YTcMX_aiowps_events\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"YTcMX_aiowps_global_meta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"YTcMX_aiowps_logged_in_users\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"YTcMX_aiowps_login_lockdown\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"YTcMX_aiowps_message_store\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"YTcMX_aiowps_permanent_block\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"YTcMX_chaty_contact_form_leads\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"YTcMX_commentmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"YTcMX_comments\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"YTcMX_duplicator_activity_logs\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"YTcMX_duplicator_backups\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"YTcMX_duplicator_entities\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"YTcMX_e_events\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"YTcMX_e_notes\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"YTcMX_e_notes_users_relations\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"YTcMX_e_submissions\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"YTcMX_e_submissions_actions_log\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"YTcMX_e_submissions_values\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"YTcMX_ff_scheduled_actions\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"YTcMX_fluentform_entry_details\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"YTcMX_fluentform_forms\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"YTcMX_fluentform_form_analytics\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"YTcMX_fluentform_form_meta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"YTcMX_fluentform_logs\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"YTcMX_fluentform_submissions\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"YTcMX_fluentform_submission_meta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"YTcMX_fsmpt_email_logs\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"YTcMX_gf_draft_submissions\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"YTcMX_gf_entry\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"YTcMX_gf_entry_meta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"YTcMX_gf_entry_notes\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"YTcMX_gf_form\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"YTcMX_gf_form_meta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"YTcMX_gf_form_revisions\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"YTcMX_gf_form_view\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"YTcMX_links\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"YTcMX_options\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"YTcMX_postmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"YTcMX_posts\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"YTcMX_rank_math_404_logs\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"YTcMX_rank_math_analytics_gsc\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"YTcMX_rank_math_analytics_inspections\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"YTcMX_rank_math_analytics_objects\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"YTcMX_rank_math_internal_links\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"YTcMX_rank_math_internal_meta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"YTcMX_rank_math_redirections\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"YTcMX_rank_math_redirections_cache\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"YTcMX_statistics_events\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"YTcMX_statistics_exclusions\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"YTcMX_statistics_historical\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"YTcMX_statistics_pages\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"YTcMX_statistics_summary_totals\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"YTcMX_statistics_visitor\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"YTcMX_statistics_visitor_relationships\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"YTcMX_termmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"YTcMX_terms\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"YTcMX_term_relationships\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"YTcMX_term_taxonomy\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"YTcMX_wpuf_subscribers\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"YTcMX_wpuf_transaction\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                }\n            }\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 3,\n            \"storageClass\": \"Duplicator\\\\Models\\\\Storages\\\\AbstractStorageEntity\",\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 0,\n            \"stopped_timestamp\": 0,\n            \"chunkPosition\": [],\n            \"isProcessing\": false,\n            \"storage\": null,\n            \"packageExists\": true,\n            \"isDownloadFromRemote\": false,\n            \"copyExtraData\": [],\n            \"generalExtraData\": []\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": -1,\n    \"buildEmailSent\": false,\n    \"version\": \"4.5.24.3\",\n    \"created\": \"2026-02-05 07:50:18\",\n    \"updated\": \"2026-02-05 07:53:10\",\n    \"flags\": [\n        \"MANUAL\",\n        \"ZIP_ARCHIVE\"\n    ],\n    \"flagUpdatedAfterLoad\": false,\n    \"mainScanLogId\": 1,\n    \"mainActivityLogId\": 3\n}","4.5.24.3","2026-02-05 07:50:18","2026-02-05 07:53:10");

INSERT IGNORE INTO `YTcMX_duplicator_entities` VALUES 
("1","DUP_PRO_Global_Entity","","","","","","{\n    \"email_summary_frequency\": \"weekly\",\n    \"email_summary_recipients\": [\n        \"admin@avnalaw.com\"\n    ],\n    \"usageTracking\": true,\n    \"amNotices\": true,\n    \"package_mysqldump\": false,\n    \"package_mysqldump_path\": \"\",\n    \"package_phpdump_mode\": 0,\n    \"package_mysqldump_qrylimit\": 131072,\n    \"packageMysqldumpOptions\": [\n        {\n            \"option\": \"quick\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": false,\n            \"arguments\": []\n        },\n        {\n            \"option\": \"extended-insert\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": false,\n            \"arguments\": []\n        },\n        {\n            \"option\": \"routines\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": true,\n            \"arguments\": []\n        },\n        {\n            \"option\": \"disable-keys\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": false,\n            \"arguments\": []\n        },\n        {\n            \"option\": \"compact\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": false,\n            \"arguments\": []\n        }\n    ],\n    \"archive_build_mode\": 2,\n    \"archive_compression\": true,\n    \"ziparchive_validation\": false,\n    \"ziparchive_mode\": 0,\n    \"ziparchive_chunk_size_in_mb\": 32,\n    \"homepath_as_abspath\": false,\n    \"server_load_reduction\": 0,\n    \"max_package_runtime_in_min\": 90,\n    \"max_package_transfer_time_in_min\": 90,\n    \"php_max_worker_time_in_sec\": 20,\n    \"cleanup_mode\": 0,\n    \"cleanup_email\": \"admin@avnalaw.com\",\n    \"auto_cleanup_hours\": 24,\n    \"lock_mode\": 0,\n    \"ajax_protocol\": \"https\",\n    \"custom_ajax_url\": \"https:\\/\\/avnalaw.com\\/wp-admin\\/admin-ajax.php\",\n    \"clientside_kickoff\": false,\n    \"basic_auth_enabled\": false,\n    \"basic_auth_user\": \"\",\n    \"installer_name_mode\": \"simple\",\n    \"installer_base_name\": \"installer.php\",\n    \"skip_archive_scan\": false,\n    \"send_email_on_build_mode\": 1,\n    \"notification_email_address\": \"\",\n    \"storage_htaccess_off\": false,\n    \"max_storage_retries\": 10,\n    \"purgeBackupRecords\": 0,\n    \"manual_mode_storage_ids\": [\n        3\n    ],\n    \"license_key_visible\": 1,\n    \"last_system_check_timestamp\": 0,\n    \"initial_activation_timestamp\": 1770277751,\n    \"ssl_useservercerts\": true,\n    \"ssl_disableverify\": true,\n    \"import_chunk_size\": 1024,\n    \"import_custom_path\": \"\",\n    \"ipv4_only\": false,\n    \"unhook_third_party_js\": false,\n    \"unhook_third_party_css\": false,\n    \"recoveryCustomPath\": \"\",\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 1,\n    \"version\": \"4.5.24.3\",\n    \"created\": \"2026-02-05 07:49:10\",\n    \"updated\": \"2026-02-05 07:50:18\"\n}","4.5.24.3","2026-02-05 07:49:10","2026-02-05 07:50:18"),
("2","Dynamic_Entity","","","","","","{\n    \"data\": \"bDmX6Y+fjIdk11EYQpOTqET3uQXKoYyzCcdiNuNDezmxLdYgf5gJ04v\\/hX2eN6ZyvObUFTgfEu8BJdffHts6UQQQH5Et0XYy\",\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 2,\n    \"version\": \"4.5.24.3\",\n    \"created\": \"2026-02-05 07:49:10\",\n    \"updated\": \"2026-02-05 07:49:10\",\n    \"dataIsEncrypted\": true\n}","4.5.24.3","2026-02-05 07:49:10","2026-02-05 07:49:10"),
("3","DUP_PRO_Storage_Entity","","","","","","{\n    \"name\": \"Default\",\n    \"notes\": \"The default location for storage on this server.\",\n    \"storage_type\": -2,\n    \"config\": \"IrRejlXFSe5+AtbVz9PN7qp8DrlHvRFJ2Rk5ObXOcdVEDLVsprq1IbRSUj6UcPa+QbCA+k3FiT3DIYAoMoWyCLBlVW5wW0wZt0HCGJeLp8GSUKSUMtgIHfK8PLdkf94FJNTR6iX3WHhrMoMHuSqPHD\\/MzDtyEeQHQPS+mkZRKs1VcehdP9l3nNujZYuObmwilv8TxPvrNkHLFS4x1VybKtAqV8NO7jSKixgsWXdo0qtyOwgGUtr2oZgGF\\/aXp9uW\",\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 3,\n    \"version\": \"4.5.24.3\",\n    \"created\": \"2026-02-05 07:49:10\",\n    \"updated\": \"2026-02-05 07:49:10\"\n}","4.5.24.3","2026-02-05 07:49:10","2026-02-05 07:49:10"),
("4","EmailSummary","","","","","","{\n    \"manualPackageIds\": [],\n    \"scheduledPackageIds\": [],\n    \"failedPackageIds\": [],\n    \"failedUploads\": [],\n    \"cancelledUploads\": [],\n    \"successfulUploads\": [],\n    \"scheduleIds\": [],\n    \"storageIds\": [],\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 4,\n    \"version\": \"4.5.24.3\",\n    \"created\": \"2026-02-05 07:49:10\",\n    \"updated\": \"2026-02-05 07:49:10\"\n}","4.5.24.3","2026-02-05 07:49:10","2026-02-05 07:49:10"),
("5","DUP_PRO_Package_Template_Entity","","","","","","{\n    \"name\": \"Default\",\n    \"package_name_format\": \"%year%%month%%day%_%sitetitle%\",\n    \"notes\": \"The default template.\",\n    \"filter_sites\": [],\n    \"archive_export_onlydb\": false,\n    \"archive_filter_on\": false,\n    \"archive_filter_dirs\": \"\",\n    \"archive_filter_exts\": \"\",\n    \"archive_filter_files\": \"\",\n    \"archive_filter_names\": false,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"database_filter_on\": false,\n    \"databasePrefixFilter\": false,\n    \"databasePrefixSubFilter\": false,\n    \"database_filter_tables\": \"\",\n    \"database_compatibility_modes\": \"\",\n    \"installer_opts_secure_on\": 0,\n    \"installerPassowrd\": \"j6HANp\\/ZoOCNn5GTtlroQXW+QjM+mK+tOmEZbVXnvl7UPcSMJZNZPyGw1eA9tw\\/s+eja3pcwMinz83vYCFHaWA==\",\n    \"installer_opts_skip_scan\": false,\n    \"installer_opts_db_host\": \"\",\n    \"installer_opts_db_name\": \"\",\n    \"installer_opts_db_user\": \"\",\n    \"installer_opts_cpnl_enable\": false,\n    \"installer_opts_cpnl_host\": \"\",\n    \"installer_opts_cpnl_user\": \"\",\n    \"installer_opts_cpnl_pass\": \"\",\n    \"installer_opts_cpnl_db_action\": \"create\",\n    \"installer_opts_cpnl_db_host\": \"\",\n    \"installer_opts_cpnl_db_name\": \"\",\n    \"installer_opts_cpnl_db_user\": \"\",\n    \"installer_opts_brand\": -2,\n    \"is_default\": true,\n    \"is_manual\": false,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 5,\n    \"version\": \"4.5.24.3\",\n    \"created\": \"2026-02-05 07:49:10\",\n    \"updated\": \"2026-02-05 07:49:10\"\n}","4.5.24.3","2026-02-05 07:49:10","2026-02-05 07:49:10"),
("6","DUP_PRO_Package_Template_Entity","","","","","","{\n    \"name\": \"[Manual Mode]\",\n    \"package_name_format\": \"%year%%month%%day%_%sitetitle%\",\n    \"notes\": \"The default template.\",\n    \"filter_sites\": \"\",\n    \"archive_export_onlydb\": false,\n    \"archive_filter_on\": false,\n    \"archive_filter_dirs\": \"\",\n    \"archive_filter_exts\": \"\",\n    \"archive_filter_files\": \"\",\n    \"archive_filter_names\": false,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"database_filter_on\": false,\n    \"databasePrefixFilter\": false,\n    \"databasePrefixSubFilter\": false,\n    \"database_filter_tables\": \"\",\n    \"database_compatibility_modes\": \"\",\n    \"installer_opts_secure_on\": 0,\n    \"installerPassowrd\": \"CPUUu1acYDMgwEm+DXkopwO2\\/E32P5iEzfbFQXL7AC+m6nLrOKwgZhn8v4xHDFXcvbJ65JV5N2EZTfszMolW5JXwevSVwB+YKu1thOZ0vH3jVd1MAOMO5Q==\",\n    \"installer_opts_skip_scan\": false,\n    \"installer_opts_db_host\": \"\",\n    \"installer_opts_db_name\": \"\",\n    \"installer_opts_db_user\": \"\",\n    \"installer_opts_cpnl_enable\": false,\n    \"installer_opts_cpnl_host\": \"\",\n    \"installer_opts_cpnl_user\": \"\",\n    \"installer_opts_cpnl_pass\": \"\",\n    \"installer_opts_cpnl_db_action\": \"create\",\n    \"installer_opts_cpnl_db_host\": \"\",\n    \"installer_opts_cpnl_db_name\": \"\",\n    \"installer_opts_cpnl_db_user\": \"\",\n    \"installer_opts_brand\": -1,\n    \"is_default\": false,\n    \"is_manual\": true,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 6,\n    \"version\": \"4.5.24.3\",\n    \"created\": \"2026-02-05 07:49:10\",\n    \"updated\": \"2026-02-05 07:50:18\"\n}","4.5.24.3","2026-02-05 07:49:10","2026-02-05 07:50:18"),
("7","LicenseDataEntity","","","","","","{\n    \"licenseKey\": \"aFXwHuTpdbzxDYKrcjipZM+YZbr1PgQ8+FA7qBIlQE5iyQvK+ZvFTiQ7dv6yxI2gWxo5NbgQmrhJiwBmA\\/S0lgo\\/kQx9YEO0XL6eXREijtBJ\\/nzH5OyrEkKO4jvJpJsF\",\n    \"status\": \"g2IIKXAmrPxr3aULYD8PEWKGzGInzJMvCtZ6p9fcpH3GkZ2OQvv9qvODmFAa7EiuU+QISVvtui+wgiIjfxK2Ha9imXa3znyI\",\n    \"type\": \"3OqJ0c0lwvxCWIMxtCpA2MHDaHS8DqoNoTDbU3W4Swe1s6CjJ3CGW09iF\\/\\/VMVu2vMOz2Rapkr8R12WRioED72GBW+lIeVq\\/\",\n    \"data\": \"3Dv\\/QgvpwzGsVdXe+2Obe8VpRCEUH6amz6f0njE76PGidEFk3gUqhK\\/B9mEHH4jR3lBrUFh2ULl0KlWvGBP2KAjfIir8aofUtRuu\\/6LqBAkVJxwHj2XxZMUZ2LLNYXcxrvLB\\/\\/z1OjkzL4cS\\/VAHSvCdwlwJObh+fAehs5TGLjZ6FBoUXRMXoLxHFSFl7hSvR2\\/a\\/nwAhscJEvnJfT12HucKxAgqmik0T6umKtdqERuGgYvQwt6ZOSDjrgkp5xoE6AA01tr4JH+jWX7CE2db7B\\/WSm737ZLjUQaKBO3L1bQe3HPK0Txog+ZSzvri6MFDs7wlo8ttACv03PL7WUXDSE81PPwBJY23QP481AejbJGnMrhAAIA5MgeYge5pxrrFd54tGonXdZrscFOmliWfrNJX8L1eLEE6U8wjQcsfUwR\\/zncyvFHuWjLtNnj58MTnTCEPek31NRfkCIwxWsfSefp90\\/n7Fu2B\",\n    \"lastRemoteUpdate\": \"2026-02-05 07:49:11\",\n    \"lastFailureTime\": \"\",\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 7,\n    \"version\": \"4.5.24.3\",\n    \"created\": \"2026-02-05 07:49:10\",\n    \"updated\": \"2026-02-05 07:49:11\"\n}","4.5.24.3","2026-02-05 07:49:10","2026-02-05 07:49:11"),
("8","DUP_PRO_System_Global_Entity","","","","","","{\n    \"recommended_fixes\": [],\n    \"schedule_failed\": false,\n    \"package_check_ts\": 1770277986,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 8,\n    \"version\": \"4.5.24.3\",\n    \"created\": \"2026-02-05 07:49:11\",\n    \"updated\": \"2026-02-05 07:53:06\"\n}","4.5.24.3","2026-02-05 07:49:11","2026-02-05 07:53:06");

INSERT IGNORE INTO `YTcMX_fluentform_forms` VALUES 
("1","Contact Form Demo","unpublished",NULL,"{\"fields\":[{\"index\":0,\"element\":\"input_name\",\"attributes\":{\"name\":\"names\",\"data-type\":\"name-element\"},\"settings\":{\"container_class\":\"\",\"admin_field_label\":\"Name\",\"conditional_logics\":[]},\"fields\":{\"first_name\":{\"element\":\"input_text\",\"attributes\":{\"type\":\"text\",\"name\":\"first_name\",\"value\":\"\",\"id\":\"\",\"class\":\"\",\"placeholder\":\"First Name\"},\"settings\":{\"container_class\":\"\",\"label\":\"First Name\",\"help_message\":\"\",\"visible\":true,\"validation_rules\":{\"required\":{\"value\":false,\"message\":\"This field is required\"}},\"conditional_logics\":[]},\"editor_options\":{\"template\":\"inputText\"}},\"middle_name\":{\"element\":\"input_text\",\"attributes\":{\"type\":\"text\",\"name\":\"middle_name\",\"value\":\"\",\"id\":\"\",\"class\":\"\",\"placeholder\":\"\",\"required\":false},\"settings\":{\"container_class\":\"\",\"label\":\"Middle Name\",\"help_message\":\"\",\"error_message\":\"\",\"visible\":false,\"validation_rules\":{\"required\":{\"value\":false,\"message\":\"This field is required\"}},\"conditional_logics\":[]},\"editor_options\":{\"template\":\"inputText\"}},\"last_name\":{\"element\":\"input_text\",\"attributes\":{\"type\":\"text\",\"name\":\"last_name\",\"value\":\"\",\"id\":\"\",\"class\":\"\",\"placeholder\":\"Last Name\",\"required\":false},\"settings\":{\"container_class\":\"\",\"label\":\"Last Name\",\"help_message\":\"\",\"error_message\":\"\",\"visible\":true,\"validation_rules\":{\"required\":{\"value\":false,\"message\":\"This field is required\"}},\"conditional_logics\":[]},\"editor_options\":{\"template\":\"inputText\"}}},\"editor_options\":{\"title\":\"Name Fields\",\"element\":\"name-fields\",\"icon_class\":\"ff-edit-name\",\"template\":\"nameFields\"},\"uniqElKey\":\"el_1570866006692\"},{\"index\":1,\"element\":\"input_email\",\"attributes\":{\"type\":\"email\",\"name\":\"email\",\"value\":\"\",\"id\":\"\",\"class\":\"\",\"placeholder\":\"Email Address\"},\"settings\":{\"container_class\":\"\",\"label\":\"Email\",\"label_placement\":\"\",\"help_message\":\"\",\"admin_field_label\":\"\",\"validation_rules\":{\"required\":{\"value\":true,\"message\":\"This field is required\"},\"email\":{\"value\":true,\"message\":\"This field must contain a valid email\"}},\"conditional_logics\":[]},\"editor_options\":{\"title\":\"Email Address\",\"icon_class\":\"ff-edit-email\",\"template\":\"inputText\"},\"uniqElKey\":\"el_1570866012914\"},{\"index\":2,\"element\":\"input_text\",\"attributes\":{\"type\":\"text\",\"name\":\"subject\",\"value\":\"\",\"class\":\"\",\"placeholder\":\"Subject\"},\"settings\":{\"container_class\":\"\",\"label\":\"Subject\",\"label_placement\":\"\",\"admin_field_label\":\"Subject\",\"help_message\":\"\",\"validation_rules\":{\"required\":{\"value\":false,\"message\":\"This field is required\"}},\"conditional_logics\":{\"type\":\"any\",\"status\":false,\"conditions\":[{\"field\":\"\",\"value\":\"\",\"operator\":\"\"}]}},\"editor_options\":{\"title\":\"Simple Text\",\"icon_class\":\"ff-edit-text\",\"template\":\"inputText\"},\"uniqElKey\":\"el_1570878958648\"},{\"index\":3,\"element\":\"textarea\",\"attributes\":{\"name\":\"message\",\"value\":\"\",\"id\":\"\",\"class\":\"\",\"placeholder\":\"Your Message\",\"rows\":4,\"cols\":2},\"settings\":{\"container_class\":\"\",\"label\":\"Your Message\",\"admin_field_label\":\"\",\"label_placement\":\"\",\"help_message\":\"\",\"validation_rules\":{\"required\":{\"value\":true,\"message\":\"This field is required\"}},\"conditional_logics\":{\"type\":\"any\",\"status\":false,\"conditions\":[{\"field\":\"\",\"value\":\"\",\"operator\":\"\"}]}},\"editor_options\":{\"title\":\"Text Area\",\"icon_class\":\"ff-edit-textarea\",\"template\":\"inputTextarea\"},\"uniqElKey\":\"el_1570879001207\"}],\"submitButton\":{\"uniqElKey\":\"el_1524065200616\",\"element\":\"button\",\"attributes\":{\"type\":\"submit\",\"class\":\"\"},\"settings\":{\"align\":\"left\",\"button_style\":\"default\",\"container_class\":\"\",\"help_message\":\"\",\"background_color\":\"#1a7efb\",\"button_size\":\"md\",\"color\":\"#ffffff\",\"button_ui\":{\"type\":\"default\",\"text\":\"Submit Form\",\"img_url\":\"\"}},\"editor_options\":{\"title\":\"Submit Button\"}}}","0","",NULL,"1","2025-08-31 21:01:54","2025-09-04 15:46:33"),
("2","Subscription Form","unpublished",NULL,"{\"fields\":[{\"index\":1,\"element\":\"container\",\"attributes\":[],\"settings\":{\"container_class\":\"\",\"conditional_logics\":{\"type\":\"any\",\"status\":false,\"conditions\":[{\"field\":\"\",\"value\":\"\",\"operator\":\"\"}]}},\"columns\":[{\"fields\":[{\"index\":1,\"element\":\"input_email\",\"attributes\":{\"type\":\"email\",\"name\":\"email\",\"value\":\"\",\"id\":\"\",\"class\":\"\",\"placeholder\":\"Your Email Address\"},\"settings\":{\"container_class\":\"\",\"label\":\"\",\"label_placement\":\"\",\"help_message\":\"\",\"admin_field_label\":\"Email\",\"validation_rules\":{\"required\":{\"value\":true,\"message\":\"This field is required\"},\"email\":{\"value\":true,\"message\":\"This field must contain a valid email\"}},\"conditional_logics\":[],\"is_unique\":\"no\",\"unique_validation_message\":\"Email address need to be unique.\"},\"editor_options\":{\"title\":\"Email Address\",\"icon_class\":\"ff-edit-email\",\"template\":\"inputText\"},\"uniqElKey\":\"el_16231279686950.8779857923682932\"}]},{\"fields\":[{\"index\":15,\"element\":\"custom_submit_button\",\"attributes\":{\"class\":\"\",\"type\":\"submit\"},\"settings\":{\"button_style\":\"\",\"button_size\":\"md\",\"align\":\"left\",\"container_class\":\"\",\"current_state\":\"normal_styles\",\"background_color\":\"\",\"color\":\"\",\"hover_styles\":{\"backgroundColor\":\"#ffffff\",\"borderColor\":\"#1a7efb\",\"color\":\"#1a7efb\",\"borderRadius\":\"\",\"minWidth\":\"100%\"},\"normal_styles\":{\"backgroundColor\":\"#1a7efb\",\"borderColor\":\"#1a7efb\",\"color\":\"#ffffff\",\"borderRadius\":\"\",\"minWidth\":\"100%\"},\"button_ui\":{\"text\":\"Subscribe\",\"type\":\"default\",\"img_url\":\"\"},\"conditional_logics\":{\"type\":\"any\",\"status\":false,\"conditions\":[{\"field\":\"\",\"value\":\"\",\"operator\":\"\"}]}},\"editor_options\":{\"title\":\"Custom Submit Button\",\"icon_class\":\"dashicons dashicons-arrow-right-alt\",\"template\":\"customButton\"},\"uniqElKey\":\"el_16231279798380.5947400167493171\"}]}],\"editor_options\":{\"title\":\"Two Column Container\",\"icon_class\":\"ff-edit-column-2\"},\"uniqElKey\":\"el_16231279284710.40955091024524304\"}],\"submitButton\":{\"uniqElKey\":\"el_1524065200616\",\"element\":\"button\",\"attributes\":{\"type\":\"submit\",\"class\":\"\"},\"settings\":{\"align\":\"left\",\"button_style\":\"default\",\"container_class\":\"\",\"help_message\":\"\",\"background_color\":\"#1a7efb\",\"button_size\":\"md\",\"color\":\"#ffffff\",\"button_ui\":{\"type\":\"default\",\"text\":\"Subscribe\",\"img_url\":\"\"}},\"editor_options\":{\"title\":\"Submit Button\"}}}","0","form",NULL,"1","2025-08-31 21:01:54","2025-09-04 15:46:28");

INSERT IGNORE INTO `YTcMX_fluentform_form_meta` VALUES 
("1","1","template_name","basic_contact_form"),
("2","1","formSettings","{\"confirmation\":{\"redirectTo\":\"samePage\",\"messageToShow\":\"Thank you for your message. We will get in touch with you shortly\",\"customPage\":null,\"samePageFormBehavior\":\"hide_form\",\"customUrl\":null},\"restrictions\":{\"limitNumberOfEntries\":{\"enabled\":false,\"numberOfEntries\":null,\"period\":\"total\",\"limitReachedMsg\":\"Maximum number of entries exceeded.\"},\"scheduleForm\":{\"enabled\":false,\"start\":null,\"end\":null,\"selectedDays\":[\"Monday\",\"Tuesday\",\"Wednesday\",\"Thursday\",\"Friday\",\"Saturday\",\"Sunday\"],\"pendingMsg\":\"Form submission is not started yet.\",\"expiredMsg\":\"Form submission is now closed.\"},\"requireLogin\":{\"enabled\":false,\"requireLoginMsg\":\"You must be logged in to submit the form.\"},\"denyEmptySubmission\":{\"enabled\":false,\"message\":\"Sorry, you cannot submit an empty form. Let\'s hear what you wanna say.\"}},\"layout\":{\"labelPlacement\":\"top\",\"helpMessagePlacement\":\"with_label\",\"errorMessagePlacement\":\"inline\",\"cssClassName\":\"\",\"asteriskPlacement\":\"asterisk-right\"},\"delete_entry_on_submission\":\"no\",\"appendSurveyResult\":{\"enabled\":false,\"showLabel\":false,\"showCount\":false}}"),
("3","1","advancedValidationSettings","{\"status\":false,\"type\":\"all\",\"conditions\":[{\"field\":\"\",\"operator\":\"=\",\"value\":\"\"}],\"error_message\":\"\",\"validation_type\":\"fail_on_condition_met\"}"),
("4","1","double_optin_settings","{\"status\":\"no\",\"confirmation_message\":\"Please check your email inbox to confirm this submission\",\"email_body_type\":\"global\",\"email_subject\":\"Please confirm your form submission\",\"email_body\":\"<h2>Please Confirm Your Submission</h2><p>&nbsp;</p><p style=\"text-align: center;\"><a style=\"color: #ffffff; background-color: #454545; font-size: 16px; border-radius: 5px; text-decoration: none; font-weight: normal; font-style: normal; padding: 0.8rem 1rem; border-color: #0072ff;\" href=\"#confirmation_url#\">Confirm Submission</a></p><p>&nbsp;</p><p>If you received this email by mistake, simply delete it. Your form submission won\'t proceed if you don\'t click the confirmation link above.</p>\",\"email_field\":\"\",\"skip_if_logged_in\":\"yes\",\"skip_if_fc_subscribed\":\"no\"}"),
("5","2","template_name","inline_subscription"),
("6","2","formSettings","{\"confirmation\":{\"redirectTo\":\"samePage\",\"messageToShow\":\"Thank you for your message. We will get in touch with you shortly\",\"customPage\":null,\"samePageFormBehavior\":\"hide_form\",\"customUrl\":null},\"restrictions\":{\"limitNumberOfEntries\":{\"enabled\":false,\"numberOfEntries\":null,\"period\":\"total\",\"limitReachedMsg\":\"Maximum number of entries exceeded.\"},\"scheduleForm\":{\"enabled\":false,\"start\":null,\"end\":null,\"pendingMsg\":\"Form submission is not started yet.\",\"expiredMsg\":\"Form submission is now closed.\"},\"requireLogin\":{\"enabled\":false,\"requireLoginMsg\":\"You must be logged in to submit the form.\"},\"denyEmptySubmission\":{\"enabled\":false,\"message\":\"Sorry, you cannot submit an empty form. Let\'s hear what you wanna say.\"}},\"layout\":{\"labelPlacement\":\"top\",\"helpMessagePlacement\":\"with_label\",\"errorMessagePlacement\":\"inline\",\"asteriskPlacement\":\"asterisk-right\"}}"),
("7","2","notifications","{\"name\":\"Admin Notification Email\",\"sendTo\":{\"type\":\"email\",\"email\":\"{wp.admin_email}\",\"field\":\"email\",\"routing\":[{\"email\":null,\"field\":null,\"operator\":\"=\",\"value\":null}]},\"fromName\":\"\",\"fromEmail\":\"\",\"replyTo\":\"\",\"bcc\":\"\",\"subject\":\"[{inputs.names}] New Form Submission\",\"message\":\"<p>{all_data}<\\/p> <p>This form submitted at: {embed_post.permalink}<\\/p>\",\"conditionals\":{\"status\":false,\"type\":\"all\",\"conditions\":[{\"field\":null,\"operator\":\"=\",\"value\":null}]},\"enabled\":false,\"email_template\":\"\"}"),
("8","2","step_data_persistency_status","no"),
("9","2","_primary_email_field","email");

INSERT IGNORE INTO `YTcMX_fsmpt_email_logs` VALUES 
("1",NULL,"a:1:{i:0;a:1:{s:5:\"email\";s:17:\"admin@avnalaw.com\";}}","Dadman <info@avnalaw.com>","[Wordfence Alert] avnalaw.com ورود مدیر","این ایمیل از وب سایت شما \"گروه وکلای آونا\" توسط افزونه Wordfence در Sunday 30th of November 2025 at 02:11:39 PM ارسال شده است\nآدرس مدیریت وردفنس برای این سایت است: https://avnalaw.com/wp-admin/admin.php?page=Wordfence\nکاربری با نام کاربری \"admin_x9yeemci\" که دسترسی سرپرست دارد به سایت وردپرس شما وارد شده است.\nIP کاربر: 5.239.173.55\nنام هاست کاربر: 5.239.173.55\nمکان کاربر: Iran\n\n\n	Translation is too long to be saved\nتوجه: شما از نسخه رایگان Wordfence استفاده می کنید. امروز به روز رسانی کنید:\n  - به‌روزرسانی‌های فایروال و قوانین موتور اسکن لحظه ای را برای محافظت در صورت ظهور تهدیدها دریافت کنید\n  - بلاک لیست لحظه ای IP دسترسی مخرب ترین IP ها را به سایت شما مسدود می کند\n  - مسدود کردن کشور\n  - بررسی میزان تکراری بودن IP\n  - اسکن ها را برای اجرا بیشتر و در زمان های بهینه برنامه ریزی کنید\n  - دسترسی به پشتیبانی Premium\n  - تخفیف برای خریدهای چند ساله و چند مجوز\n\nبرای ارتقا به Wordfence Premium اینجا را کلیک کنید:\nhttps://www.wordfence.com/zz1/wordfence-signup/\n--\nبرای تغییر تنظیمات هشدار شما برای وردفنس آدرس https://avnalaw.com/wp-admin/admin.php?page=Wordfence&subpage=global_options را ببینید\nبرای مشاهده هشدارهای فعلی وردفنس آدرس https://avnalaw.com/wp-admin/admin.php?page=Wordfence را ببینید\n\n\n\nدیگر مدیر سایت این سایت نیست؟ برای جلوگیری از دریافت هشدارهای امنیتی اینجا را کلیک کنید: https://avnalaw.com/?_wfsf=removeAlertEmail&jwt=eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJlbWFpbCI6ImFkbWluQGF2bmFsYXcuY29tIiwiX2V4cCI6MTc2NTEwNDA5OX0.668VIs8xxUt5ys600fQef9b4jopDOlSfdLVyvJXTPwk","a:4:{s:8:\"reply-to\";a:0:{}s:2:\"cc\";a:0:{}s:3:\"bcc\";a:0:{}s:12:\"content-type\";s:10:\"text/plain\";}","a:0:{}","sent","a:3:{s:4:\"code\";i:422;s:7:\"message\";s:35:\"SMTP Error: Could not authenticate.\";s:6:\"errors\";N;}","a:1:{s:8:\"provider\";s:4:\"smtp\";}","1","0",NULL,"2025-11-30 14:11:41","2025-11-30 14:22:28"),
("2",NULL,"a:1:{i:0;a:1:{s:5:\"email\";s:17:\"admin@avnalaw.com\";}}","Dadman <info@avnalaw.com>","فعالیت Wordfence برای دسامبر 1, 2025 در avnalaw.com","<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\">\n<head>\n	<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\"/>\n	<meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\"/>\n	<title>فعالیت حروف واژه از November 24, 2025 تا December 1, 2025</title>\n	<!-- Targeting Windows Mobile -->\n	<!--[if IEMobile 7]>\n	<style type=\"text/css\">\n\n	</style>\n	<![endif]-->\n\n	<!-- ***********************************************\n	****************************************************\n	END MOBILE TARGETING\n	****************************************************\n	************************************************ -->\n\n	<!--[if gte mso 9]>\n	<style>\n		/* Target Outlook 2007 and 2010 */\n	</style>\n	<![endif]-->\n</head>\n  <body style=\"font-size: 10pt; vertical-align: baseline; line-height: 1; font-family: Helvetica, Arial, sans-serif; text-rendering: optimizeLegibility; color: #000; background-image: none !important; width: 100% !important; -webkit-text-size-adjust: 100%; -ms-text-size-adjust: 100%; background-color: #e6e6e6; margin: 0; padding: 0; border: 0;\" bgcolor=\"#e6e6e6\"><style type=\"text/css\">\nblockquote:before { content: none !important; }\nblockquote:after { content: none !important; }\nq:before { content: none !important; }\nq:after { content: none !important; }\na:focus { outline: thin dotted !important; }\n.clear:after { clear: both !important; }\n.wrapper:after { clear: both !important; }\n.format-status .entry-header:after { clear: both !important; }\n.clear:before { display: table !important; content: \"\" !important; }\n.clear:after { display: table !important; content: \"\" !important; }\n.wrapper:before { display: table !important; content: \"\" !important; }\n.wrapper:after { display: table !important; content: \"\" !important; }\n.format-status .entry-header:before { display: table !important; content: \"\" !important; }\n.format-status .entry-header:after { display: table !important; content: \"\" !important; }\n.menu-toggle:hover { color: #5e5e5e !important; background-color: #ebebeb !important; background-repeat: repeat-x !important; background-image: linear-gradient(top, #f9f9f9, #ebebeb) !important; }\n.menu-toggle:focus { color: #5e5e5e !important; background-color: #ebebeb !important; background-repeat: repeat-x !important; background-image: linear-gradient(top, #f9f9f9, #ebebeb) !important; }\nbutton:hover { color: #5e5e5e !important; background-color: #ebebeb !important; background-repeat: repeat-x !important; background-image: linear-gradient(top, #f9f9f9, #ebebeb) !important; }\ninput[type=\"submit\"]:hover { color: #5e5e5e !important; background-color: #ebebeb !important; background-repeat: repeat-x !important; background-image: linear-gradient(top, #f9f9f9, #ebebeb) !important; }\ninput[type=\"button\"]:hover { color: #5e5e5e !important; background-color: #ebebeb !important; background-repeat: repeat-x !important; background-image: linear-gradient(top, #f9f9f9, #ebebeb) !important; }\ninput[type=\"reset\"]:hover { color: #5e5e5e !important; background-color: #ebebeb !important; background-repeat: repeat-x !important; background-image: linear-gradient(top, #f9f9f9, #ebebeb) !important; }\narticle.post-password-required input[type=submit]:hover { color: #5e5e5e !important; background-color: #ebebeb !important; background-repeat: repeat-x !important; background-image: linear-gradient(top, #f9f9f9, #ebebeb) !important; }\n.menu-toggle:active { color: #757575 !important; background-color: #e1e1e1 !important; background-repeat: repeat-x !important; background-image: linear-gradient(top, #ebebeb, #e1e1e1) !important; box-shadow: inset 0 0 8px 2px #c6c6c6, 0 1px 0 0 #f4f4f4 !important; border-color: transparent !important; }\nbutton:active { color: #757575 !important; background-color: #e1e1e1 !important; background-repeat: repeat-x !important; background-image: linear-gradient(top, #ebebeb, #e1e1e1) !important; box-shadow: inset 0 0 8px 2px #c6c6c6, 0 1px 0 0 #f4f4f4 !important; border-color: transparent !important; }\ninput[type=\"submit\"]:active { color: #757575 !important; background-color: #e1e1e1 !important; background-repeat: repeat-x !important; background-image: linear-gradient(top, #ebebeb, #e1e1e1) !important; box-shadow: inset 0 0 8px 2px #c6c6c6, 0 1px 0 0 #f4f4f4 !important; border-color: transparent !important; }\ninput[type=\"button\"]:active { color: #757575 !important; background-color: #e1e1e1 !important; background-repeat: repeat-x !important; background-image: linear-gradient(top, #ebebeb, #e1e1e1) !important; box-shadow: inset 0 0 8px 2px #c6c6c6, 0 1px 0 0 #f4f4f4 !important; border-color: transparent !important; }\ninput[type=\"reset\"]:active { color: #757575 !important; background-color: #e1e1e1 !important; background-repeat: repeat-x !important; background-image: linear-gradient(top, #ebebeb, #e1e1e1) !important; box-shadow: inset 0 0 8px 2px #c6c6c6, 0 1px 0 0 #f4f4f4 !important; border-color: transparent !important; }\na:hover { color: #0f3647 !important; }\n.main-navigation .assistive-text:focus { background: #fff !important; border: 2px solid #333 !important; border-radius: 3px !important; clip: auto !important; color: #000 !important; display: block !important; font-size: 12px !important; padding: 12px !important; position: absolute !important; top: 5px !important; left: 5px !important; z-index: 100000 !important; }\n.site-header h1 a:hover { color: #21759b !important; }\n.site-header h2 a:hover { color: #21759b !important; }\n.main-navigation a:hover { color: #21759b !important; }\n.main-navigation a:focus { color: #21759b !important; }\n.widget-area .widget a:hover { color: #21759b !important; }\n.widget-area .widget a:visited { color: #9f9f9f !important; }\nfooter[role=\"contentinfo\"] a:hover { color: #21759b !important; }\n.comments-link a:hover { color: #21759b !important; }\n.entry-meta a:hover { color: #21759b !important; }\n.entry-content a:visited { color: #9f9f9f !important; }\n.comment-content a:visited { color: #9f9f9f !important; }\narticle.format-aside h1 a:hover { color: #2e3542 !important; }\n.format-status .entry-header header a:hover { color: #21759b !important; }\n.comments-area article header a:hover { color: #21759b !important; }\n.comments-area article header cite a:hover { text-decoration: underline !important; }\na.comment-reply-link:hover { color: #21759b !important; }\na.comment-edit-link:hover { color: #21759b !important; }\n.template-front-page .widget-area .widget li a:hover { color: #21759b !important; }\n@-ms-viewport { width: device-width !important; }\n@viewport { width: device-width !important; }\n.main-navigation li a:hover { color: #000 !important; }\n.main-navigation li a:focus { color: #000 !important; }\n.main-navigation ul li:hover > ul { border-left: 0 !important; clip: inherit !important; overflow: inherit !important; height: inherit !important; width: inherit !important; }\n.main-navigation ul li:focus > ul { border-left: 0 !important; clip: inherit !important; overflow: inherit !important; height: inherit !important; width: inherit !important; }\n.main-navigation li ul li a:hover { background: #e3e3e3 !important; color: #444 !important; }\n.main-navigation li ul li a:focus { background: #e3e3e3 !important; color: #444 !important; }\nfooter a[rel=bookmark]:after { content: \" [\" attr(href) \"] \" !important; }\nfooter a[rel=bookmark]:visited:after { content: \" [\" attr(href) \"] \" !important; }\nh1 a:active { color: red !important; }\nh2 a:active { color: red !important; }\nh3 a:active { color: red !important; }\nh4 a:active { color: red !important; }\nh5 a:active { color: red !important; }\nh6 a:active { color: red !important; }\nh1 a:visited { color: purple !important; }\nh2 a:visited { color: purple !important; }\nh3 a:visited { color: purple !important; }\nh4 a:visited { color: purple !important; }\nh5 a:visited { color: purple !important; }\nh6 a:visited { color: purple !important; }\n.button:hover { background: none repeat scroll 0 0 #1E8CBE !important; border-color: #0074A2 !important; box-shadow: 0 1px 0 rgba(120, 200, 230, 0.6) inset !important; color: #FFF !important; }\n.button:active { background: none repeat scroll 0 0 #1E8CBE !important; border-color: #0074A2 !important; box-shadow: 0 1px 0 rgba(120, 200, 230, 0.6) inset !important; color: #FFF !important; }\n.button:focus { background: none repeat scroll 0 0 #1E8CBE !important; border-color: #0074A2 !important; box-shadow: 0 1px 0 rgba(120, 200, 230, 0.6) inset !important; color: #FFF !important; }\n</style>\n<!-- Wrapper/Container Table: Use a wrapper table to control the width and the background color consistently of your email. Use this approach instead of setting attributes on the body tag. -->\n<table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" id=\"backgroundTable\" style=\"font-size: 100%; vertical-align: baseline; border-collapse: collapse; border-spacing: 0; width: 100% !important; line-height: 100% !important; mso-table-lspace: 0pt; mso-table-rspace: 0pt; margin: 0 auto; padding: 0; border: 0;\">\n	<tr style=\"font-size: 100%; vertical-align: baseline; margin: 0; padding: 0; border: 0;\">\n		<td valign=\"top\" style=\"font-size: 100%; vertical-align: baseline; font-weight: normal; text-align: left; border-collapse: collapse; margin: 0; padding: 0; border: 0;\" align=\"left\">\n			<div class=\"wrapper wp-core-ui\" style=\"font-size: 100%; vertical-align: baseline; border-top-style: none; box-shadow: none; line-height: 1.4; width: 600px; background-color: #FFFFFF; margin: 0 auto; padding: 20px; border: 0;\">\n				<div style=\"float: right; text-align: right; line-height: 1.1; color: #666666; font-size: 100%; vertical-align: baseline; margin: 20px 0 0; padding: 0; border: 0;\" align=\"right\">\n					فعالیت حروف واژه از <strong>November 24, 2025</strong> تا <strong>December 1, 2025</strong>				</div>\n				<a href=\"https://www.wordfence.com/zz5/\" style=\"font-size: 100%; vertical-align: baseline; outline: none; color: orange; text-decoration: none; margin: 0; padding: 0; border: 0;\"><img src=\"http://avnalaw.com/wp-content/plugins/wordfence/images/logo.png\" alt=\"\" style=\"font-size: 100%; vertical-align: baseline; -ms-interpolation-mode: bicubic; outline: none; text-decoration: none; margin: 0; padding: 0; border: 0 none; width: 560px;\" /></a>\n\n				<p style=\"font-size: 100%; vertical-align: baseline; margin: 1em 0; padding: 0; border: 0;\">\n					این ایمیل از وب‌سایت شما <a href=\"http://avnalaw.com\">http://avnalaw.com</a> ارسال شده است و خلاصه‌ای از فعالیت‌های امنیتی است که Wordfence برای بازه November 24, 2025 تا December 1, 2025 نظارت می‌کند. NOTE: You are using the free version of Wordfence and are missing out on features like real-time firewall rule and malware signature updates, country blocking, and detecting if your site IP is sending spam. <a href=\"https://www.wordfence.com/zz6/\">Click here to upgrade to Wordfence Premium now</a>.				</p>\n\n				<h2 style=\"font-size: 20px; vertical-align: baseline; clear: both; color: #222 !important; margin: 20px 0 4px; padding: 0; border: 0;\">\n					10 آی پی جدید مسدود شده اند				</h2>\n\n				\n				<table class=\"activity-table\" style=\"font-size: 100%; vertical-align: baseline; border-collapse: collapse; border-spacing: 0; mso-table-lspace: 0pt; mso-table-rspace: 0pt; width: 100%; max-width: 100%; margin: 0; padding: 0; border: 0;\">\n					<thead style=\"font-size: 100%; vertical-align: baseline; margin: 0; padding: 0; border: 0;\">\n						<tr style=\"font-size: 100%; vertical-align: baseline; margin: 0; padding: 0; border: 0;\">\n							<th style=\"font-size: 100%; vertical-align: baseline; font-weight: bold; text-align: left; color: #FFFFFF; background-color: #222; margin: 0; padding: 6px 4px; border: 1px solid #474747;\" align=\"left\" bgcolor=\"#222\" valign=\"baseline\">آی پی</th>\n							<th style=\"font-size: 100%; vertical-align: baseline; font-weight: bold; text-align: left; color: #FFFFFF; background-color: #222; margin: 0; padding: 6px 4px; border: 1px solid #474747;\" align=\"left\" bgcolor=\"#222\" valign=\"baseline\">کشور</th>\n							<th style=\"font-size: 100%; vertical-align: baseline; font-weight: bold; text-align: left; color: #FFFFFF; background-color: #222; margin: 0; padding: 6px 4px; border: 1px solid #474747;\" align=\"left\" bgcolor=\"#222\" valign=\"baseline\">دفعات مسدودیت</th>\n						</tr>\n					</thead>\n					<tbody style=\"font-size: 100%; vertical-align: baseline; margin: 0; padding: 0; border: 0;\">\n													<tr class=\"odd\" style=\"font-size: 100%; vertical-align: baseline; margin: 0; padding: 0; border: 0;\">\n								<td style=\"font-size: 100%; vertical-align: baseline; font-weight: normal; text-align: left; border-collapse: collapse; margin: 0; padding: 6px 4px; border: 1px solid #cccccc;\" align=\"left\" valign=\"baseline\"><code style=\"font-size: 100%; vertical-align: baseline; margin: 0; padding: 0; border: 0;\">128.90.135.19</code></td>\n								<td style=\"font-size: 100%; vertical-align: baseline; font-weight: normal; text-align: left; border-collapse: collapse; margin: 0; padding: 6px 4px; border: 1px solid #cccccc;\" align=\"left\" valign=\"baseline\">\n																		<span class=\"wf-flag wf-flag-nl\" style=\"display: inline-block;vertical-align: middle;\n	margin: 0;padding: 0; border: 0;background-repeat: no-repeat;background-position: -64px -154px;width: 16px;height: 11px;background-image: url(\'http://avnalaw.com/wp-content/plugins/wordfence/images/flags.png\')\"></span>\n										&nbsp;\n										هلند																	</td>\n								<td style=\"font-size: 100%; vertical-align: baseline; font-weight: normal; text-align: left; border-collapse: collapse; margin: 0; padding: 6px 4px; border: 1px solid #cccccc;\" align=\"left\" valign=\"baseline\">8</td>\n							</tr>\n													<tr class=\"even\" style=\"font-size: 100%; vertical-align: baseline; margin: 0; padding: 0; border: 0;\">\n								<td style=\"font-size: 100%; vertical-align: baseline; font-weight: normal; text-align: left; border-collapse: collapse; margin: 0; padding: 6px 4px; border: 1px solid #cccccc;background-color: #eeeeee;\" align=\"left\" valign=\"baseline\"><code style=\"font-size: 100%; vertical-align: baseline; margin: 0; padding: 0; border: 0;\">159.223.166.76</code></td>\n								<td style=\"font-size: 100%; vertical-align: baseline; font-weight: normal; text-align: left; border-collapse: collapse; margin: 0; padding: 6px 4px; border: 1px solid #cccccc;background-color: #eeeeee;\" align=\"left\" valign=\"baseline\">\n																		<span class=\"wf-flag wf-flag-us\" style=\"display: inline-block;vertical-align: middle;\n	margin: 0;padding: 0; border: 0;background-repeat: no-repeat;background-position: -32px -220px;width: 16px;height: 11px;background-image: url(\'http://avnalaw.com/wp-content/plugins/wordfence/images/flags.png\')\"></span>\n										&nbsp;\n										ایالات متحده																	</td>\n								<td style=\"font-size: 100%; vertical-align: baseline; font-weight: normal; text-align: left; border-collapse: collapse; margin: 0; padding: 6px 4px; border: 1px solid #cccccc;background-color: #eeeeee;\" align=\"left\" valign=\"baseline\">2</td>\n							</tr>\n													<tr class=\"odd\" style=\"font-size: 100%; vertical-align: baseline; margin: 0; padding: 0; border: 0;\">\n								<td style=\"font-size: 100%; vertical-align: baseline; font-weight: normal; text-align: left; border-collapse: collapse; margin: 0; padding: 6px 4px; border: 1px solid #cccccc;\" align=\"left\" valign=\"baseline\"><code style=\"font-size: 100%; vertical-align: baseline; margin: 0; padding: 0; border: 0;\">139.59.33.41</code></td>\n								<td style=\"font-size: 100%; vertical-align: baseline; font-weight: normal; text-align: left; border-collapse: collapse; margin: 0; padding: 6px 4px; border: 1px solid #cccccc;\" align=\"left\" valign=\"baseline\">\n																		<span class=\"wf-flag wf-flag-in\" style=\"display: inline-block;vertical-align: middle;\n	margin: 0;padding: 0; border: 0;background-repeat: no-repeat;background-position: -48px -99px;width: 16px;height: 11px;background-image: url(\'http://avnalaw.com/wp-content/plugins/wordfence/images/flags.png\')\"></span>\n										&nbsp;\n										هند																	</td>\n								<td style=\"font-size: 100%; vertical-align: baseline; font-weight: normal; text-align: left; border-collapse: collapse; margin: 0; padding: 6px 4px; border: 1px solid #cccccc;\" align=\"left\" valign=\"baseline\">2</td>\n							</tr>\n																	</tbody>\n				</table>\n\n				<p style=\"font-size: 100%; vertical-align: baseline; margin: 1em 0; padding: 0; border: 0;\">\n					<a class=\"button\" href=\"http://avnalaw.com/wp-admin/admin.php?page=WordfenceWAF#top#blocking\"  style=\"font-size: 13px; vertical-align: baseline; outline: none; color: #FFF; text-decoration: none; display: inline-block; line-height: 26px; height: 28px; cursor: pointer; border-radius: 3px; white-space: nowrap; box-sizing: border-box; box-shadow: 0 1px 0 rgba(120, 200, 230, 0.5) inset, 0 1px 0 rgba(0, 0, 0, 0.15); background-image: none; background-attachment: scroll; background-repeat: repeat; background-color: #2EA2CC; margin: 0; padding: 0 10px 1px; border: 1px solid #0074a2;\">بروزرسانی آی پی های مسدود شده</a>\n				</p>\n\n				\n				<h2 style=\"font-size: 20px; vertical-align: baseline; clear: both; color: #222 !important; margin: 20px 0 4px; padding: 0; border: 0;\">10 کشور برتر که مسدود شده اند</h2>\n\n				<table class=\"activity-table\" style=\"font-size: 100%; vertical-align: baseline; border-collapse: collapse; border-spacing: 0; mso-table-lspace: 0pt; mso-table-rspace: 0pt; width: 100%; max-width: 100%; margin: 0; padding: 0; border: 0;\">\n					<thead style=\"font-size: 100%; vertical-align: baseline; margin: 0; padding: 0; border: 0;\">\n						<tr style=\"font-size: 100%; vertical-align: baseline; margin: 0; padding: 0; border: 0;\">\n							<th style=\"font-size: 100%; vertical-align: baseline; font-weight: bold; text-align: left; color: #FFFFFF; background-color: #222; margin: 0; padding: 6px 4px; border: 1px solid #474747;\" align=\"left\" bgcolor=\"#222\" valign=\"baseline\">کشور</th>\n							<th style=\"font-size: 100%; vertical-align: baseline; font-weight: bold; text-align: left; color: #FFFFFF; background-color: #222; margin: 0; padding: 6px 4px; border: 1px solid #474747;\" align=\"left\" bgcolor=\"#222\" valign=\"baseline\">کل آی پی های مسدود شده</th>\n							<th style=\"font-size: 100%; vertical-align: baseline; font-weight: bold; text-align: left; color: #FFFFFF; background-color: #222; margin: 0; padding: 6px 4px; border: 1px solid #474747;\" align=\"left\" bgcolor=\"#222\" valign=\"baseline\">دفعات مسدودیت</th>\n						</tr>\n					</thead>\n					<tbody style=\"font-size: 100%; vertical-align: baseline; margin: 0; padding: 0; border: 0;\">\n														<tr class=\"odd\" style=\"font-size: 100%; vertical-align: baseline; margin: 0; padding: 0; border: 0;\">\n									<td style=\"font-size: 100%; vertical-align: baseline; font-weight: normal; text-align: left; border-collapse: collapse; margin: 0; padding: 6px 4px; border: 1px solid #cccccc;\" align=\"left\" valign=\"baseline\">\n																					<span class=\"wf-flag wf-flag-nl\" style=\"display: inline-block;vertical-align: middle;\n													margin: 0;padding: 0; border: 0;background-repeat: no-repeat;background-position: -64px -154px;width: 16px;height: 11px;background-image: url(\'http://avnalaw.com/wp-content/plugins/wordfence/images/flags.png\')\"></span>\n											&nbsp;\n											هلند																			</td>\n									<td style=\"font-size: 100%; vertical-align: baseline; font-weight: normal; text-align: left; border-collapse: collapse; margin: 0; padding: 6px 4px; border: 1px solid #cccccc;\" align=\"left\" valign=\"baseline\">1</td>\n									<td style=\"font-size: 100%; vertical-align: baseline; font-weight: normal; text-align: left; border-collapse: collapse; margin: 0; padding: 6px 4px; border: 1px solid #cccccc;\" align=\"left\" valign=\"baseline\">8</td>\n								</tr>\n															<tr class=\"even\" style=\"font-size: 100%; vertical-align: baseline; margin: 0; padding: 0; border: 0;\">\n									<td style=\"font-size: 100%; vertical-align: baseline; font-weight: normal; text-align: left; border-collapse: collapse; margin: 0; padding: 6px 4px; border: 1px solid #cccccc;background-color: #eeeeee;\" align=\"left\" valign=\"baseline\">\n																					<span class=\"wf-flag wf-flag-in\" style=\"display: inline-block;vertical-align: middle;\n													margin: 0;padding: 0; border: 0;background-repeat: no-repeat;background-position: -48px -99px;width: 16px;height: 11px;background-image: url(\'http://avnalaw.com/wp-content/plugins/wordfence/images/flags.png\')\"></span>\n											&nbsp;\n											هند																			</td>\n									<td style=\"font-size: 100%; vertical-align: baseline; font-weight: normal; text-align: left; border-collapse: collapse; margin: 0; padding: 6px 4px; border: 1px solid #cccccc;background-color: #eeeeee;\" align=\"left\" valign=\"baseline\">1</td>\n									<td style=\"font-size: 100%; vertical-align: baseline; font-weight: normal; text-align: left; border-collapse: collapse; margin: 0; padding: 6px 4px; border: 1px solid #cccccc;background-color: #eeeeee;\" align=\"left\" valign=\"baseline\">2</td>\n								</tr>\n															<tr class=\"odd\" style=\"font-size: 100%; vertical-align: baseline; margin: 0; padding: 0; border: 0;\">\n									<td style=\"font-size: 100%; vertical-align: baseline; font-weight: normal; text-align: left; border-collapse: collapse; margin: 0; padding: 6px 4px; border: 1px solid #cccccc;\" align=\"left\" valign=\"baseline\">\n																					<span class=\"wf-flag wf-flag-us\" style=\"display: inline-block;vertical-align: middle;\n													margin: 0;padding: 0; border: 0;background-repeat: no-repeat;background-position: -32px -220px;width: 16px;height: 11px;background-image: url(\'http://avnalaw.com/wp-content/plugins/wordfence/images/flags.png\')\"></span>\n											&nbsp;\n											ایالات متحده																			</td>\n									<td style=\"font-size: 100%; vertical-align: baseline; font-weight: normal; text-align: left; border-collapse: collapse; margin: 0; padding: 6px 4px; border: 1px solid #cccccc;\" align=\"left\" valign=\"baseline\">1</td>\n									<td style=\"font-size: 100%; vertical-align: baseline; font-weight: normal; text-align: left; border-collapse: collapse; margin: 0; padding: 6px 4px; border: 1px solid #cccccc;\" align=\"left\" valign=\"baseline\">2</td>\n								</tr>\n																		</tbody>\n				</table>\n\n				<p style=\"font-size: 100%; vertical-align: baseline; margin: 1em 0; padding: 0; border: 0;\">\n					<a class=\"button\" href=\"http://avnalaw.com/wp-admin/admin.php?page=WordfenceWAF#top#blocking\" style=\"font-size: 13px; vertical-align: baseline; outline: none; color: #FFF; text-decoration: none; display: inline-block; line-height: 26px; height: 28px; cursor: pointer; border-radius: 3px; white-space: nowrap; box-sizing: border-box; box-shadow: 0 1px 0 rgba(120, 200, 230, 0.5) inset, 0 1px 0 rgba(0, 0, 0, 0.15); background-image: none; background-attachment: scroll; background-repeat: repeat; background-color: #2EA2CC; margin: 0; padding: 0 10px 1px; border: 1px solid #0074a2;\">بروز رسانی کشورهای مسدود شده</a>\n				</p>\n\n				\n				<h2 style=\"font-size: 20px; vertical-align: baseline; clear: both; color: #222 !important; margin: 20px 0 4px; padding: 0; border: 0;\">10  کاربر برتر که برای ورود به سایت با شکست مواجه شده اند</h2>\n\n				<table class=\"activity-table\" style=\"font-size: 100%; vertical-align: baseline; border-collapse: collapse; border-spacing: 0; mso-table-lspace: 0pt; mso-table-rspace: 0pt; width: 100%; max-width: 100%; margin: 0; padding: 0; border: 0;\">\n					<thead style=\"font-size: 100%; vertical-align: baseline; margin: 0; padding: 0; border: 0;\">\n						<tr style=\"font-size: 100%; vertical-align: baseline; margin: 0; padding: 0; border: 0;\">\n							<th style=\"font-size: 100%; vertical-align: baseline; font-weight: bold; text-align: left; color: #FFFFFF; background-color: #222; margin: 0; padding: 6px 4px; border: 1px solid #474747;\" align=\"left\" bgcolor=\"#222\" valign=\"baseline\">نام ‌کاربری</th>\n							<th style=\"font-size: 100%; vertical-align: baseline; font-weight: bold; text-align: left; color: #FFFFFF; background-color: #222; margin: 0; padding: 6px 4px; border: 1px solid #474747;\" align=\"left\" bgcolor=\"#222\" valign=\"baseline\">تعداد تلاش برای ورود</th>\n							<th style=\"font-size: 100%; vertical-align: baseline; font-weight: bold; text-align: left; color: #FFFFFF; background-color: #222; margin: 0; padding: 6px 4px; border: 1px solid #474747;\" align=\"left\" bgcolor=\"#222\" valign=\"baseline\">کاربر عضو سایت</th>\n						</tr>\n					</thead>\n					<tbody style=\"font-size: 100%; vertical-align: baseline; margin: 0; padding: 0; border: 0;\">\n																													<tr class=\"odd\" style=\"font-size: 100%; vertical-align: baseline; margin: 0; padding: 0; border: 0;\">\n									<td style=\"font-size: 100%; vertical-align: baseline; font-weight: normal; text-align: left; border-collapse: collapse; margin: 0; padding: 6px 4px; border: 1px solid #cccccc; word-wrap: break-word; word-break: break-all; \" align=\"left\" valign=\"baseline\">info@dadmanlaw.com</td>\n									<td style=\"font-size: 100%; vertical-align: baseline; font-weight: normal; text-align: left; border-collapse: collapse; margin: 0; padding: 6px 4px; border: 1px solid #cccccc;\" align=\"left\" valign=\"baseline\">1</td>\n									<td style=\"font-size: 100%; vertical-align: baseline; font-weight: normal; text-align: left; border-collapse: collapse; margin: 0; padding: 6px 4px; border: 1px solid #cccccc;\" align=\"left\" valign=\"baseline\" class=\"loginFailInvalidUsername\">خیر</td>\n								</tr>\n																		</tbody>\n				</table>\n\n				<p style=\"font-size: 100%; vertical-align: baseline; margin: 1em 0; padding: 0; border: 0;\">\n					<a class=\"button\" href=\"http://avnalaw.com/wp-admin/admin.php?page=WordfenceWAF&subpage=waf_options#waf-options-bruteforce\" style=\"font-size: 13px; vertical-align: baseline; outline: none; color: #FFF; text-decoration: none; display: inline-block; line-height: 26px; height: 28px; cursor: pointer; border-radius: 3px; white-space: nowrap; box-sizing: border-box; box-shadow: 0 1px 0 rgba(120, 200, 230, 0.5) inset, 0 1px 0 rgba(0, 0, 0, 0.15); background-image: none; background-attachment: scroll; background-repeat: repeat; background-color: #2EA2CC; margin: 0; padding: 0 10px 1px; border: 1px solid #0074a2;\">بروز رسانی تنظیمات امنیتی ورود</a>\n				</p>\n				\n								\n				<h2 style=\"font-size: 20px; vertical-align: baseline; clear: both; color: #222 !important; margin: 20px 0 4px; padding: 0; border: 0;\">حملاتی که اخیرا مسدود شده اند</h2>\n				\n				<table class=\"activity-table\" style=\"font-size: 100%; vertical-align: baseline; border-collapse: collapse; border-spacing: 0; mso-table-lspace: 0pt; mso-table-rspace: 0pt; width: 100%; max-width: 100%; margin: 0; padding: 0; border: 0;\">\n					<thead style=\"font-size: 100%; vertical-align: baseline; margin: 0; padding: 0; border: 0;\">\n					<tr style=\"font-size: 100%; vertical-align: baseline; margin: 0; padding: 0; border: 0;\">\n						<th style=\"font-size: 100%; vertical-align: baseline; font-weight: bold; text-align: left; color: #FFFFFF; background-color: #222; margin: 0; padding: 6px 4px; border: 1px solid #474747;\" align=\"left\" bgcolor=\"#222\" valign=\"baseline\">زمان</th>\n						<th style=\"font-size: 100%; vertical-align: baseline; font-weight: bold; text-align: left; color: #FFFFFF; background-color: #222; margin: 0; padding: 6px 4px; border: 1px solid #474747;\" align=\"left\" bgcolor=\"#222\" valign=\"baseline\">آی پی / عمل</th>\n					</tr>\n					</thead>\n					<tbody style=\"font-size: 100%; vertical-align: baseline; margin: 0; padding: 0; border: 0;\">\n																						<tr class=\"odd\" style=\"font-size: 100%; vertical-align: baseline; margin: 0; padding: 0; border: 0;\">\n							<td style=\"font-size: 100%; vertical-align: baseline; font-weight: normal; text-align: left; border-collapse: collapse; margin: 0; padding: 6px 4px; border: 1px solid #cccccc;white-space: nowrap;\" align=\"left\" valign=\"baseline\">December 1, 2025<br>10:44am</td>\n							<td style=\"font-size: 100%; vertical-align: baseline; font-weight: normal; text-align: left; border-collapse: collapse; margin: 0; padding: 6px 4px; border: 1px solid #cccccc;\" align=\"left\" valign=\"baseline\">\n								<div style=\"font-weight: bold; font-size: 12px;\">128.90.135.19 (هلند)</div> \n								<pre class=\"display-file\" style=\"font-size: 12px; vertical-align: baseline; width: 420px; margin: 0; padding: 0; border: 0; white-space: normal;\">برای WordPress New Install File Probing مسدود شده است</pre>\n							</td>\n						</tr>\n																	<tr class=\"even\" style=\"font-size: 100%; vertical-align: baseline; margin: 0; padding: 0; border: 0;\">\n							<td style=\"font-size: 100%; vertical-align: baseline; font-weight: normal; text-align: left; border-collapse: collapse; margin: 0; padding: 6px 4px; border: 1px solid #cccccc;white-space: nowrap;background-color: #eeeeee;\" align=\"left\" valign=\"baseline\">December 1, 2025<br>10:44am</td>\n							<td style=\"font-size: 100%; vertical-align: baseline; font-weight: normal; text-align: left; border-collapse: collapse; margin: 0; padding: 6px 4px; border: 1px solid #cccccc;background-color: #eeeeee;\" align=\"left\" valign=\"baseline\">\n								<div style=\"font-weight: bold; font-size: 12px;\">128.90.135.19 (هلند)</div> \n								<pre class=\"display-file\" style=\"font-size: 12px; vertical-align: baseline; width: 420px; margin: 0; padding: 0; border: 0; white-space: normal;\">برای WordPress New Install File Probing مسدود شده است</pre>\n							</td>\n						</tr>\n																	<tr class=\"odd\" style=\"font-size: 100%; vertical-align: baseline; margin: 0; padding: 0; border: 0;\">\n							<td style=\"font-size: 100%; vertical-align: baseline; font-weight: normal; text-align: left; border-collapse: collapse; margin: 0; padding: 6px 4px; border: 1px solid #cccccc;white-space: nowrap;\" align=\"left\" valign=\"baseline\">December 1, 2025<br>10:44am</td>\n							<td style=\"font-size: 100%; vertical-align: baseline; font-weight: normal; text-align: left; border-collapse: collapse; margin: 0; padding: 6px 4px; border: 1px solid #cccccc;\" align=\"left\" valign=\"baseline\">\n								<div style=\"font-weight: bold; font-size: 12px;\">128.90.135.19 (هلند)</div> \n								<pre class=\"display-file\" style=\"font-size: 12px; vertical-align: baseline; width: 420px; margin: 0; padding: 0; border: 0; white-space: normal;\">برای WordPress New Install File Probing مسدود شده است</pre>\n							</td>\n						</tr>\n																	<tr class=\"even\" style=\"font-size: 100%; vertical-align: baseline; margin: 0; padding: 0; border: 0;\">\n							<td style=\"font-size: 100%; vertical-align: baseline; font-weight: normal; text-align: left; border-collapse: collapse; margin: 0; padding: 6px 4px; border: 1px solid #cccccc;white-space: nowrap;background-color: #eeeeee;\" align=\"left\" valign=\"baseline\">December 1, 2025<br>10:44am</td>\n							<td style=\"font-size: 100%; vertical-align: baseline; font-weight: normal; text-align: left; border-collapse: collapse; margin: 0; padding: 6px 4px; border: 1px solid #cccccc;background-color: #eeeeee;\" align=\"left\" valign=\"baseline\">\n								<div style=\"font-weight: bold; font-size: 12px;\">128.90.135.19 (هلند)</div> \n								<pre class=\"display-file\" style=\"font-size: 12px; vertical-align: baseline; width: 420px; margin: 0; padding: 0; border: 0; white-space: normal;\">برای WordPress New Install File Probing مسدود شده است</pre>\n							</td>\n						</tr>\n																	<tr class=\"odd\" style=\"font-size: 100%; vertical-align: baseline; margin: 0; padding: 0; border: 0;\">\n							<td style=\"font-size: 100%; vertical-align: baseline; font-weight: normal; text-align: left; border-collapse: collapse; margin: 0; padding: 6px 4px; border: 1px solid #cccccc;white-space: nowrap;\" align=\"left\" valign=\"baseline\">December 1, 2025<br>10:44am</td>\n							<td style=\"font-size: 100%; vertical-align: baseline; font-weight: normal; text-align: left; border-collapse: collapse; margin: 0; padding: 6px 4px; border: 1px solid #cccccc;\" align=\"left\" valign=\"baseline\">\n								<div style=\"font-weight: bold; font-size: 12px;\">128.90.135.19 (هلند)</div> \n								<pre class=\"display-file\" style=\"font-size: 12px; vertical-align: baseline; width: 420px; margin: 0; padding: 0; border: 0; white-space: normal;\">برای WordPress New Install File Probing مسدود شده است</pre>\n							</td>\n						</tr>\n																	<tr class=\"even\" style=\"font-size: 100%; vertical-align: baseline; margin: 0; padding: 0; border: 0;\">\n							<td style=\"font-size: 100%; vertical-align: baseline; font-weight: normal; text-align: left; border-collapse: collapse; margin: 0; padding: 6px 4px; border: 1px solid #cccccc;white-space: nowrap;background-color: #eeeeee;\" align=\"left\" valign=\"baseline\">December 1, 2025<br>10:44am</td>\n							<td style=\"font-size: 100%; vertical-align: baseline; font-weight: normal; text-align: left; border-collapse: collapse; margin: 0; padding: 6px 4px; border: 1px solid #cccccc;background-color: #eeeeee;\" align=\"left\" valign=\"baseline\">\n								<div style=\"font-weight: bold; font-size: 12px;\">128.90.135.19 (هلند)</div> \n								<pre class=\"display-file\" style=\"font-size: 12px; vertical-align: baseline; width: 420px; margin: 0; padding: 0; border: 0; white-space: normal;\">برای WordPress New Install File Probing مسدود شده است</pre>\n							</td>\n						</tr>\n																	<tr class=\"odd\" style=\"font-size: 100%; vertical-align: baseline; margin: 0; padding: 0; border: 0;\">\n							<td style=\"font-size: 100%; vertical-align: baseline; font-weight: normal; text-align: left; border-collapse: collapse; margin: 0; padding: 6px 4px; border: 1px solid #cccccc;white-space: nowrap;\" align=\"left\" valign=\"baseline\">December 1, 2025<br>10:44am</td>\n							<td style=\"font-size: 100%; vertical-align: baseline; font-weight: normal; text-align: left; border-collapse: collapse; margin: 0; padding: 6px 4px; border: 1px solid #cccccc;\" align=\"left\" valign=\"baseline\">\n								<div style=\"font-weight: bold; font-size: 12px;\">128.90.135.19 (هلند)</div> \n								<pre class=\"display-file\" style=\"font-size: 12px; vertical-align: baseline; width: 420px; margin: 0; padding: 0; border: 0; white-space: normal;\">برای WordPress New Install File Probing مسدود شده است</pre>\n							</td>\n						</tr>\n																	<tr class=\"even\" style=\"font-size: 100%; vertical-align: baseline; margin: 0; padding: 0; border: 0;\">\n							<td style=\"font-size: 100%; vertical-align: baseline; font-weight: normal; text-align: left; border-collapse: collapse; margin: 0; padding: 6px 4px; border: 1px solid #cccccc;white-space: nowrap;background-color: #eeeeee;\" align=\"left\" valign=\"baseline\">December 1, 2025<br>10:44am</td>\n							<td style=\"font-size: 100%; vertical-align: baseline; font-weight: normal; text-align: left; border-collapse: collapse; margin: 0; padding: 6px 4px; border: 1px solid #cccccc;background-color: #eeeeee;\" align=\"left\" valign=\"baseline\">\n								<div style=\"font-weight: bold; font-size: 12px;\">128.90.135.19 (هلند)</div> \n								<pre class=\"display-file\" style=\"font-size: 12px; vertical-align: baseline; width: 420px; margin: 0; padding: 0; border: 0; white-space: normal;\">برای WordPress New Install File Probing مسدود شده است</pre>\n							</td>\n						</tr>\n															</tbody>\n				</table>\n				\n				 \n				\n				<p style=\"font-size: 100%; vertical-align: baseline; margin: 1em 0; padding: 0; border: 0;\">\n					<a class=\"button\" href=\"http://avnalaw.com/wp-admin/admin.php?page=WordfenceTools&subpage=livetraffic\" style=\"font-size: 13px; vertical-align: baseline; outline: none; color: #FFF; text-decoration: none; display: inline-block; line-height: 26px; height: 28px; cursor: pointer; border-radius: 3px; white-space: nowrap; box-sizing: border-box; box-shadow: 0 1px 0 rgba(120, 200, 230, 0.5) inset, 0 1px 0 rgba(0, 0, 0, 0.15); background-image: none; background-attachment: scroll; background-repeat: repeat; background-color: #2EA2CC; margin: 0; padding: 0 10px 1px; border: 1px solid #0074a2;\">مشاهده ترافیک اخیر</a>\n				</p>\n\n				\n				<h2 style=\"font-size: 20px; vertical-align: baseline; clear: both; color: #222 !important; margin: 20px 0 4px; padding: 0; border: 0;\">فایل هایی که اخیرا تغییر کرده اند</h2>\n\n				<table class=\"activity-table\" style=\"font-size: 100%; vertical-align: baseline; border-collapse: collapse; border-spacing: 0; mso-table-lspace: 0pt; mso-table-rspace: 0pt; width: 100%; max-width: 100%; margin: 0; padding: 0; border: 0;\">\n					<thead style=\"font-size: 100%; vertical-align: baseline; margin: 0; padding: 0; border: 0;\">\n						<tr style=\"font-size: 100%; vertical-align: baseline; margin: 0; padding: 0; border: 0;\">\n							<th style=\"font-size: 100%; vertical-align: baseline; font-weight: bold; text-align: left; color: #FFFFFF; background-color: #222; margin: 0; padding: 6px 4px; border: 1px solid #474747;\" align=\"left\" bgcolor=\"#222\" valign=\"baseline\">اصلاح شده</th>\n							<th style=\"font-size: 100%; vertical-align: baseline; font-weight: bold; text-align: left; color: #FFFFFF; background-color: #222; margin: 0; padding: 6px 4px; border: 1px solid #474747;\" align=\"left\" bgcolor=\"#222\" valign=\"baseline\">پرونده</th>\n						</tr>\n					</thead>\n					<tbody style=\"font-size: 100%; vertical-align: baseline; margin: 0; padding: 0; border: 0;\">\n																				<tr class=\"odd\" style=\"font-size: 100%; vertical-align: baseline; margin: 0; padding: 0; border: 0;\">\n								<td style=\"font-size: 100%; vertical-align: baseline; font-weight: normal; text-align: left; border-collapse: collapse; margin: 0; padding: 6px 4px; border: 1px solid #cccccc;white-space: nowrap;\" align=\"left\" valign=\"baseline\">December 1, 2025 4:00pm</td>\n								<td style=\"font-size: 100%; vertical-align: baseline; font-weight: normal; text-align: left; border-collapse: collapse; margin: 0; padding: 6px 4px; border: 1px solid #cccccc;\" align=\"left\" valign=\"baseline\">\n									<pre class=\"display-file\" style=\"font-size: 12px; vertical-align: baseline; width: 420px; overflow: auto; margin: 0; padding: 0; border: 0; word-wrap: break-word; word-break: break-all;\">wp-content/uploads/ast-block-templates-json/index.html</pre>\n								</td>\n							</tr>\n																				<tr class=\"even\" style=\"font-size: 100%; vertical-align: baseline; margin: 0; padding: 0; border: 0;\">\n								<td style=\"font-size: 100%; vertical-align: baseline; font-weight: normal; text-align: left; border-collapse: collapse; margin: 0; padding: 6px 4px; border: 1px solid #cccccc;white-space: nowrap;background-color: #eeeeee;\" align=\"left\" valign=\"baseline\">December 1, 2025 3:55pm</td>\n								<td style=\"font-size: 100%; vertical-align: baseline; font-weight: normal; text-align: left; border-collapse: collapse; margin: 0; padding: 6px 4px; border: 1px solid #cccccc;background-color: #eeeeee;\" align=\"left\" valign=\"baseline\">\n									<pre class=\"display-file\" style=\"font-size: 12px; vertical-align: baseline; width: 420px; overflow: auto; margin: 0; padding: 0; border: 0; word-wrap: break-word; word-break: break-all;\">wp-content/uploads/2025/12/8161c833-23e3-49eb-a731-eb9190041bb11-1.png</pre>\n								</td>\n							</tr>\n																				<tr class=\"odd\" style=\"font-size: 100%; vertical-align: baseline; margin: 0; padding: 0; border: 0;\">\n								<td style=\"font-size: 100%; vertical-align: baseline; font-weight: normal; text-align: left; border-collapse: collapse; margin: 0; padding: 6px 4px; border: 1px solid #cccccc;white-space: nowrap;\" align=\"left\" valign=\"baseline\">December 1, 2025 3:55pm</td>\n								<td style=\"font-size: 100%; vertical-align: baseline; font-weight: normal; text-align: left; border-collapse: collapse; margin: 0; padding: 6px 4px; border: 1px solid #cccccc;\" align=\"left\" valign=\"baseline\">\n									<pre class=\"display-file\" style=\"font-size: 12px; vertical-align: baseline; width: 420px; overflow: auto; margin: 0; padding: 0; border: 0; word-wrap: break-word; word-break: break-all;\">wp-content/uploads/2025/12/8161c833-23e3-49eb-a731-eb9190041bb11-1-150x150.png</pre>\n								</td>\n							</tr>\n																				<tr class=\"even\" style=\"font-size: 100%; vertical-align: baseline; margin: 0; padding: 0; border: 0;\">\n								<td style=\"font-size: 100%; vertical-align: baseline; font-weight: normal; text-align: left; border-collapse: collapse; margin: 0; padding: 6px 4px; border: 1px solid #cccccc;white-space: nowrap;background-color: #eeeeee;\" align=\"left\" valign=\"baseline\">December 1, 2025 3:55pm</td>\n								<td style=\"font-size: 100%; vertical-align: baseline; font-weight: normal; text-align: left; border-collapse: collapse; margin: 0; padding: 6px 4px; border: 1px solid #cccccc;background-color: #eeeeee;\" align=\"left\" valign=\"baseline\">\n									<pre class=\"display-file\" style=\"font-size: 12px; vertical-align: baseline; width: 420px; overflow: auto; margin: 0; padding: 0; border: 0; word-wrap: break-word; word-break: break-all;\">wp-content/uploads/2025/12/8161c833-23e3-49eb-a731-eb9190041bb11-1-768x768.png</pre>\n								</td>\n							</tr>\n																				<tr class=\"odd\" style=\"font-size: 100%; vertical-align: baseline; margin: 0; padding: 0; border: 0;\">\n								<td style=\"font-size: 100%; vertical-align: baseline; font-weight: normal; text-align: left; border-collapse: collapse; margin: 0; padding: 6px 4px; border: 1px solid #cccccc;white-space: nowrap;\" align=\"left\" valign=\"baseline\">December 1, 2025 3:55pm</td>\n								<td style=\"font-size: 100%; vertical-align: baseline; font-weight: normal; text-align: left; border-collapse: collapse; margin: 0; padding: 6px 4px; border: 1px solid #cccccc;\" align=\"left\" valign=\"baseline\">\n									<pre class=\"display-file\" style=\"font-size: 12px; vertical-align: baseline; width: 420px; overflow: auto; margin: 0; padding: 0; border: 0; word-wrap: break-word; word-break: break-all;\">wp-content/uploads/2025/12/8161c833-23e3-49eb-a731-eb9190041bb11-1-300x300.png</pre>\n								</td>\n							</tr>\n																				<tr class=\"even\" style=\"font-size: 100%; vertical-align: baseline; margin: 0; padding: 0; border: 0;\">\n								<td style=\"font-size: 100%; vertical-align: baseline; font-weight: normal; text-align: left; border-collapse: collapse; margin: 0; padding: 6px 4px; border: 1px solid #cccccc;white-space: nowrap;background-color: #eeeeee;\" align=\"left\" valign=\"baseline\">December 1, 2025 3:45pm</td>\n								<td style=\"font-size: 100%; vertical-align: baseline; font-weight: normal; text-align: left; border-collapse: collapse; margin: 0; padding: 6px 4px; border: 1px solid #cccccc;background-color: #eeeeee;\" align=\"left\" valign=\"baseline\">\n									<pre class=\"display-file\" style=\"font-size: 12px; vertical-align: baseline; width: 420px; overflow: auto; margin: 0; padding: 0; border: 0; word-wrap: break-word; word-break: break-all;\">wp-content/uploads/2025/12/8161c833-23e3-49eb-a731-eb9190041bb11-300x300.png</pre>\n								</td>\n							</tr>\n																				<tr class=\"odd\" style=\"font-size: 100%; vertical-align: baseline; margin: 0; padding: 0; border: 0;\">\n								<td style=\"font-size: 100%; vertical-align: baseline; font-weight: normal; text-align: left; border-collapse: collapse; margin: 0; padding: 6px 4px; border: 1px solid #cccccc;white-space: nowrap;\" align=\"left\" valign=\"baseline\">December 1, 2025 3:45pm</td>\n								<td style=\"font-size: 100%; vertical-align: baseline; font-weight: normal; text-align: left; border-collapse: collapse; margin: 0; padding: 6px 4px; border: 1px solid #cccccc;\" align=\"left\" valign=\"baseline\">\n									<pre class=\"display-file\" style=\"font-size: 12px; vertical-align: baseline; width: 420px; overflow: auto; margin: 0; padding: 0; border: 0; word-wrap: break-word; word-break: break-all;\">wp-content/uploads/2025/12/8161c833-23e3-49eb-a731-eb9190041bb11-150x150.png</pre>\n								</td>\n							</tr>\n																				<tr class=\"even\" style=\"font-size: 100%; vertical-align: baseline; margin: 0; padding: 0; border: 0;\">\n								<td style=\"font-size: 100%; vertical-align: baseline; font-weight: normal; text-align: left; border-collapse: collapse; margin: 0; padding: 6px 4px; border: 1px solid #cccccc;white-space: nowrap;background-color: #eeeeee;\" align=\"left\" valign=\"baseline\">December 1, 2025 3:45pm</td>\n								<td style=\"font-size: 100%; vertical-align: baseline; font-weight: normal; text-align: left; border-collapse: collapse; margin: 0; padding: 6px 4px; border: 1px solid #cccccc;background-color: #eeeeee;\" align=\"left\" valign=\"baseline\">\n									<pre class=\"display-file\" style=\"font-size: 12px; vertical-align: baseline; width: 420px; overflow: auto; margin: 0; padding: 0; border: 0; word-wrap: break-word; word-break: break-all;\">wp-content/uploads/2025/12/8161c833-23e3-49eb-a731-eb9190041bb11-768x768.png</pre>\n								</td>\n							</tr>\n																				<tr class=\"odd\" style=\"font-size: 100%; vertical-align: baseline; margin: 0; padding: 0; border: 0;\">\n								<td style=\"font-size: 100%; vertical-align: baseline; font-weight: normal; text-align: left; border-collapse: collapse; margin: 0; padding: 6px 4px; border: 1px solid #cccccc;white-space: nowrap;\" align=\"left\" valign=\"baseline\">December 1, 2025 3:45pm</td>\n								<td style=\"font-size: 100%; vertical-align: baseline; font-weight: normal; text-align: left; border-collapse: collapse; margin: 0; padding: 6px 4px; border: 1px solid #cccccc;\" align=\"left\" valign=\"baseline\">\n									<pre class=\"display-file\" style=\"font-size: 12px; vertical-align: baseline; width: 420px; overflow: auto; margin: 0; padding: 0; border: 0; word-wrap: break-word; word-break: break-all;\">wp-content/uploads/2025/12/8161c833-23e3-49eb-a731-eb9190041bb11.png</pre>\n								</td>\n							</tr>\n																				<tr class=\"even\" style=\"font-size: 100%; vertical-align: baseline; margin: 0; padding: 0; border: 0;\">\n								<td style=\"font-size: 100%; vertical-align: baseline; font-weight: normal; text-align: left; border-collapse: collapse; margin: 0; padding: 6px 4px; border: 1px solid #cccccc;white-space: nowrap;background-color: #eeeeee;\" align=\"left\" valign=\"baseline\">December 1, 2025 3:00am</td>\n								<td style=\"font-size: 100%; vertical-align: baseline; font-weight: normal; text-align: left; border-collapse: collapse; margin: 0; padding: 6px 4px; border: 1px solid #cccccc;background-color: #eeeeee;\" align=\"left\" valign=\"baseline\">\n									<pre class=\"display-file\" style=\"font-size: 12px; vertical-align: baseline; width: 420px; overflow: auto; margin: 0; padding: 0; border: 0; word-wrap: break-word; word-break: break-all;\">.litespeed_flag</pre>\n								</td>\n							</tr>\n											</tbody>\n				</table>\n\n				<div style=\"font-size: 12px; font-style: italic; vertical-align: baseline; clear: both; margin: 8px 0 4px; padding: 0; border: 0;\">این لیست ممکن است شامل بروز رسانی هسته/پلاگین/پوسته وردپرس، logs خطا، فایل های کش و سایر تغییرات عادی باشد.</div>\n\n				\n				<h2 style=\"font-size: 20px; vertical-align: baseline; clear: both; color: #222 !important; margin: 20px 0 4px; padding: 0; border: 0;\">بروز رسانی های مورد نیاز</h2>\n				\n																				\n									<p style=\"font-size: 100%; vertical-align: baseline; margin: 1em 0; padding: 0; border: 0;\">\n						در حال حاضر هیچ بروز رسانی در دسترس نیست.					</p>\n				\n				<p style=\"font-size: 100%; vertical-align: baseline; margin: 1em 0; padding: 0; border: 0;\">\n					اگر می‌خواهید به <a href=\"http://avnalaw.com\">http://avnalaw.com</a> وارد شوید، لطفاً اکنون <a href=\"http://avnalaw.com/wp-admin/\">اینجا را کلیک کنید</a>. می‌توانید با مراجعه به <a href=\"http://avnalaw.com/wp-admin/admin.php?page=Wordfence&amp;subpage=global_options#global-options-email-summary\">صفحه گزینه‌های Wordfence</a>، فرکانس این ایمیل را تغییر دهید یا آن را روشن و خاموش کنید.				</p>\n\n				<p style=\"font-size: 100%; vertical-align: baseline; margin: 1em 0; padding: 0; border: 0;\">\n					دیگر مدیر سایت این سایت نیست؟ برای جلوگیری از دریافت هشدارهای امنیتی <a href=\"http://avnalaw.com/?_wfsf=removeAlertEmail&amp;jwt=eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJlbWFpbCI6ImFkbWluQGF2bmFsYXcuY29tIiwiX2V4cCI6MTc2NTE5NzAwNH0.adwZhNhAQZtAmTZakkCBuLUFAAKhR5ZR0qce0SqpqyQ\" target=\"_blank\">اینجا کلیک کنید</a>.\n				</p>\n			</div>\n		</td>\n	</tr>\n</table>\n<!-- End of wrapper table -->\n</body>\n</html>","a:4:{s:8:\"reply-to\";a:0:{}s:2:\"cc\";a:0:{}s:3:\"bcc\";a:0:{}s:12:\"content-type\";s:21:\"multipart/alternative\";}","a:0:{}","sent","a:1:{s:8:\"response\";s:2:\"OK\";}","a:1:{s:8:\"provider\";s:4:\"smtp\";}","0","0",NULL,"2025-12-01 16:00:04",NULL),
("3",NULL,"a:1:{i:0;a:1:{s:5:\"email\";s:17:\"admin@avnalaw.com\";}}","Dadman <info@avnalaw.com>","[Wordfence Alert] avnalaw.com Admin Login","This email was sent from your website \"گروه وکلای آونا\" by the Wordfence plugin at Tuesday 2nd of December 2025 at 01:07:51 PM\nThe Wordfence administrative URL for this site is: https://avnalaw.com/wp-admin/admin.php?page=Wordfence\nA user with username \"admin_x9yeemci\" who has administrator access signed in to your WordPress site.\nUser IP: 188.245.212.16\nUser hostname: static.16.212.245.188.clients.your-server.de\nUser location: Nuremberg, Germany\n\n\n	NOTE: You are using the free version of Wordfence. Upgrade today:\n - Receive real-time Firewall and Scan engine rule updates for protection as threats emerge\n - Real-time IP Blocklist blocks the most malicious IPs from accessing your site\n - Country blocking\n - IP reputation monitoring\n - Schedule scans to run more frequently and at optimal times\n - Access to Premium Support\n - Discounts for multi-year and multi-license purchases\n\nClick here to upgrade to Wordfence Premium:\nhttps://www.wordfence.com/zz1/wordfence-signup/\n--\nTo change your alert options for Wordfence, visit:\nhttps://avnalaw.com/wp-admin/admin.php?page=Wordfence&subpage=global_options\nTo see current Wordfence alerts, visit:\nhttps://avnalaw.com/wp-admin/admin.php?page=Wordfence\n\n\n\nNo longer an administrator for this site? Click here to stop receiving security alerts: https://avnalaw.com/?_wfsf=removeAlertEmail&jwt=eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJlbWFpbCI6ImFkbWluQGF2bmFsYXcuY29tIiwiX2V4cCI6MTc2NTI3MzA3MX0.d1_QU-0R41VWcwjKo7Ahmtpubbw3pLJ5Q3fhi_6_A60","a:4:{s:8:\"reply-to\";a:0:{}s:2:\"cc\";a:0:{}s:3:\"bcc\";a:0:{}s:12:\"content-type\";s:10:\"text/plain\";}","a:0:{}","sent","a:1:{s:8:\"response\";s:2:\"OK\";}","a:1:{s:8:\"provider\";s:4:\"smtp\";}","0","0",NULL,"2025-12-02 13:07:51",NULL),
("4",NULL,"a:1:{i:0;a:1:{s:5:\"email\";s:17:\"admin@avnalaw.com\";}}","Dadman <info@avnalaw.com>","[Wordfence Alert] Problems found on avnalaw.com","<p>این ایمیل از وبسایت &quot;گروه وکلای آونا&quot; شما توسط افزونه وردفنس ارسال شده است.</p>\n\n<p>وردفنس مشکلات جدید زیر را در &quot;گروه وکلای آونا&quot; پیدا کرد.</p>\n\n<p>هشدار در Wednesday 3rd of December 2025 at 02:45:09 PM ایجاد شده است</p>\n\n<br>\n\n<p>جزئیات نتایج این اسکن را در سایت خود در: https://avnalaw.com/wp-admin/admin.php?page=WordfenceScan مشاهده کنید</p>\n\n\n\n\n<p>مشکلات شدید متوسط:</p>\n<p>* افزونه &quot;Fluent Forms - Customizable Contact Forms, Survey, Quiz, &amp; Conversational Form Builder&quot; نیاز به ارتقا دارد (6.1.8 -&gt; 6.1.10).</p>\n<p>https://wordpress.org/plugins/fluentform/#developers</p>\n\n<p>* افزونه &quot;Rank Math SEO&quot; نیاز به ارتقا دارد (1.0.258 -&gt; 1.0.259).</p>\n<p>https://wordpress.org/plugins/seo-by-rank-math/#developers</p>\n\n<p>* طرح زمینه &quot;Astra&quot; نیاز به ارتقا دارد (4.11.15 -&gt; 4.11.16).</p>\n\n\n\n\n	<p>توجه: شما از نسخه رایگان وردفنس استفاده می کنید. امروز ارتقاء دهید:</p>\n	\n	<ul>\n		<li>دریافت فایروال در زمان واقعی و بروز رسانی قوانین موتور اسکن برای محافظت مواردی که به عنوان تهدی ظاهر می شوند</li>\n		<li>بلاکلیست IP لحظه ای دسترسی مخرب ترین IP ها را به سایت شما مسدود می کند</li>\n		<li>مسدود کردن کشور</li>\n		<li>نظارت بر اعتبار آی پی</li>\n		<li>زمانبندی اسکن برای اجرا غالبابیشتر و در زمان مطلوب</li>\n		<li>دسترسی به پشتیبانی پرمیوم</li>\n		<li>تخفیف برای خرید چند ساله و چند لایسنسه</li>\n	</ul>\n\n	<p>برای ارتقا وردفنس به نسخه پرمیوم اینجا را کلیک کنید:<br><a href=\"https://www.wordfence.com/zz2/wordfence-signup/\">https://www.wordfence.com/zz2/wordfence-signup/</a></p>\n\n<p>دیگر مدیر سایت این سایت نیست؟ برای جلوگیری از دریافت هشدارهای امنیتی <a href=\"https://avnalaw.com/?_wfsf=removeAlertEmail&amp;jwt=eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJlbWFpbCI6ImFkbWluQGF2bmFsYXcuY29tIiwiX2V4cCI6MTc2NTM2NTMwOX0.yuGvFpB29lx7Q6q5DHtljCLBTF0BG42p_Usqwbfzcec\" target=\"_blank\">اینجا کلیک کنید</a>.</p>","a:4:{s:8:\"reply-to\";a:0:{}s:2:\"cc\";a:0:{}s:3:\"bcc\";a:0:{}s:12:\"content-type\";s:21:\"multipart/alternative\";}","a:0:{}","sent","a:1:{s:8:\"response\";s:2:\"OK\";}","a:1:{s:8:\"provider\";s:4:\"smtp\";}","0","0",NULL,"2025-12-03 14:45:10",NULL),
("5",NULL,"a:1:{i:0;a:1:{s:5:\"email\";s:17:\"admin@avnalaw.com\";}}","Dadman <info@avnalaw.com>","[Wordfence Alert] Problems found on avnalaw.com","<p>این ایمیل از وبسایت &quot;گروه وکلای آونا&quot; شما توسط افزونه وردفنس ارسال شده است.</p>\n\n<p>وردفنس مشکلات جدید زیر را در \"گروه وکلای آونا\" پیدا کرد (3 مشکل موجود نیز دوباره پیدا شد).</p>\n\n<p>هشدار در Thursday 4th of December 2025 at 02:45:40 AM ایجاد شده است</p>\n\n<br>\n\n<p>جزئیات نتایج این اسکن را در سایت خود در: https://avnalaw.com/wp-admin/admin.php?page=WordfenceScan مشاهده کنید</p>\n\n\n\n\n<p>مشکلات شدید متوسط:</p>\n<p>* افزونه &quot;Wordfence Security&quot; نیاز به ارتقا دارد (8.1.2 -&gt; 8.1.3).</p>\n<p>https://wordpress.org/plugins/wordfence/#developers</p>\n\n<p>* طرح زمینه &quot;Twenty Twenty-Five&quot; نیاز به ارتقا دارد (1.3 -&gt; 1.4).</p>\n\n\n\n<p>3 مسئله موجود دوباره پیدا شد و نشان داده نشده است.</p>\n	<p>توجه: شما از نسخه رایگان وردفنس استفاده می کنید. امروز ارتقاء دهید:</p>\n	\n	<ul>\n		<li>دریافت فایروال در زمان واقعی و بروز رسانی قوانین موتور اسکن برای محافظت مواردی که به عنوان تهدی ظاهر می شوند</li>\n		<li>بلاکلیست IP لحظه ای دسترسی مخرب ترین IP ها را به سایت شما مسدود می کند</li>\n		<li>مسدود کردن کشور</li>\n		<li>نظارت بر اعتبار آی پی</li>\n		<li>زمانبندی اسکن برای اجرا غالبابیشتر و در زمان مطلوب</li>\n		<li>دسترسی به پشتیبانی پرمیوم</li>\n		<li>تخفیف برای خرید چند ساله و چند لایسنسه</li>\n	</ul>\n\n	<p>برای ارتقا وردفنس به نسخه پرمیوم اینجا را کلیک کنید:<br><a href=\"https://www.wordfence.com/zz2/wordfence-signup/\">https://www.wordfence.com/zz2/wordfence-signup/</a></p>\n\n<p>دیگر مدیر سایت این سایت نیست؟ برای جلوگیری از دریافت هشدارهای امنیتی <a href=\"https://avnalaw.com/?_wfsf=removeAlertEmail&amp;jwt=eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJlbWFpbCI6ImFkbWluQGF2bmFsYXcuY29tIiwiX2V4cCI6MTc2NTQwODU0MH0.qkEw0yj-7MT74o9MH9hb29i8YVJq10oh6BQ8SRD78Ow\" target=\"_blank\">اینجا کلیک کنید</a>.</p>","a:4:{s:8:\"reply-to\";a:0:{}s:2:\"cc\";a:0:{}s:3:\"bcc\";a:0:{}s:12:\"content-type\";s:21:\"multipart/alternative\";}","a:0:{}","sent","a:1:{s:8:\"response\";s:2:\"OK\";}","a:1:{s:8:\"provider\";s:4:\"smtp\";}","0","0",NULL,"2025-12-04 02:45:40",NULL),
("6",NULL,"a:1:{i:0;a:1:{s:5:\"email\";s:17:\"admin@avnalaw.com\";}}","Dadman <info@avnalaw.com>","[Wordfence Alert] Problems found on avnalaw.com","<p>این ایمیل از وبسایت &quot;گروه وکلای آونا&quot; شما توسط افزونه وردفنس ارسال شده است.</p>\n\n<p>وردفنس مشکلات جدید زیر را در \"گروه وکلای آونا\" پیدا کرد (4 مشکل موجود نیز دوباره پیدا شد).</p>\n\n<p>هشدار در Thursday 4th of December 2025 at 03:45:10 PM ایجاد شده است</p>\n\n<br>\n\n<p>جزئیات نتایج این اسکن را در سایت خود در: https://avnalaw.com/wp-admin/admin.php?page=WordfenceScan مشاهده کنید</p>\n\n\n\n\n<p>مشکلات شدید متوسط:</p>\n<p>* افزونه &quot;Fluent Forms - Customizable Contact Forms, Survey, Quiz, &amp; Conversational Form Builder&quot; نیاز به ارتقا دارد (6.1.8 -&gt; 6.1.11).</p>\n<p>https://wordpress.org/plugins/fluentform/#developers</p>\n\n<p>* افزونه &quot;Spectra&quot; نیاز به ارتقا دارد (2.19.16 -&gt; 2.19.17).</p>\n<p>https://wordpress.org/plugins/ultimate-addons-for-gutenberg/#developers</p>\n\n\n<p>4 مسئله موجود دوباره پیدا شد و نشان داده نشده است.</p>\n	<p>توجه: شما از نسخه رایگان وردفنس استفاده می کنید. امروز ارتقاء دهید:</p>\n	\n	<ul>\n		<li>دریافت فایروال در زمان واقعی و بروز رسانی قوانین موتور اسکن برای محافظت مواردی که به عنوان تهدی ظاهر می شوند</li>\n		<li>بلاکلیست IP لحظه ای دسترسی مخرب ترین IP ها را به سایت شما مسدود می کند</li>\n		<li>مسدود کردن کشور</li>\n		<li>نظارت بر اعتبار آی پی</li>\n		<li>زمانبندی اسکن برای اجرا غالبابیشتر و در زمان مطلوب</li>\n		<li>دسترسی به پشتیبانی پرمیوم</li>\n		<li>تخفیف برای خرید چند ساله و چند لایسنسه</li>\n	</ul>\n\n	<p>برای ارتقا وردفنس به نسخه پرمیوم اینجا را کلیک کنید:<br><a href=\"https://www.wordfence.com/zz2/wordfence-signup/\">https://www.wordfence.com/zz2/wordfence-signup/</a></p>\n\n<p>دیگر مدیر سایت این سایت نیست؟ برای جلوگیری از دریافت هشدارهای امنیتی <a href=\"https://avnalaw.com/?_wfsf=removeAlertEmail&amp;jwt=eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJlbWFpbCI6ImFkbWluQGF2bmFsYXcuY29tIiwiX2V4cCI6MTc2NTQ1NTMxMH0.symri7SkRROooZPkn0fL2srPeFfzNJM772hPsHQTY9Q\" target=\"_blank\">اینجا کلیک کنید</a>.</p>","a:4:{s:8:\"reply-to\";a:0:{}s:2:\"cc\";a:0:{}s:3:\"bcc\";a:0:{}s:12:\"content-type\";s:21:\"multipart/alternative\";}","a:0:{}","sent","a:1:{s:8:\"response\";s:2:\"OK\";}","a:1:{s:8:\"provider\";s:4:\"smtp\";}","0","0",NULL,"2025-12-04 15:45:10",NULL),
("7",NULL,"a:1:{i:0;a:1:{s:5:\"email\";s:17:\"admin@avnalaw.com\";}}","Dadman <info@avnalaw.com>","[Wordfence Alert] Problems found on avnalaw.com","<p>این ایمیل از وبسایت &quot;گروه وکلای آونا&quot; شما توسط افزونه وردفنس ارسال شده است.</p>\n\n<p>وردفنس مشکلات جدید زیر را در \"گروه وکلای آونا\" پیدا کرد (5 مشکل موجود نیز دوباره پیدا شد).</p>\n\n<p>هشدار در Friday 5th of December 2025 at 02:45:08 PM ایجاد شده است</p>\n\n<br>\n\n<p>جزئیات نتایج این اسکن را در سایت خود در: https://avnalaw.com/wp-admin/admin.php?page=WordfenceScan مشاهده کنید</p>\n\n\n\n\n<p>مشکلات شدید متوسط:</p>\n<p>* افزونه &quot;Rank Math SEO&quot; نیاز به ارتقا دارد (1.0.258 -&gt; 1.0.259.1).</p>\n<p>https://wordpress.org/plugins/seo-by-rank-math/#developers</p>\n\n\n<p>5 مسئله موجود دوباره پیدا شد و نشان داده نشده است.</p>\n	<p>توجه: شما از نسخه رایگان وردفنس استفاده می کنید. امروز ارتقاء دهید:</p>\n	\n	<ul>\n		<li>دریافت فایروال در زمان واقعی و بروز رسانی قوانین موتور اسکن برای محافظت مواردی که به عنوان تهدی ظاهر می شوند</li>\n		<li>بلاکلیست IP لحظه ای دسترسی مخرب ترین IP ها را به سایت شما مسدود می کند</li>\n		<li>مسدود کردن کشور</li>\n		<li>نظارت بر اعتبار آی پی</li>\n		<li>زمانبندی اسکن برای اجرا غالبابیشتر و در زمان مطلوب</li>\n		<li>دسترسی به پشتیبانی پرمیوم</li>\n		<li>تخفیف برای خرید چند ساله و چند لایسنسه</li>\n	</ul>\n\n	<p>برای ارتقا وردفنس به نسخه پرمیوم اینجا را کلیک کنید:<br><a href=\"https://www.wordfence.com/zz2/wordfence-signup/\">https://www.wordfence.com/zz2/wordfence-signup/</a></p>\n\n<p>دیگر مدیر سایت این سایت نیست؟ برای جلوگیری از دریافت هشدارهای امنیتی <a href=\"https://avnalaw.com/?_wfsf=removeAlertEmail&amp;jwt=eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJlbWFpbCI6ImFkbWluQGF2bmFsYXcuY29tIiwiX2V4cCI6MTc2NTUzODEwOH0.shfzUWUfB3Gr9irJ7z8po-jE_e0Ra3i27cwWYO9b4q4\" target=\"_blank\">اینجا کلیک کنید</a>.</p>","a:4:{s:8:\"reply-to\";a:0:{}s:2:\"cc\";a:0:{}s:3:\"bcc\";a:0:{}s:12:\"content-type\";s:21:\"multipart/alternative\";}","a:0:{}","sent","a:1:{s:8:\"response\";s:2:\"OK\";}","a:1:{s:8:\"provider\";s:4:\"smtp\";}","0","0",NULL,"2025-12-05 14:45:08",NULL),
("8",NULL,"a:1:{i:0;a:1:{s:5:\"email\";s:17:\"admin@avnalaw.com\";}}","Dadman <info@avnalaw.com>","[Wordfence Alert] avnalaw.com ورود مدیر","این ایمیل از وب سایت شما \"گروه وکلای آونا\" توسط افزونه Wordfence در Sunday 7th of December 2025 at 10:36:01 AM ارسال شده است\nآدرس مدیریت وردفنس برای این سایت است: https://avnalaw.com/wp-admin/admin.php?page=Wordfence\nکاربری با نام کاربری \"admin_x9yeemci\" که دسترسی سرپرست دارد به سایت وردپرس شما وارد شده است.\nIP کاربر: 104.28.214.165\nنام هاست کاربر: 104.28.214.165\nمکان کاربر: Tehran, Iran\n\n\n	Translation is too long to be saved\nتوجه: شما از نسخه رایگان Wordfence استفاده می کنید. امروز به روز رسانی کنید:\n  - به‌روزرسانی‌های فایروال و قوانین موتور اسکن لحظه ای را برای محافظت در صورت ظهور تهدیدها دریافت کنید\n  - بلاک لیست لحظه ای IP دسترسی مخرب ترین IP ها را به سایت شما مسدود می کند\n  - مسدود کردن کشور\n  - بررسی میزان تکراری بودن IP\n  - اسکن ها را برای اجرا بیشتر و در زمان های بهینه برنامه ریزی کنید\n  - دسترسی به پشتیبانی Premium\n  - تخفیف برای خریدهای چند ساله و چند مجوز\n\nبرای ارتقا به Wordfence Premium اینجا را کلیک کنید:\nhttps://www.wordfence.com/zz1/wordfence-signup/\n--\nبرای تغییر تنظیمات هشدار شما برای وردفنس آدرس https://avnalaw.com/wp-admin/admin.php?page=Wordfence&subpage=global_options را ببینید\nبرای مشاهده هشدارهای فعلی وردفنس آدرس https://avnalaw.com/wp-admin/admin.php?page=Wordfence را ببینید\n\n\n\nدیگر مدیر سایت این سایت نیست؟ برای جلوگیری از دریافت هشدارهای امنیتی اینجا را کلیک کنید: https://avnalaw.com/?_wfsf=removeAlertEmail&jwt=eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJlbWFpbCI6ImFkbWluQGF2bmFsYXcuY29tIiwiX2V4cCI6MTc2NTY5NTk2MX0.2aEnEZOmvJDjM9DyLQVAwwJzzVm071-WNLKGzDZIVgI","a:4:{s:8:\"reply-to\";a:0:{}s:2:\"cc\";a:0:{}s:3:\"bcc\";a:0:{}s:12:\"content-type\";s:10:\"text/plain\";}","a:0:{}","sent","a:1:{s:8:\"response\";s:2:\"OK\";}","a:1:{s:8:\"provider\";s:4:\"smtp\";}","0","0",NULL,"2025-12-07 10:36:01",NULL),
("9",NULL,"a:1:{i:0;a:1:{s:5:\"email\";s:17:\"admin@avnalaw.com\";}}","Dadman <info@avnalaw.com>","[Wordfence Alert] avnalaw.com Wordfence Deactivated","This email was sent from your website \"گروه وکلای آونا\" by the Wordfence plugin at Sunday 7th of December 2025 at 10:40:18 AM\nThe Wordfence administrative URL for this site is: https://avnalaw.com/wp-admin/admin.php?page=Wordfence\nA user with username \"admin_x9yeemci\" deactivated Wordfence on your WordPress site.\nUser IP: 104.28.214.165\nUser hostname: 104.28.214.165\nUser location: Tehran, Iran\n\n\n	NOTE: You are using the free version of Wordfence. Upgrade today:\n - Receive real-time Firewall and Scan engine rule updates for protection as threats emerge\n - Real-time IP Blocklist blocks the most malicious IPs from accessing your site\n - Country blocking\n - IP reputation monitoring\n - Schedule scans to run more frequently and at optimal times\n - Access to Premium Support\n - Discounts for multi-year and multi-license purchases\n\nClick here to upgrade to Wordfence Premium:\nhttps://www.wordfence.com/zz1/wordfence-signup/\n--\nTo change your alert options for Wordfence, visit:\nhttps://avnalaw.com/wp-admin/admin.php?page=Wordfence&subpage=global_options\nTo see current Wordfence alerts, visit:\nhttps://avnalaw.com/wp-admin/admin.php?page=Wordfence\n\n\n\nNo longer an administrator for this site? Click here to stop receiving security alerts: https://avnalaw.com/?_wfsf=removeAlertEmail&jwt=eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJlbWFpbCI6ImFkbWluQGF2bmFsYXcuY29tIiwiX2V4cCI6MTc2NTY5NjIxOH0.MEtVLzpqoh_i0wXMUQ5w5x7MVif3U5XrdB7owNws_qo","a:4:{s:8:\"reply-to\";a:0:{}s:2:\"cc\";a:0:{}s:3:\"bcc\";a:0:{}s:12:\"content-type\";s:10:\"text/plain\";}","a:0:{}","sent","a:1:{s:8:\"response\";s:2:\"OK\";}","a:1:{s:8:\"provider\";s:4:\"smtp\";}","0","0",NULL,"2025-12-07 10:40:18",NULL),
("10",NULL,"a:1:{i:0;a:1:{s:5:\"email\";s:17:\"admin@avnalaw.com\";}}","Dadman <info@avnalaw.com>","[گروه وکلای آونا] New User Registration","New user registration on your site گروه وکلای آونا:\r\n\r\nUsername: hashemi\r\n\r\nEmail: sayidmahdi@gmail.com\r\n","a:4:{s:8:\"reply-to\";a:0:{}s:2:\"cc\";a:0:{}s:3:\"bcc\";a:0:{}s:12:\"content-type\";s:10:\"text/plain\";}","a:0:{}","sent","a:1:{s:8:\"response\";s:2:\"OK\";}","a:1:{s:8:\"provider\";s:4:\"smtp\";}","0","0",NULL,"2025-12-07 10:40:37",NULL),
("11",NULL,"a:1:{i:0;a:1:{s:5:\"email\";s:20:\"sayidmahdi@gmail.com\";}}","Dadman <info@avnalaw.com>","جزئیات ورود [گروه وکلای آونا]","نام‌کاربری : hashemi\r\n\r\nبرای تنظیم رمز خود، این نشانی را ببینید:\r\n\r\nhttps://avnalaw.com/wp-login.php?login=hashemi&key=lufIBEBQrSp9pkRf88g6&action=rp\r\n\r\nhttps://avnalaw.com/wp-login.php\r\n","a:4:{s:8:\"reply-to\";a:0:{}s:2:\"cc\";a:0:{}s:3:\"bcc\";a:0:{}s:12:\"content-type\";s:10:\"text/plain\";}","a:0:{}","sent","a:1:{s:8:\"response\";s:2:\"OK\";}","a:1:{s:8:\"provider\";s:4:\"smtp\";}","0","0",NULL,"2025-12-07 10:40:37",NULL),
("12",NULL,"a:1:{i:0;a:1:{s:5:\"email\";s:17:\"admin@avnalaw.com\";}}","Dadman <info@avnalaw.com>","[گروه وکلای آونا] New User Registration","New user registration on your site گروه وکلای آونا:\r\n\r\nUsername: rasaneh-design\r\n\r\nEmail: rasane.design@gmail.com\r\n","a:4:{s:8:\"reply-to\";a:0:{}s:2:\"cc\";a:0:{}s:3:\"bcc\";a:0:{}s:12:\"content-type\";s:10:\"text/plain\";}","a:0:{}","sent","a:1:{s:8:\"response\";s:2:\"OK\";}","a:1:{s:8:\"provider\";s:4:\"smtp\";}","0","0",NULL,"2025-12-07 17:26:47",NULL),
("13",NULL,"a:1:{i:0;a:1:{s:5:\"email\";s:23:\"rasane.design@gmail.com\";}}","Dadman <info@avnalaw.com>","جزئیات ورود [گروه وکلای آونا]","نام‌کاربری : rasaneh-design\r\n\r\nبرای تنظیم رمز خود، این نشانی را ببینید:\r\n\r\nhttps://avnalaw.com/modiran/?login=rasaneh-design&key=76GzyNUtSeqh1vrcJ0lv&action=rp\r\n\r\nhttps://avnalaw.com/modiran/\r\n","a:4:{s:8:\"reply-to\";a:0:{}s:2:\"cc\";a:0:{}s:3:\"bcc\";a:0:{}s:12:\"content-type\";s:10:\"text/plain\";}","a:0:{}","sent","a:1:{s:8:\"response\";s:2:\"OK\";}","a:1:{s:8:\"provider\";s:4:\"smtp\";}","0","0",NULL,"2025-12-07 17:26:48",NULL),
("14",NULL,"a:1:{i:0;a:1:{s:5:\"email\";s:17:\"admin@avnalaw.com\";}}","Dadman <info@avnalaw.com>","[گروه وکلای آونا] New User Registration","New user registration on your site گروه وکلای آونا:\r\n\r\nUsername: a.hashemi\r\n\r\nEmail: hashemi@avnalaw.com\r\n","a:4:{s:8:\"reply-to\";a:0:{}s:2:\"cc\";a:0:{}s:3:\"bcc\";a:0:{}s:12:\"content-type\";s:10:\"text/plain\";}","a:0:{}","sent","a:1:{s:8:\"response\";s:2:\"OK\";}","a:1:{s:8:\"provider\";s:4:\"smtp\";}","0","0",NULL,"2025-12-07 17:28:43",NULL),
("15",NULL,"a:1:{i:0;a:1:{s:5:\"email\";s:19:\"hashemi@avnalaw.com\";}}","Dadman <info@avnalaw.com>","[گروه وکلای آونا] ایمیل تغییر کرد","سلام a.hashemi،\n\nاین پیغام تأیید می‌کند که ایمیل شما در سایت گروه وکلای آونا تغییر کرده است.\n\nاگر ایمیل خود را تغییر نداده‌اید، خواهشمندیم با مدیر سایت با نشانی ایمیل زیر تماس بگیرید: admin@avnalaw.com\n\nاین ایمیل به نشانی hashemi@avnalaw.com فرستاده شده است.\n\nبا احترام\nگروه گروه وکلای آونا\nhttps://avnalaw.com","a:4:{s:8:\"reply-to\";a:0:{}s:2:\"cc\";a:0:{}s:3:\"bcc\";a:0:{}s:12:\"content-type\";s:10:\"text/plain\";}","a:0:{}","sent","a:1:{s:8:\"response\";s:2:\"OK\";}","a:1:{s:8:\"provider\";s:4:\"smtp\";}","0","0",NULL,"2025-12-11 14:01:02",NULL);

INSERT IGNORE INTO `YTcMX_gf_form` VALUES 
("1","تماس با ما","2025-12-16 15:23:59",NULL,"1","0"),
("2","درخواست مشاوره","2025-12-17 08:59:21",NULL,"1","0");

INSERT IGNORE INTO `YTcMX_gf_form_meta` VALUES 
("1","{\"fields\":[{\"is_payment\":false,\"type\":\"name\",\"id\":1,\"formId\":1,\"label\":\"\\u0646\\u0627\\u0645 \\u0648 \\u0646\\u0627\\u0645 \\u062e\\u0627\\u0646\\u0648\\u0627\\u062f\\u06af\\u06cc\",\"adminLabel\":\"\",\"isRequired\":true,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"nameFormat\":\"advanced\",\"inputs\":[{\"id\":\"1.2\",\"label\":\"\\u067e\\u06cc\\u0634\\u0648\\u0646\\u062f\",\"name\":\"\",\"autocompleteAttribute\":\"honorific-prefix\",\"choices\":[{\"text\":\"Dr.\",\"value\":\"Dr.\"},{\"text\":\"Miss\",\"value\":\"Miss\"},{\"text\":\"Mr.\",\"value\":\"Mr.\"},{\"text\":\"Mrs.\",\"value\":\"Mrs.\"},{\"text\":\"Ms.\",\"value\":\"Ms.\"},{\"text\":\"Mx.\",\"value\":\"Mx.\"},{\"text\":\"Prof.\",\"value\":\"Prof.\"},{\"text\":\"Rev.\",\"value\":\"Rev.\"}],\"isHidden\":true,\"inputType\":\"radio\"},{\"id\":\"1.3\",\"label\":\"\\u0646\\u0627\\u0645\",\"name\":\"\",\"autocompleteAttribute\":\"given-name\"},{\"id\":\"1.4\",\"label\":\"\\u0645\\u06cc\\u0627\\u0646\",\"name\":\"\",\"autocompleteAttribute\":\"additional-name\",\"isHidden\":true},{\"id\":\"1.6\",\"label\":\"\\u0646\\u0627\\u0645 \\u062e\\u0627\\u0646\\u0648\\u0627\\u062f\\u06af\\u06cc\",\"name\":\"\",\"autocompleteAttribute\":\"family-name\"},{\"id\":\"1.8\",\"label\":\"\\u067e\\u0633\\u0648\\u0646\\u062f\",\"name\":\"\",\"autocompleteAttribute\":\"honorific-suffix\",\"isHidden\":true}],\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"name\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"above\",\"subLabelPlacement\":\"above\",\"placeholder\":\"\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"layoutGridColumnSpan\":\"\",\"enableDisplayInColumns\":\"\",\"enableEnhancedUI\":0,\"layoutGroupId\":\"b1dd59f7\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"errors\":[],\"pageNumber\":1,\"fields\":\"\"},{\"is_payment\":false,\"type\":\"phone\",\"id\":3,\"formId\":1,\"label\":\"\\u0634\\u0645\\u0627\\u0631\\u0647 \\u062a\\u0645\\u0627\\u0633\",\"adminLabel\":\"\",\"isRequired\":true,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"phoneFormat\":\"international\",\"autocompleteAttribute\":\"tel\",\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"phone\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"choices\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"layoutGridColumnSpan\":12,\"enableDisplayInColumns\":\"\",\"enableEnhancedUI\":0,\"layoutGroupId\":\"8bb558fc\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"errors\":[],\"pageNumber\":1,\"fields\":\"\"},{\"is_payment\":false,\"type\":\"textarea\",\"id\":4,\"formId\":1,\"label\":\"\\u0645\\u0648\\u0636\\u0648\\u0639\",\"adminLabel\":\"\",\"isRequired\":false,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"textarea\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\\u0628\\u0631\\u0627\\u06cc \\u0645\\u0634\\u0627\\u0648\\u0631\\u0647 \\u0628\\u0647\\u062a\\u0631 \\u0645\\u0648\\u0636\\u0648\\u0639 \\u067e\\u0631\\u0648\\u0646\\u062f\\u0647 \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0628\\u0647 \\u0627\\u062e\\u062a\\u0635\\u0627\\u0631 \\u0628\\u06cc\\u0627\\u0646 \\u06a9\\u0646\\u06cc\\u062f\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"layoutGridColumnSpan\":12,\"enableDisplayInColumns\":\"\",\"useRichTextEditor\":false,\"enableEnhancedUI\":0,\"layoutGroupId\":\"34ea5967\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"errors\":[],\"pageNumber\":1,\"fields\":\"\"}],\"button\":{\"type\":\"text\",\"text\":\"\\u062f\\u0631\\u062e\\u0648\\u0627\\u0633\\u062a \\u0645\\u0634\\u0627\\u0648\\u0631\\u0647\",\"imageUrl\":\"\",\"width\":\"auto\",\"location\":\"bottom\",\"layoutGridColumnSpan\":12,\"id\":\"submit\"},\"title\":\"\\u062a\\u0645\\u0627\\u0633 \\u0628\\u0627 \\u0645\\u0627\",\"description\":\"\",\"version\":\"2.9.24\",\"id\":1,\"markupVersion\":2,\"nextFieldId\":5,\"useCurrentUserAsAuthor\":true,\"postContentTemplateEnabled\":false,\"postTitleTemplateEnabled\":false,\"postTitleTemplate\":\"\",\"postContentTemplate\":\"\",\"lastPageButton\":null,\"pagination\":null,\"firstPageCssClass\":null,\"notifications\":{\"6941798f83942\":{\"id\":\"6941798f83942\",\"isActive\":true,\"to\":\"{admin_email}\",\"name\":\"\\u0627\\u0639\\u0644\\u0627\\u0646 \\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a\",\"event\":\"form_submission\",\"toType\":\"email\",\"subject\":\"\\u0641\\u0631\\u0645 \\u0627\\u0631\\u0633\\u0627\\u0644\\u06cc \\u062c\\u062f\\u06cc\\u062f {form_title}\",\"message\":\"{all_fields}\"}},\"confirmations\":{\"6941798f83d9c\":{\"id\":\"6941798f83d9c\",\"name\":\"\\u062a\\u0627\\u06cc\\u06cc\\u062f\\u06cc\\u0647 \\u067e\\u06cc\\u0634\\u0641\\u0631\\u0636\",\"isDefault\":true,\"type\":\"message\",\"message\":\"\\u0627\\u0632 \\u062a\\u0645\\u0627\\u0633 \\u0634\\u0645\\u0627 \\u0645\\u062a\\u0634\\u06a9\\u0631\\u06cc\\u0645! \\u0628\\u0647 \\u0632\\u0648\\u062f\\u06cc \\u0628\\u0627 \\u0634\\u0645\\u0627 \\u062a\\u0645\\u0627\\u0633 \\u0645\\u06cc \\u06af\\u06cc\\u0631\\u06cc\\u0645.\",\"url\":\"\",\"pageId\":\"\",\"queryString\":\"\"}},\"labelPlacement\":\"top_label\",\"descriptionPlacement\":\"below\",\"validationPlacement\":\"below\",\"subLabelPlacement\":\"below\",\"requiredIndicator\":\"custom\",\"customRequiredIndicator\":\"(\\u0627\\u0644\\u0632\\u0627\\u0645\\u06cc)\",\"cssClass\":\"\",\"saveButtonText\":\"Save & Continue\",\"limitEntries\":false,\"limitEntriesCount\":\"\",\"limitEntriesPeriod\":\"\",\"limitEntriesMessage\":\"\",\"scheduleForm\":false,\"scheduleStart\":\"\",\"scheduleEnd\":\"\",\"schedulePendingMessage\":\"\",\"scheduleMessage\":\"\",\"requireLogin\":false,\"requireLoginMessage\":\"\",\"enableHoneypot\":true,\"honeypotAction\":\"spam\",\"submitSpeedCheckThreshold\":2000,\"submitSpeedCheckMode\":\"normal\",\"validationSummary\":false,\"deprecated\":\"\",\"saveEnabled\":\"\",\"enableSubmitSpeedCheck\":false,\"enableAnimation\":false,\"save\":{\"enabled\":false,\"button\":{\"type\":\"link\",\"text\":\"Save & Continue\"}},\"scheduleStartHour\":\"\",\"scheduleStartMinute\":\"\",\"scheduleStartAmpm\":\"\",\"scheduleEndHour\":\"\",\"scheduleEndMinute\":\"\",\"scheduleEndAmpm\":\"\"}",NULL,"{\"6941798f83d9c\":{\"id\":\"6941798f83d9c\",\"name\":\"\\u062a\\u0627\\u06cc\\u06cc\\u062f\\u06cc\\u0647 \\u067e\\u06cc\\u0634\\u0641\\u0631\\u0636\",\"isDefault\":true,\"type\":\"message\",\"message\":\"<strong><span style=\\\"font-size: 14pt;\\\">{\\u0646\\u0627\\u0645 \\u0648 \\u0646\\u0627\\u0645 \\u062e\\u0627\\u0646\\u0648\\u0627\\u062f\\u06af\\u06cc (\\u0646\\u0627\\u0645):1.3} {\\u0646\\u0627\\u0645 \\u0648 \\u0646\\u0627\\u0645 \\u062e\\u0627\\u0646\\u0648\\u0627\\u062f\\u06af\\u06cc (\\u0646\\u0627\\u0645 \\u062e\\u0627\\u0646\\u0648\\u0627\\u062f\\u06af\\u06cc):1.6} \\u0639\\u0632\\u06cc\\u0632 \\u0627\\u0632 \\u062a\\u0645\\u0627\\u0633 \\u0634\\u0645\\u0627 \\u0645\\u062a\\u0634\\u06a9\\u0631\\u06cc\\u0645! \\u0628\\u0647 \\u0632\\u0648\\u062f\\u06cc \\u0628\\u0627 \\u0634\\u0645\\u0627 \\u062a\\u0645\\u0627\\u0633 \\u0645\\u06cc \\u06af\\u06cc\\u0631\\u06cc\\u0645.<\\/span><\\/strong>\",\"url\":\"\",\"pageId\":\"\",\"queryString\":\"\",\"event\":\"\",\"disableAutoformat\":false,\"page\":\"\",\"conditionalLogic\":[]}}","{\"6941798f83942\":{\"id\":\"6941798f83942\",\"isActive\":true,\"to\":\"{admin_email}\",\"name\":\"\\u0627\\u0639\\u0644\\u0627\\u0646 \\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a\",\"event\":\"form_submission\",\"toType\":\"email\",\"subject\":\"\\u0641\\u0631\\u0645 \\u0627\\u0631\\u0633\\u0627\\u0644\\u06cc \\u062c\\u062f\\u06cc\\u062f {form_title}\",\"message\":\"{all_fields}\"}}"),
("2","{\"fields\":[],\"button\":{\"type\":\"text\",\"text\":\"\",\"imageUrl\":\"\"},\"title\":\"\\u062f\\u0631\\u062e\\u0648\\u0627\\u0633\\u062a \\u0645\\u0634\\u0627\\u0648\\u0631\\u0647\",\"description\":\"\",\"version\":\"2.9.24\",\"id\":2,\"markupVersion\":2}",NULL,"{\"694270e9c94c4\":{\"id\":\"694270e9c94c4\",\"name\":\"\\u062a\\u0627\\u06cc\\u06cc\\u062f\\u06cc\\u0647 \\u067e\\u06cc\\u0634\\u0641\\u0631\\u0636\",\"isDefault\":true,\"type\":\"message\",\"message\":\"\\u0627\\u0632 \\u062a\\u0645\\u0627\\u0633 \\u0634\\u0645\\u0627 \\u0645\\u062a\\u0634\\u06a9\\u0631\\u06cc\\u0645! \\u0628\\u0647 \\u0632\\u0648\\u062f\\u06cc \\u0628\\u0627 \\u0634\\u0645\\u0627 \\u062a\\u0645\\u0627\\u0633 \\u0645\\u06cc \\u06af\\u06cc\\u0631\\u06cc\\u0645.\",\"url\":\"\",\"pageId\":\"\",\"queryString\":\"\"}}","{\"694270e9c90dc\":{\"id\":\"694270e9c90dc\",\"isActive\":true,\"to\":\"{admin_email}\",\"name\":\"\\u0627\\u0639\\u0644\\u0627\\u0646 \\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a\",\"event\":\"form_submission\",\"toType\":\"email\",\"subject\":\"\\u0641\\u0631\\u0645 \\u0627\\u0631\\u0633\\u0627\\u0644\\u06cc \\u062c\\u062f\\u06cc\\u062f {form_title}\",\"message\":\"{all_fields}\"}}");

INSERT IGNORE INTO `YTcMX_gf_form_view` VALUES 
("1","1","2025-12-16 15:45:11","","18"),
("2","1","2025-12-17 15:47:37","","65"),
("3","1","2025-12-18 15:53:45","","67"),
("4","1","2025-12-19 15:54:05","","69"),
("5","1","2025-12-20 15:54:10","","74"),
("6","1","2025-12-21 15:54:23","","62"),
("7","1","2025-12-22 15:54:55","","108"),
("8","1","2025-12-23 15:55:00","","55"),
("9","1","2025-12-24 15:55:42","","73"),
("10","1","2025-12-25 16:25:31","","67"),
("11","1","2025-12-26 16:26:32","","63"),
("12","1","2025-12-27 16:55:42","","61"),
("13","1","2025-12-28 16:56:09","","61"),
("14","1","2025-12-29 16:56:17","","72"),
("15","1","2025-12-30 16:56:28","","70"),
("16","1","2025-12-31 16:56:47","","55"),
("17","1","2026-01-01 16:57:18","","52"),
("18","1","2026-01-02 17:27:09","","67"),
("19","1","2026-01-03 17:27:20","","55"),
("20","1","2026-01-04 17:27:40","","63"),
("21","1","2026-01-05 17:28:09","","61"),
("22","1","2026-01-06 17:28:50","","65"),
("23","1","2026-01-07 17:31:42","","62"),
("24","1","2026-01-08 17:33:34","","55"),
("25","1","2026-01-09 17:34:08","","52"),
("26","1","2026-01-10 17:34:23","","53"),
("27","1","2026-01-11 17:34:44","","60"),
("28","1","2026-01-12 17:35:09","","55"),
("29","1","2026-01-13 18:01:20","","55"),
("30","1","2026-01-14 18:01:46","","58"),
("31","1","2026-01-15 18:01:54","","64"),
("32","1","2026-01-16 18:02:01","","52"),
("33","1","2026-01-17 18:02:09","","54"),
("34","1","2026-01-18 18:02:41","","59"),
("35","1","2026-01-19 18:32:30","","53"),
("36","1","2026-01-20 18:33:29","","52"),
("37","1","2026-01-21 19:00:47","","51"),
("38","1","2026-01-22 19:04:09","","54"),
("39","1","2026-01-23 19:04:52","","69"),
("40","1","2026-01-24 19:34:29","","54"),
("41","1","2026-01-25 19:34:54","","57"),
("42","1","2026-01-26 19:34:56","","66"),
("43","1","2026-01-27 19:35:04","","56"),
("44","1","2026-01-28 20:02:39","","81"),
("45","1","2026-01-29 20:05:26","","91"),
("46","1","2026-01-30 20:05:35","","70"),
("47","1","2026-01-31 20:35:20","","72"),
("48","1","2026-02-01 21:04:51","","77"),
("49","1","2026-02-02 21:04:57","","63"),
("50","1","2026-02-03 21:06:28","","63"),
("51","1","2026-02-04 21:25:15","","33");

INSERT IGNORE INTO `YTcMX_options` VALUES 
("1","cron","a:32:{i:1770277839;a:1:{s:26:\"action_scheduler_run_queue\";a:1:{s:32:\"0d04ed39571b55704c122d726248bbac\";a:3:{s:8:\"schedule\";s:12:\"every_minute\";s:4:\"args\";a:1:{i:0;s:7:\"WP Cron\";}s:8:\"interval\";i:60;}}}i:1770277853;a:1:{s:26:\"aios_15_minutes_cron_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:21:\"aios-every-15-minutes\";s:4:\"args\";a:0:{}s:8:\"interval\";i:900;}}}i:1770278650;a:1:{s:32:\"duplicator_backup_storages_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:41:\"duplicator_backup_storages_check_interval\";s:4:\"args\";a:0:{}s:8:\"interval\";i:900;}}}i:1770278907;a:1:{s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1770279653;a:1:{s:24:\"aiowps_hourly_cron_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1770280469;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1770282268;a:1:{s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1770282737;a:1:{s:35:\"rank_math/content-ai/update_prompts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1770284068;a:1:{s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1770284087;a:1:{s:26:\"upgrader_scheduled_cleanup\";a:1:{s:32:\"b4e4c4c859f3fb1f1bb72c6ec664e2a7\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:1623;}}}}i:1770284635;a:1:{s:26:\"upgrader_scheduled_cleanup\";a:1:{s:32:\"5fd7db3f9b98a021f0372fce87016940\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:1624;}}}}i:1770286853;a:2:{s:23:\"aiowps_daily_cron_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:23:\"aiowps_clean_old_events\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1770288185;a:1:{s:29:\"wp_statistics_daily_cron_hook\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1770288186;a:1:{s:31:\"wp_statistics_referrals_db_hook\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:7:\"monthly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:2592000;}}}i:1770289221;a:1:{s:28:\"elementor/tracker/send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1770291459;a:1:{s:20:\"non_recur_subs_daily\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1770304914;a:1:{s:17:\"gravityforms_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1770320069;a:1:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1770322107;a:2:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1770322108;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1770323400;a:2:{s:26:\"wp_statistics_dbmaint_hook\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:34:\"wp_statistics_record_daily_summary\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1770336000;a:2:{s:35:\"rank_math/redirection/clean_trashed\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:30:\"rank_math/links/internal_links\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1770364150;a:1:{s:31:\"duplicator_activity_log_cleanup\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:21:\"duplicator_daily_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1770417779;a:1:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1770492956;a:1:{s:30:\"wp_delete_temp_updater_backups\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1770546053;a:1:{s:24:\"aiowps_weekly_cron_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1770547386;a:1:{s:35:\"wp_statistics_check_licenses_status\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1770578900;a:1:{s:24:\"astra_delete_docs_folder\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1770579269;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1770633000;a:1:{s:33:\"duplicator_pro_email_summary_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1771025332;a:1:{s:30:\"duplicator_usage_tracking_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}s:7:\"version\";i:2;}","on"),
("2","siteurl","https://avnalaw.com","on"),
("3","home","https://avnalaw.com","on"),
("4","blogname","گروه وکلای آونا - بهترین وکلای پایه 1 تهران","on"),
("5","blogdescription","مشاوره و خدمات حقوقی","on"),
("6","users_can_register","0","on"),
("7","admin_email","admin@avnalaw.com","on"),
("8","start_of_week","6","on"),
("9","use_balanceTags","0","on"),
("10","use_smilies","1","on"),
("11","require_name_email","","on"),
("12","comments_notify","","on"),
("13","posts_per_rss","10","on"),
("14","rss_use_excerpt","0","on"),
("15","mailserver_url","mail.example.com","on"),
("16","mailserver_login","login@example.com","on"),
("17","mailserver_pass","","on"),
("18","mailserver_port","110","on"),
("19","default_category","1","on"),
("20","default_comment_status","open","on"),
("21","default_ping_status","","on"),
("22","default_pingback_flag","","on"),
("23","posts_per_page","12","on"),
("24","date_format","F j, Y","on"),
("25","time_format","g:i a","on"),
("26","links_updated_date_format","F j, Y g:i a","on"),
("27","comment_moderation","1","on"),
("28","moderation_notify","","on"),
("29","permalink_structure","/%category%/%postname%/","on"),
("31","hack_file","0","on"),
("32","blog_charset","UTF-8","on"),
("33","moderation_keys","","off"),
("34","active_plugins","a:12:{i:0;s:29:\"gravityforms/gravityforms.php\";i:1;s:51:\"all-in-one-wp-security-and-firewall/wp-security.php\";i:2;s:19:\"chaty/cht-icons.php\";i:3;s:33:\"classic-editor/classic-editor.php\";i:4;s:33:\"duplicator-pro/duplicator-pro.php\";i:5;s:31:\"elementor-pro/elementor-pro.php\";i:6;s:23:\"elementor/elementor.php\";i:7;s:65:\"essential-addons-for-elementor-lite/essential_adons_elementor.php\";i:8;s:30:\"seo-by-rank-math/rank-math.php\";i:9;s:37:\"tinymce-advanced/tinymce-advanced.php\";i:10;s:23:\"wp-shamsi/wp-shamsi.php\";i:11;s:31:\"wp-statistics/wp-statistics.php\";}","on"),
("35","category_base","","on"),
("36","ping_sites","https://rpc.pingomatic.com/","on"),
("37","comment_max_links","2","on"),
("38","gmt_offset","","on"),
("39","default_email_category","1","on"),
("40","recently_edited","","off"),
("41","template","hello-elementor","on"),
("42","stylesheet","hello-elementor","on"),
("43","comment_registration","","on"),
("44","html_type","text/html","on"),
("45","use_trackback","0","on"),
("46","default_role","subscriber","on"),
("47","db_version","60717","on"),
("48","uploads_use_yearmonth_folders","1","on"),
("49","upload_path","","on"),
("50","blog_public","1","on"),
("51","default_link_category","0","on"),
("52","show_on_front","page","on"),
("53","tag_base","","on"),
("54","show_avatars","","on"),
("55","avatar_rating","G","on"),
("56","upload_url_path","","on"),
("57","thumbnail_size_w","150","on"),
("58","thumbnail_size_h","150","on"),
("59","thumbnail_crop","1","on"),
("60","medium_size_w","300","on"),
("61","medium_size_h","300","on"),
("62","avatar_default","mystery","on"),
("63","large_size_w","1024","on"),
("64","large_size_h","1024","on"),
("65","image_default_link_type","","on"),
("66","image_default_size","","on"),
("67","image_default_align","","on"),
("68","close_comments_for_old_posts","","on"),
("69","close_comments_days_old","14","on"),
("70","thread_comments","1","on"),
("71","thread_comments_depth","5","on"),
("72","page_comments","","on"),
("73","comments_per_page","50","on"),
("74","default_comments_page","newest","on"),
("75","comment_order","asc","on"),
("76","sticky_posts","a:0:{}","on"),
("77","widget_categories","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","auto"),
("78","widget_text","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","auto"),
("79","widget_rss","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","auto"),
("80","uninstall_plugins","a:7:{s:44:\"click-to-chat-for-whatsapp/click-to-chat.php\";a:2:{i:0;s:15:\"HT_CTC_Register\";i:1;s:9:\"uninstall\";}s:51:\"all-in-one-wp-security-and-firewall/wp-security.php\";a:2:{i:0;s:15:\"AIO_WP_Security\";i:1;s:17:\"uninstall_handler\";}s:31:\"wp-statistics/wp-statistics.php\";a:2:{i:0;s:13:\"WP_Statistics\";i:1;s:11:\"uninstaller\";}s:23:\"elementor/elementor.php\";a:2:{i:0;s:21:\"Elementor\\Maintenance\";i:1;s:9:\"uninstall\";}s:31:\"cache-enabler/cache-enabler.php\";a:2:{i:0;s:13:\"Cache_Enabler\";i:1;s:12:\"on_uninstall\";}s:33:\"wp-call-button/wp-call-button.php\";s:29:\"wp_call_button_uninstall_hook\";s:27:\"autoptimize/autoptimize.php\";s:29:\"autoptimizeMain::on_uninstall\";}","off"),
("81","timezone_string","Asia/Tehran","on"),
("82","page_for_posts","156","on"),
("83","page_on_front","1179","on"),
("84","default_post_format","0","on"),
("85","link_manager_enabled","0","on"),
("86","finished_splitting_shared_terms","1","on"),
("87","site_icon","1517","on"),
("88","medium_large_size_w","768","on"),
("89","medium_large_size_h","0","on"),
("90","wp_page_for_privacy_policy","3","on"),
("91","show_comments_cookies_opt_in","","on"),
("92","admin_email_lifespan","1772134468","on"),
("93","disallowed_keys","","off"),
("94","comment_previously_approved","","on"),
("95","auto_plugin_theme_update_emails","a:0:{}","off"),
("96","auto_update_core_dev","enabled","on"),
("97","auto_update_core_minor","enabled","on"),
("98","auto_update_core_major","enabled","on"),
("99","wp_force_deactivated_plugins","a:0:{}","on"),
("100","wp_attachment_pages_enabled","0","on"),
("101","initial_db_version","60421","on"),
("102","YTcMX_user_roles","a:6:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:107:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:23:\"wf2fa_activate_2fa_self\";b:1;s:25:\"wf2fa_activate_2fa_others\";b:1;s:21:\"wf2fa_manage_settings\";b:1;s:23:\"manage_zip_ai_assistant\";b:1;s:26:\"manage_ast_block_templates\";b:1;s:23:\"rank_math_edit_htaccess\";b:1;s:16:\"rank_math_titles\";b:1;s:17:\"rank_math_general\";b:1;s:17:\"rank_math_sitemap\";b:1;s:21:\"rank_math_404_monitor\";b:1;s:22:\"rank_math_link_builder\";b:1;s:22:\"rank_math_redirections\";b:1;s:22:\"rank_math_role_manager\";b:1;s:19:\"rank_math_analytics\";b:1;s:23:\"rank_math_site_analysis\";b:1;s:25:\"rank_math_onpage_analysis\";b:1;s:24:\"rank_math_onpage_general\";b:1;s:25:\"rank_math_onpage_advanced\";b:1;s:24:\"rank_math_onpage_snippet\";b:1;s:23:\"rank_math_onpage_social\";b:1;s:20:\"rank_math_content_ai\";b:1;s:19:\"rank_math_admin_bar\";b:1;s:27:\"fluentform_dashboard_access\";b:1;s:24:\"fluentform_forms_manager\";b:1;s:25:\"fluentform_entries_viewer\";b:1;s:25:\"fluentform_manage_entries\";b:1;s:24:\"fluentform_view_payments\";b:1;s:26:\"fluentform_manage_payments\";b:1;s:27:\"fluentform_settings_manager\";b:1;s:22:\"fluentform_full_access\";b:1;s:26:\"create_notes_elementor-pro\";b:1;s:24:\"edit_notes_elementor-pro\";b:1;s:26:\"delete_notes_elementor-pro\";b:1;s:24:\"read_notes_elementor-pro\";b:1;s:31:\"edit_others_notes_elementor-pro\";b:1;s:33:\"delete_others_notes_elementor-pro\";b:1;s:39:\"read_others_private_notes_elementor-pro\";b:1;s:20:\"duplicator_pro_basic\";b:1;s:21:\"duplicator_pro_create\";b:1;s:23:\"duplicator_pro_schedule\";b:1;s:22:\"duplicator_pro_storage\";b:1;s:29:\"duplicator_pro_backup_restore\";b:1;s:21:\"duplicator_pro_import\";b:1;s:21:\"duplicator_pro_export\";b:1;s:23:\"duplicator_pro_settings\";b:1;s:22:\"duplicator_pro_license\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:40:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:23:\"rank_math_site_analysis\";b:1;s:25:\"rank_math_onpage_analysis\";b:1;s:24:\"rank_math_onpage_general\";b:1;s:24:\"rank_math_onpage_snippet\";b:1;s:23:\"rank_math_onpage_social\";b:1;s:23:\"manage_zip_ai_assistant\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:14:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:25:\"rank_math_onpage_analysis\";b:1;s:24:\"rank_math_onpage_general\";b:1;s:24:\"rank_math_onpage_snippet\";b:1;s:23:\"rank_math_onpage_social\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:7:\"manager\";a:2:{s:4:\"name\";s:8:\"مدیر\";s:12:\"capabilities\";a:11:{s:4:\"read\";b:1;s:10:\"edit_posts\";b:1;s:13:\"publish_posts\";b:1;s:12:\"delete_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:12:\"upload_files\";b:1;s:12:\"assign_terms\";b:1;s:17:\"edit_others_posts\";b:0;s:19:\"delete_others_posts\";b:0;s:17:\"manage_categories\";b:1;}}}","on"),
("103","fresh_site","0","off"),
("104","user_count","5","off"),
("105","widget_block","a:16:{i:2;a:1:{s:7:\"content\";s:19:\"<!-- wp:search /-->\";}i:3;a:1:{s:7:\"content\";s:154:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Recent Posts</h2><!-- /wp:heading --><!-- wp:latest-posts /--></div><!-- /wp:group -->\";}i:4;a:1:{s:7:\"content\";s:227:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Recent Comments</h2><!-- /wp:heading --><!-- wp:latest-comments {\"displayAvatar\":false,\"displayDate\":false,\"displayExcerpt\":false} /--></div><!-- /wp:group -->\";}i:5;a:1:{s:7:\"content\";s:146:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Archives</h2><!-- /wp:heading --><!-- wp:archives /--></div><!-- /wp:group -->\";}i:6;a:1:{s:7:\"content\";s:150:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Categories</h2><!-- /wp:heading --><!-- wp:categories /--></div><!-- /wp:group -->\";}s:12:\"_multiwidget\";i:1;i:9;a:1:{s:7:\"content\";s:69:\"<!-- wp:paragraph -->\n<p>درباره ما</p>\n<!-- /wp:paragraph -->\";}i:10;a:1:{s:7:\"content\";s:108:\"<!-- wp:heading {\"level\":3} -->\n<h3 class=\"wp-block-heading\">دسترسی سریع</h3>\n<!-- /wp:heading -->\";}i:11;a:1:{s:7:\"content\";s:109:\"<!-- wp:heading {\"level\":3} -->\n<h3 class=\"wp-block-heading\">ارتباط با ما</h3>\n<!-- /wp:heading -->\";}i:12;a:1:{s:7:\"content\";s:52:\"<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\";}i:13;a:1:{s:7:\"content\";s:104:\"<!-- wp:heading {\"level\":3} -->\n<h3 class=\"wp-block-heading\">درباره ما</h3>\n<!-- /wp:heading -->\";}i:14;a:1:{s:7:\"content\";s:52:\"<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\";}i:15;a:1:{s:7:\"content\";s:896:\"<!-- wp:paragraph {\"align\":\"right\",\"className\":\"footer-text-about\",\"style\":{\"elements\":{\"link\":{\":hover\":{\"color\":{\"text\":\"#f0b323\"}},\"color\":{\"text\":\"var:preset|color|white\"}}},\"typography\":{\"fontSize\":\"18px\"}},\"textColor\":\"white\"} -->\n<p class=\"has-text-align-right footer-text-about has-white-color has-text-color has-link-color\" style=\"font-size:18px\"><strong><a href=\"/\">گروه وکلای آونا</a></strong> ارائه‌دهند‌ه‌ی خدمات تخصصی مشاوره و وکالت هستند. از تنظیم و بازبینی قراردادها تا حل اختلافات ملکی و تجاری، دعاوی خانواده و امور کیفری، تلاش ما ارائه‌ی راه‌حل‌های سریع، شفاف و قابل اتکا است. برای شروع همکاری و تعیین وقت مشاوره با ما در تماس باشید.</p>\n<!-- /wp:paragraph -->\";}i:16;a:1:{s:7:\"content\";s:439:\"<!-- wp:paragraph {\"className\":\"footer-text-phone\",\"style\":{\"typography\":{\"fontSize\":\"20px\"},\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|ast-global-color-4\"},\":hover\":{\"color\":{\"text\":\"#f0b323\"}}}}},\"textColor\":\"ast-global-color-4\"} -->\n<p class=\"footer-text-phone has-ast-global-color-4-color has-text-color has-link-color\" style=\"font-size:20px\"><a href=\"tel:+989122984278\">۰۹۱۲۲۹۸۴۲۷۸</a></p>\n<!-- /wp:paragraph -->\";}i:18;a:1:{s:7:\"content\";s:453:\"<!-- wp:paragraph {\"className\":\"footer-text-mail\",\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|ast-global-color-4\"},\":hover\":{\"color\":{\"text\":\"#f0b323\"}}}},\"typography\":{\"fontSize\":\"16px\"}},\"textColor\":\"ast-global-color-4\"} -->\n<p class=\"footer-text-mail has-ast-global-color-4-color has-text-color has-link-color\" style=\"font-size:16px\"><a href=\"mailto:meysamasadpor6@gmail.com\">meysamasadpor6@gmail.com</a></p>\n<!-- /wp:paragraph -->\";}i:20;a:1:{s:7:\"content\";s:142:\"<!-- wp:search {\"label\":\"\",\"showLabel\":false,\"buttonText\":\"\",\"buttonPosition\":\"button-inside\",\"style\":{\"color\":{\"background\":\"#f0b323\"}}} /-->\";}}","on"),
("106","sidebars_widgets","a:2:{s:19:\"wp_inactive_widgets\";a:15:{i:0;s:7:\"block-9\";i:1;s:8:\"block-12\";i:2;s:8:\"block-14\";i:3;s:7:\"block-2\";i:4;s:7:\"block-3\";i:5;s:7:\"block-4\";i:6;s:7:\"block-5\";i:7;s:7:\"block-6\";i:8;s:8:\"block-13\";i:9;s:8:\"block-15\";i:10;s:8:\"block-10\";i:11;s:8:\"block-11\";i:12;s:8:\"block-16\";i:13;s:8:\"block-18\";i:14;s:8:\"block-20\";}s:13:\"array_version\";i:3;}","on"),
("107","widget_pages","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("108","widget_calendar","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("109","widget_archives","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("110","widget_media_audio","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("111","widget_media_image","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("112","widget_media_gallery","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("113","widget_media_video","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("114","widget_meta","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("115","widget_search","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("116","widget_recent-posts","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("117","widget_recent-comments","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("118","widget_tag_cloud","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("119","widget_nav_menu","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("120","widget_custom_html","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("121","_transient_wp_core_block_css_files","a:2:{s:7:\"version\";s:5:\"6.9.1\";s:5:\"files\";a:584:{i:0;s:31:\"accordion-heading/style-rtl.css\";i:1;s:35:\"accordion-heading/style-rtl.min.css\";i:2;s:27:\"accordion-heading/style.css\";i:3;s:31:\"accordion-heading/style.min.css\";i:4;s:28:\"accordion-item/style-rtl.css\";i:5;s:32:\"accordion-item/style-rtl.min.css\";i:6;s:24:\"accordion-item/style.css\";i:7;s:28:\"accordion-item/style.min.css\";i:8;s:29:\"accordion-panel/style-rtl.css\";i:9;s:33:\"accordion-panel/style-rtl.min.css\";i:10;s:25:\"accordion-panel/style.css\";i:11;s:29:\"accordion-panel/style.min.css\";i:12;s:23:\"accordion/style-rtl.css\";i:13;s:27:\"accordion/style-rtl.min.css\";i:14;s:19:\"accordion/style.css\";i:15;s:23:\"accordion/style.min.css\";i:16;s:23:\"archives/editor-rtl.css\";i:17;s:27:\"archives/editor-rtl.min.css\";i:18;s:19:\"archives/editor.css\";i:19;s:23:\"archives/editor.min.css\";i:20;s:22:\"archives/style-rtl.css\";i:21;s:26:\"archives/style-rtl.min.css\";i:22;s:18:\"archives/style.css\";i:23;s:22:\"archives/style.min.css\";i:24;s:20:\"audio/editor-rtl.css\";i:25;s:24:\"audio/editor-rtl.min.css\";i:26;s:16:\"audio/editor.css\";i:27;s:20:\"audio/editor.min.css\";i:28;s:19:\"audio/style-rtl.css\";i:29;s:23:\"audio/style-rtl.min.css\";i:30;s:15:\"audio/style.css\";i:31;s:19:\"audio/style.min.css\";i:32;s:19:\"audio/theme-rtl.css\";i:33;s:23:\"audio/theme-rtl.min.css\";i:34;s:15:\"audio/theme.css\";i:35;s:19:\"audio/theme.min.css\";i:36;s:21:\"avatar/editor-rtl.css\";i:37;s:25:\"avatar/editor-rtl.min.css\";i:38;s:17:\"avatar/editor.css\";i:39;s:21:\"avatar/editor.min.css\";i:40;s:20:\"avatar/style-rtl.css\";i:41;s:24:\"avatar/style-rtl.min.css\";i:42;s:16:\"avatar/style.css\";i:43;s:20:\"avatar/style.min.css\";i:44;s:21:\"button/editor-rtl.css\";i:45;s:25:\"button/editor-rtl.min.css\";i:46;s:17:\"button/editor.css\";i:47;s:21:\"button/editor.min.css\";i:48;s:20:\"button/style-rtl.css\";i:49;s:24:\"button/style-rtl.min.css\";i:50;s:16:\"button/style.css\";i:51;s:20:\"button/style.min.css\";i:52;s:22:\"buttons/editor-rtl.css\";i:53;s:26:\"buttons/editor-rtl.min.css\";i:54;s:18:\"buttons/editor.css\";i:55;s:22:\"buttons/editor.min.css\";i:56;s:21:\"buttons/style-rtl.css\";i:57;s:25:\"buttons/style-rtl.min.css\";i:58;s:17:\"buttons/style.css\";i:59;s:21:\"buttons/style.min.css\";i:60;s:22:\"calendar/style-rtl.css\";i:61;s:26:\"calendar/style-rtl.min.css\";i:62;s:18:\"calendar/style.css\";i:63;s:22:\"calendar/style.min.css\";i:64;s:25:\"categories/editor-rtl.css\";i:65;s:29:\"categories/editor-rtl.min.css\";i:66;s:21:\"categories/editor.css\";i:67;s:25:\"categories/editor.min.css\";i:68;s:24:\"categories/style-rtl.css\";i:69;s:28:\"categories/style-rtl.min.css\";i:70;s:20:\"categories/style.css\";i:71;s:24:\"categories/style.min.css\";i:72;s:19:\"code/editor-rtl.css\";i:73;s:23:\"code/editor-rtl.min.css\";i:74;s:15:\"code/editor.css\";i:75;s:19:\"code/editor.min.css\";i:76;s:18:\"code/style-rtl.css\";i:77;s:22:\"code/style-rtl.min.css\";i:78;s:14:\"code/style.css\";i:79;s:18:\"code/style.min.css\";i:80;s:18:\"code/theme-rtl.css\";i:81;s:22:\"code/theme-rtl.min.css\";i:82;s:14:\"code/theme.css\";i:83;s:18:\"code/theme.min.css\";i:84;s:22:\"columns/editor-rtl.css\";i:85;s:26:\"columns/editor-rtl.min.css\";i:86;s:18:\"columns/editor.css\";i:87;s:22:\"columns/editor.min.css\";i:88;s:21:\"columns/style-rtl.css\";i:89;s:25:\"columns/style-rtl.min.css\";i:90;s:17:\"columns/style.css\";i:91;s:21:\"columns/style.min.css\";i:92;s:33:\"comment-author-name/style-rtl.css\";i:93;s:37:\"comment-author-name/style-rtl.min.css\";i:94;s:29:\"comment-author-name/style.css\";i:95;s:33:\"comment-author-name/style.min.css\";i:96;s:29:\"comment-content/style-rtl.css\";i:97;s:33:\"comment-content/style-rtl.min.css\";i:98;s:25:\"comment-content/style.css\";i:99;s:29:\"comment-content/style.min.css\";i:100;s:26:\"comment-date/style-rtl.css\";i:101;s:30:\"comment-date/style-rtl.min.css\";i:102;s:22:\"comment-date/style.css\";i:103;s:26:\"comment-date/style.min.css\";i:104;s:31:\"comment-edit-link/style-rtl.css\";i:105;s:35:\"comment-edit-link/style-rtl.min.css\";i:106;s:27:\"comment-edit-link/style.css\";i:107;s:31:\"comment-edit-link/style.min.css\";i:108;s:32:\"comment-reply-link/style-rtl.css\";i:109;s:36:\"comment-reply-link/style-rtl.min.css\";i:110;s:28:\"comment-reply-link/style.css\";i:111;s:32:\"comment-reply-link/style.min.css\";i:112;s:30:\"comment-template/style-rtl.css\";i:113;s:34:\"comment-template/style-rtl.min.css\";i:114;s:26:\"comment-template/style.css\";i:115;s:30:\"comment-template/style.min.css\";i:116;s:42:\"comments-pagination-numbers/editor-rtl.css\";i:117;s:46:\"comments-pagination-numbers/editor-rtl.min.css\";i:118;s:38:\"comments-pagination-numbers/editor.css\";i:119;s:42:\"comments-pagination-numbers/editor.min.css\";i:120;s:34:\"comments-pagination/editor-rtl.css\";i:121;s:38:\"comments-pagination/editor-rtl.min.css\";i:122;s:30:\"comments-pagination/editor.css\";i:123;s:34:\"comments-pagination/editor.min.css\";i:124;s:33:\"comments-pagination/style-rtl.css\";i:125;s:37:\"comments-pagination/style-rtl.min.css\";i:126;s:29:\"comments-pagination/style.css\";i:127;s:33:\"comments-pagination/style.min.css\";i:128;s:29:\"comments-title/editor-rtl.css\";i:129;s:33:\"comments-title/editor-rtl.min.css\";i:130;s:25:\"comments-title/editor.css\";i:131;s:29:\"comments-title/editor.min.css\";i:132;s:23:\"comments/editor-rtl.css\";i:133;s:27:\"comments/editor-rtl.min.css\";i:134;s:19:\"comments/editor.css\";i:135;s:23:\"comments/editor.min.css\";i:136;s:22:\"comments/style-rtl.css\";i:137;s:26:\"comments/style-rtl.min.css\";i:138;s:18:\"comments/style.css\";i:139;s:22:\"comments/style.min.css\";i:140;s:20:\"cover/editor-rtl.css\";i:141;s:24:\"cover/editor-rtl.min.css\";i:142;s:16:\"cover/editor.css\";i:143;s:20:\"cover/editor.min.css\";i:144;s:19:\"cover/style-rtl.css\";i:145;s:23:\"cover/style-rtl.min.css\";i:146;s:15:\"cover/style.css\";i:147;s:19:\"cover/style.min.css\";i:148;s:22:\"details/editor-rtl.css\";i:149;s:26:\"details/editor-rtl.min.css\";i:150;s:18:\"details/editor.css\";i:151;s:22:\"details/editor.min.css\";i:152;s:21:\"details/style-rtl.css\";i:153;s:25:\"details/style-rtl.min.css\";i:154;s:17:\"details/style.css\";i:155;s:21:\"details/style.min.css\";i:156;s:20:\"embed/editor-rtl.css\";i:157;s:24:\"embed/editor-rtl.min.css\";i:158;s:16:\"embed/editor.css\";i:159;s:20:\"embed/editor.min.css\";i:160;s:19:\"embed/style-rtl.css\";i:161;s:23:\"embed/style-rtl.min.css\";i:162;s:15:\"embed/style.css\";i:163;s:19:\"embed/style.min.css\";i:164;s:19:\"embed/theme-rtl.css\";i:165;s:23:\"embed/theme-rtl.min.css\";i:166;s:15:\"embed/theme.css\";i:167;s:19:\"embed/theme.min.css\";i:168;s:19:\"file/editor-rtl.css\";i:169;s:23:\"file/editor-rtl.min.css\";i:170;s:15:\"file/editor.css\";i:171;s:19:\"file/editor.min.css\";i:172;s:18:\"file/style-rtl.css\";i:173;s:22:\"file/style-rtl.min.css\";i:174;s:14:\"file/style.css\";i:175;s:18:\"file/style.min.css\";i:176;s:23:\"footnotes/style-rtl.css\";i:177;s:27:\"footnotes/style-rtl.min.css\";i:178;s:19:\"footnotes/style.css\";i:179;s:23:\"footnotes/style.min.css\";i:180;s:23:\"freeform/editor-rtl.css\";i:181;s:27:\"freeform/editor-rtl.min.css\";i:182;s:19:\"freeform/editor.css\";i:183;s:23:\"freeform/editor.min.css\";i:184;s:22:\"gallery/editor-rtl.css\";i:185;s:26:\"gallery/editor-rtl.min.css\";i:186;s:18:\"gallery/editor.css\";i:187;s:22:\"gallery/editor.min.css\";i:188;s:21:\"gallery/style-rtl.css\";i:189;s:25:\"gallery/style-rtl.min.css\";i:190;s:17:\"gallery/style.css\";i:191;s:21:\"gallery/style.min.css\";i:192;s:21:\"gallery/theme-rtl.css\";i:193;s:25:\"gallery/theme-rtl.min.css\";i:194;s:17:\"gallery/theme.css\";i:195;s:21:\"gallery/theme.min.css\";i:196;s:20:\"group/editor-rtl.css\";i:197;s:24:\"group/editor-rtl.min.css\";i:198;s:16:\"group/editor.css\";i:199;s:20:\"group/editor.min.css\";i:200;s:19:\"group/style-rtl.css\";i:201;s:23:\"group/style-rtl.min.css\";i:202;s:15:\"group/style.css\";i:203;s:19:\"group/style.min.css\";i:204;s:19:\"group/theme-rtl.css\";i:205;s:23:\"group/theme-rtl.min.css\";i:206;s:15:\"group/theme.css\";i:207;s:19:\"group/theme.min.css\";i:208;s:21:\"heading/style-rtl.css\";i:209;s:25:\"heading/style-rtl.min.css\";i:210;s:17:\"heading/style.css\";i:211;s:21:\"heading/style.min.css\";i:212;s:19:\"html/editor-rtl.css\";i:213;s:23:\"html/editor-rtl.min.css\";i:214;s:15:\"html/editor.css\";i:215;s:19:\"html/editor.min.css\";i:216;s:20:\"image/editor-rtl.css\";i:217;s:24:\"image/editor-rtl.min.css\";i:218;s:16:\"image/editor.css\";i:219;s:20:\"image/editor.min.css\";i:220;s:19:\"image/style-rtl.css\";i:221;s:23:\"image/style-rtl.min.css\";i:222;s:15:\"image/style.css\";i:223;s:19:\"image/style.min.css\";i:224;s:19:\"image/theme-rtl.css\";i:225;s:23:\"image/theme-rtl.min.css\";i:226;s:15:\"image/theme.css\";i:227;s:19:\"image/theme.min.css\";i:228;s:29:\"latest-comments/style-rtl.css\";i:229;s:33:\"latest-comments/style-rtl.min.css\";i:230;s:25:\"latest-comments/style.css\";i:231;s:29:\"latest-comments/style.min.css\";i:232;s:27:\"latest-posts/editor-rtl.css\";i:233;s:31:\"latest-posts/editor-rtl.min.css\";i:234;s:23:\"latest-posts/editor.css\";i:235;s:27:\"latest-posts/editor.min.css\";i:236;s:26:\"latest-posts/style-rtl.css\";i:237;s:30:\"latest-posts/style-rtl.min.css\";i:238;s:22:\"latest-posts/style.css\";i:239;s:26:\"latest-posts/style.min.css\";i:240;s:18:\"list/style-rtl.css\";i:241;s:22:\"list/style-rtl.min.css\";i:242;s:14:\"list/style.css\";i:243;s:18:\"list/style.min.css\";i:244;s:22:\"loginout/style-rtl.css\";i:245;s:26:\"loginout/style-rtl.min.css\";i:246;s:18:\"loginout/style.css\";i:247;s:22:\"loginout/style.min.css\";i:248;s:19:\"math/editor-rtl.css\";i:249;s:23:\"math/editor-rtl.min.css\";i:250;s:15:\"math/editor.css\";i:251;s:19:\"math/editor.min.css\";i:252;s:18:\"math/style-rtl.css\";i:253;s:22:\"math/style-rtl.min.css\";i:254;s:14:\"math/style.css\";i:255;s:18:\"math/style.min.css\";i:256;s:25:\"media-text/editor-rtl.css\";i:257;s:29:\"media-text/editor-rtl.min.css\";i:258;s:21:\"media-text/editor.css\";i:259;s:25:\"media-text/editor.min.css\";i:260;s:24:\"media-text/style-rtl.css\";i:261;s:28:\"media-text/style-rtl.min.css\";i:262;s:20:\"media-text/style.css\";i:263;s:24:\"media-text/style.min.css\";i:264;s:19:\"more/editor-rtl.css\";i:265;s:23:\"more/editor-rtl.min.css\";i:266;s:15:\"more/editor.css\";i:267;s:19:\"more/editor.min.css\";i:268;s:30:\"navigation-link/editor-rtl.css\";i:269;s:34:\"navigation-link/editor-rtl.min.css\";i:270;s:26:\"navigation-link/editor.css\";i:271;s:30:\"navigation-link/editor.min.css\";i:272;s:29:\"navigation-link/style-rtl.css\";i:273;s:33:\"navigation-link/style-rtl.min.css\";i:274;s:25:\"navigation-link/style.css\";i:275;s:29:\"navigation-link/style.min.css\";i:276;s:33:\"navigation-submenu/editor-rtl.css\";i:277;s:37:\"navigation-submenu/editor-rtl.min.css\";i:278;s:29:\"navigation-submenu/editor.css\";i:279;s:33:\"navigation-submenu/editor.min.css\";i:280;s:25:\"navigation/editor-rtl.css\";i:281;s:29:\"navigation/editor-rtl.min.css\";i:282;s:21:\"navigation/editor.css\";i:283;s:25:\"navigation/editor.min.css\";i:284;s:24:\"navigation/style-rtl.css\";i:285;s:28:\"navigation/style-rtl.min.css\";i:286;s:20:\"navigation/style.css\";i:287;s:24:\"navigation/style.min.css\";i:288;s:23:\"nextpage/editor-rtl.css\";i:289;s:27:\"nextpage/editor-rtl.min.css\";i:290;s:19:\"nextpage/editor.css\";i:291;s:23:\"nextpage/editor.min.css\";i:292;s:24:\"page-list/editor-rtl.css\";i:293;s:28:\"page-list/editor-rtl.min.css\";i:294;s:20:\"page-list/editor.css\";i:295;s:24:\"page-list/editor.min.css\";i:296;s:23:\"page-list/style-rtl.css\";i:297;s:27:\"page-list/style-rtl.min.css\";i:298;s:19:\"page-list/style.css\";i:299;s:23:\"page-list/style.min.css\";i:300;s:24:\"paragraph/editor-rtl.css\";i:301;s:28:\"paragraph/editor-rtl.min.css\";i:302;s:20:\"paragraph/editor.css\";i:303;s:24:\"paragraph/editor.min.css\";i:304;s:23:\"paragraph/style-rtl.css\";i:305;s:27:\"paragraph/style-rtl.min.css\";i:306;s:19:\"paragraph/style.css\";i:307;s:23:\"paragraph/style.min.css\";i:308;s:35:\"post-author-biography/style-rtl.css\";i:309;s:39:\"post-author-biography/style-rtl.min.css\";i:310;s:31:\"post-author-biography/style.css\";i:311;s:35:\"post-author-biography/style.min.css\";i:312;s:30:\"post-author-name/style-rtl.css\";i:313;s:34:\"post-author-name/style-rtl.min.css\";i:314;s:26:\"post-author-name/style.css\";i:315;s:30:\"post-author-name/style.min.css\";i:316;s:25:\"post-author/style-rtl.css\";i:317;s:29:\"post-author/style-rtl.min.css\";i:318;s:21:\"post-author/style.css\";i:319;s:25:\"post-author/style.min.css\";i:320;s:33:\"post-comments-count/style-rtl.css\";i:321;s:37:\"post-comments-count/style-rtl.min.css\";i:322;s:29:\"post-comments-count/style.css\";i:323;s:33:\"post-comments-count/style.min.css\";i:324;s:33:\"post-comments-form/editor-rtl.css\";i:325;s:37:\"post-comments-form/editor-rtl.min.css\";i:326;s:29:\"post-comments-form/editor.css\";i:327;s:33:\"post-comments-form/editor.min.css\";i:328;s:32:\"post-comments-form/style-rtl.css\";i:329;s:36:\"post-comments-form/style-rtl.min.css\";i:330;s:28:\"post-comments-form/style.css\";i:331;s:32:\"post-comments-form/style.min.css\";i:332;s:32:\"post-comments-link/style-rtl.css\";i:333;s:36:\"post-comments-link/style-rtl.min.css\";i:334;s:28:\"post-comments-link/style.css\";i:335;s:32:\"post-comments-link/style.min.css\";i:336;s:26:\"post-content/style-rtl.css\";i:337;s:30:\"post-content/style-rtl.min.css\";i:338;s:22:\"post-content/style.css\";i:339;s:26:\"post-content/style.min.css\";i:340;s:23:\"post-date/style-rtl.css\";i:341;s:27:\"post-date/style-rtl.min.css\";i:342;s:19:\"post-date/style.css\";i:343;s:23:\"post-date/style.min.css\";i:344;s:27:\"post-excerpt/editor-rtl.css\";i:345;s:31:\"post-excerpt/editor-rtl.min.css\";i:346;s:23:\"post-excerpt/editor.css\";i:347;s:27:\"post-excerpt/editor.min.css\";i:348;s:26:\"post-excerpt/style-rtl.css\";i:349;s:30:\"post-excerpt/style-rtl.min.css\";i:350;s:22:\"post-excerpt/style.css\";i:351;s:26:\"post-excerpt/style.min.css\";i:352;s:34:\"post-featured-image/editor-rtl.css\";i:353;s:38:\"post-featured-image/editor-rtl.min.css\";i:354;s:30:\"post-featured-image/editor.css\";i:355;s:34:\"post-featured-image/editor.min.css\";i:356;s:33:\"post-featured-image/style-rtl.css\";i:357;s:37:\"post-featured-image/style-rtl.min.css\";i:358;s:29:\"post-featured-image/style.css\";i:359;s:33:\"post-featured-image/style.min.css\";i:360;s:34:\"post-navigation-link/style-rtl.css\";i:361;s:38:\"post-navigation-link/style-rtl.min.css\";i:362;s:30:\"post-navigation-link/style.css\";i:363;s:34:\"post-navigation-link/style.min.css\";i:364;s:27:\"post-template/style-rtl.css\";i:365;s:31:\"post-template/style-rtl.min.css\";i:366;s:23:\"post-template/style.css\";i:367;s:27:\"post-template/style.min.css\";i:368;s:24:\"post-terms/style-rtl.css\";i:369;s:28:\"post-terms/style-rtl.min.css\";i:370;s:20:\"post-terms/style.css\";i:371;s:24:\"post-terms/style.min.css\";i:372;s:31:\"post-time-to-read/style-rtl.css\";i:373;s:35:\"post-time-to-read/style-rtl.min.css\";i:374;s:27:\"post-time-to-read/style.css\";i:375;s:31:\"post-time-to-read/style.min.css\";i:376;s:24:\"post-title/style-rtl.css\";i:377;s:28:\"post-title/style-rtl.min.css\";i:378;s:20:\"post-title/style.css\";i:379;s:24:\"post-title/style.min.css\";i:380;s:26:\"preformatted/style-rtl.css\";i:381;s:30:\"preformatted/style-rtl.min.css\";i:382;s:22:\"preformatted/style.css\";i:383;s:26:\"preformatted/style.min.css\";i:384;s:24:\"pullquote/editor-rtl.css\";i:385;s:28:\"pullquote/editor-rtl.min.css\";i:386;s:20:\"pullquote/editor.css\";i:387;s:24:\"pullquote/editor.min.css\";i:388;s:23:\"pullquote/style-rtl.css\";i:389;s:27:\"pullquote/style-rtl.min.css\";i:390;s:19:\"pullquote/style.css\";i:391;s:23:\"pullquote/style.min.css\";i:392;s:23:\"pullquote/theme-rtl.css\";i:393;s:27:\"pullquote/theme-rtl.min.css\";i:394;s:19:\"pullquote/theme.css\";i:395;s:23:\"pullquote/theme.min.css\";i:396;s:39:\"query-pagination-numbers/editor-rtl.css\";i:397;s:43:\"query-pagination-numbers/editor-rtl.min.css\";i:398;s:35:\"query-pagination-numbers/editor.css\";i:399;s:39:\"query-pagination-numbers/editor.min.css\";i:400;s:31:\"query-pagination/editor-rtl.css\";i:401;s:35:\"query-pagination/editor-rtl.min.css\";i:402;s:27:\"query-pagination/editor.css\";i:403;s:31:\"query-pagination/editor.min.css\";i:404;s:30:\"query-pagination/style-rtl.css\";i:405;s:34:\"query-pagination/style-rtl.min.css\";i:406;s:26:\"query-pagination/style.css\";i:407;s:30:\"query-pagination/style.min.css\";i:408;s:25:\"query-title/style-rtl.css\";i:409;s:29:\"query-title/style-rtl.min.css\";i:410;s:21:\"query-title/style.css\";i:411;s:25:\"query-title/style.min.css\";i:412;s:25:\"query-total/style-rtl.css\";i:413;s:29:\"query-total/style-rtl.min.css\";i:414;s:21:\"query-total/style.css\";i:415;s:25:\"query-total/style.min.css\";i:416;s:20:\"query/editor-rtl.css\";i:417;s:24:\"query/editor-rtl.min.css\";i:418;s:16:\"query/editor.css\";i:419;s:20:\"query/editor.min.css\";i:420;s:19:\"quote/style-rtl.css\";i:421;s:23:\"quote/style-rtl.min.css\";i:422;s:15:\"quote/style.css\";i:423;s:19:\"quote/style.min.css\";i:424;s:19:\"quote/theme-rtl.css\";i:425;s:23:\"quote/theme-rtl.min.css\";i:426;s:15:\"quote/theme.css\";i:427;s:19:\"quote/theme.min.css\";i:428;s:23:\"read-more/style-rtl.css\";i:429;s:27:\"read-more/style-rtl.min.css\";i:430;s:19:\"read-more/style.css\";i:431;s:23:\"read-more/style.min.css\";i:432;s:18:\"rss/editor-rtl.css\";i:433;s:22:\"rss/editor-rtl.min.css\";i:434;s:14:\"rss/editor.css\";i:435;s:18:\"rss/editor.min.css\";i:436;s:17:\"rss/style-rtl.css\";i:437;s:21:\"rss/style-rtl.min.css\";i:438;s:13:\"rss/style.css\";i:439;s:17:\"rss/style.min.css\";i:440;s:21:\"search/editor-rtl.css\";i:441;s:25:\"search/editor-rtl.min.css\";i:442;s:17:\"search/editor.css\";i:443;s:21:\"search/editor.min.css\";i:444;s:20:\"search/style-rtl.css\";i:445;s:24:\"search/style-rtl.min.css\";i:446;s:16:\"search/style.css\";i:447;s:20:\"search/style.min.css\";i:448;s:20:\"search/theme-rtl.css\";i:449;s:24:\"search/theme-rtl.min.css\";i:450;s:16:\"search/theme.css\";i:451;s:20:\"search/theme.min.css\";i:452;s:24:\"separator/editor-rtl.css\";i:453;s:28:\"separator/editor-rtl.min.css\";i:454;s:20:\"separator/editor.css\";i:455;s:24:\"separator/editor.min.css\";i:456;s:23:\"separator/style-rtl.css\";i:457;s:27:\"separator/style-rtl.min.css\";i:458;s:19:\"separator/style.css\";i:459;s:23:\"separator/style.min.css\";i:460;s:23:\"separator/theme-rtl.css\";i:461;s:27:\"separator/theme-rtl.min.css\";i:462;s:19:\"separator/theme.css\";i:463;s:23:\"separator/theme.min.css\";i:464;s:24:\"shortcode/editor-rtl.css\";i:465;s:28:\"shortcode/editor-rtl.min.css\";i:466;s:20:\"shortcode/editor.css\";i:467;s:24:\"shortcode/editor.min.css\";i:468;s:24:\"site-logo/editor-rtl.css\";i:469;s:28:\"site-logo/editor-rtl.min.css\";i:470;s:20:\"site-logo/editor.css\";i:471;s:24:\"site-logo/editor.min.css\";i:472;s:23:\"site-logo/style-rtl.css\";i:473;s:27:\"site-logo/style-rtl.min.css\";i:474;s:19:\"site-logo/style.css\";i:475;s:23:\"site-logo/style.min.css\";i:476;s:27:\"site-tagline/editor-rtl.css\";i:477;s:31:\"site-tagline/editor-rtl.min.css\";i:478;s:23:\"site-tagline/editor.css\";i:479;s:27:\"site-tagline/editor.min.css\";i:480;s:26:\"site-tagline/style-rtl.css\";i:481;s:30:\"site-tagline/style-rtl.min.css\";i:482;s:22:\"site-tagline/style.css\";i:483;s:26:\"site-tagline/style.min.css\";i:484;s:25:\"site-title/editor-rtl.css\";i:485;s:29:\"site-title/editor-rtl.min.css\";i:486;s:21:\"site-title/editor.css\";i:487;s:25:\"site-title/editor.min.css\";i:488;s:24:\"site-title/style-rtl.css\";i:489;s:28:\"site-title/style-rtl.min.css\";i:490;s:20:\"site-title/style.css\";i:491;s:24:\"site-title/style.min.css\";i:492;s:26:\"social-link/editor-rtl.css\";i:493;s:30:\"social-link/editor-rtl.min.css\";i:494;s:22:\"social-link/editor.css\";i:495;s:26:\"social-link/editor.min.css\";i:496;s:27:\"social-links/editor-rtl.css\";i:497;s:31:\"social-links/editor-rtl.min.css\";i:498;s:23:\"social-links/editor.css\";i:499;s:27:\"social-links/editor.min.css\";i:500;s:26:\"social-links/style-rtl.css\";i:501;s:30:\"social-links/style-rtl.min.css\";i:502;s:22:\"social-links/style.css\";i:503;s:26:\"social-links/style.min.css\";i:504;s:21:\"spacer/editor-rtl.css\";i:505;s:25:\"spacer/editor-rtl.min.css\";i:506;s:17:\"spacer/editor.css\";i:507;s:21:\"spacer/editor.min.css\";i:508;s:20:\"spacer/style-rtl.css\";i:509;s:24:\"spacer/style-rtl.min.css\";i:510;s:16:\"spacer/style.css\";i:511;s:20:\"spacer/style.min.css\";i:512;s:20:\"table/editor-rtl.css\";i:513;s:24:\"table/editor-rtl.min.css\";i:514;s:16:\"table/editor.css\";i:515;s:20:\"table/editor.min.css\";i:516;s:19:\"table/style-rtl.css\";i:517;s:23:\"table/style-rtl.min.css\";i:518;s:15:\"table/style.css\";i:519;s:19:\"table/style.min.css\";i:520;s:19:\"table/theme-rtl.css\";i:521;s:23:\"table/theme-rtl.min.css\";i:522;s:15:\"table/theme.css\";i:523;s:19:\"table/theme.min.css\";i:524;s:24:\"tag-cloud/editor-rtl.css\";i:525;s:28:\"tag-cloud/editor-rtl.min.css\";i:526;s:20:\"tag-cloud/editor.css\";i:527;s:24:\"tag-cloud/editor.min.css\";i:528;s:23:\"tag-cloud/style-rtl.css\";i:529;s:27:\"tag-cloud/style-rtl.min.css\";i:530;s:19:\"tag-cloud/style.css\";i:531;s:23:\"tag-cloud/style.min.css\";i:532;s:28:\"template-part/editor-rtl.css\";i:533;s:32:\"template-part/editor-rtl.min.css\";i:534;s:24:\"template-part/editor.css\";i:535;s:28:\"template-part/editor.min.css\";i:536;s:27:\"template-part/theme-rtl.css\";i:537;s:31:\"template-part/theme-rtl.min.css\";i:538;s:23:\"template-part/theme.css\";i:539;s:27:\"template-part/theme.min.css\";i:540;s:24:\"term-count/style-rtl.css\";i:541;s:28:\"term-count/style-rtl.min.css\";i:542;s:20:\"term-count/style.css\";i:543;s:24:\"term-count/style.min.css\";i:544;s:30:\"term-description/style-rtl.css\";i:545;s:34:\"term-description/style-rtl.min.css\";i:546;s:26:\"term-description/style.css\";i:547;s:30:\"term-description/style.min.css\";i:548;s:23:\"term-name/style-rtl.css\";i:549;s:27:\"term-name/style-rtl.min.css\";i:550;s:19:\"term-name/style.css\";i:551;s:23:\"term-name/style.min.css\";i:552;s:28:\"term-template/editor-rtl.css\";i:553;s:32:\"term-template/editor-rtl.min.css\";i:554;s:24:\"term-template/editor.css\";i:555;s:28:\"term-template/editor.min.css\";i:556;s:27:\"term-template/style-rtl.css\";i:557;s:31:\"term-template/style-rtl.min.css\";i:558;s:23:\"term-template/style.css\";i:559;s:27:\"term-template/style.min.css\";i:560;s:27:\"text-columns/editor-rtl.css\";i:561;s:31:\"text-columns/editor-rtl.min.css\";i:562;s:23:\"text-columns/editor.css\";i:563;s:27:\"text-columns/editor.min.css\";i:564;s:26:\"text-columns/style-rtl.css\";i:565;s:30:\"text-columns/style-rtl.min.css\";i:566;s:22:\"text-columns/style.css\";i:567;s:26:\"text-columns/style.min.css\";i:568;s:19:\"verse/style-rtl.css\";i:569;s:23:\"verse/style-rtl.min.css\";i:570;s:15:\"verse/style.css\";i:571;s:19:\"verse/style.min.css\";i:572;s:20:\"video/editor-rtl.css\";i:573;s:24:\"video/editor-rtl.min.css\";i:574;s:16:\"video/editor.css\";i:575;s:20:\"video/editor.min.css\";i:576;s:19:\"video/style-rtl.css\";i:577;s:23:\"video/style-rtl.min.css\";i:578;s:15:\"video/style.css\";i:579;s:19:\"video/style.min.css\";i:580;s:19:\"video/theme-rtl.css\";i:581;s:23:\"video/theme-rtl.min.css\";i:582;s:15:\"video/theme.css\";i:583;s:19:\"video/theme.min.css\";}}","on"),
("125","nonce_key","3TGH;8eK gB%GoEv)ZOu>[2R2Zmwb#L9qS]0tqC)<J#0tS.apuPuMPqudOkQjx.H","off"),
("126","nonce_salt","%M89ABXNWBvOm:}Z}(L&jkjKK ,uqEG8n4b6,ylB$ <mgD}Os?zH5/?Bs&9(Fg/1","off"),
("127","theme_mods_twentytwentyfive","a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1756666280;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:9:\"sidebar-2\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}}}}","off"),
("128","_transient_wp_styles_for_blocks","a:2:{s:4:\"hash\";s:32:\"ee201cceec3030105765a602aadbbb50\";s:6:\"blocks\";a:6:{s:11:\"core/button\";s:0:\"\";s:14:\"core/site-logo\";s:0:\"\";s:18:\"core/post-template\";s:0:\"\";s:18:\"core/term-template\";s:0:\"\";s:12:\"core/columns\";s:0:\"\";s:14:\"core/pullquote\";s:69:\":root :where(.wp-block-pullquote){font-size: 1.5em;line-height: 1.6;}\";}}","on"),
("129","recovery_keys","a:0:{}","off"),
("137","widget_akismet_widget","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("163","finished_updating_comment_type","1","auto"),
("207","recently_activated","a:0:{}","off"),
("212","_site_transient_wp_plugin_dependencies_plugin_data","a:1:{s:9:\"elementor\";a:35:{s:4:\"name\";s:84:\"وب‌سایت ساز المنتور &#8211; فراتر از یک صفحه‌ساز\";s:4:\"slug\";s:9:\"elementor\";s:7:\"version\";s:6:\"3.35.1\";s:6:\"author\";s:64:\"<a href=\"https://profiles.wordpress.org/elemntor/\">Elementor</a>\";s:14:\"author_profile\";s:40:\"https://profiles.wordpress.org/elemntor/\";s:12:\"contributors\";a:1:{s:8:\"elemntor\";a:3:{s:7:\"profile\";s:40:\"https://profiles.wordpress.org/elemntor/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/7d70f15d78757f876d1847a8f87dd93e1d9c168264b4aeeaf72058656690d05b?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:9:\"Elementor\";}}s:8:\"requires\";s:3:\"6.6\";s:6:\"tested\";s:5:\"6.9.1\";s:12:\"requires_php\";s:3:\"7.4\";s:16:\"requires_plugins\";a:0:{}s:6:\"rating\";i:90;s:7:\"ratings\";a:5:{i:5;i:6099;i:4;i:218;i:3;i:112;i:2;i:107;i:1;i:646;}s:11:\"num_ratings\";i:7182;s:11:\"support_url\";s:47:\"https://wordpress.org/support/plugin/elementor/\";s:15:\"support_threads\";i:92;s:24:\"support_threads_resolved\";i:73;s:15:\"active_installs\";i:10000000;s:12:\"last_updated\";s:21:\"2026-02-04 8:47pm GMT\";s:5:\"added\";s:10:\"2016-05-30\";s:8:\"homepage\";s:87:\"https://elementor.com/?utm_source=wp-plugins&utm_campaign=plugin-uri&utm_medium=wp-dash\";s:8:\"sections\";a:6:{s:11:\"description\";s:27040:\"<p><iframe loading=\"lazy\" title=\"This is Elementor | The complete website building experience for WordPress\" width=\"750\" height=\"422\" src=\"https://www.youtube.com/embed/ROEC0CPRO3w?feature=oembed\" frameborder=\"0\" allow=\"accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share\" referrerpolicy=\"strict-origin-when-cross-origin\" allowfullscreen></iframe></p>\n<h4>THE #1 NO CODE DRAG &amp; DROP WORDPRESS WEBSITE BUILDER POWERING 20M+ WEBSITES WORLDWIDE, NOW WITH AI.</h4>\n<p>المنتور، پلتفرم پیشرو ایجاد وب‌سایت وردپرس، شما را قادر می‌سازد تا وب‌سایت‌های حرفه‌ای و دقیق پیکسلی را به صورت یکپارچه با ویرایشگر بدون کد و کشیدن و رها کردن خود بسازید.</p>\n<p>با پشتیبانی از چرخه کامل عمر وب‌سایت، المنتور به شما امکان می‌دهد با قابلیت‌های گسترده‌ای مانند ایجاد مبتنی بر هوش مصنوعی، بهینه‌سازی تصویر، تحویل ایمیل تراکنشی، ابزارهای دسترسی‌پذیری، تقویت‌کننده‌های کارایی و موارد دیگر، وب‌سایت خود را با اطمینان بسازید، بهینه کنید و مدیریت کنید.</p>\n<p>Unlock all features with <strong><a href=\"https://go.elementor.com/wp-repo-description-tab-elementor-pro-pro-features/\" rel=\"nofollow ugc\">Elementor One</a></strong>.</p>\n<p>Need fast and secure cloud hosting for your Elementor site? Try out <strong><a href=\"https://elemn.to/repo-hosting\" rel=\"nofollow ugc\">Elementor Host</a></strong> Powered by Google Cloud &amp; Cloudflare. 4.9/5 TrustPilot score.</p>\n<h3>🌟 Create Professional Stunning Websites</h3>\n<ul>\n<li><strong><a href=\"https://go.elementor.com/feature-page-editor/\" rel=\"nofollow ugc\">Intuitive Drag &amp; Drop Builder</a></strong>: Build any website with our no-code, drag-and-drop Editor. Achieve design precision with full control over layout and style.</li>\n<li><strong><a href=\"https://go.elementor.com/wp-repo-description-tab-pro-features-feature-page/\" rel=\"nofollow ugc\">Pixel-Perfect Design Tools</a></strong>: Upload SVGs, apply masks, gradients, box shadows, headline effects, shape dividers, and use built-in CSS controls for advanced customization.</li>\n<li><strong><a href=\"https://go.elementor.com/wp-repo-description-tab-library-full-website-kit/\" rel=\"nofollow ugc\">Template Library</a></strong>: Apply complete website kits for instant setups, or choose from a vast library of single pages, blocks, and pop-up templates.</li>\n<li><strong><a href=\"https://go.elementor.com/feature-page-editor/\" rel=\"nofollow ugc\">Advanced Widgets</a></strong>: Access over 40 FREE widgets, including heading, image, text editor, video, button, gallery, carousels, and more.</li>\n<li><strong><a href=\"https://go.elementor.com/wp-repo-description-tab-elementor-ai/\" rel=\"nofollow ugc\">AI Capabilities</a></strong>: Revolutionize your design and content creation process with native AI integration. Instantly create sections, text, code, and images.</li>\n</ul>\n<h4>🗝️ Key features:</h4>\n<ul>\n<li><strong><a href=\"https://go.elementor.com/feature-page-global-settings/\" rel=\"nofollow ugc\">Design System</a></strong>: Use Elementor’s Design System for consistent colors, typography, and design elements, ensuring a cohesive, professional look.</li>\n<li><strong><a href=\"https://go.elementor.com/feature-page-responsive-design/\" rel=\"nofollow ugc\">Responsive Design</a></strong>: Optimize your design for every device with custom breakpoints, ensuring a seamless desktop, tablet, and mobile experience.</li>\n<li><strong>Mask Shapes</strong>: Turning any element, like an image or video, into whatever shape you desire to create standout designs.</li>\n<li><strong>CSS Transform</strong>: Use CSS Transform to rotate, scale, and skew elements, adding dynamic styling to your site.</li>\n<li><strong>Entrance Animations</strong>: Add entrance animations to elements to create engaging and interactive user experiences.</li>\n<li><strong><a href=\"https://elementor.com/features/#SaveBackup\" rel=\"nofollow ugc\">Revision History</a></strong>: Elementor’s Revision History feature enables users to track and revert to previous versions of their designs, providing peace of mind and flexibility during the creative process.</li>\n<li><strong><a href=\"https://go.elementor.com/wp-repo-description-tab-developers-developers-website/\" rel=\"nofollow ugc\">Developer-Friendly</a></strong>: Equipped with extensive documentation, API, developer tools, and custom code areas, Elementor offers a conducive environment for developers to extend its capabilities and create custom solutions.</li>\n<li><strong><a href=\"https://elementor.com/features/contact-button/\" rel=\"nofollow ugc\">دکمه‌های شناور</a></strong>: تعامل کاربر را با دکمه‌های عملیات شناور و قابل شخصی‌سازی که هنگام پیمایش کاربران در دید باقی می‌مانند، افزایش دهید.</li>\n<li><strong><a href=\"https://go.elementor.com/wp-repo-description-tab-pro-features-industry-leading-theme-builder/\" rel=\"nofollow ugc\">Theme Builder</a> [Pro]</strong>: Design every part of your site—headers, footers, posts, and archives—for complete control over appearance.</li>\n<li><strong><a href=\"https://go.elementor.com/wp-repo-description-tab-pro-features-popup-builder/\" rel=\"nofollow ugc\">Popup Builder</a> [Pro]</strong>: Create eye-catching popups with Elementor’s Popup Builder, equipped with advanced targeting and triggering options to optimize user engagement and conversions.</li>\n<li><strong><a href=\"https://go.elementor.com/wp-repo-description-tab-pro-features-professional-form-builder-and-submission-log/\" rel=\"nofollow ugc\">Forms</a> [Pro]</strong>: Design and integrate custom forms, utilizing advanced features and integrations to capture and manage submissions effectively.</li>\n<li><strong><a href=\"https://go.elementor.com/wp-repo-description-tab-pro-features-woocommerce-builder/\" rel=\"nofollow ugc\">WooCommerce Builder</a> [Pro]</strong>:  Integrate Elementor with WooCommerce to design custom product pages, shop layouts, archives, carts, checkout pages, my account, and more, enhancing your store’s visual appeal and functionality.</li>\n<li><strong><a href=\"https://go.elementor.com/wp-repo-description-tab-pro-features-dynamic-content/\" rel=\"nofollow ugc\">Dynamic Content</a> [Pro]</strong>: Leverage dynamic content capabilities to create personalized and interactive web experiences by connecting your designs to various data sources.</li>\n<li><strong><a href=\"https://go.elementor.com/features-page-notes/\" rel=\"nofollow ugc\">Notes</a> [Pro]</strong>: Enhance team collaboration by using Elementor’s Notes feature to leave feedback and comments directly on the design interface.</li>\n<li><strong>Custom Code [Pro]</strong>: Insert custom code to extend the functionality of your site, offering flexibility for advanced customizations.</li>\n<li><strong>Custom CSS [Pro]</strong>: Apply Custom CSS to fine-tune the styling of elements, ensuring precise control over the design aspects.</li>\n<li><strong><a href=\"https://go.elementor.com/wp-repo-description-tab-pro-features-motion-effects/\" rel=\"nofollow ugc\">Motion Effects</a> [Pro]</strong>: Add advanced motion effects to elements for a more dynamic and engaging user experience.</li>\n<li><strong>Custom Fonts &amp; Icons [Pro]</strong>: Upload and use custom fonts and icons to match your brand’s identity.</li>\n</ul>\n<h4>😍 Elementor FREE widgets</h4>\n<p>Unlock the potential of Elementor with our comprehensive suite of free widgets and tools, designed to empower your website creation process and elevate your design capabilities:</p>\n<ul>\n<li><strong>عنوان</strong>. عنوان‌های چشم نواز را اضافه کنید.</li>\n<li><strong>Image</strong>. Control the size, opacity and more.</li>\n<li><strong>Text Editor</strong>. Just like the WordPress text editor.</li>\n<li><strong>Video</strong>. Add YouTube, Vimeo, VideoPress, Dailymotion or self-hosted videos.</li>\n<li><strong>Button</strong>. Create interactive buttons.</li>\n<li><strong>Link in Bio</strong>. Build link in bio components to promote your business / services.</li>\n<li><strong>Image Box</strong>. A box with image, headline and text.</li>\n<li><strong>Testimonials</strong>. Customer testimonials.</li>\n<li><strong>نماد</strong>. یک یا چند نماد از بیش از ۶۰۰ نماد را در دسترس قرار دهید.</li>\n<li><strong>Icon Box</strong>. An icon, headline, and text with one widget.</li>\n<li><strong>Social Icons</strong>. Link to your social pages with the Facebook/X (formerly Twitter) icons.</li>\n<li><strong>Image Gallery</strong>. Display your images in a grid.</li>\n<li><strong>Image Carousel</strong>. Create rotating carousels or sliders for chosen images.</li>\n<li><strong>فهرست نماد</strong>. از هر نمادی برای ایجاد یک لیست گلوله استفاده کنید.</li>\n<li><strong>Counter</strong>. Show numbers in an escalating manner.</li>\n<li><strong>نوار پیشرفت</strong>. شامل یک نوار پیشرفت در حال افزایش است.</li>\n<li><strong>Nested Tabs</strong>. Display content in vertical or horizontal tabs.</li>\n<li><strong>Nested Accordion</strong>. Display any type of content in collapsible sections.</li>\n<li><strong>Rating</strong>. Display how many stars (or another icon) other visitors gave.</li>\n<li><strong>هشدار</strong>. یک جعبه هشدار رنگی برای جلب توجه بازدیدکنندگان قرار دهید.</li>\n<li><strong>HTML</strong>. کد را در برگه وارد کنید.</li>\n<li><strong>Shortcode</strong>. Insert shortcodes from any plugin into the page.</li>\n<li><strong>لنگر فهرست</strong>. هر منو را به این لنگر پیوند دهید.</li>\n<li><strong>Read More</strong>. Set the Read More cut-off for the excerpt in archive pages.</li>\n<li><strong>Sidebar</strong>. Add sidebars onto the page.</li>\n<li><strong>نقشه‌های گوگل</strong>. نقشه‌ها را در برگه جاسازی کنید.</li>\n<li><strong>SoundCloud</strong>. Add SoundCloud audio bits.</li>\n<li><strong>تقسیم‌کننده</strong>. مطالب را با یک تقسیم‌کننده طراحی شده جدا کنید.</li>\n<li><strong>فاصله‌گذار</strong>. فاصله بین عناصر اضافه کنید..</li>\n<li><strong>Text Path</strong>. Attach your text to a path.</li>\n<li><strong>و شمارش&#8230;</strong></li>\n</ul>\n<h3>🚀 Enhance Your Website</h3>\n<p><strong><a href=\"https://go.elementor.com/wp-repo-description-tab-performance-performance-page/\" rel=\"nofollow ugc\">High-Performing Websites</a></strong>: Website performance impacts your visitor’s experience and search result ranking. Elementor, in partnership with Google Chrome, continuously enhances performance without compromising design.</p>\n<p><strong>Key features include:</strong></p>\n<ul>\n<li><strong>Reduced DOM Output</strong>: Streamlined HTML structure for faster rendering.</li>\n<li><strong>Improved Media File Loading</strong>: Optimized loading of images, videos, and other media assets.</li>\n<li><strong>کاهش فایل‌های CSS و JS</strong>: شیوه‌نامه‌ها و اسکریپت‌های کوچک‌شده که به صورت جداگانه و فقط در صورت تقاضا برای زمان بارگذاری سریع‌تر بارگذاری می‌شوند.</li>\n<li><strong>Lazy Loading</strong>: Deferred loading of non-critical resources to improve initial page load speed.</li>\n<li><strong>Faster Font Loading</strong>: Efficient delivery of web fonts to enhance text rendering speed.</li>\n<li><strong>Optimized Front-End Asset Loading</strong>: Efficient loading of assets like JavaScript and CSS to minimize render-blocking.</li>\n<li><strong>Element Caching</strong>: Cache frequently accessed design elements to reduce server response time and enhance overall performance.</li>\n</ul>\n<h3>🔥 ویژگی‌های ویرایشگر حرفه‌ای المنتور</h3>\n<p>Create unparalleled websites while saving time, money and resources with <a href=\"https://go.elementor.com/wp-repo-description-tab-elementor-pro-elementor-pro/\" rel=\"nofollow ugc\">Elementor Editor Pro</a>’s full website builder. Get access to 100+ professional widgets, features, and tools.</p>\n<p><strong>Editor Pro Design Widgets:</strong></p>\n<ol>\n<li><strong>Posts</strong>: Display your blog posts with customizable layouts and styles.</li>\n<li><strong>Share Buttons</strong>: Allow visitors to easily share your content on various social media platforms.</li>\n<li><strong>Portfolio</strong>: Showcase your work or projects with stunning portfolio layouts.</li>\n<li><strong>Slides</strong>: Create dynamic slideshows with custom animations and transitions.</li>\n<li><strong>Form</strong>: Design and customize advanced forms for user interaction and data collection.</li>\n<li><strong>Login</strong>: Add a login form or user registration module to your website.</li>\n<li><strong>Nav Menu</strong>: Customize and style your website&#8217;s navigation menu for better user experience.</li>\n<li><strong>Animated Headline</strong>: Create attention-grabbing headlines with animated effects.</li>\n<li><strong>Price Table</strong>: Display pricing plans or packages in a structured and visually appealing format.</li>\n<li><strong>Price List</strong>: Showcase a list of prices or services with customizable styling options.</li>\n<li><strong>Gallery</strong>: Create beautiful image galleries with various layout options and lightbox support.</li>\n<li><strong>Flip Box</strong>: Add interactive flip animations to highlight content or features.</li>\n<li><strong>Call to Action</strong>: Encourage user interaction and conversions with compelling call-to-action sections.</li>\n<li><strong>Media Carousel</strong>: Showcase a carousel of media files such as images or videos.</li>\n<li><strong>Testimonial Carousel</strong>: Display client testimonials in a carousel format for social proof.</li>\n<li><strong>Nested Carousel</strong>: Create nested carousels for more complex content organization.</li>\n<li><strong>Loop Carousel</strong>: Display content in a looped carousel for continuous viewing.</li>\n<li><strong>Table Of Content</strong>: Generate a table of contents for longer articles or guides to improve navigation.</li>\n<li><strong>Countdown</strong>: Add countdown timers to create urgency for promotions or events.</li>\n<li><strong>Facebook Page</strong>: Embed your Facebook page feed or content onto your website.</li>\n<li><strong>Blockquote</strong>: Highlight quotes or testimonials with stylish formatting options.</li>\n<li><strong>Template</strong>: Save and reuse design templates for consistent branding and layout.</li>\n<li><strong>Reviews</strong>: Showcase customer reviews and ratings to build trust and credibility.</li>\n<li><strong>Facebook Button</strong>: Add buttons to promote interactions with your Facebook page or content.</li>\n<li><strong>Facebook Embed</strong>: Embed Facebook posts or content onto your website.</li>\n<li><strong>Facebook Comments</strong>: Enable Facebook comments on your website&#8217;s pages or posts.</li>\n<li><strong>PayPal Button</strong>: Integrate PayPal buttons for easy online payments.</li>\n<li><strong>Stripe Button</strong>: Integrate Stripe payment buttons to facilitate secure online transactions.</li>\n<li><strong>Lottie Widget</strong>: Add Lottie animations to enhance visual appeal and engagement.</li>\n<li><strong>Code Highlight</strong>: Display code snippets with syntax highlighting for better readability.</li>\n<li><strong>Video Playlist</strong>: Create and customize playlists for video content on your website.</li>\n<li><strong>مگا منو</strong>: منوهای پیشرفته را برای پیمایش بهتر و نمایش محتوای پیچیده سفارشی کنید.</li>\n<li><strong>Off Canvas</strong>: Create off-canvas areas that slide in to show extra info or menus without cluttering the main layout.</li>\n</ol>\n<p><strong>Editor Pro Theme Widgets:</strong></p>\n<p>Build and customize all the key parts of your website including headers, footers, 404 page, global archives, and more&#8230;</p>\n<ol>\n<li><strong>Post Title</strong>: Customize the title of individual blog posts or pages.</li>\n<li><strong>Post Excerpt</strong>: Display a brief summary or teaser of your blog posts.</li>\n<li><strong>Post Content</strong>: Customize the main content area of your blog posts or pages.</li>\n<li><strong>Featured Image</strong>: Set and customize featured images for blog posts or pages.</li>\n<li><strong>Author Box</strong>: Display author information and bios on blog posts.</li>\n<li><strong>Post Comments</strong>: Customize the appearance and functionality of comments sections on your website.</li>\n<li><strong>Post Navigation</strong>: Add navigation links to adjacent posts for easy browsing.</li>\n<li><strong>Post Info</strong>: Display additional information about blog posts, such as author and date.</li>\n<li><strong>Site Logo</strong>: Upload and customize your website&#8217;s logo for branding purposes.</li>\n<li><strong>Site Title</strong>: Customize the title of your website.</li>\n<li><strong>Page Title</strong>: Customize the title of individual pages.</li>\n<li><strong>Search Bar</strong>: Add a search bar to allow users to search your website&#8217;s content.</li>\n<li><strong>Breadcrumbs</strong>: Display hierarchical navigation paths for better user navigation.</li>\n<li><strong>Sitemap</strong>: Generate a sitemap for better search engine indexing and user navigation.</li>\n<li><strong>Loop Grid</strong>: Design and customize grid layouts for blog post archives or product listings.</li>\n</ol>\n<p><strong>Editor Pro WooCommerce Widgets:</strong></p>\n<p>Design and customize a complete online shopping experience across your entire website.</p>\n<ol>\n<li><strong>Product</strong>: Display individual products with customizable layouts and styles.</li>\n<li><strong>Breadcrumbs</strong>: Display hierarchical navigation paths for better user navigation within your store.</li>\n<li><strong>Product Title</strong>: Customize the title of individual products.</li>\n<li><strong>Product Images</strong>: Set and customize images for product listings.</li>\n<li><strong>Product Price</strong>: Display the price of individual products.</li>\n<li><strong>Add To Cart</strong>: Add customizable add to cart buttons for easy purchasing.</li>\n<li><strong>Product Rating</strong>: Display ratings and reviews for products.</li>\n<li><strong>Product Stock</strong>: Display stock availability for products.</li>\n<li><strong>Product Meta</strong>: Display additional information about products, such as SKU and categories.</li>\n<li><strong>Product Content</strong>: Customize the main content area of product descriptions.</li>\n<li><strong>Short Description</strong>: Display brief summaries or teasers of products.</li>\n<li><strong>Product Data Tabs</strong>: Organize product information into tabbed sections for better organization.</li>\n<li><strong>Additional Information</strong>: Display additional details about products, such as dimensions and weight.</li>\n<li><strong>Product Related</strong>: Showcase related products to encourage additional purchases.</li>\n<li><strong>Upsells</strong>: Promote upsell products to increase average order value.</li>\n<li><strong>Products</strong>: Display a grid or list of products with customizable settings.</li>\n<li><strong>Custom Add To Cart</strong>: Customize the add to cart button for specific products.</li>\n<li><strong>WooCommerce Pages</strong>: Design and customize WooCommerce-specific pages, such as the cart and checkout pages.</li>\n<li><strong>Product Categories</strong>: Display product categories for easy navigation within your store.</li>\n<li><strong>Menu Cart</strong>: Display a cart icon in your navigation menu for easy access to the shopping cart.</li>\n<li><strong>Cart</strong>: Customize the appearance and functionality of the shopping cart page.</li>\n<li><strong>Checkout</strong>: Customize the appearance and functionality of the checkout page.</li>\n<li><strong>My Account</strong>: Customize the appearance and functionality of the customer account area.</li>\n<li><strong>Purchase Summary</strong>: Display a summary of purchases during the checkout process.</li>\n<li><strong>WooCommerce Notices</strong>: Customize the appearance and functionality of WooCommerce notices, such as order confirmation messages.</li>\n</ol>\n<p>Build professional websites with <strong><a href=\"https://go.elementor.com/wp-repo-description-tab-elementor-pro-elementor-pro/\" rel=\"nofollow ugc\">Elementor Editor Pro</a></strong>!</p>\n<h4>🔒 SECURITY AND COMPLIANCE</h4>\n<p>Elementor places a paramount focus on security, evident through our acquisition of industry certifications such as ISO/IEC 27001, ISO/IEC 27017, ISO/IEC 27018, ISO/IEC 27701, and SOC 2 Type II. These certifications underscore our commitment to implementing robust security measures, and highlight our dedication to adhering to recognized industry standards.</p>\n<p>We encourage ethical security research through our <a href=\"https://go.elementor.com/wp-repo-description-tab-bug-crowd-bug-bounty-program/\" rel=\"nofollow ugc\">Bug Bounty program</a>. We collaborate with leading bug bounty services to provide opportunities for researchers to report vulnerabilities in our services. Our bounty programs include a triage team available 24/7/365.</p>\n<p>For more information: <a href=\"https://go.elementor.com/trust-center/\" rel=\"nofollow ugc\">Trust Center</a>.</p>\n<h4>♿ Accessibility Best Practices</h4>\n<p>Elementor offers accessibility tools and enhancements to help you provide a better experience for all users. Including HTML 5 semantic, full keyboard navigation menu, ongoing improvement of features, widget, and more.</p>\n<h4>🌐 Translated to 63+ languages, includes RTL support</h4>\n<p>Elementor supports multiple languages, typographies, and RTL, with editor translations in <a href=\"https://go.elementor.com/wp-repo-description-tab-wordpress-plugin-translate/\" rel=\"nofollow ugc\">over 63 languages</a>.</p>\n<p>It’s also compatible with WPML, Polylang, TranslatePress, Weglot, and more. To contribute, add a new language via <a href=\"https://translate.wordpress.org\" rel=\"nofollow ugc\">translate.wordpress.org</a>. See our guide on <a href=\"https://go.elementor.com/wp-repo-description-tab-help-center-translate/\" rel=\"nofollow ugc\">how to translate and localize the plugin</a>.</p>\n<h4>⏩ Use of 3rd Party Services</h4>\n<p>To improve the user experience, Elementor may use the following 3rd party services if the required feature is enabled:</p>\n<ul>\n<li>Google Fonts – are loaded to add additional fonts to your website. Google’s <a href=\"https://policies.google.com/terms\" rel=\"nofollow ugc\">TOS</a> and <a href=\"https://policies.google.com/privacy\" rel=\"nofollow ugc\">Privacy Policy</a> apply.</li>\n<li>Some Elementor features require loading assets from Elementor.com. These assets are not used for tracking unless explicitly mentioned, requiring your approval and manual opt-in. Learn more in our <a href=\"https://go.elementor.com/wp-repo-description-tab-elementor-plugin-terms/\" rel=\"nofollow ugc\">TOS</a> and <a href=\"https://go.elementor.com/wp-repo-description-tab-elementor-plugin-privacy/\" rel=\"nofollow ugc\">Privacy Policy</a>.</li>\n</ul>\n<h4>📧 Related Products by Elementor</h4>\n<p><strong><a href=\"https://go.elementor.com/wp-repo-description-tab-elementor-io/\" rel=\"nofollow ugc\">Image Optimizer</a></strong>: Superior image compression for faster, high-quality website performance.</p>\n<p><strong><a href=\"https://go.elementor.com/wp-repo-description-tab-elementor-sm/\" rel=\"nofollow ugc\">Site Mailer</a></strong>: Reliable email management without SMTP plugins, keeping your communications streamlined and efficient.</p>\n<p><strong><a href=\"http://go.elementor.com/editor-acc-wp-repo\" rel=\"nofollow ugc\">Ally</a></strong>: قابلیت استفاده وب‌سایت را برای افراد دارای معلولیت افزایش می‌دهد. Ally طراحی شده است تا به سازندگان وب کمک کند وب‌سایت‌های خود را فراگیرتر کنند. این ابزار تخلفات کلیدی دسترسی‌پذیری را اسکن، شناسایی و اصلاح می‌کند و به طور یکپارچه در تمام وب‌سایت‌های وردپرس و المنتور کار می‌کند.</p>\n<h4>📣 See What Our Users Have to Say</h4>\n<blockquote>\n<p>“Elementor is hands down the best page builder out there” – ★★★★★ <em><a href=\"https://wordpress.org/support/topic/elementor-is-hands-down-the-best-page-builder-out-there/\" rel=\"ugc\">Graphicvision1</a></em></p>\n<p>“An incredibly user-friendly plugin” – ★★★★★ <em><a href=\"https://wordpress.org/support/topic/a-wonderful-experience/\" rel=\"ugc\">Hyeyoga</a></em></p>\n<p>“Easily, my most used WP plugin” – ★★★★★ <em><a href=\"https://wordpress.org/support/topic/easily-my-most-used-wp-plugin/\" rel=\"ugc\">Xander Venske</a></em></p>\n<p>“I upgraded to the Pro version and just love this plugin!” – ★★★★★ <em><a href=\"https://wordpress.org/support/topic/love-elementor-17/\" rel=\"ugc\">Andybarn56</a></em></p>\n<p>“Excellent product with great tech support” – ★★★★★ <em><a href=\"https://wordpress.org/support/topic/excellent-product-with-great-tech-support/\" rel=\"ugc\">Martywilsonnj</a></em></p>\n</blockquote>\n<p><em><a href=\"https://wordpress.org/support/plugin/elementor/reviews/?filter=5\" rel=\"ugc\">More testimonials</a></em></p>\n<h4>🌍 به یک جامعه جهانی بپیوندید.</h4>\n<p>به جامعه جهانی‌ای بپیوندید که به یکدیگر کمک می‌کند تا به اهداف خود دست یابند.</p>\n<ul>\n<li><a href=\"https://elemn.to/discord\" rel=\"nofollow ugc\">انجمن دیسکورد</a> – با سازندگان وب گپ بزنید، در مورد موضوعات خاص در کانال‌های اختصاصی بحث کنید.</li>\n<li><a href=\"https://go.elementor.com/wp-repo-description-tab-facebook-group/\" rel=\"nofollow ugc\">Facebook Community</a> &#8211; Over 150K+ members, offering support, advice, feedback, and tutorials.</li>\n<li><a href=\"https://go.elementor.com/wp-repo-description-tab-github-repo/\" rel=\"nofollow ugc\">GitHub Community</a> &#8211; Get information about releases, request features, or report a bug.</li>\n<li><a href=\"https://go.elementor.com/wp-repo-description-tab-addons-dozens-of-elementor-addons/\" rel=\"nofollow ugc\">Elementor Addons, Themes, and Kits</a> Themes and Kits  &hellip;</li>\n</ul>\n\";s:12:\"installation\";s:1959:\"<h4>حداقل نیازمندی‌ها</h4>\n<ul>\n<li>WordPress 6.5 or greater</li>\n<li>PHP نسخه ۷.۴ یا بالاتر</li>\n<li>MySQL نسخه 5.0 یا بالاتر</li>\n</ul>\n<h4>الزامات توصیه شده</h4>\n<ul>\n<li>PHP نسخه 8.1 یا بالاتر</li>\n<li>MySQL نسخه 5.6 یا بالاتر</li>\n<li>محدودیت حافظه وردپرس ۶۴ مگابایت یا بیشتر (۱۲۸ مگابایت یا بالاتر ترجیح داده می‌شود)</li>\n</ul>\n<p><iframe loading=\"lazy\" title=\"Installing Elementor on WordPress\" width=\"750\" height=\"422\" src=\"https://www.youtube.com/embed/9EZ159ryFNs?feature=oembed\" frameborder=\"0\" allow=\"accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share\" referrerpolicy=\"strict-origin-when-cross-origin\" allowfullscreen></iframe></p>\n<h4>فرایند نصب</h4>\n<ol>\n<li>با استفاده از نصب‌کننده افزونه داخلی وردپرس نصب کنید، یا فایل فشرده را استخراج کنید و محتویات را در <code>wp-content/plugins/</code> پوشه نصب وردپرس خود رها کنید.</li>\n<li>افزونه را از طریق فهرست &#8216;افزونه‌ها&#8217; در وردپرس فعال کنید.</li>\n<li>برو به برگه‌ها &gt; افزودن جدید</li>\n<li>دکمه &#8216;ویرایش با المنتور&#8217; را فشار دهید.</li>\n<li>اکنون می‌توانید ابزارک‌ها را از پانل سمت چپ به قسمت محتوا بکشید و رها کنید، همچنین بخش‌ها و ستون‌های جدیدی را که ساختار صفحه را تشکیل می‌دهند اضافه کنید.</li>\n</ol>\n<p>برای مستندات و آموزش‌ها به <a href=\"https://elementor.com/help/?utm_source=wp-repo&amp;utm_medium=link&amp;utm_campaign=readme\" rel=\"nofollow ugc\">پایگاه دانش</a> ما مراجعه کنید.</p>\n\";s:3:\"faq\";s:5860:\"\n<dt id=\"how%20do%20i%20install%20elementor%20editor%3F\">\nچگونه ویرایشگر المنتور را نصب کنم؟\n</h4>\n<p>\n<p>To install the free version of Elementor Editor, follow the steps below:<br />\nFrom your WordPress dashboard -&gt; Go to Plugins -&gt; Click on &#8216;Add new&#8217;-&gt; In the Search field, enter Elementor and choose Elementor website builder.<br />\nPress install -&gt; After installation, click Activate.</p>\n</p>\n<dt id=\"does%20elementor%20editor%20work%20with%20all%20the%20themes%3F\">\nDoes Elementor Editor work with all the themes?\n</h4>\n<p>\n<p>Elementor Editor works all the themes that respect the coding standards of WordPress set by its Codex. It is recommended to use Elementor&#8217;s <a href=\"https://go.elementor.com/wp-repo-description-tab-hello-theme-hello-theme/\" rel=\"nofollow ugc\">Hello Theme</a>, a lightweight blank canvas, to enjoy full flexibility when using Elementor Editor, and optimize your experience.</p>\n</p>\n<dt id=\"is%20elementor%20editor%20compatible%20with%20gutenberg%3F\">\nIs Elementor Editor compatible with Gutenberg?\n</h4>\n<p>\n<p>Elementor Editor and Gutenberg work seamlessly together. As a user, you can easily decide which editor to use at every point while editing your site.</p>\n</p>\n<dt id=\"can%20i%20create%20an%20online%20store%3F\">\nآیا می‌توانم یک فروشگاه اینترنتی ایجاد کنم؟\n</h4>\n<p>\n<p>Yes, with the Elementor Editor Pro WooCommerce Builder you can customize every page of your store to create an amazing customer experience that drives sales.</p>\n</p>\n<dt id=\"does%20it%20work%20with%20other%20wordpress%20plugins%3F\">\nآیا با سایر افزونه‌های وردپرس کار می‌کند؟\n</h4>\n<p>\n<p>It works with almost all the plugins. If you experience an incompatibility issue, please report it to us and to the plugin that conflicts with Elementor Editor.</p>\n</p>\n<dt id=\"do%20i%20need%20to%20know%20how%20to%20code%3F\">\nآیا باید بدانم چگونه کدنویسی کنم؟\n</h4>\n<p>\n<p>No! Elementor Editor provides you with all the widgets and features that you need to build a professional website without using code.</p>\n</p>\n<dt id=\"do%20i%20need%20to%20know%20how%20to%20design%3F\">\nDo I need to know how to design?\n</h4>\n<p>\n<p>No, you can choose between professionally designed kits and templates that fit to every industry and have all you need to create your own professional website.</p>\n</p>\n<dt id=\"will%20elementor%20editor%20slow%20down%20my%20website%3F\">\nWill Elementor Editor slow down my website?\n</h4>\n<p>\n<p>As Elementor prioritizes speed and performance, you enjoy better and faster performance with each new version of the Editor. When testing the same page layout on older versions you can see a significant performance improvement, from a score of 82 in Google PageSpeed Insight in version 3.1, to a score of 95 i in version 3.5.</p>\n</p>\n<dt id=\"is%20my%20site%20secure%20with%20elementor%20editor%3F\">\nIs my site secure with Elementor Editor?\n</h4>\n<p>\n<p>امنیت وب سایت شما برای ما بسیار مهم است و ما اقدامات پیشگیرانه ای را برای اطمینان از ایمن بودن وب سایت شما انجام می دهیم. المنتور دارای گواهینامه ISO 27001 است و دارای یک تیم اختصاصی از متخصصان امنیتی است که بهترین شیوه های صنعت را برای حداکثر امنیت و انطباق، 24/7 پیاده سازی می کنند.</p>\n<p>همچنین یک برنامه امنیتی مدیریت شده جایزه اشکال وجود دارد که با فعال کردن 24/7/365 شناسایی آسیب‌پذیری crowdsourced از قدرت جامعه استفاده می‌کند.</p>\n</p>\n<dt id=\"can%20i%20buy%20templates%20separately%3F\">\nآیا می‌توانم قالب‌ها را جداگانه بخرم؟\n</h4>\n<p>\n<p>Of course, you can use any template that supports Elementor Editor.</p>\n</p>\n<dt id=\"is%20elementor%20editor%20compatible%20with%20post%20and%20custom%20post%20types%3F\">\nIs Elementor Editor compatible with Post and Custom Post Types?\n</h4>\n<p>\n<p>البته! می‌توانید تعیین کنید کدام نوع پست المنتور را در صفحه تنظیمات فعال می‌کند.</p>\n</p>\n<dt id=\"what%20is%20the%20difference%20between%20elementor%27s%20free%20editor%20plugin%20and%20elementor%20editor%20pro%3F\">\nتفاوت بین افزونه ویرایشگر رایگان المنتور و ویرایشگر حرفه‌ای المنتور چیست؟\n</h4>\n<p>\n<p>Elementor Editor’s Free version allows you to explore our revolutionary drag &amp; drop live editor, basic widgets and templates. Elementor Editor Pro (Essential, Advanced, Expert, Studio, and Agency) empowers you with more professional tools that speed up your workflow, give you access to human-powered support, help you build more advanced content, and convert visitors. See full comparison here.</p>\n</p>\n<dt id=\"how%20can%20i%20become%20a%20contributor%3F\">\nHow can I become a Contributor?\n</h4>\n<p>\n<p>اگر می‌خواهید کمک کنید، به <a href=\"https://github.com/elementor/elementor\" rel=\"nofollow ugc\">مخزن Elementor GitHub</a> ما بروید و ببینید کجا می‌توانید کمک کنید.<br />\nهمچنین می‌توانید از طریق <a href=\"https://go.elementor.com/wp-repo-description-tab-wordpress-plugin-translate/\" rel=\"nofollow ugc\">translate.wordpress.org</a> یک زبان جدید اضافه کنید. ما یک راهنمای کوتاه ایجاد کرده‌ایم که <a href=\"https://go.elementor.com/wp-repo-description-tab-wordpress-plugin-translate-faq/\" rel=\"nofollow ugc\">نحوه ترجمه و بومی‌سازی افزونه را توضیح می‌دهد</a>.</p>\n</p>\n\n\";s:9:\"changelog\";s:1944:\"<h4>3.35.1 &#8211; 2026-02-04</h4>\n<ul>\n<li>Fix: Editor Top Bar does not appear in various scenarios (<a href=\"https://github.com/elementor/elementor/issues/34623\" rel=\"nofollow ugc\">#34623</a>)</li>\n<li>Fix: Fatal error when the PHP <code>mbstring</code> module is missing</li>\n<li>Fix: General UI issues in Editor screens in WordPress Admin</li>\n</ul>\n<h4>3.35.0 &#8211; 2026-02-02</h4>\n<ul>\n<li>New: Introducing Components &#8211; reusable layout building blocks with global sync and per-instance content overrides &#8211; Editor V4</li>\n<li>New: Introducing Inline Editing &#8211; edit Atomic Heading and Paragraph text directly on the canvas &#8211; Editor V4</li>\n<li>New: Introducing a contextual formatting toolbar for inline text editing, including links and common text styles &#8211; Editor V4</li>\n<li>Tweak: Version 4 status updated to Beta and production-ready &#8211; Editor V4</li>\n<li>Tweak: Children perspective controls available only for relevant parent elements &#8211; Editor V4</li>\n<li>Tweak: <code>:hover</code> styling automatically applies to <code>:focus-visible</code> for improved accessibility &#8211; Editor V4</li>\n<li>Tweak: Dynamic tags support added to color picker controls &#8211; Editor V4</li>\n<li>Tweak: Link and Button accessibility improvements in Dynamic Tags &#8211; Editor V4</li>\n<li>Tweak: Nested Accordion optimizations with Grid in Chrome browser</li>\n<li>Fix: Size link-unlink operations not applying consistently &#8211; Editor V4</li>\n<li>Fix: Div Block and Flexbox base styles overriding user settings when viewed from another document &#8211; Editor V4</li>\n<li>Fix: Flex and Div blocks lose selection when deleting an assigned class via the Class Manager &#8211; Editor V4</li>\n<li>Fix: Container handles not visible when &#8220;Overflow: Hidden&#8221; is enabled</li>\n</ul>\n<p><a href=\"https://go.elementor.com/full-changelog/\" rel=\"nofollow ugc\">See changelog for all versions.</a></p>\n\";s:11:\"screenshots\";s:3162:\"<ol><li><a href=\"https://ps.w.org/elementor/assets/screenshot-1.gif?rev=3005087\"><img src=\"https://ps.w.org/elementor/assets/screenshot-1.gif?rev=3005087\" alt=\"&lt;strong&gt;Visual Drag and Drop Editor&lt;/strong&gt; - Design your website layouts and place any element anywhere on the page for pixel-perfect designs.\"></a><p><strong>Visual Drag and Drop Editor</strong> - Design your website layouts and place any element anywhere on the page for pixel-perfect designs.</p></li><li><a href=\"https://ps.w.org/elementor/assets/screenshot-2.gif?rev=3005087\"><img src=\"https://ps.w.org/elementor/assets/screenshot-2.gif?rev=3005087\" alt=\"&lt;strong&gt;Full Design System&lt;/strong&gt; - Enjoy a professional workflow and ensure consistency across your site. Define your settings, use them globally, and instantly adjust them any time.\"></a><p><strong>Full Design System</strong> - Enjoy a professional workflow and ensure consistency across your site. Define your settings, use them globally, and instantly adjust them any time.</p></li><li><a href=\"https://ps.w.org/elementor/assets/screenshot-3.gif?rev=3005087\"><img src=\"https://ps.w.org/elementor/assets/screenshot-3.gif?rev=3005087\" alt=\"&lt;strong&gt;Responsive Design&lt;/strong&gt; Fully edit your website and customize the behavior on desktop, tablet, &amp; mobile to optimize the visitor experience on every device.\"></a><p><strong>Responsive Design</strong> Fully edit your website and customize the behavior on desktop, tablet, &amp; mobile to optimize the visitor experience on every device.</p></li><li><a href=\"https://ps.w.org/elementor/assets/screenshot-4.gif?rev=3005087\"><img src=\"https://ps.w.org/elementor/assets/screenshot-4.gif?rev=3005087\" alt=\"&lt;strong&gt;Kits and Templates&lt;/strong&gt; - Jumpstart your web creation process or get inspired with professionally-designed templates or full website kits available for your immediate customization.\"></a><p><strong>Kits and Templates</strong> - Jumpstart your web creation process or get inspired with professionally-designed templates or full website kits available for your immediate customization.</p></li><li><a href=\"https://ps.w.org/elementor/assets/screenshot-5.gif?rev=3005087\"><img src=\"https://ps.w.org/elementor/assets/screenshot-5.gif?rev=3005087\" alt=\"&lt;strong&gt;Nested Elements&lt;/strong&gt; Leverage Elementor Editor&#039;s Nested widgets to place any widget inside the content area of another widget - like Tabs, and Accordion for complete design flexibility.\"></a><p><strong>Nested Elements</strong> Leverage Elementor Editor\'s Nested widgets to place any widget inside the content area of another widget - like Tabs, and Accordion for complete design flexibility.</p></li><li><a href=\"https://ps.w.org/elementor/assets/screenshot-6.gif?rev=3005087\"><img src=\"https://ps.w.org/elementor/assets/screenshot-6.gif?rev=3005087\" alt=\"&lt;strong&gt;Motion Effects&lt;/strong&gt; - Add entrance animations and transitions to any element in your website to captivate visitors.\"></a><p><strong>Motion Effects</strong> - Add entrance animations and transitions to any element in your website to captivate visitors.</p></li></ol>\";s:7:\"reviews\";s:16495:\"<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Wonderful</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"1 از 5 ستاره\" data-title-template=\"%s از 5 ستاره\" data-rating=\"1\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				توسط <a href=\"https://profiles.wordpress.org/keyascii/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/8aede766e37ca20411e18ce027e1b1cb5e9eb58cefe14f7a980339726551b0db?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/8aede766e37ca20411e18ce027e1b1cb5e9eb58cefe14f7a980339726551b0db?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/keyascii/\" class=\"reviewer-name\">keyascii</a> در <span class=\"review-date\">فوریه 3, 2026</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>Does not work. Simply. If I create a new template, it is not managed as a popup</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">MAJ sur MAJ</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"2 از 5 ستاره\" data-title-template=\"%s از 5 ستاره\" data-rating=\"2\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				توسط <a href=\"https://profiles.wordpress.org/monastromag/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/7963eea045273490f88ed9b8317cb5fa727a25d324b835fbda1b155050d233cb?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/7963eea045273490f88ed9b8317cb5fa727a25d324b835fbda1b155050d233cb?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/monastromag/\" class=\"reviewer-name\">monastromag</a> در <span class=\"review-date\">فوریه 2, 2026</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>Depuis quelques temps ont est submergé de mise à jours mais dans 90% du temps c\'est pour une V4 qui est toujours en phase béta. Je ne suis pas contre les évolutions mais ça commence a faire long cette version béta. Déçu par ce coté répétitif qui nous oblige a réaliser une action qui à l\'heure actuelle ne m\'apporte rien du tout. Passer en alpha et je ferai les mise à jours avec grand plaisir.</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Truly mixed feelings - it&#039;s good for beginners mostly</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"3 از 5 ستاره\" data-title-template=\"%s از 5 ستاره\" data-rating=\"3\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				توسط <a href=\"https://profiles.wordpress.org/yb1313/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/a96b098785d2570e67c0361d976338fc1e616938057fde35a7dc58857bec9ca2?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/a96b098785d2570e67c0361d976338fc1e616938057fde35a7dc58857bec9ca2?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/yb1313/\" class=\"reviewer-name\">yb1313</a> در <span class=\"review-date\">فوریه 1, 2026</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>I\'m thankful for Elementor\'s enabling website-building with simple &amp; intuitive blocks. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>But not for the overly expensive Pro version, and the occasional bugs. I wish I had just used the WP page builder/editor instead for some sites without relying so much on a single plugin. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Hopefully this review will be of help and go up with time. </p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">ТОП</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 از 5 ستاره\" data-title-template=\"%s از 5 ستاره\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				توسط <a href=\"https://profiles.wordpress.org/k7news/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/db97903e020213c50481f5e8a4e896cedab52a1840a3f5591e317bd2f82de28f?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/db97903e020213c50481f5e8a4e896cedab52a1840a3f5591e317bd2f82de28f?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/k7news/\" class=\"reviewer-name\">K7NEWS-OFFICE <small>(k7news)</small></a> در <span class=\"review-date\">ژانویه 30, 2026</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>ТОП</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Not intuitive</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 از 5 ستاره\" data-title-template=\"%s از 5 ستاره\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				توسط <a href=\"https://profiles.wordpress.org/spasso888/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/9c9cfd7c1d8a36d48e44e26285afae83616a05b38537bfdeb92b151d6a6df8c9?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/9c9cfd7c1d8a36d48e44e26285afae83616a05b38537bfdeb92b151d6a6df8c9?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/spasso888/\" class=\"reviewer-name\">Josh S <small>(spasso888)</small></a> در <span class=\"review-date\">ژانویه 27, 2026</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>Every other page builder makes it easy to add a column and a row. This plugin, if we can call it that is unintutive. The work flow is clunky. Making a 2 column layout in anything else is easy... this takes the cake for the worst page builder. Having a learning curve or not this is still the worst page builder with the most bloat!</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">très intuitif et performant</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 از 5 ستاره\" data-title-template=\"%s از 5 ستاره\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				توسط <a href=\"https://profiles.wordpress.org/hugues7/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/2b7ad77f51afe84339bdc09770ca157e630afe689ea2b523e1de266a1fcfdf77?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/2b7ad77f51afe84339bdc09770ca157e630afe689ea2b523e1de266a1fcfdf77?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/hugues7/\" class=\"reviewer-name\">hugues7</a> در <span class=\"review-date\">ژانویه 26, 2026</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>Elementor est très intuitif , et très performant.</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">So tiring!</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"1 از 5 ستاره\" data-title-template=\"%s از 5 ستاره\" data-rating=\"1\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				توسط <a href=\"https://profiles.wordpress.org/lala9/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/247757b1ed3f2791865433bf7bba562a85b9ea98b9f307a6d74556d08df16d78?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/247757b1ed3f2791865433bf7bba562a85b9ea98b9f307a6d74556d08df16d78?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/lala9/\" class=\"reviewer-name\">lala9</a> در <span class=\"review-date\">ژانویه 25, 2026</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>Totally unnecessary changes just make it all so tiring and stressful that I am decided we are going to hire a techie to convert my site to blocks only.  This is too much.  And now, everywhere I look I get alerts and notifications warning me I only have 1 month to renew my pro license. So intrusive!</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Far too much unnecessary fluff that just slows down our site.</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Too clever</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 از 5 ستاره\" data-title-template=\"%s از 5 ستاره\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				توسط <a href=\"https://profiles.wordpress.org/ra1953watts/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/1df5ec68deedb39a57eb3ee0e7ba50bffce3c4f4fc5e17dae11a23f55154fbd7?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/1df5ec68deedb39a57eb3ee0e7ba50bffce3c4f4fc5e17dae11a23f55154fbd7?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/ra1953watts/\" class=\"reviewer-name\">Roger Watts <small>(ra1953watts)</small></a> در <span class=\"review-date\">ژانویه 23, 2026</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>Elementor is now in a competitive market place; it\'s all-in-one versatility is being overtaken and overshadowed by its quest to be all things. I feel I am getting sucked in to a vortex...</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">i love it</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 از 5 ستاره\" data-title-template=\"%s از 5 ستاره\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				توسط <a href=\"https://profiles.wordpress.org/piotrgross/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/4f1662c5b12f4bd2477e3fa46a233ebca6152966afcb216f4ea0b27d5c13a3b5?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/4f1662c5b12f4bd2477e3fa46a233ebca6152966afcb216f4ea0b27d5c13a3b5?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/piotrgross/\" class=\"reviewer-name\">piotrgross</a> در <span class=\"review-date\">ژانویه 23, 2026</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>I\'ve been using Elementor for years. It\'s never let me down.</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Mixes Formatting and Content</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"1 از 5 ستاره\" data-title-template=\"%s از 5 ستاره\" data-rating=\"1\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				توسط <a href=\"https://profiles.wordpress.org/kloddant/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/ea6d0543003811bf39dfef74a31f15287a49823fc40fb5011edcc3c0d71614b7?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/ea6d0543003811bf39dfef74a31f15287a49823fc40fb5011edcc3c0d71614b7?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/kloddant/\" class=\"reviewer-name\">kloddant</a> در <span class=\"review-date\">ژانویه 21, 2026</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>This plugin is always super annoying when I find it installed on a website, because it mixes formatting and content, which is a bad thing to do, because then the plugin can never be uninstalled if there is a problem, the syntax that is used for formatting cannot be switched, the formatting is not under version control, and the formatting is not templated but instead needs to be replicated on each post.  Formatting belongs in the theme.  Content belongs in the database.  They should not be mixed.</p>\n<!-- /wp:paragraph --></div>\n</div>\n\";}s:17:\"short_description\";s:342:\"صفحه‌ساز المنتور همه چیز را در خود جای داده: صفحه‌سازی با قابلیت کشیدن و رها کردن عناصر، طراحی پیکسلی عالی، ویرایشگر ریسپانسیو برای نسخه تلفن همراه و چیزهای زیاد دیگر. همین الان شروع کنید!\";s:13:\"download_link\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.35.1.zip\";s:14:\"upgrade_notice\";a:0:{}s:11:\"screenshots\";a:6:{i:1;a:2:{s:3:\"src\";s:62:\"https://ps.w.org/elementor/assets/screenshot-1.gif?rev=3005087\";s:7:\"caption\";s:144:\"<strong>Visual Drag and Drop Editor</strong> - Design your website layouts and place any element anywhere on the page for pixel-perfect designs.\";}i:2;a:2:{s:3:\"src\";s:62:\"https://ps.w.org/elementor/assets/screenshot-2.gif?rev=3005087\";s:7:\"caption\";s:185:\"<strong>Full Design System</strong> - Enjoy a professional workflow and ensure consistency across your site. Define your settings, use them globally, and instantly adjust them any time.\";}i:3;a:2:{s:3:\"src\";s:62:\"https://ps.w.org/elementor/assets/screenshot-3.gif?rev=3005087\";s:7:\"caption\";s:170:\"<strong>Responsive Design</strong> Fully edit your website and customize the behavior on desktop, tablet, &amp; mobile to optimize the visitor experience on every device.\";}i:4;a:2:{s:3:\"src\";s:62:\"https://ps.w.org/elementor/assets/screenshot-4.gif?rev=3005087\";s:7:\"caption\";s:193:\"<strong>Kits and Templates</strong> - Jumpstart your web creation process or get inspired with professionally-designed templates or full website kits available for your immediate customization.\";}i:5;a:2:{s:3:\"src\";s:62:\"https://ps.w.org/elementor/assets/screenshot-5.gif?rev=3005087\";s:7:\"caption\";s:197:\"<strong>Nested Elements</strong> Leverage Elementor Editor\'s Nested widgets to place any widget inside the content area of another widget - like Tabs, and Accordion for complete design flexibility.\";}i:6;a:2:{s:3:\"src\";s:62:\"https://ps.w.org/elementor/assets/screenshot-6.gif?rev=3005087\";s:7:\"caption\";s:127:\"<strong>Motion Effects</strong> - Add entrance animations and transitions to any element in your website to captivate visitors.\";}}s:4:\"tags\";a:5:{s:13:\"drag-and-drop\";s:13:\"drag-and-drop\";s:6:\"editor\";s:6:\"editor\";s:9:\"elementor\";s:9:\"elementor\";s:12:\"landing-page\";s:12:\"landing page\";s:12:\"page-builder\";s:12:\"page builder\";}s:8:\"versions\";a:401:{s:5:\"3.0.0\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.0.0.zip\";s:5:\"3.0.1\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.0.1.zip\";s:6:\"3.0.10\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.0.10.zip\";s:6:\"3.0.11\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.0.11.zip\";s:6:\"3.0.12\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.0.12.zip\";s:6:\"3.0.13\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.0.13.zip\";s:6:\"3.0.14\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.0.14.zip\";s:6:\"3.0.15\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.0.15.zip\";s:6:\"3.0.16\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.0.16.zip\";s:5:\"3.0.2\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.0.2.zip\";s:5:\"3.0.3\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.0.3.zip\";s:5:\"3.0.4\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.0.4.zip\";s:5:\"3.0.5\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.0.5.zip\";s:5:\"3.0.6\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.0.6.zip\";s:5:\"3.0.7\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.0.7.zip\";s:5:\"3.0.8\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.0.8.zip\";s:7:\"3.0.8.1\";s:60:\"https://downloads.wordpress.org/plugin/elementor.3.0.8.1.zip\";s:5:\"3.0.9\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.0.9.zip\";s:5:\"3.1.0\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.1.0.zip\";s:11:\"3.1.0-beta1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.1.0-beta1.zip\";s:11:\"3.1.0-beta2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.1.0-beta2.zip\";s:11:\"3.1.0-beta3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.1.0-beta3.zip\";s:11:\"3.1.0-beta4\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.1.0-beta4.zip\";s:10:\"3.1.0-dev1\";s:63:\"https://downloads.wordpress.org/plugin/elementor.3.1.0-dev1.zip\";s:10:\"3.1.0-dev2\";s:63:\"https://downloads.wordpress.org/plugin/elementor.3.1.0-dev2.zip\";s:10:\"3.1.0-dev3\";s:63:\"https://downloads.wordpress.org/plugin/elementor.3.1.0-dev3.zip\";s:5:\"3.1.1\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.1.1.zip\";s:5:\"3.1.2\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.1.2.zip\";s:5:\"3.1.3\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.1.3.zip\";s:5:\"3.1.4\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.1.4.zip\";s:6:\"3.10.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.10.0.zip\";s:11:\"3.10.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.10.0-dev1.zip\";s:6:\"3.10.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.10.1.zip\";s:6:\"3.10.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.10.2.zip\";s:6:\"3.11.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.11.0.zip\";s:12:\"3.11.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.11.0-beta1.zip\";s:12:\"3.11.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.11.0-beta2.zip\";s:12:\"3.11.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.11.0-beta3.zip\";s:11:\"3.11.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.11.0-dev1.zip\";s:11:\"3.11.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.11.0-dev2.zip\";s:11:\"3.11.0-dev3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.11.0-dev3.zip\";s:6:\"3.11.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.11.1.zip\";s:6:\"3.11.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.11.2.zip\";s:6:\"3.11.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.11.3.zip\";s:6:\"3.11.4\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.11.4.zip\";s:6:\"3.11.5\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.11.5.zip\";s:6:\"3.12.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.12.0.zip\";s:6:\"3.12.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.12.1.zip\";s:6:\"3.12.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.12.2.zip\";s:6:\"3.13.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.13.0.zip\";s:12:\"3.13.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.13.0-beta1.zip\";s:12:\"3.13.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.13.0-beta2.zip\";s:12:\"3.13.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.13.0-beta3.zip\";s:11:\"3.13.0-dev3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.13.0-dev3.zip\";s:11:\"3.13.0-dev4\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.13.0-dev4.zip\";s:6:\"3.13.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.13.1.zip\";s:6:\"3.13.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.13.2.zip\";s:6:\"3.13.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.13.3.zip\";s:6:\"3.13.4\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.13.4.zip\";s:6:\"3.14.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.14.0.zip\";s:12:\"3.14.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.14.0-beta1.zip\";s:12:\"3.14.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.14.0-beta2.zip\";s:12:\"3.14.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.14.0-beta3.zip\";s:12:\"3.14.0-beta4\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.14.0-beta4.zip\";s:12:\"3.14.0-beta5\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.14.0-beta5.zip\";s:6:\"3.14.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.14.1.zip\";s:6:\"3.15.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.15.0.zip\";s:6:\"3.15.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.15.1.zip\";s:6:\"3.15.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.15.2.zip\";s:6:\"3.15.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.15.3.zip\";s:6:\"3.16.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.16.0.zip\";s:12:\"3.16.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.16.0-beta3.zip\";s:12:\"3.16.0-beta4\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.16.0-beta4.zip\";s:11:\"3.16.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.16.0-dev1.zip\";s:11:\"3.16.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.16.0-dev2.zip\";s:6:\"3.16.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.16.1.zip\";s:6:\"3.16.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.16.2.zip\";s:6:\"3.16.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.16.3.zip\";s:6:\"3.16.4\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.16.4.zip\";s:6:\"3.16.5\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.16.5.zip\";s:6:\"3.16.6\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.16.6.zip\";s:6:\"3.17.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.17.0.zip\";s:11:\"3.17.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.17.0-dev2.zip\";s:11:\"3.17.0-dev3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.17.0-dev3.zip\";s:11:\"3.17.0-dev4\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.17.0-dev4.zip\";s:6:\"3.17.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.17.1.zip\";s:6:\"3.17.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.17.2.zip\";s:6:\"3.17.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.17.3.zip\";s:6:\"3.18.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.18.0.zip\";s:12:\"3.18.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.18.0-beta1.zip\";s:12:\"3.18.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.18.0-beta2.zip\";s:12:\"3.18.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.18.0-beta3.zip\";s:12:\"3.18.0-beta4\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.18.0-beta4.zip\";s:11:\"3.18.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.18.0-dev1.zip\";s:6:\"3.18.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.18.1.zip\";s:6:\"3.18.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.18.2.zip\";s:6:\"3.18.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.18.3.zip\";s:6:\"3.19.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.19.0.zip\";s:12:\"3.19.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.19.0-beta1.zip\";s:12:\"3.19.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.19.0-beta2.zip\";s:12:\"3.19.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.19.0-beta3.zip\";s:12:\"3.19.0-beta4\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.19.0-beta4.zip\";s:12:\"3.19.0-beta5\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.19.0-beta5.zip\";s:12:\"3.19.0-beta6\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.19.0-beta6.zip\";s:11:\"3.19.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.19.0-dev1.zip\";s:11:\"3.19.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.19.0-dev2.zip\";s:11:\"3.19.0-dev3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.19.0-dev3.zip\";s:11:\"3.19.0-dev4\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.19.0-dev4.zip\";s:11:\"3.19.0-dev5\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.19.0-dev5.zip\";s:11:\"3.19.0-dev6\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.19.0-dev6.zip\";s:6:\"3.19.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.19.1.zip\";s:6:\"3.19.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.19.2.zip\";s:6:\"3.19.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.19.3.zip\";s:6:\"3.19.4\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.19.4.zip\";s:5:\"3.2.0\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.2.0.zip\";s:5:\"3.2.1\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.2.1.zip\";s:5:\"3.2.2\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.2.2.zip\";s:5:\"3.2.3\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.2.3.zip\";s:5:\"3.2.4\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.2.4.zip\";s:5:\"3.2.5\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.2.5.zip\";s:6:\"3.20.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.20.0.zip\";s:12:\"3.20.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.20.0-beta1.zip\";s:12:\"3.20.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.20.0-beta2.zip\";s:12:\"3.20.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.20.0-beta3.zip\";s:12:\"3.20.0-beta4\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.20.0-beta4.zip\";s:11:\"3.20.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.20.0-dev1.zip\";s:11:\"3.20.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.20.0-dev2.zip\";s:11:\"3.20.0-dev3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.20.0-dev3.zip\";s:11:\"3.20.0-dev4\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.20.0-dev4.zip\";s:6:\"3.20.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.20.1.zip\";s:6:\"3.20.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.20.2.zip\";s:6:\"3.20.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.20.3.zip\";s:6:\"3.20.4\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.20.4.zip\";s:6:\"3.21.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.21.0.zip\";s:12:\"3.21.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.21.0-beta1.zip\";s:12:\"3.21.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.21.0-beta2.zip\";s:12:\"3.21.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.21.0-beta3.zip\";s:11:\"3.21.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.21.0-dev1.zip\";s:11:\"3.21.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.21.0-dev2.zip\";s:11:\"3.21.0-dev3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.21.0-dev3.zip\";s:6:\"3.21.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.21.1.zip\";s:6:\"3.21.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.21.2.zip\";s:6:\"3.21.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.21.3.zip\";s:6:\"3.21.4\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.21.4.zip\";s:6:\"3.21.5\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.21.5.zip\";s:6:\"3.21.6\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.21.6.zip\";s:6:\"3.21.7\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.21.7.zip\";s:6:\"3.21.8\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.21.8.zip\";s:6:\"3.22.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.22.0.zip\";s:12:\"3.22.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.22.0-beta1.zip\";s:12:\"3.22.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.22.0-beta2.zip\";s:12:\"3.22.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.22.0-beta3.zip\";s:12:\"3.22.0-beta4\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.22.0-beta4.zip\";s:12:\"3.22.0-beta5\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.22.0-beta5.zip\";s:12:\"3.22.0-beta6\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.22.0-beta6.zip\";s:11:\"3.22.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.22.0-dev1.zip\";s:11:\"3.22.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.22.0-dev2.zip\";s:11:\"3.22.0-dev3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.22.0-dev3.zip\";s:11:\"3.22.0-dev4\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.22.0-dev4.zip\";s:11:\"3.22.0-dev5\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.22.0-dev5.zip\";s:11:\"3.22.0-dev6\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.22.0-dev6.zip\";s:6:\"3.22.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.22.1.zip\";s:6:\"3.22.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.22.2.zip\";s:6:\"3.22.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.22.3.zip\";s:6:\"3.23.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.23.0.zip\";s:12:\"3.23.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.23.0-beta1.zip\";s:12:\"3.23.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.23.0-beta2.zip\";s:12:\"3.23.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.23.0-beta3.zip\";s:12:\"3.23.0-beta4\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.23.0-beta4.zip\";s:12:\"3.23.0-beta5\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.23.0-beta5.zip\";s:12:\"3.23.0-beta6\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.23.0-beta6.zip\";s:11:\"3.23.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.23.0-dev1.zip\";s:11:\"3.23.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.23.0-dev2.zip\";s:11:\"3.23.0-dev3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.23.0-dev3.zip\";s:11:\"3.23.0-dev4\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.23.0-dev4.zip\";s:11:\"3.23.0-dev5\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.23.0-dev5.zip\";s:11:\"3.23.0-dev6\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.23.0-dev6.zip\";s:6:\"3.23.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.23.1.zip\";s:6:\"3.23.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.23.2.zip\";s:6:\"3.23.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.23.3.zip\";s:6:\"3.23.4\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.23.4.zip\";s:6:\"3.24.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.24.0.zip\";s:12:\"3.24.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.24.0-beta1.zip\";s:12:\"3.24.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.24.0-beta2.zip\";s:12:\"3.24.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.24.0-beta3.zip\";s:11:\"3.24.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.24.0-dev1.zip\";s:11:\"3.24.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.24.0-dev2.zip\";s:11:\"3.24.0-dev3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.24.0-dev3.zip\";s:6:\"3.24.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.24.1.zip\";s:6:\"3.24.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.24.2.zip\";s:6:\"3.24.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.24.3.zip\";s:6:\"3.24.4\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.24.4.zip\";s:6:\"3.24.5\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.24.5.zip\";s:6:\"3.24.6\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.24.6.zip\";s:6:\"3.24.7\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.24.7.zip\";s:6:\"3.24.8\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.24.8.zip\";s:6:\"3.25.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.25.0.zip\";s:12:\"3.25.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.25.0-beta1.zip\";s:12:\"3.25.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.25.0-beta2.zip\";s:12:\"3.25.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.25.0-beta3.zip\";s:11:\"3.25.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.25.0-dev1.zip\";s:11:\"3.25.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.25.0-dev2.zip\";s:11:\"3.25.0-dev3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.25.0-dev3.zip\";s:6:\"3.25.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.25.1.zip\";s:7:\"3.25.10\";s:60:\"https://downloads.wordpress.org/plugin/elementor.3.25.10.zip\";s:7:\"3.25.11\";s:60:\"https://downloads.wordpress.org/plugin/elementor.3.25.11.zip\";s:6:\"3.25.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.25.2.zip\";s:6:\"3.25.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.25.3.zip\";s:6:\"3.25.4\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.25.4.zip\";s:6:\"3.25.5\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.25.5.zip\";s:6:\"3.25.6\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.25.6.zip\";s:6:\"3.25.7\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.25.7.zip\";s:6:\"3.25.8\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.25.8.zip\";s:6:\"3.25.9\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.25.9.zip\";s:6:\"3.26.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.26.0.zip\";s:12:\"3.26.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.26.0-beta1.zip\";s:12:\"3.26.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.26.0-beta2.zip\";s:12:\"3.26.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.26.0-beta3.zip\";s:12:\"3.26.0-beta4\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.26.0-beta4.zip\";s:12:\"3.26.0-beta5\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.26.0-beta5.zip\";s:11:\"3.26.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.26.0-dev1.zip\";s:11:\"3.26.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.26.0-dev2.zip\";s:11:\"3.26.0-dev3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.26.0-dev3.zip\";s:11:\"3.26.0-dev4\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.26.0-dev4.zip\";s:11:\"3.26.0-dev5\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.26.0-dev5.zip\";s:6:\"3.26.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.26.1.zip\";s:6:\"3.26.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.26.2.zip\";s:6:\"3.26.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.26.3.zip\";s:6:\"3.26.4\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.26.4.zip\";s:6:\"3.26.5\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.26.5.zip\";s:6:\"3.27.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.27.0.zip\";s:12:\"3.27.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.27.0-beta1.zip\";s:12:\"3.27.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.27.0-beta2.zip\";s:11:\"3.27.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.27.0-dev1.zip\";s:11:\"3.27.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.27.0-dev2.zip\";s:6:\"3.27.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.27.1.zip\";s:6:\"3.27.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.27.2.zip\";s:6:\"3.27.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.27.3.zip\";s:6:\"3.27.4\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.27.4.zip\";s:6:\"3.27.5\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.27.5.zip\";s:6:\"3.27.6\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.27.6.zip\";s:6:\"3.27.7\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.27.7.zip\";s:6:\"3.28.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.28.0.zip\";s:12:\"3.28.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.28.0-beta1.zip\";s:12:\"3.28.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.28.0-beta2.zip\";s:12:\"3.28.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.28.0-beta3.zip\";s:11:\"3.28.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.28.0-dev1.zip\";s:11:\"3.28.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.28.0-dev2.zip\";s:11:\"3.28.0-dev3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.28.0-dev3.zip\";s:6:\"3.28.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.28.1.zip\";s:6:\"3.28.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.28.2.zip\";s:6:\"3.28.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.28.3.zip\";s:6:\"3.28.4\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.28.4.zip\";s:6:\"3.29.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.29.0.zip\";s:12:\"3.29.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.29.0-beta1.zip\";s:12:\"3.29.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.29.0-beta2.zip\";s:12:\"3.29.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.29.0-beta3.zip\";s:12:\"3.29.0-beta4\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.29.0-beta4.zip\";s:11:\"3.29.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.29.0-dev1.zip\";s:11:\"3.29.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.29.0-dev2.zip\";s:11:\"3.29.0-dev3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.29.0-dev3.zip\";s:11:\"3.29.0-dev4\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.29.0-dev4.zip\";s:6:\"3.29.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.29.1.zip\";s:6:\"3.29.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.29.2.zip\";s:5:\"3.3.0\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.3.0.zip\";s:5:\"3.3.1\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.3.1.zip\";s:6:\"3.30.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.30.0.zip\";s:12:\"3.30.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.30.0-beta1.zip\";s:12:\"3.30.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.30.0-beta2.zip\";s:12:\"3.30.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.30.0-beta3.zip\";s:11:\"3.30.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.30.0-dev1.zip\";s:11:\"3.30.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.30.0-dev2.zip\";s:11:\"3.30.0-dev3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.30.0-dev3.zip\";s:6:\"3.30.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.30.1.zip\";s:6:\"3.30.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.30.2.zip\";s:6:\"3.30.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.30.3.zip\";s:6:\"3.30.4\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.30.4.zip\";s:6:\"3.31.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.31.0.zip\";s:12:\"3.31.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.31.0-beta1.zip\";s:12:\"3.31.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.31.0-beta2.zip\";s:11:\"3.31.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.31.0-dev1.zip\";s:11:\"3.31.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.31.0-dev2.zip\";s:6:\"3.31.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.31.1.zip\";s:6:\"3.31.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.31.2.zip\";s:6:\"3.31.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.31.3.zip\";s:6:\"3.31.4\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.31.4.zip\";s:6:\"3.31.5\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.31.5.zip\";s:6:\"3.32.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.32.0.zip\";s:12:\"3.32.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.32.0-beta1.zip\";s:12:\"3.32.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.32.0-beta2.zip\";s:12:\"3.32.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.32.0-beta3.zip\";s:11:\"3.32.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.32.0-dev1.zip\";s:11:\"3.32.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.32.0-dev2.zip\";s:11:\"3.32.0-dev3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.32.0-dev3.zip\";s:6:\"3.32.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.32.1.zip\";s:6:\"3.32.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.32.2.zip\";s:6:\"3.32.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.32.3.zip\";s:6:\"3.32.4\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.32.4.zip\";s:6:\"3.32.5\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.32.5.zip\";s:6:\"3.33.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.33.0.zip\";s:12:\"3.33.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.33.0-beta1.zip\";s:12:\"3.33.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.33.0-beta2.zip\";s:12:\"3.33.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.33.0-beta3.zip\";s:12:\"3.33.0-beta4\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.33.0-beta4.zip\";s:11:\"3.33.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.33.0-dev1.zip\";s:11:\"3.33.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.33.0-dev2.zip\";s:11:\"3.33.0-dev3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.33.0-dev3.zip\";s:11:\"3.33.0-dev4\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.33.0-dev4.zip\";s:6:\"3.33.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.33.1.zip\";s:6:\"3.33.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.33.2.zip\";s:6:\"3.33.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.33.3.zip\";s:6:\"3.33.4\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.33.4.zip\";s:6:\"3.33.5\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.33.5.zip\";s:6:\"3.33.6\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.33.6.zip\";s:6:\"3.34.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.34.0.zip\";s:12:\"3.34.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.34.0-beta1.zip\";s:12:\"3.34.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.34.0-beta2.zip\";s:12:\"3.34.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.34.0-beta3.zip\";s:11:\"3.34.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.34.0-dev1.zip\";s:11:\"3.34.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.34.0-dev2.zip\";s:6:\"3.34.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.34.1.zip\";s:6:\"3.34.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.34.2.zip\";s:6:\"3.34.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.34.3.zip\";s:6:\"3.34.4\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.34.4.zip\";s:6:\"3.35.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.35.0.zip\";s:12:\"3.35.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.35.0-beta1.zip\";s:12:\"3.35.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.35.0-beta2.zip\";s:12:\"3.35.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.35.0-beta3.zip\";s:12:\"3.35.0-beta4\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.35.0-beta4.zip\";s:11:\"3.35.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.35.0-dev1.zip\";s:11:\"3.35.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.35.0-dev2.zip\";s:11:\"3.35.0-dev3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.35.0-dev3.zip\";s:11:\"3.35.0-dev4\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.35.0-dev4.zip\";s:6:\"3.35.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.35.1.zip\";s:5:\"3.4.0\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.4.0.zip\";s:10:\"3.4.0-dev7\";s:63:\"https://downloads.wordpress.org/plugin/elementor.3.4.0-dev7.zip\";s:10:\"3.4.0-dev8\";s:63:\"https://downloads.wordpress.org/plugin/elementor.3.4.0-dev8.zip\";s:10:\"3.4.0-dev9\";s:63:\"https://downloads.wordpress.org/plugin/elementor.3.4.0-dev9.zip\";s:5:\"3.4.1\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.4.1.zip\";s:5:\"3.4.2\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.4.2.zip\";s:5:\"3.4.3\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.4.3.zip\";s:5:\"3.4.4\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.4.4.zip\";s:5:\"3.4.5\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.4.5.zip\";s:5:\"3.4.6\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.4.6.zip\";s:5:\"3.4.7\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.4.7.zip\";s:5:\"3.4.8\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.4.8.zip\";s:5:\"3.5.0\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.5.0.zip\";s:11:\"3.5.0-beta1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.5.0-beta1.zip\";s:11:\"3.5.0-beta2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.5.0-beta2.zip\";s:11:\"3.5.0-beta3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.5.0-beta3.zip\";s:11:\"3.5.0-beta4\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.5.0-beta4.zip\";s:11:\"3.5.0-beta5\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.5.0-beta5.zip\";s:11:\"3.5.0-beta7\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.5.0-beta7.zip\";s:11:\"3.5.0-beta8\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.5.0-beta8.zip\";s:10:\"3.5.0-dev8\";s:63:\"https://downloads.wordpress.org/plugin/elementor.3.5.0-dev8.zip\";s:10:\"3.5.0-dev9\";s:63:\"https://downloads.wordpress.org/plugin/elementor.3.5.0-dev9.zip\";s:5:\"3.5.1\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.5.1.zip\";s:5:\"3.5.2\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.5.2.zip\";s:5:\"3.5.3\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.5.3.zip\";s:5:\"3.5.4\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.5.4.zip\";s:5:\"3.5.5\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.5.5.zip\";s:5:\"3.5.6\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.5.6.zip\";s:5:\"3.6.0\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.6.0.zip\";s:11:\"3.6.0-beta1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.6.0-beta1.zip\";s:11:\"3.6.0-beta2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.6.0-beta2.zip\";s:11:\"3.6.0-beta3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.6.0-beta3.zip\";s:11:\"3.6.0-beta4\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.6.0-beta4.zip\";s:11:\"3.6.0-beta5\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.6.0-beta5.zip\";s:10:\"3.6.0-dev1\";s:63:\"https://downloads.wordpress.org/plugin/elementor.3.6.0-dev1.zip\";s:11:\"3.6.0-dev10\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.6.0-dev10.zip\";s:5:\"3.6.1\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.6.1.zip\";s:5:\"3.6.2\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.6.2.zip\";s:5:\"3.6.3\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.6.3.zip\";s:5:\"3.6.4\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.6.4.zip\";s:5:\"3.6.5\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.6.5.zip\";s:5:\"3.6.6\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.6.6.zip\";s:5:\"3.6.7\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.6.7.zip\";s:5:\"3.6.8\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.6.8.zip\";s:5:\"3.7.0\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.7.0.zip\";s:11:\"3.7.0-beta1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.7.0-beta1.zip\";s:11:\"3.7.0-beta2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.7.0-beta2.zip\";s:11:\"3.7.0-beta3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.7.0-beta3.zip\";s:11:\"3.7.0-beta4\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.7.0-beta4.zip\";s:10:\"3.7.0-dev1\";s:63:\"https://downloads.wordpress.org/plugin/elementor.3.7.0-dev1.zip\";s:5:\"3.7.1\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.7.1.zip\";s:5:\"3.7.2\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.7.2.zip\";s:5:\"3.7.3\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.7.3.zip\";s:5:\"3.7.4\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.7.4.zip\";s:5:\"3.7.5\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.7.5.zip\";s:5:\"3.7.6\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.7.6.zip\";s:5:\"3.7.7\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.7.7.zip\";s:5:\"3.7.8\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.7.8.zip\";s:5:\"3.8.0\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.8.0.zip\";s:11:\"3.8.0-beta1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.8.0-beta1.zip\";s:11:\"3.8.0-beta2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.8.0-beta2.zip\";s:11:\"3.8.0-beta3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.8.0-beta3.zip\";s:5:\"3.8.1\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.8.1.zip\";s:5:\"3.9.0\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.9.0.zip\";s:5:\"3.9.1\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.9.1.zip\";s:5:\"3.9.2\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.9.2.zip\";s:5:\"trunk\";s:52:\"https://downloads.wordpress.org/plugin/elementor.zip\";}s:14:\"business_model\";s:10:\"commercial\";s:14:\"repository_url\";s:0:\"\";s:22:\"commercial_support_url\";s:94:\"https://elementor.com/support/?utm_source=wp-repo&utm_medium=link&utm_campaign=premium-support\";s:11:\"donate_link\";s:0:\"\";s:7:\"banners\";a:2:{s:3:\"low\";s:64:\"https://ps.w.org/elementor/assets/banner-772x250.png?rev=3443226\";s:4:\"high\";s:65:\"https://ps.w.org/elementor/assets/banner-1544x500.png?rev=3443226\";}s:5:\"icons\";a:2:{s:2:\"1x\";s:62:\"https://ps.w.org/elementor/assets/icon-128x128.gif?rev=3444228\";s:2:\"2x\";s:62:\"https://ps.w.org/elementor/assets/icon-256x256.gif?rev=3444228\";}s:12:\"preview_link\";s:0:\"\";s:4:\"Name\";s:84:\"وب‌سایت ساز المنتور &#8211; فراتر از یک صفحه‌ساز\";}}","off");

INSERT IGNORE INTO `YTcMX_options` VALUES 
("232","wfls_last_role_change","1756627565","off"),
("235","wordfence_installed","","auto"),
("237","wf_plugin_act_error","","auto"),
("253","virtual_patches_subscription_guid","","auto"),
("271","current_theme","Hello Elementor","auto"),
("272","theme_mods_astra","a:5:{i:0;b:0;s:18:\"nav_menu_locations\";a:2:{s:7:\"primary\";i:2;s:11:\"mobile_menu\";i:3;}s:18:\"custom_css_post_id\";i:60;s:11:\"custom_logo\";s:0:\"\";s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1756811663;s:4:\"data\";a:8:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:5:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:7:\"block-5\";i:4;s:7:\"block-6\";}s:15:\"footer-widget-1\";a:0:{}s:15:\"footer-widget-2\";a:0:{}s:24:\"advanced-footer-widget-1\";a:0:{}s:24:\"advanced-footer-widget-2\";a:0:{}s:24:\"advanced-footer-widget-3\";a:0:{}s:24:\"advanced-footer-widget-4\";a:0:{}}}}","off"),
("273","theme_switched","","auto"),
("277","allowed_astra_notices","a:1:{i:0;s:21:\"astra-sites-on-active\";}","auto"),
("278","astra_analytics_installed_time","1756666281","off"),
("285","nps-survey-astra","a:6:{s:13:\"dismiss_count\";i:1;s:19:\"dismiss_permanently\";b:0;s:12:\"dismiss_step\";s:10:\"nps-rating\";s:12:\"dismiss_time\";i:1764351089;s:16:\"dismiss_timespan\";i:1209600;s:17:\"first_render_time\";i:1756668500;}","auto"),
("303","_transient_health-check-site-status-result","{\"good\":18,\"recommended\":5,\"critical\":1}","on"),
("321","__uagb_do_redirect","","auto"),
("322","__uagb_activated_before","1","auto"),
("323","__uagb_asset_version","1765465348","auto"),
("324","uagb_site_url","staging-dadmanlaw-com","auto"),
("325","_uagb_allow_file_generation","enabled","auto"),
("326","uagb-version","2.19.17","auto"),
("327","spectra_analytics_installed_time","1756673940","off"),
("328","ast-block-templates-version","2.4.8","auto"),
("331","uag_content_width_set_by","Astra Theme","auto"),
("334","nps-survey-spectra","a:6:{s:13:\"dismiss_count\";i:1;s:19:\"dismiss_permanently\";b:0;s:12:\"dismiss_step\";s:10:\"nps-rating\";s:12:\"dismiss_time\";i:1764354806;s:16:\"dismiss_timespan\";i:1209600;s:17:\"first_render_time\";i:1756673941;}","auto"),
("335","action_scheduler_hybrid_store_demarkation","9","auto"),
("336","schema-ActionScheduler_StoreSchema","8.0.1756673979","auto"),
("337","schema-ActionScheduler_LoggerSchema","3.0.1756673979","auto"),
("338","rank_math_known_post_types","a:5:{s:4:\"post\";s:4:\"post\";s:4:\"page\";s:4:\"page\";s:10:\"attachment\";s:10:\"attachment\";s:18:\"e-floating-buttons\";s:18:\"e-floating-buttons\";s:17:\"elementor_library\";s:17:\"elementor_library\";}","auto"),
("339","rank_math_modules","a:17:{i:0;s:12:\"link-counter\";i:1;s:9:\"analytics\";i:2;s:12:\"seo-analysis\";i:3;s:7:\"sitemap\";i:4;s:12:\"rich-snippet\";i:5;s:11:\"woocommerce\";i:6;s:10:\"buddypress\";i:7;s:7:\"bbpress\";i:8;s:3:\"acf\";i:9;s:11:\"web-stories\";i:11;s:16:\"instant-indexing\";i:12;s:9:\"local-seo\";i:13;s:12:\"role-manager\";i:14;s:11:\"404-monitor\";i:15;s:9:\"image-seo\";i:16;s:8:\"llms-txt\";i:17;s:12:\"redirections\";}","auto"),
("340","rank_math_react_settings_ui","on","off"),
("341","rank-math-options-general","a:57:{s:19:\"strip_category_base\";s:3:\"off\";s:24:\"attachment_redirect_urls\";s:2:\"on\";s:27:\"attachment_redirect_default\";s:19:\"https://avnalaw.com\";s:23:\"nofollow_external_links\";s:3:\"off\";s:20:\"nofollow_image_links\";s:3:\"off\";s:25:\"new_window_external_links\";s:2:\"on\";s:11:\"add_img_alt\";s:3:\"off\";s:14:\"img_alt_format\";s:10:\"%filename%\";s:13:\"add_img_title\";s:3:\"off\";s:16:\"img_title_format\";s:22:\"%title% %count(title)%\";s:11:\"breadcrumbs\";s:3:\"off\";s:21:\"breadcrumbs_separator\";s:1:\"-\";s:16:\"breadcrumbs_home\";s:2:\"on\";s:22:\"breadcrumbs_home_label\";s:4:\"Home\";s:26:\"breadcrumbs_archive_format\";s:15:\"Archives for %s\";s:25:\"breadcrumbs_search_format\";s:14:\"Results for %s\";s:21:\"breadcrumbs_404_label\";s:25:\"404 Error: page not found\";s:31:\"breadcrumbs_ancestor_categories\";s:3:\"off\";s:21:\"breadcrumbs_blog_page\";s:3:\"off\";s:16:\"404_monitor_mode\";s:6:\"simple\";s:17:\"404_monitor_limit\";s:3:\"100\";s:35:\"404_monitor_ignore_query_parameters\";s:2:\"on\";s:24:\"redirections_header_code\";s:3:\"301\";s:18:\"redirections_debug\";s:3:\"off\";s:23:\"console_caching_control\";i:90;s:21:\"console_email_reports\";b:1;s:23:\"console_email_frequency\";s:7:\"monthly\";s:22:\"wc_remove_product_base\";b:0;s:23:\"wc_remove_category_base\";b:0;s:31:\"wc_remove_category_parent_slugs\";b:0;s:18:\"rss_before_content\";s:0:\"\";s:17:\"rss_after_content\";s:0:\"\";s:19:\"wc_remove_generator\";b:1;s:24:\"remove_shop_snippet_data\";b:1;s:18:\"frontend_seo_score\";s:3:\"off\";s:29:\"frontend_seo_score_post_types\";a:1:{i:0;s:4:\"post\";}s:27:\"frontend_seo_score_position\";s:3:\"top\";s:10:\"setup_mode\";s:8:\"advanced\";s:21:\"content_ai_post_types\";a:2:{i:0;s:4:\"post\";i:1;s:4:\"page\";}s:18:\"content_ai_country\";s:3:\"all\";s:15:\"content_ai_tone\";s:6:\"Formal\";s:19:\"content_ai_audience\";s:16:\"General Audience\";s:19:\"content_ai_language\";s:10:\"US English\";s:15:\"analytics_stats\";b:0;s:15:\"toc_block_title\";s:17:\"Table of Contents\";s:20:\"toc_block_list_style\";s:2:\"ul\";s:15:\"llms_post_types\";a:2:{i:0;s:4:\"post\";i:1;s:4:\"page\";}s:21:\"breadcrumbs_home_link\";s:19:\"https://avnalaw.com\";s:29:\"breadcrumbs_remove_post_title\";s:3:\"off\";s:30:\"breadcrumbs_hide_taxonomy_name\";s:3:\"off\";s:16:\"headless_support\";s:3:\"off\";s:27:\"frontend_seo_score_template\";s:6:\"circle\";s:17:\"support_rank_math\";s:2:\"on\";s:10:\"llms_limit\";s:2:\"50\";s:21:\"redirections_fallback\";s:7:\"default\";s:26:\"redirections_post_redirect\";s:2:\"on\";s:19:\"404_monitor_exclude\";a:0:{}}","auto"),
("342","rank-math-options-titles","a:147:{s:24:\"noindex_empty_taxonomies\";s:2:\"on\";s:15:\"title_separator\";s:1:\"-\";s:17:\"capitalize_titles\";s:3:\"off\";s:17:\"twitter_card_type\";s:19:\"summary_large_image\";s:19:\"knowledgegraph_type\";s:7:\"company\";s:19:\"knowledgegraph_name\";s:12:\"دادمان\";s:12:\"website_name\";s:36:\"دادمان | وکلای متخصص\";s:19:\"local_business_type\";s:12:\"Organization\";s:20:\"local_address_format\";s:43:\"{address} {locality}, {region} {postalcode}\";s:13:\"opening_hours\";a:7:{i:0;a:2:{s:3:\"day\";s:6:\"Monday\";s:4:\"time\";s:11:\"09:00-17:00\";}i:1;a:2:{s:3:\"day\";s:7:\"Tuesday\";s:4:\"time\";s:11:\"09:00-17:00\";}i:2;a:2:{s:3:\"day\";s:9:\"Wednesday\";s:4:\"time\";s:11:\"09:00-17:00\";}i:3;a:2:{s:3:\"day\";s:8:\"Thursday\";s:4:\"time\";s:11:\"09:00-17:00\";}i:4;a:2:{s:3:\"day\";s:6:\"Friday\";s:4:\"time\";s:11:\"09:00-17:00\";}i:5;a:2:{s:3:\"day\";s:8:\"Saturday\";s:4:\"time\";s:11:\"09:00-17:00\";}i:6;a:2:{s:3:\"day\";s:6:\"Sunday\";s:4:\"time\";s:11:\"09:00-17:00\";}}s:20:\"opening_hours_format\";s:0:\"\";s:14:\"homepage_title\";s:34:\"%sitename% %page% %sep% %sitedesc%\";s:20:\"homepage_description\";s:0:\"\";s:22:\"homepage_custom_robots\";b:0;s:23:\"disable_author_archives\";s:0:\"\";s:15:\"url_author_base\";s:6:\"author\";s:20:\"author_custom_robots\";s:2:\"on\";s:13:\"author_robots\";a:1:{i:0;s:7:\"noindex\";}s:20:\"author_archive_title\";s:30:\"%name% %sep% %sitename% %page%\";s:19:\"author_add_meta_box\";s:2:\"on\";s:21:\"disable_date_archives\";s:2:\"on\";s:18:\"date_archive_title\";s:30:\"%date% %page% %sep% %sitename%\";s:12:\"search_title\";s:38:\"%search_query% %page% %sep% %sitename%\";s:9:\"404_title\";s:31:\"Page Not Found %sep% %sitename%\";s:19:\"date_archive_robots\";a:1:{i:0;s:7:\"noindex\";}s:14:\"noindex_search\";s:2:\"on\";s:24:\"noindex_archive_subpages\";s:3:\"off\";s:26:\"noindex_password_protected\";s:3:\"off\";s:32:\"pt_download_default_rich_snippet\";s:7:\"product\";s:29:\"author_slack_enhanced_sharing\";s:2:\"on\";s:13:\"pt_post_title\";s:24:\"%title% %sep% %sitename%\";s:19:\"pt_post_description\";s:9:\"%excerpt%\";s:14:\"pt_post_robots\";a:1:{i:0;s:5:\"index\";}s:21:\"pt_post_custom_robots\";s:3:\"off\";s:28:\"pt_post_default_rich_snippet\";s:7:\"article\";s:28:\"pt_post_default_article_type\";s:11:\"BlogPosting\";s:28:\"pt_post_default_snippet_name\";s:11:\"%seo_title%\";s:28:\"pt_post_default_snippet_desc\";s:17:\"%seo_description%\";s:30:\"pt_post_slack_enhanced_sharing\";s:2:\"on\";s:17:\"pt_post_ls_use_fk\";s:6:\"titles\";s:20:\"pt_post_add_meta_box\";s:2:\"on\";s:20:\"pt_post_bulk_editing\";s:7:\"editing\";s:24:\"pt_post_link_suggestions\";s:2:\"on\";s:24:\"pt_post_primary_taxonomy\";s:8:\"category\";s:13:\"pt_page_title\";s:24:\"%title% %sep% %sitename%\";s:19:\"pt_page_description\";s:9:\"%excerpt%\";s:14:\"pt_page_robots\";a:1:{i:0;s:5:\"index\";}s:21:\"pt_page_custom_robots\";s:3:\"off\";s:28:\"pt_page_default_rich_snippet\";s:7:\"article\";s:28:\"pt_page_default_article_type\";s:7:\"Article\";s:28:\"pt_page_default_snippet_name\";s:11:\"%seo_title%\";s:28:\"pt_page_default_snippet_desc\";s:17:\"%seo_description%\";s:30:\"pt_page_slack_enhanced_sharing\";s:2:\"on\";s:17:\"pt_page_ls_use_fk\";s:6:\"titles\";s:20:\"pt_page_add_meta_box\";s:2:\"on\";s:20:\"pt_page_bulk_editing\";s:7:\"editing\";s:24:\"pt_page_link_suggestions\";s:2:\"on\";s:19:\"pt_attachment_title\";s:24:\"%title% %sep% %sitename%\";s:25:\"pt_attachment_description\";s:9:\"%excerpt%\";s:20:\"pt_attachment_robots\";a:1:{i:0;s:7:\"noindex\";}s:27:\"pt_attachment_custom_robots\";b:1;s:34:\"pt_attachment_default_rich_snippet\";b:0;s:34:\"pt_attachment_default_article_type\";s:7:\"Article\";s:34:\"pt_attachment_default_snippet_name\";s:11:\"%seo_title%\";s:34:\"pt_attachment_default_snippet_desc\";s:17:\"%seo_description%\";s:36:\"pt_attachment_slack_enhanced_sharing\";b:0;s:26:\"pt_attachment_add_meta_box\";b:0;s:16:\"pt_product_title\";s:24:\"%title% %sep% %sitename%\";s:22:\"pt_product_description\";s:9:\"%excerpt%\";s:17:\"pt_product_robots\";a:1:{i:0;s:5:\"index\";}s:24:\"pt_product_custom_robots\";b:0;s:31:\"pt_product_default_rich_snippet\";s:7:\"product\";s:31:\"pt_product_default_article_type\";s:7:\"Article\";s:31:\"pt_product_default_snippet_name\";s:11:\"%seo_title%\";s:31:\"pt_product_default_snippet_desc\";s:17:\"%seo_description%\";s:33:\"pt_product_slack_enhanced_sharing\";b:1;s:20:\"pt_product_ls_use_fk\";s:6:\"titles\";s:23:\"pt_product_add_meta_box\";b:1;s:23:\"pt_product_bulk_editing\";s:7:\"editing\";s:27:\"pt_product_link_suggestions\";b:1;s:27:\"pt_product_primary_taxonomy\";s:11:\"product_cat\";s:18:\"pt_web-story_title\";s:24:\"%title% %sep% %sitename%\";s:24:\"pt_web-story_description\";s:9:\"%excerpt%\";s:19:\"pt_web-story_robots\";a:1:{i:0;s:5:\"index\";}s:26:\"pt_web-story_custom_robots\";b:0;s:33:\"pt_web-story_default_rich_snippet\";s:7:\"article\";s:33:\"pt_web-story_default_article_type\";s:7:\"Article\";s:33:\"pt_web-story_default_snippet_name\";s:11:\"%seo_title%\";s:33:\"pt_web-story_default_snippet_desc\";s:17:\"%seo_description%\";s:35:\"pt_web-story_slack_enhanced_sharing\";b:0;s:25:\"pt_web-story_add_meta_box\";b:0;s:18:\"tax_category_title\";s:23:\"%term% %sep% %sitename%\";s:19:\"tax_category_robots\";a:1:{i:0;s:5:\"index\";}s:25:\"tax_category_add_meta_box\";s:2:\"on\";s:26:\"tax_category_custom_robots\";s:3:\"off\";s:24:\"tax_category_description\";s:18:\"%term_description%\";s:35:\"tax_category_slack_enhanced_sharing\";s:2:\"on\";s:18:\"tax_post_tag_title\";s:23:\"%term% %sep% %sitename%\";s:19:\"tax_post_tag_robots\";a:1:{i:0;s:7:\"noindex\";}s:25:\"tax_post_tag_add_meta_box\";s:2:\"on\";s:26:\"tax_post_tag_custom_robots\";s:2:\"on\";s:24:\"tax_post_tag_description\";s:18:\"%term_description%\";s:35:\"tax_post_tag_slack_enhanced_sharing\";s:2:\"on\";s:21:\"tax_post_format_title\";s:23:\"%term% %sep% %sitename%\";s:22:\"tax_post_format_robots\";a:1:{i:0;s:7:\"noindex\";}s:28:\"tax_post_format_add_meta_box\";b:1;s:29:\"tax_post_format_custom_robots\";b:1;s:27:\"tax_post_format_description\";s:18:\"%term_description%\";s:38:\"tax_post_format_slack_enhanced_sharing\";b:1;s:31:\"remove_product_cat_snippet_data\";b:1;s:31:\"remove_product_tag_snippet_data\";b:1;s:19:\"knowledgegraph_logo\";s:65:\"https://avnalaw.com/wp-content/uploads/2025/09/cropped-icon-1.png\";s:22:\"knowledgegraph_logo_id\";s:3:\"225\";s:22:\"website_alternate_name\";s:12:\"دادمان\";s:16:\"open_graph_image\";s:68:\"https://avnalaw.com/wp-content/uploads/2025/09/regulations-image.jpg\";s:19:\"open_graph_image_id\";s:3:\"989\";s:33:\"pt_wpuf_subscription_add_meta_box\";s:3:\"off\";s:13:\"robots_global\";a:1:{i:0;s:5:\"index\";}s:22:\"advanced_robots_global\";a:3:{s:11:\"max-snippet\";i:-1;s:17:\"max-video-preview\";i:-1;s:17:\"max-image-preview\";s:5:\"large\";}s:3:\"url\";s:19:\"https://avnalaw.com\";s:13:\"phone_numbers\";a:1:{i:0;a:2:{s:4:\"type\";s:16:\"customer support\";s:6:\"number\";s:0:\"\";}}s:15:\"additional_info\";a:1:{i:0;a:2:{s:4:\"type\";s:9:\"legalName\";s:5:\"value\";s:0:\"\";}}s:22:\"author_advanced_robots\";a:3:{s:11:\"max-snippet\";i:-1;s:17:\"max-video-preview\";i:-1;s:17:\"max-image-preview\";s:5:\"large\";}s:20:\"date_advanced_robots\";a:3:{s:11:\"max-snippet\";i:-1;s:17:\"max-video-preview\";i:-1;s:17:\"max-image-preview\";s:5:\"large\";}s:23:\"noindex_paginated_pages\";s:3:\"off\";s:23:\"pt_post_advanced_robots\";a:3:{s:11:\"max-snippet\";i:-1;s:17:\"max-video-preview\";i:-1;s:17:\"max-image-pr