import type { SVGProps } from 'react';

interface CustomIconProps extends SVGProps<SVGSVGElement> {
    size?: number;
    fill?: string;
    stroke?: string;
    strokeWidth?: number;
    viewBox?: string;
}

const compress = ({
                                             size = 24,
                                             fill = 'none',
                                             stroke = 'none',
                                             strokeWidth = 2,
                                             viewBox = '0 0 24 24',
                                             ...props
                                         }:CustomIconProps) => (
    <svg
        width={size}
        height={size}
        fill={fill}
        stroke={stroke}
        strokeWidth={strokeWidth}
        viewBox={viewBox}
        strokeLinecap="round"
        strokeLinejoin="round"
        xmlns="http://www.w3.org/2000/svg"
        {...props}
    >
        <path
            d="M5 14C4.71667 14 4.47917 13.9042 4.2875 13.7125C4.09583 13.5208 4 13.2833 4 13C4 12.7167 4.09583 12.4792 4.2875 12.2875C4.47917 12.0958 4.71667 12 5 12H19C19.2833 12 19.5208 12.0958 19.7125 12.2875C19.9042 12.4792 20 12.7167 20 13C20 13.2833 19.9042 13.5208 19.7125 13.7125C19.5208 13.9042 19.2833 14 19 14H5ZM5 11C4.71667 11 4.47917 10.9042 4.2875 10.7125C4.09583 10.5208 4 10.2833 4 10C4 9.71667 4.09583 9.47917 4.2875 9.2875C4.47917 9.09583 4.71667 9 5 9H19C19.2833 9 19.5208 9.09583 19.7125 9.2875C19.9042 9.47917 20 9.71667 20 10C20 10.2833 19.9042 10.5208 19.7125 10.7125C19.5208 10.9042 19.2833 11 19 11H5ZM12 22C11.7167 22 11.4792 21.9042 11.2875 21.7125C11.0958 21.5208 11 21.2833 11 21V18.8L10.1 19.7C9.91667 19.8833 9.68333 19.975 9.4 19.975C9.11667 19.975 8.88333 19.8833 8.7 19.7C8.51667 19.5167 8.425 19.2833 8.425 19C8.425 18.7167 8.51667 18.4833 8.7 18.3L11.3 15.7C11.4 15.6 11.5083 15.5292 11.625 15.4875C11.7417 15.4458 11.8667 15.425 12 15.425C12.1333 15.425 12.2583 15.4458 12.375 15.4875C12.4917 15.5292 12.6 15.6 12.7 15.7L15.3 18.3C15.4833 18.4833 15.5792 18.7125 15.5875 18.9875C15.5958 19.2625 15.5 19.5 15.3 19.7C15.1167 19.8833 14.8875 19.9792 14.6125 19.9875C14.3375 19.9958 14.1 19.9083 13.9 19.725L13 18.85V21C13 21.2833 12.9042 21.5208 12.7125 21.7125C12.5208 21.9042 12.2833 22 12 22ZM12 7.575C11.8667 7.575 11.7417 7.55417 11.625 7.5125C11.5083 7.47083 11.4 7.4 11.3 7.3L8.7 4.7C8.51667 4.51667 8.425 4.28333 8.425 4C8.425 3.71667 8.51667 3.48333 8.7 3.3C8.88333 3.11667 9.11667 3.025 9.4 3.025C9.68333 3.025 9.91667 3.11667 10.1 3.3L11 4.2V2C11 1.71667 11.0958 1.47917 11.2875 1.2875C11.4792 1.09583 11.7167 1 12 1C12.2833 1 12.5208 1.09583 12.7125 1.2875C12.9042 1.47917 13 1.71667 13 2V4.2L13.9 3.3C14.0833 3.11667 14.3167 3.025 14.6 3.025C14.8833 3.025 15.1167 3.11667 15.3 3.3C15.4833 3.48333 15.575 3.71667 15.575 4C15.575 4.28333 15.4833 4.51667 15.3 4.7L12.7 7.3C12.6 7.4 12.4917 7.47083 12.375 7.5125C12.2583 7.55417 12.1333 7.575 12 7.575Z"
            fill={fill}
            stroke={stroke}
            strokeWidth={strokeWidth}
        />
    </svg>
);

export default compress;